<?php
/*
	author: Spectre
	site: https://6ns.net
	file: wp-index-redis.php
	credit: jim westergren
	updated: 2018-3-30

	这是一个由jim westergren启发的wordpress redis缓存系统。
	在这里看到更多：www.jimwestergren.com/wordpress-with-redis-as-a-frontend-cache/
	脚本再次由Spectre重新编写发布并公开源代码,请遵守jim westergren许可协议,并注明作者名称与链接.
	如果您需要获得新版本,请移动到https://6ns.net/post-994.html获取更多信息
	
*/

$no_cache_page = array(														//禁止缓存的页面
	'/domain',
	'/ip',
	'/add-ip',
	'/add-domain',
	'/checkout',
	'/login',
	'/register',
	'/lostpassword?error=invalidkey',
	'/lostpassword'
);
//$str = "/\/post-[0-9]\d*.html\\/[A-Za-z0-9\-]+/";							// 截取/post-111.html/xxx
//$str = "/download/";														// 固定链接
$debug = 1;																	// 调试模式
$del_cache_command = '?r=7cb235e4a947ceab050f5b7e';							// 用于定时任务清除缓存
$start = microtime();														// 开始计时
define('WP_USE_THEMES', true);												// 加载主题文件
include("predis.php");														// 加载redis客户端
$redis = new Predis\Client('');												// redis链接模式
$domain = $_SERVER['HTTP_HOST'];											// URL xxx.com
$request_uri = $_SERVER['REQUEST_URI'];										// ?r=y
$url = "https://" . $domain . $request_uri;									// URL完整地址 https://xxx.com/index.php?r=y
if ( strpos("?r=",$request_uri) ){
	$tmp_url = str_replace($del_cache_command,'',$url);						// 去除多余的参数 https://xxx.com?r=y
}
$dkey = md5($domain);														// 用于缓存
$ukey = md5($tmp_url);														// 用于缓存
$check_nocache = in_array($request_uri,$no_cache_page);						// 排除不缓存的页面
$del_cache = substr($request_uri, -27);										// 删除缓存-用于定时任务
$cookie = var_export($_COOKIE, true);										// 获取COOKIE
$loggedin = preg_match("/wordpress_logged_in/", $cookie);					// 是否已登录
//$download_url = preg_match_all($str, $request_uri);						// 排除下载页面,防止无法发送邮件

/*
 * 核心代码开始
*/

//if ( $loggedin || $download_url || $check_nocache ) {						// 已登录用户不缓存,排除下载页面缓存,排除不缓存的页面
if ( $loggedin || $check_nocache ) {										// 已登录用户不缓存,排除不缓存的页面
	require('./wp-blog-header.php');
	$msg = 'Not Cached';
/*
}else if ( $del_cache == $del_cache_command ) {								// 删除缓存指令,用于定时任务
	require('./wp-blog-header.php');
	if ( $redis->exists($dkey) ) {
		$redis->del($dkey);
		$msg = 'Cache Deleted';
	}else{
		$msg = 'No Cache to Flush';
	}
*/
/*
 * 为了使用插件,使用此判断
*/
}else if ( $del_cache == $del_cache_command ) {								// 删除缓存指令,用于定时任务
	if ( $redis->exists($dkey) ) {											// 如果缓存存在
		$redis->del($dkey);													// 删除缓存
		$debug = 0;															// 关闭调试模式,防止输出调试信息
		echo "Cache Deleted";												// 输出内容,用于脚本判断缓存状态
	}else{
		$debug = 0;
		echo "No Cache to Flush";
	}
}else if ( $redis->hexists($dkey, $ukey) && !$loggedin ) {					//检查缓存是否存在
	echo $redis->hget($dkey, $ukey);
	if (!$debug) exit(0);
	$msg = 'This is a Cache';
}else{
	ob_start();																// 开始缓存页面
	require('./wp-blog-header.php');
	$html = ob_get_contents();												// 输出缓存的内容
	ob_end_clean();
	echo $html;
	$redis->hset($dkey,$ukey,$html);
	$msg = 'Cache is set';
}

/*
 * 核心代码结束 Spectre - https://6ns.net
*/
$end = microtime();															// 结束计时
// 显示调试
if ($debug) {
    echo $msg.': ';
    echo t_exec($start, $end).'ns - Powered By <a href="https://6ns.net/post-994.html">Spectre</a>';
}
// 时间差异
function t_exec($start, $end) {
    $t = (getmicrotime($end) - getmicrotime($start));
	//return round($t,5) * 1000000;  //ps 皮秒
    return round($t,5) * 1000;  //ns 纳秒
	//return round($t,5);  //μs 微妙
	//return round($t,5) / 1000;  //ms 毫秒
	//return round($t,5) / 1000000;  //s 秒
}
// 获取时间
function getmicrotime($t) {
    list($usec, $sec) = explode(" ",$t);
    return ((float)$usec + (float)$sec);
}
?>