<?php
/*
Plugin Name: SVG分类导航
Version: 1.1
Plugin URL: http://www.youngxj.cn
Description:SVG分类导航插件
ForEmlog:5.3.x
Author: 杨小杰
Author URL: http://www.youngxj.cn
*/

!defined('EMLOG_ROOT') && exit('access deined!');
function classification(){
  	include 'classification_config.php';
  	$bg=$config['bg'];
  	$home=$config['home'];
  	global $CACHE;
	$sort_cache = $CACHE->readCache('sort');
?>
  <style>
#box{
    width: 100%;
    height:300px;
    opacity:0.5;
    -webkit-transition: all 1s ease;
  -moz-transition: all 1s ease;
  -o-transition: all 1s ease;
  transition: all 1s ease;}
</style>
<div id="box" onclick="color()"></div>
      <script>
        var oSvg = createTag('svg',{'version':'1.1','xmls':'http://www.w3.org/2000/svg',height:'100%',width:'100%'});
        var oBox = document.getElementById('box');
        var W = parseInt(getComputedStyle(oBox).width);
        var H = parseInt(getComputedStyle(oBox).height);
        var appearance = {
            'dis':H/3,
            'r0':H/8,'r':H/10,
            'x0':W/2,'y0':H/2,
            'fontSize':H/24,
            'bg0':'rgba(255,255,255,.6)','bg':'rgba(255,255,255,.6)',
            'borderColor0':'rgba(0,0,0,.3)','bordercolor':'rgba(0,0,0,.3)',
            'strokeWidth0':4,'strokeWidth1':2,'strokeWidth2':4,
            'lineColor':'rgba(0,0,0,0.3)','lineWidth':1,'lineDashed':'5,5',
            'backX':W/20,'backY':H/20,'backFill':'rgba(0,0,0,.3)','backScale':'0.4',
        }
        var data = {
          text:'<?php echo $home;?>',
    		children:[
			<?php
	foreach($sort_cache as $value):
		if ($value['pid'] != 0) continue;
	?>
	{text:'<?php echo $value['sortname']; ?>(<?php echo $value['lognum'] ?>)',url:'<?php echo Url::sort($value['sid']); ?>'},
	<?php endforeach; ?>
    ],  
}
function init(){
    addChildenTags(data.children);
    addCenterTag(data);
    oBox.appendChild(oSvg);    
}
init();function createTag(tag,objAttr){
  var oTag = document.createElementNS('http://www.w3.org/2000/svg',tag);
      for(var attr in objAttr){
        if(attr == 'xlink:href'){
            oTag.setAttributeNS("http://www.w3.org/1999/xlink",attr,objAttr[attr]);
        }else{
            oTag.setAttribute(attr,objAttr[attr]);
        }        
      }    
  return oTag;
} 
function addCenterTag(obj){
    var oG = createTag('g',{'style':'cursor:pointer'});
    var oCircle = createTag('circle',{'cx':appearance.x0,'cy':appearance.y0,'r':appearance.r0,'fill':appearance.bg0,'stroke':appearance.borderColor0,'stroke-width':appearance.strokeWidth0});
    var oText = createTag('text',{'x':appearance.x0,'y':appearance.y0,'font-size':appearance.fontSize,'text-anchor':'middle','dominant-baseline':'middle','stroke-width':appearance.strokeWidth0});
    oText.innerHTML = obj.text;
    oG.appendChild(oCircle);
    oG.appendChild(oText);
    oSvg.appendChild(oG);
    oG.onclick = function(e){
        e = e || event;
        oSvg.innerHTML = '';
        if(obj.url == '#'){
            addChildenTags(obj.children);
            addBackTag();
        }else{
            addChildenTags(data.children);
        }       
        addCenterTag(obj);        
    }
}
function addBackTag(){
    var oG = createTag('g',{'style':'cursor:pointer'});
    var oClipPath = createTag('clipPath',{'id':'clipPath1'});
    var oPolygon = createTag('polygon',{'points':'40 0, 40 20, 100 20, 100 80, 40 80, 40 100, 0 50'});
    var oRect = createTag('rect',{'x':0,'y':0,'width':100,'height':100,'fill':appearance.backFill,'clip-path':'url(#clipPath1)','transform':'scale(' + appearance.backScale + ') translate(' + appearance.backX + ','+appearance.backY + ')',});
    oClipPath.appendChild(oPolygon);
    oG.appendChild(oClipPath);
    oG.appendChild(oRect);
    oSvg.appendChild(oG);
    oG.onclick = function(){
        oSvg.innerHTML = '';
        addChildenTags(data.children);
        addCenterTag(data);
    }    
}
function randomArr(arr){
    return arr.sort(function(){return Math.random() - 0.5});
}
function addChildenTags(children){
    var length = children.length;
    var deg = (360/length)*(2*Math.PI)/360;
    var posArr = [];
    var randomRotate = Math.floor(360*Math.random());
    for(var i = 0; i < children.length;i++){
        var cos = Math.cos(deg*i - randomRotate);
        var sin = Math.sin(deg*i - randomRotate);
        var x = appearance.x0  + appearance.dis*cos;
        var y = appearance.y0  + appearance.dis*sin;        
        posArr[i] = {index:i,cos:cos,sin:sin,x:x,y:y};  
    }    
    randomArr(posArr);    
    for(var i = 0; i < children.length;i++){
        var oA = createTag('a',{'xlink:href':children[i].url,'target':'_black'}); 
        oA.obj = children[i];
        oA.index = posArr[i].index;
        var oG = createTag('g',{'style':'cursor:pointer'});        
        var oLine = createTag('line',{'x1':posArr[i].x-appearance.r*posArr[i].cos,y1:posArr[i].y-appearance.r*posArr[i].sin,x2:appearance.x0+appearance.r0*posArr[i].cos,y2:appearance.y0+appearance.r0*posArr[i].sin,'stroke':appearance.lineColor,'stroke-width':appearance.lineWidth,'stroke-dasharray':appearance.lineDashed,'style':'transition:.5s'});
        var oLineHelper = createTag('line',{'x1':posArr[i].x-appearance.r*posArr[i].cos,y1:posArr[i].y-appearance.r*posArr[i].sin,x2:appearance.x0+appearance.r0*posArr[i].cos,y2:appearance.y0+appearance.r0*posArr[i].sin,'stroke':'transparent','stroke-width':10});  
        if(oA.obj.url === '#'){
            var oCircle = createTag('circle',{'cx':posArr[i].x,'cy':posArr[i].y,'r':appearance.r,'fill':appearance.bg,'stroke':appearance.bordercolor,'stroke-width':appearance.strokeWidth2,'class':'frostedglass'});
        }else{
            var oCircle = createTag('circle',{'cx':posArr[i].x,'cy':posArr[i].y,'r':appearance.r,'fill':appearance.bg,'stroke':appearance.bordercolor,'stroke-width':appearance.strokeWidth1,'class':'frostedglass'});            
        }             

        var oText = createTag('text',{'x':posArr[i].x,'y':posArr[i].y,'font-size':appearance.fontSize,'text-anchor':'middle','dominant-baseline':'middle','stroke-width':appearance.strokeWidth1,fill:appearance.color});
        oText.innerHTML = children[i].text;  
        oG.appendChild(oLine);
        oG.appendChild(oLineHelper);            
        oG.appendChild(oCircle);                  
        oG.appendChild(oText);
        oA.appendChild(oG);
        oSvg.appendChild(oA);
        oA.onmouseenter = function(){
            elasticMove(this,appearance.r*1.2);
            var line = this.getElementsByTagName('line')[0];
            line.removeAttribute('stroke-dasharray');
            line.setAttribute('stroke-width',appearance.lineWidth*3);
            line.setAttribute('x1',appearance.x0+(appearance.dis - appearance.r0)*Math.cos(deg*this.index - randomRotate));
            line.setAttribute('y1',appearance.y0+(appearance.dis - appearance.r0)*Math.sin(deg*this.index - randomRotate));
        }
        oA.onmouseleave = function(){
            elasticMove(this,appearance.r);
            var line = this.getElementsByTagName('line')[0];
            line.setAttribute('stroke-width',appearance.lineWidth);
            line.setAttribute('stroke-dasharray',appearance.lineDashed);
            line.setAttribute('x1',appearance.x0+(appearance.dis - appearance.r)*Math.cos(deg*this.index - randomRotate));
            line.setAttribute('y1',appearance.y0+(appearance.dis - appearance.r)*Math.sin(deg*this.index - randomRotate));          
        } 
        oA.onclick = function(e){
            e = e || event;
            if(this.obj.url === '#'){
                e.preventDefault();
                oSvg.innerHTML = '';
                addCenterTag(this.obj);
                addChildenTags(this.obj.children);
                addBackTag();
            }
        }        
    }
}
function elasticMove(obj,str){
    var circle = obj.getElementsByTagName('circle')[0];
    var r0 = circle.getAttribute('r');
    var r = Number(str);
    //声明步长值
    var step = 0;
    //声明弹性距离
    var len = r - r0;
    //声明弹性系数
    var k = 0.7;
    //声明损耗系数
    var z= 0.7;
    //声明当前值
    var cur = r0;
    clearInterval(circle.timer);
    circle.timer = setInterval(function(){
        //获取当前值cur
        cur =  circle.getAttribute('r');
        //更新弹性距离
        len = r - cur;
        //弹力影响
        step += len*k;
        //阻力影响
        step = step*z;
        //赋值
        circle.setAttribute('r',Number(cur) + step);
        //当元素的步长值接近于0，并且弹性距离接近于0时，停止定时器
        if(Math.round(step) == 0 && Math.round(len) == 0){
            circle.setAttribute('r',r);
            clearInterval(circle.timer); 
        }    
    },30);
}
</script>
<?php if($bg){?>
<script>
function color(){
		var d = document.getElementById("box");
		var cc='#'+('00000'+(Math.random()*0x1000000<<0).toString(16)).substr(-6); 
		if(1){
			d.style.backgroundColor = cc;
		}
		setTimeout("color()",2000);
	}
</script>
<?php }?>
  <?php
    }
function classification_menu(){
	echo '<div class="sidebarsubmenu"><a href="./plugin.php?plugin=classification">SVG分类导航</a></div>';
}
?>
<?php 
addAction('classification','classification');
addAction('adm_sidebar_ext', 'classification_menu');
?>