<?php namespace Admin\Controller;
use Think\Controller;

class FileController extends Controller {
	private $imagesThuDir;
	private $imagesDir;
	private $filesDir;
	private $pathRoot = '.';
	public function _initialize() {
		$this->imagesDir    = '/uploads/' . $_SESSION['username'] . '/image/';
		$this->imagesThuDir = '/uploads/' . $_SESSION['username'] . '/thu_image/';
		$this->filesDir     = '/uploads/' . $_SESSION['username'] . '/file/';
	}
	public function countFiles($path) {
		$count = sizeof(scandir($this->pathRoot . $path)) - 2;
		return $count;
	}
	public function getDirSize($path) //文件夹总大小
	{
		$handle    = opendir($this->pathRoot . $path);
		$totalSize = 0;
		while (($file = readdir($handle)) !== false) {
			if ('.' != $file && '..' != $file) {
				$totalSize += floor(filesize($this->pathRoot . $path . $file));
			}
		}
		return $this->realSize($totalSize);
	}
	public function realSize($size) {
		$kb = 1024; // Kilobyte
		$mb = 1024 * $kb; // Megabyte
		$gb = 1024 * $mb; // Gigabyte
		$tb = 1024 * $gb; // Terabyte
		if ($size < $kb) {
			return $size . " B";
		} else if ($size < $mb) {
			return round($size / $kb, 2) . " KB";
		} else if ($size < $gb) {
			return round($size / $mb, 2) . " MB";
		} else if ($size < $tb) {
			return round($size / $gb, 2) . " GB";
		} else {
			return round($size / $tb, 2) . " TB";
		}
	}
	public function imagesStorageInfo() {
		$returnArray = array("imagecount" => $this->countFiles($this->imagesDir), "size" => $this->getDirSize($this->imagesDir)); //申明返回数组
		return $returnArray;
	}
	public function listImages($fileType) {
		$currentPage = 0;
		$count       = 0;
		$returnArray = array("pageinfo" => array(), "fileslist" => array()); //申明返回数组
		$pathArray   = array(); //申明文件列表数组

		if (null == $_GET['page']) {
			$currentPage = 1;
		} else {
			$currentPage = $_GET['page'];
		}

		$count = $this->countFiles($this->imagesDir) - 2;

		if ($count % 18 != 0) {
			$pages = floor($count / 24) + 1;
		} else {
			$pages = floor($count / 24);
		}

		$start = ($currentPage - 1) * 24;

		switch ($fileType) {
			case 'image':
				$objDir = $this->pathRoot . $this->imagesDir;
				break;
			case 'file':
				$objDir = $this->pathRoot . $this->filesDir;
				break;
			default:
				# code...
				break;
		}
		$handle = @opendir($objDir);
		while (($file = readdir($handle)) !== false) {
			if ('.' != $file && '..' != $file) {
				$attach = $this->imageAttach($file);
				$size   = floor(filesize($objDir . $file) / 1024);
				switch ($fileType) {
					case 'image':
						if (no == $_GET['filter']) {
							if (!isset($attach)) {
								$imageinfo = '';
								$imageinfo = '未依附于任何文章，文件大小：' . $size . 'KB';
								$fileInfo  = array("filename" => $file, "thufileroot" => $this->imagesThuDir . 'thu_' . $file, "fileroot" => $this->imagesDir . $file, "info" => $imageinfo);
								array_push($pathArray, $fileInfo);
								$pages = 0;
							}
						} else if (all == $_GET['filter']) {
							if (($i > $start) && ($i < $start + 25)) {
								$imageinfo = '';
								$imageinfo .= '文件大小：' . $size . 'KB';
								if (isset($attach)) {
									$imageinfo .= '依附于：《' . $attach['title'] . '》 ';
								}

								$fileInfo = array("filename" => $file, "thufileroot" => $this->imagesThuDir . 'thu_' . $file, "fileroot" => $this->imagesDir . $file, "info" => $imageinfo);
								array_push($pathArray, $fileInfo);
							}
						}
						break;
					case 'file':
						$creatTime = date("Y-m-d H:i:s", filectime($objDir . $file));
						$fileInfo  = array("filename" => $file, "fileroot" => $this->filesDir . $file, "filesize" => $size, "fileattach" => $attach['title'], "filetime" => $creatTime, "extension" => $this->getExtension($file));
						array_push($pathArray, $fileInfo);
						break;
					default:
						# code...
						break;
				}

				$i++;
			}

		}
		$pageinfo                 = array('pages' => $pages, 'current' => $currentPage);
		$returnArray['pageinfo']  = $pageinfo;
		$returnArray['fileslist'] = $pathArray;
		return $returnArray;
	}
	public function imageAttach($image) {
		$model = M();
		$array = $model->table(C('DB_PREFIX') . 'archives')->where('userid=' . $_SESSION['userid'] . ' and content like "%' . $image . '%"')->find();
		return $array;
	}
	public function delFiles() {
		switch ($_GET['filetype']) {
			default:
				unlink($this->pathRoot . $this->imagesDir . $_GET['file']);
				unlink($this->pathRoot . $this->imagesThuDir . 'thu_' . $_GET['file']);
				$rtnArr = array(
					'msg'    => '成功删除“' . $_GET['file'] . '”和“' . 'thu_' . $_GET['file'] . '”',
					'status' => 'success',
				);
				break;
			case 'file':
				unlink($this->pathRoot . $this->filesDir . $_GET['file']);
				$rtnArr = array(
					'msg'    => '成功删除' . $_GET['file'],
					'status' => 'success',
				); 	# code...
				break;
		}
		echo json_encode($rtnArr);
	}
	public function getExtension($file) {
		return substr(strrchr($file, '.'), 1);
	}

}
