<?php
namespace Admin\Controller;
use Think\Controller;

class IndexController extends Controller {
	public function _initialize() {
		if (!isset($_SESSION['username']) || '' == $_SESSION['username']) {
			$this->redirect('Login/index');
		}
		set_theme();
	}
	public function index() {
		$arr                 = array('PageName' => '后台首页', 'PageFun' => 'index');
		$archive             = new ArchiveController();
		$comments            = new CommentController();
		$files               = new FileController();
		$info                = array();
		$info['ArchivesSum'] = $archive->getArchiveSum();
		$info['CommentsSum'] = $comments->getCommentsSum();
		//$info['ImagesSum']=$files->imagesStorageInfo()['imagecount'];
		//$info['ImagesSize']=$files->imagesStorageInfo()['size'];
		$arr['info'] = $info;
		$this->assign('data', $arr);
		$this->display('tpl/index');
	}
	public function profile() {
		$arr               = array('PageName' => '个人选项', 'PageFun' => 'profile');
		$settings          = new SettingsController();
		$arr['settings']   = $settings->getSettings();
		$arr['listthemes'] = $settings->listThemes();
		$settings->listThemes();
		$this->assign('data', $arr);
		$this->display('tpl/profile');
	}
	public function archive() {
		$cate            = new CateController();
		$arr             = array('PageName' => '内容发布', 'PageFun' => 'archive');
		$arr['category'] = $cate->listCategory();
		$arr['tag']      = $cate->listTag();
		$arr['edittype'] = 'addArchive';
		if (isset($_GET['id'])) {
			$archive            = new ArchiveController();
			$arr['archive']     = $archive->getarchive($_GET['id']);
			$arr['selectedtag'] = $cate->listSelectedTags($_GET['id']);
			$arr['edittype']    = 'editArchive';

		}

		$this->assign('data', $arr);
		$this->display('tpl/archive');
	}

	public function items() {
		$cate            = new CateController();
		$arr             = array('PageName' => '我的栏目', 'PageFun' => 'items');
		$arr['category'] = $cate->listCategory();
		$arr['tag']      = $cate->listTag();
		$this->assign('data', $arr);
		$this->display('tpl/items');
	}
	public function edititem() {
		$cate = new CateController();
		if ('category' == $_GET['type']) {
			$data             = array('PageName' => '编辑分类');
			$data['category'] = $cate->listCategory($_GET['id']);
			$data['list']     = $cate->listCategory();
			$this->assign('data', $data);
			$this->display('tpl/edititem');
		} elseif ('tag' == $_GET['type']) {
			$data        = array('PageName' => '编辑Tag');
			$data['tag'] = $cate->listTag($_GET['id']);
			$this->assign('data', $data);
			$this->display('tpl/edititem');
		}

	}
	public function mycomment() {
		$arr                 = array('PageName' => '我的评论', 'PageFun' => 'mycomment');
		$comments            = new CommentController();
		$arr['Comments']     = $comments->getComments();
		$arr['LastComments'] = $comments->getLastComments();
		$this->assign('data', $arr);
		$this->display('tpl/mycomment');
	}
	public function myfiles() {
		$arr            = array('PageName' => '我的文档', 'PageFun' => 'myfiles');
		$myfiles        = new FileController();
		$tmp            = $myfiles->listImages('file');
		$arr['Files']   = $tmp["fileslist"];
		$arr['Pages']   = $tmp["pageinfo"];
		$arr['DirInfo'] = $myfiles->imagesStorageInfo();
		$this->assign('data', $arr);
		$this->display('tpl/myfiles');
	}
	public function myimages() {
		$arr            = array('PageName' => '我的图片', 'PageFun' => 'myimages');
		$myfiles        = new FileController();
		$tmp            = $myfiles->listImages('image');
		$arr['Images']  = $tmp["fileslist"];
		$arr['Pages']   = $tmp["pageinfo"];
		$arr['DirInfo'] = $myfiles->imagesStorageInfo();
		$this->assign('data', $arr);
		$this->display('tpl/myimages');
	}
	public function mylink() {
		$arr          = array('PageName' => '友情链接', 'PageFun' => 'mylink');
		$link         = new LinkController();
		$arr['links'] = $link->listLinks();
		$this->assign('data', $arr);
		$this->display('tpl/mylink');
	}
	public function archivelists() {
		$list            = new ArchiveController();
		$cate            = new CateController();
		$arr             = array('PageName' => '所有文章', 'PageFun' => 'archivelists');
		$arr['category'] = $cate->listCategory();
		$arr['list']     = $list->listArchive();
		$this->assign('data', $arr);
		$this->display('tpl/archivelists');
	}
	public function quickEditor() {
		$cate            = new CateController();
		$arr['category'] = $cate->listCategory();
		$archive         = new ArchiveController();
		$arr['archive']  = $archive->getarchive($_GET['id']);
		$this->assign('data', $arr);
		$this->display('tpl/quickeditor');
	}
	public function indexinfo() {

	}
}