<?php
function getGravatar($email, $s = 80, $d = 'mm', $r = 'g', $img = false, $atts = array()) {
	$url = 'https://secure.gravatar.com/avatar/';
	$url .= md5(strtolower(trim($email)));
	$url .= "?s=$s&d=$d&r=$r";
	if ($img) {
		foreach ($atts as $key => $val) {
			$url .= ' ' . $key . '="' . $val . '"';
		}
	}
	return $url;
}
function setReply($reply = 0, $id = 0) {

	if (0 == $reply) {
		return $id;
	} else {
		return $reply;
	}

}

function buildPreview($content) {
	$preRow   = 20;
	$preSpilt = $content;
	//return str_replace("<p>","{p}",$preSpilt);
	$preSpilt = str_replace("<p>", "{p}", $preSpilt);
	$preSpilt = str_replace("</p>", "", $preSpilt);

	$allArray = explode("{p}", $preSpilt);
	if (sizeof($allArray) > $preRow) {
		for ($i = 0; $i < $preRow; $i++) {
			$precontent .= ("<p>" . $allArray[$i] . "</p>");
		}
		return $precontent . "<p>……</p>";
	} else {
		return $content;
	}

}

function validateGravatar($email) {
	$hash    = md5(strtolower(trim($email)));
	$uri     = 'https://secure.gravatar.com/avatar/' . $hash . '?d=404';
	$headers = @get_headers($uri);
	if (!preg_match("|200|", $headers[0])) {
		$has_valid_avatar = FALSE;
	} else {
		$has_valid_avatar = TRUE;
	}
	return $has_valid_avatar;
}

function loadCodeHighter($type) {
	$typeArray = array(
		'as3'           => 'as3',
		'actionscript3' => 'as3',
		'bash'          => 'bash',
		'shell'         => 'bash',
		'coldfusion'    => 'coldfusion',
		'cf'            => 'coldfusion',
		'clojure'       => 'clojure',
		'clj'           => 'clojure',
		'cpp'           => 'cpp',
		'c'             => 'cpp',
		'c-sharp'       => 'csharp',
		'csharp'        => 'csharp',
		'css'           => 'css',
		'delphi'        => 'delphi',
		'pas'           => 'delphi',
		'pascal'        => 'delphi',
		'diff'          => 'diff',
		'patch'         => 'diff',
		'erl'           => 'erlang',
		'erlang'        => 'erlang',
		'fsharp'        => 'fsharp',
		'groovy'        => 'groovy',
		'java'          => 'java',
		'jfx'           => 'javafx',
		'javafx'        => 'javafx',
		'js'            => 'jscript',
		'jscript'       => 'jscript',
		'javascript'    => 'jscript',
		'latex'         => 'latex', // Not used as a shortcode
		'tex'           => 'latex',
		'matlab'        => 'matlabkey',
		'objc'          => 'objc',
		'obj-c'         => 'objc',
		'perl'          => 'perl',
		'pl'            => 'perl',
		'php'           => 'php',
		'plain'         => 'plain',
		'text'          => 'plain',
		'ps'            => 'powershell',
		'powershell'    => 'powershell',
		'py'            => 'python',
		'python'        => 'python',
		'r'             => 'r', // Not used as a shortcode
		'splus'         => 'r',
		'rails'         => 'ruby',
		'rb'            => 'ruby',
		'ror'           => 'ruby',
		'ruby'          => 'ruby',
		'scala'         => 'scala',
		'sql'           => 'sql',
		'vb'            => 'vb',
		'vbnet'         => 'vb',
		'xml'           => 'xml',
		'xhtml'         => 'xml',
		'xslt'          => 'xml',
		'html'          => 'xml',
	);
	return 0;
}
