<?php
/**
 * Theme functions file
 *
 *
 * @package KuImg
 * @author Mufeng
 */
require( dirname(__FILE__) . '/functions/metaboxclass.php' );
require( dirname(__FILE__) . '/functions/metabox.php' ); 
require( dirname(__FILE__) . '/functions/add-functions.php' ); 
// Theme-specific files
require( dirname(__FILE__) . '/functions/themes-function.php' );

//获取缩略图地址
 function catch_first_image() {
  global $post, $posts;
  $first_img = '';
  ob_start();
  ob_end_clean();
  $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
  $first_img = $matches [1] [0];
  $dir = get_template_directory_uri();
  if(empty($first_img)){ 
  $first_img = '//img.pximg.com/img/default.jpg';
  }
  $video_poster = get_post_meta($post->ID,"video_poster",true);
				if ( empty( $video_poster ) ) {
                    $video_poster = $first_img;
                }
  return $video_poster;
 }

/*获取"上一篇"文章缩略图*/ 
if ( function_exists('add_theme_support') )
 add_theme_support('post-thumbnails');
function prev_thumbnail_url() { 
$prev_post = get_previous_post(); 
$dir = get_template_directory_uri();
if ( get_post_meta($prev_post->ID, 'thumbnail', true) ) { 
$image = get_post_meta($prev_post->ID, 'thumbnail', true); 
return $image; 
} else { 
if ( has_post_thumbnail($prev_post->ID) ) { 
$img_src = wp_get_attachment_image_src( get_post_thumbnail_id( $prev_post->ID ), 'thumbnail'); 
return $img_src[0]; 
} else { 
$content = $prev_post->post_content; 
preg_match_all('/<img.*?(?: |\\t|\\r|\\n)?src=[\'"]?(.+?)[\'"]?(?:(?: |\\t|\\r|\\n)+.*?)?>/sim', $content, $strResult, PREG_PATTERN_ORDER); 
$n = count($strResult[1]); 
$video_poster = get_post_meta($prev_post->ID,"video_poster",true);
if($n > 0){ return $strResult[1][0];  
}else { 
return $video_poster; 
 } 
 } 
 } 
 }
 
/*获取"下一篇"文章缩略图*/ 
function next_thumbnail_url() { 
$next_post = get_next_post(); 
$dir = get_template_directory_uri();
if ( get_post_meta($next_post->ID, 'thumbnail', true) ) { 
$image = get_post_meta($next_post->ID, 'thumbnail', true); 
return $image; 
} else { 
if ( has_post_thumbnail($next_post->ID) ) { 
$img_src = wp_get_attachment_image_src( get_post_thumbnail_id( $next_post->ID ), 'thumbnail'); 
return $img_src[0]; 
} else { 
$content = $next_post->post_content; 
preg_match_all('/<img.*?(?: |\\t|\\r|\\n)?src=[\'"]?(.+?)[\'"]?(?:(?: |\\t|\\r|\\n)+.*?)?>/sim', $content, $strResult, PREG_PATTERN_ORDER); 
$n = count($strResult[1]);
$video_poster = get_post_meta($next_post->ID,"video_poster",true);
 if($n > 0){ return $strResult[1][0];  
}else { 
return $video_poster;
 } 
 } 
 } 
 }
 
 //后台文章列表页显示附件数量
add_filter('manage_posts_columns', 'mm9_columns_attachment_count', 5);
function mm9_columns_attachment_count($columns){
    $columns['attachments_count'] = '附件数';
    return $columns;
}

add_action('manage_posts_custom_column', 'mm_columns_attachment_count', 5, 2);
function mm_columns_attachment_count($column_name, $id){
    if($column_name === 'attachments_count'){
        echo count(get_children(array('post_parent'=>$id)));
    }
}

//获取文章插入图片数量
function pic_total() {
    global $post;
    $post_img = '';
    ob_start();
    ob_end_clean();
    $output = preg_match_all('/\<img.+?src="(.+?)".*?\/>/is ', $post->post_content, $matches, PREG_SET_ORDER);
    $post_img_src = $matches [0][1];
    $cnt = count($matches);
    return $cnt;
}

//获取上传图片数量
function pic_count() {
	global $post;
    $attachments = get_children( array( 'post_parent' => $post->ID ) );
    $count = count( $attachments );
    return $count;
}

//图片重命名
function new_filename($filename) {
$info = pathinfo($filename);
$ext = empty($info['extension']) ? '' : '.' . $info['extension'];
$name = basename($filename, $ext);
return substr(md5($name), 0, 15) . $ext;
}

add_filter('sanitize_file_name', 'new_filename', 10);

//去头部信息
remove_action( 'wp_head', 'rsd_link' );
remove_action( 'wp_head', 'wp_shortlink_wp_head', 10, 0 );
remove_action( 'wp_head', 'wlwmanifest_link' );
remove_action( 'wp_head', 'wp_generator' );
remove_action( 'wp_head', 'rel_canonical' );
remove_action( 'wp_head', 'index_rel_link' ); // Removes the index link
remove_action( 'wp_head', 'parent_post_rel_link', 10, 0 ); // Removes the prev link
remove_action( 'wp_head', 'start_post_rel_link', 10, 0 ); // Removes the start link
remove_action(  'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );
remove_action( 'wp_head', 'feed_links', 2 );//文章和评论feed
remove_action( 'wp_head', 'feed_links_extra', 3 ); //分类等feed

//开启友情链接
add_filter( 'pre_option_link_manager_enabled', '__return_true' );

//去除谷歌字体
function ashuwp_remove_open_sans() {
    wp_deregister_style( 'open-sans' );
    wp_register_style( 'open-sans', false );
    wp_enqueue_style('open-sans','');
}
add_action('init','ashuwp_remove_open_sans');

//热门文章月排行榜（单页-侧边栏）
function most_viewed_sidebar($mode = '', $limit = 5, $display = true) {
    global $wpdb, $post;
    $views_options = get_option('views_options');
    $where = '';
    $temp = '';
    $output = '';
    if(!empty($mode) && $mode != 'both') {
        $where = "post_type = '$mode'";
    } else {
        $where = '1=1';
    }
   $most_viewed = $wpdb->get_results("SELECT DISTINCT $wpdb->posts.*, (meta_value+0) AS views FROM $wpdb->posts LEFT JOIN $wpdb->postmeta ON $wpdb->postmeta.post_id = $wpdb->posts.ID WHERE post_date > '" . date('Y-m-d', strtotime('-15 days')) . "' AND $where AND post_status = 'publish' AND meta_key = 'views' AND post_password = '' ORDER  BY views DESC LIMIT $limit");
    if($most_viewed) {
        foreach ($most_viewed as $post) {
		$post_views = intval($post->views);
        $post_title = get_the_title();
		$category = get_the_category();
		$category[0]->cat_name;
		$category_id = get_cat_ID( $category[0]->cat_name );
		$category_link = get_category_link( $category_id );
		$posttags = get_the_tags();
            if ($posttags) {
            $count=1;
            $title = single_tag_title('', false);//当前tag标题
            $tagoutput = "";
            foreach($posttags as $tag) {
            if($count>2 && $title!=$tag->name) continue;
            $tag_link = get_tag_link($tag->term_id);
            $tagoutput .= "<a href='$tag_link'  rel='tag'>$tag->name</a>  ";
            $count++;
            }
            $tagoutput = substr($tagoutput,0,strlen($tagoutput)-2);
            }
                $post_timthumb = '';
                ob_start();
                ob_end_clean();
				$outputs = preg_match_all('/\<img.+?src="(.+?)".*?\/>/is ', $post->post_content, $matches, PREG_SET_ORDER);
                $post_img_src = $matches [0][1];
                $temp = preg_match('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $index_matches);//获取日志中第一张图片
                $first_img_src = $index_matches [1];    //获取该图片 src
				$video_poster = get_post_meta($post->ID,"video_poster",true);
				if ( empty( $video_poster ) ) {
                    $video_poster = $post_img_src;
                }
				$template_url = get_bloginfo('template_url');
				$pic_text = get_post_meta($post->ID,"video_poster",true);
				$options = get_option('mfthemes_options');
	            if ( $options['cloud'] =="1" ) {
                    $thumb = ''.$video_poster.'?imageView2/1/w/125/h/90/q/100/interlace/1';
                }
				elseif ( $options['cloud'] =="2" ) {
                    $thumb = ''.$video_poster.'!pximg/both/125x90';
                }
	            else {
		            $thumb = ''.get_bloginfo('template_directory').'/timthumb.php?src='.$video_poster.'&w=125&h=90&s=1';
				}
				if ( empty( $pic_text ) ) {
                    $pic_text = 美图;
                }
				else {
					$pic_text = 视频;
				}
                $output .='<li title="'.$post_title.'">
						  <a title="'.$post_title.'" href="'.get_permalink().'">
						  <div class="list-item">
						  <span class="list-icon"><img alt="'.$post_title.'" src="'.$thumb.'"></span>
						  <span class="list-username">'.$post_title.'</span>
						  <span class="list-text">'.get_the_time('Y-m-d').'</span>
						  <span class="list-playcount">人气：'.$post_views.'点</span>
						  <span class="list-playcount">类型：'.$pic_text.'</span>
						  </div>
						  </a>
						  </li>';
        }
	 }	
    if($display) {
        echo $output;
    }
}

//首页月度排行榜
if(!function_exists('most_viewed_30')) {
    function most_viewed_30($category_id = 0, $mode = '', $limit = 10, $chars = 0, $days = 7, $display = true) {
    global $wpdb;
    $views_options = get_option('views_options');
    $limit_date = current_time('timestamp') - ($days*86400);    
    $limit_date = date("Y-m-d H:i:s",$limit_date);
    if(is_array($category_id)) {
    $category_sql = "$wpdb->term_taxonomy.term_id IN (".join(',', $category_id).')';
    }else {
    $category_sql = "$wpdb->term_taxonomy.term_id = $category_id";
    }
    if(!empty($mode) && $mode != 'both') {
    if(is_array($mode)) {
    $mode = implode("','",$mode);
    $where = "post_type IN ('".$mode."')";
    } else {
    $where = "post_type = '$mode'";
    }
    } else {
    $where = '1=1';
    }
    $most_viewed = $wpdb->get_results("SELECT DISTINCT $wpdb->posts.*, (meta_value+0) AS views FROM $wpdb->posts LEFT JOIN $wpdb->postmeta ON $wpdb->postmeta.post_id = $wpdb->posts.ID INNER JOIN $wpdb->term_relationships ON ($wpdb->posts.ID = $wpdb->term_relationships.object_id) INNER JOIN $wpdb->term_taxonomy ON ($wpdb->term_relationships.term_taxonomy_id = $wpdb->term_taxonomy.term_taxonomy_id) WHERE post_date < '".current_time('mysql')."' AND post_date > '".$limit_date."' AND $wpdb->term_taxonomy.taxonomy = 'category' AND $category_sql AND $where AND post_status = 'publish' AND meta_key = 'views' AND post_password = '' ORDER BY views DESC LIMIT $limit");
    $e = 1;
        if($most_viewed) {
        foreach ($most_viewed as $post) {
    $post_views = intval($post->views);
    $post_title = get_the_title($post);
    $post_url = get_permalink($post);
    $category = get_the_category($post);
    $modified_time = get_the_modified_time('m-d');
    $views = number_format_i18n($post_views);
        if($chars > 0) {
    $post_title = snippet_text($post_title, $chars);
    }
    $thumbnail = get_the_post_thumbnail($post->ID,'thumbnail',true);
    $post_excerpt = views_post_excerpt($post->post_excerpt, $post->post_content, $post->post_password, $chars);
    $temp = stripslashes($views_options['most_viewed_template']);
    $post_timthumb = '';
        ob_start();
        ob_end_clean();
    $outputs = preg_match_all('/\<img.+?src="(.+?)".*?\/>/is ', $post->post_content, $matches, PREG_SET_ORDER);
    $post_img_src = $matches [0][1];
    $temp = preg_match('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $index_matches);
    $first_img_src = $index_matches [1];    
    $video_poster = get_post_meta($post->ID,"video_poster",true);
        if ( empty( $video_poster ) ) {
    $video_poster = $post_img_src;
    }
    $template_url = get_bloginfo('template_url');
    $pic_text = get_post_meta($post->ID,"video_poster",true);
    $options = get_option('mfthemes_options');
        if ( $options['cloud'] =="1" ) {
    $thumb = ''.$video_poster.'?imageView2/1/w/56/h/56/q/100/interlace/1';
    }
        elseif ( $options['cloud'] =="2" ) {
    $thumb = ''.$video_poster.'!pximg/both/56x56';
    }
        else {
    $thumb = ''.get_bloginfo('template_directory').'/timthumb.php?src='.$video_poster.'&w=56&h=56&s=1';
    }
    $output .='<dd class=""><i class="num0'.$e++.'"></i>
			   <a href="'.$post_url.'" target="_blank"><img src="'.$thumb.'" title="'.$post_title.'" alt="'.$post_title.'"></a>
               <h3 class="txt01"><a href="'.$post_url.'" target="_blank">'.$post_title.'</a></h3>
               <span class="txt02">人气：'.$views.'</span><a href="'.$post_url.'" target="_blank" class="btn" style="display: none;">查看</a>
			   </dd>';
    }
    }
        if($display) {
        echo $output;
    } 
    }
}

//禁止自动更新
add_filter( 'auto_update_translation', '__return_false' );
add_filter( 'auto_update_core', '__return_false' );
add_filter( 'allow_dev_auto_core_updates', '__return_false' );
add_filter( 'allow_minor_auto_core_updates', '__return_false' );
add_filter( 'allow_major_auto_core_updates', '__return_false' );
add_action('admin_menu','wp_hide_nag');
function wp_hide_nag() {remove_action( 'admin_notices', 'update_nag', 3 );}

//文本tag
function tagtext(){
global $post;
$gettags = get_the_tags($post->ID);
if ($gettags) {
foreach ($gettags as $tag) {
$posttag[] = $tag->name;
}
$tags = implode( ',', $posttag );
echo $tags;
}
}

//日志文章分页
function pagination($query_string){
global $posts_per_page, $paged;
$my_query = new WP_Query($query_string ."&posts_per_page=-1");
$total_posts = $my_query->post_count;
if(empty($paged))$paged = 1;
$prev = $paged - 1;							
$next = $paged + 1;	
$range = 3; // 显示分页链接个数
$showitems = ($range * 2)+1;
$pages = ceil($total_posts/$posts_per_page);
if(1 != $pages){
	echo "<div class='pagination'>";
	echo ($paged > 2 && $paged+$range+100 > $pages && $showitems < $pages)? "<a href='".get_pagenum_link(1)."' class='fir_las'>«</a>":"";
	for ($i=1; $i <= $pages; $i++){
	if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )){
	echo ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a>"; 
	}
	}
	echo ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) ? "<a href='".get_pagenum_link($pages)."' class='fir_las'>»</a>":"";
	echo "</div>\n";
	}
}


/**
 * Disable the emoji's
 */
 function disable_emojis() {
 remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
 remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
 remove_action( 'wp_print_styles', 'print_emoji_styles' );
 remove_action( 'admin_print_styles', 'print_emoji_styles' );
 remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
 remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );
 remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
 add_filter( 'tiny_mce_plugins', 'disable_emojis_tinymce' );
 }
 add_action( 'init', 'disable_emojis' );
/**
 * Filter function used to remove the tinymce emoji plugin.
 */
 function disable_emojis_tinymce( $plugins ) {
 if ( is_array( $plugins ) ) {
 return array_diff( $plugins, array( 'wpemoji' ) );
 } else {
 return array();
 }
 }
 
 //禁止加载默认jq库
if ( !is_admin() ) { // 后台不禁止
function my_init_method() {
wp_deregister_script( 'jquery' ); // 取消原有的 jquery 定义
}
add_action('init', 'my_init_method');
}
wp_deregister_script( 'l10n' );

 //获取当前标签ID
$tag_title = single_tag_title('', false);
$tag = get_term_by('name', $tag_title, 'post_tag');
$tag_id = $tag->term_id; 

//根据标签ID获取文章数
function get_tag_post_count_by_id( $tag_id ) {
    $tag = get_term_by( 'id', $tag_id, 'post_tag' );
    _make_cat_compat( $tag );
    return $tag->count;
   }
   
//WordPress去除category
add_action( 'load-themes.php',  'no_category_base_refresh_rules');   
add_action('created_category', 'no_category_base_refresh_rules');   
add_action('edited_category', 'no_category_base_refresh_rules');   
add_action('delete_category', 'no_category_base_refresh_rules');   
function no_category_base_refresh_rules() {       
    global $wp_rewrite;   
    $wp_rewrite -> flush_rules();   
}   
// Remove category base   
add_action('init', 'no_category_base_permastruct');   
function no_category_base_permastruct() {   
    global $wp_rewrite, $wp_version;   
    if (version_compare($wp_version, '3.4', '<')) {   
        // For pre-3.4 support   
        $wp_rewrite -> extra_permastructs['category'][0] = '%category%';   
    } else {   
        $wp_rewrite -> extra_permastructs['category']['struct'] = '%category%';   
    }   
}   
  
// Add our custom category rewrite rules   
add_filter('category_rewrite_rules', 'no_category_base_rewrite_rules');   
function no_category_base_rewrite_rules($category_rewrite) {   
    //var_dump($category_rewrite); // For Debugging   
  
    $category_rewrite = array();   
    $categories = get_categories(array('hide_empty' => false));   
    foreach ($categories as $category) {   
        $category_nicename = $category -> slug;   
        if ($category -> parent == $category -> cat_ID)// recursive recursion   
            $category -> parent = 0;   
        elseif ($category -> parent != 0)   
            $category_nicename = get_category_parents($category -> parent, false, '/', true) . $category_nicename;   
        $category_rewrite['(' . $category_nicename . ')/(?:feed/)?(feed|rdf|rss|rss2|atom)/?$'] = 'index.php?category_name=$matches[1]&feed=$matches[2]';   
        $category_rewrite['(' . $category_nicename . ')/page/?([0-9]{1,})/?$'] = 'index.php?category_name=$matches[1]&paged=$matches[2]';   
        $category_rewrite['(' . $category_nicename . ')/?$'] = 'index.php?category_name=$matches[1]';   
    }   
    // Redirect support from Old Category Base   
    global $wp_rewrite;   
    $old_category_base = get_option('category_base') ? get_option('category_base') : 'category';   
    $old_category_base = trim($old_category_base, '/');   
    $category_rewrite[$old_category_base . '/(.*)$'] = 'index.php?category_redirect=$matches[1]';   
  
    //var_dump($category_rewrite); // For Debugging   
    return $category_rewrite;   
}   
// Add 'category_redirect' query variable   
add_filter('query_vars', 'no_category_base_query_vars');   
function no_category_base_query_vars($public_query_vars) {   
    $public_query_vars[] = 'category_redirect';   
    return $public_query_vars;   
}   
// Redirect if 'category_redirect' is set   
add_filter('request', 'no_category_base_request');   
function no_category_base_request($query_vars) {   
    //print_r($query_vars); // For Debugging   
    if (isset($query_vars['category_redirect'])) {   
        $catlink = trailingslashit(get_option('home')) . user_trailingslashit($query_vars['category_redirect'], 'category');   
        status_header(301);   
        header("Location: $catlink");   
        exit();   
    }   
    return $query_vars;   
}

//禁止头部加载s.w.org
function remove_dns_prefetch( $hints, $relation_type ) {
if ( 'dns-prefetch' === $relation_type ) {
return array_diff( wp_dependencies_unique_hosts(), $hints );
}
return $hints;
}
add_filter( 'wp_resource_hints', 'remove_dns_prefetch', 10, 2 );

//禁用REST API
add_filter('rest_enabled', '_return_false'); 
add_filter('rest_jsonp_enabled', '_return_false');

//移除wp-json链接
remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );
remove_action( 'wp_head', 'wp_oembed_add_discovery_links', 10 );

//移除自动保存
wp_deregister_script('autosave');
//移除修订版本
remove_action('post_updated','wp_save_post_revision');

//禁用embeds功能并移除wp-embed.min.js
function disable_embeds_init() {
    /* @var WP $wp */
    global $wp;
 
    // Remove the embed query var.
    $wp->public_query_vars = array_diff( $wp->public_query_vars, array(
        'embed',
    ) );
 
    // Remove the REST API endpoint.
    remove_action( 'rest_api_init', 'wp_oembed_register_route' );
 
    // Turn off
    add_filter( 'embed_oembed_discover', '__return_false' );
 
    // Don't filter oEmbed results.
    remove_filter( 'oembed_dataparse', 'wp_filter_oembed_result', 10 );
 
    // Remove oEmbed discovery links.
    remove_action( 'wp_head', 'wp_oembed_add_discovery_links' );
 
    // Remove oEmbed-specific JavaScript from the front-end and back-end.
    remove_action( 'wp_head', 'wp_oembed_add_host_js' );
    add_filter( 'tiny_mce_plugins', 'disable_embeds_tiny_mce_plugin' );
 
    // Remove all embeds rewrite rules.
    add_filter( 'rewrite_rules_array', 'disable_embeds_rewrites' );
}
 
add_action( 'init', 'disable_embeds_init', 9999 );
 
/**
 * Removes the 'wpembed' TinyMCE plugin.
 *
 * @since 1.0.0
 *
 * @param array $plugins List of TinyMCE plugins.
 * @return array The modified list.
 */
function disable_embeds_tiny_mce_plugin( $plugins ) {
    return array_diff( $plugins, array( 'wpembed' ) );
}
 
/**
 * Remove all rewrite rules related to embeds.
 *
 * @since 1.2.0
 *
 * @param array $rules WordPress rewrite rules.
 * @return array Rewrite rules without embeds rules.
 */
function disable_embeds_rewrites( $rules ) {
    foreach ( $rules as $rule => $rewrite ) {
        if ( false !== strpos( $rewrite, 'embed=true' ) ) {
            unset( $rules[ $rule ] );
        }
    }
 
    return $rules;
}
 
/**
 * Remove embeds rewrite rules on plugin activation.
 *
 * @since 1.2.0
 */
function disable_embeds_remove_rewrite_rules() {
    add_filter( 'rewrite_rules_array', 'disable_embeds_rewrites' );
    flush_rewrite_rules();
}
 
register_activation_hook( __FILE__, 'disable_embeds_remove_rewrite_rules' );
 
/**
 * Flush rewrite rules on plugin deactivation.
 *
 * @since 1.2.0
 */
function disable_embeds_flush_rewrite_rules() {
    remove_filter( 'rewrite_rules_array', 'disable_embeds_rewrites' );
    flush_rewrite_rules();
}
 
register_deactivation_hook( __FILE__, 'disable_embeds_flush_rewrite_rules' );

add_filter( 'show_admin_bar', '__return_false' );


/* 访问计数 */
function record_visitors()
{
 if (is_singular())
 {
   global $post;
   $post_ID = $post->ID;
   if($post_ID)
   {
   $post_views = (int)get_post_meta($post_ID, 'views', true);
   if(!update_post_meta($post_ID, 'views', ($post_views+1)))
   {
 add_post_meta($post_ID, 'views', 1, true);
   }
   }
 }
}
add_action('wp_head', 'record_visitors');
 
/// 函数名称：post_views
/// 函数作用：取得文章的阅读次数
function post_views($before = '(点击 ', $after = ' 次)', $echo = 1)
{
  global $post;
  $post_ID = $post->ID;
  $views = (int)get_post_meta($post_ID, 'views', true);
  if ($echo) echo $before, number_format($views), $after;
  else return $views;
}
?>