<?php 
/*
* 侧边栏组件、页面模块
*/
if(!defined('EMLOG_ROOT')) {exit('error!');} 
?>
<?php
//widget：blogger
function widget_blogger($title){
	global $CACHE;
	$user_cache = $CACHE->readCache('user');
	$name = $user_cache[1]['mail'] != '' ? "<a href=\"mailto:".$user_cache[1]['mail']."\">".$user_cache[1]['name']."</a>" : $user_cache[1]['name'];?>
	<div class="cbx">
	<h3><span><?php echo $title; ?></span></h3>
	<div class="ctx">
	<ul id="bloggerinfo">
	<div id="bloggerinfoimg">
	<?php if (!empty($user_cache[1]['photo']['src'])): ?>
	<img src="<?php echo BLOG_URL.$user_cache[1]['photo']['src']; ?>" width="<?php echo $user_cache[1]['photo']['width']; ?>" height="<?php echo $user_cache[1]['photo']['height']; ?>" alt="blogger" />
	<?php endif;?>
	</div>
	<p><b><?php echo $name; ?></b>
	<?php echo $user_cache[1]['des']; ?></p>
	</ul>
	</div>
	</div>
<?php }?>
<?php
//widget：日历
function widget_calendar($title){ ?>
	<div class="cbx">
	<h3><span><?php echo $title; ?></span></h3>
	<div id="calendar">
	</div>
	<script>sendinfo('<?php echo Calendar::url(); ?>','calendar');</script>
	</div>
<?php }?>
<?php
//widget：标签
function widget_tag($title){
	global $CACHE;
	$tag_cache = $CACHE->readCache('tags');?>
	<div class="cbx">
	<h3><span><?php echo $title; ?></span></h3>
	<div class="ctx">
	<ul id="blogtags">
	<?php foreach($tag_cache as $value): ?>
		<span style="font-size:<?php echo $value['fontsize']; ?>pt; line-height:30px;">
		<a href="<?php echo Url::tag($value['tagurl']); ?>" title="<?php echo $value['usenum']; ?> 篇日志"><?php echo $value['tagname']; ?></a></span>
	<?php endforeach; ?>
	</ul>
	</div>
	</div>
<?php }?>
<?php
//widget：分类
function widget_sort($title){
	global $CACHE;
	$sort_cache = $CACHE->readCache('sort'); ?>
	<div class="cbx list2">
	<h3><span><?php echo $title; ?></span></h3>
	<div class="ctx">
	<ul id="blogsort">
	<?php foreach($sort_cache as $value): ?>
	<li>
	<a href="<?php echo Url::sort($value['sid']); ?>"><?php echo $value['sortname']; ?>(<?php echo $value['lognum'] ?>)</a>
	</li>
	<?php endforeach; ?>
	</ul>
	</div>
	</div>
<?php }?>
<?php
//widget：最新碎语
function widget_twitter($title){
	global $CACHE; 
	$newtws_cache = $CACHE->readCache('newtw');
	$istwitter = Option::get('istwitter');
	?>
	<div class="cbx">
	<h3><span><?php echo $title; ?></span></h3>
	<div class="ctx">
	<ul id="twitter">
	<?php foreach($newtws_cache as $value): ?>
	<li><?php echo $value['t']; ?><p><?php echo smartDate($value['date']); ?> </p></li>
	<?php endforeach; ?>
    <?php if ($istwitter == 'y') :?>
	<p><a href="<?php echo BLOG_URL . 't/'; ?>">更多&raquo;</a></p>
	<?php endif;?>
	</ul>
	</div>
	</div>
<?php }?>
<?php
//widget：最新评论
function widget_newcomm($title){
	global $CACHE; 
	$com_cache = $CACHE->readCache('comment');
	?>
	<div class="cbx" id="recent-comments">
	<h3><span><?php echo $title; ?></span></h3>
	<div class="ctx">
	<ul id="newcomment">
	<?php
	foreach($com_cache as $value):
	$url = Url::comment($value['gid'], $value['page'], $value['cid']);
	?>
	<li id="comment">
	<a href="<?php echo $url; ?>"><span class="comer"><?php echo $value['name']; ?> : </span><?php echo $value['content']; ?></a></li>
	<?php endforeach; ?>
	</ul>
	</div>
	</div>
<?php }?>
<?php
//widget：最新日志
function widget_newlog($title){
	global $CACHE; 
	$newLogs_cache = $CACHE->readCache('newlog');
	?>
	<div class="cbx">
	<h3><span><?php echo $title; ?></span></h3>
	<div class="ctx">
	<ul id="newlog">
	<?php foreach($newLogs_cache as $value): ?>
	<li><a href="<?php echo Url::log($value['gid']); ?>"><?php echo $value['title']; ?></a></li>
	<?php endforeach; ?>
	</ul>
	</div>
	</div>
<?php }?>
<?php
//widget：随机日志
function widget_random_log($title){
	$index_randlognum = Option::get('index_randlognum');
	$Log_Model = new Log_Model();
	$randLogs = $Log_Model->getRandLog($index_randlognum);?>
	<div class="cbx">
	<h3><span><?php echo $title; ?></span></h3>
	<div class="ctx">
	<ul id="randlog">
	<?php foreach($randLogs as $value): ?>
	<li><a href="<?php echo Url::log($value['gid']); ?>"><?php echo $value['title']; ?></a></li>
	<?php endforeach; ?>
	</ul>
	</div>
	</div>
<?php }?>
<?php
//widget：搜索
function widget_search($title){ ?>
	<div class="cbx">
	<h3><span><?php echo $title; ?></span></h3>
	<div class="ctx">
	<ul id="logserch">
	<form name="keyform" method="get" action="<?php echo BLOG_URL; ?>index.php">
	<input class="textinupt" name="keyword"  type="text" value="" style="width:120px;"/>
	<input type="submit" id="logserch_logserch" value="搜索" />
	</form>
	</ul>
	</div>
	</div>
<?php } ?>
<?php
//widget：归档
function widget_archive($title){
	global $CACHE; 
	$record_cache = $CACHE->readCache('record');
	?>
	<div class="cbx">
	<h3><span><?php echo $title; ?></span></h3>
	<div class="ctx ">
	<ul id="record">
	<?php foreach($record_cache as $value): ?>
	<li><a href="<?php echo Url::record($value['date']); ?>"><?php echo $value['record']; ?>(<?php echo $value['lognum']; ?>)</a></li>
	<?php endforeach; ?>
	</ul>
	</div>
	</div>
<?php } ?>
<?php
//widget：自定义组件
function widget_custom_text($title, $content){ ?>
	<div class="cbx">
	<h3><span><?php echo $title; ?></span></h3>
	<div class="ctx">
	<ul>
	<?php echo $content; ?>
	</ul>
	</div>
	</div>
<?php } ?>
<?php
//widget：链接
function widget_link($title){
	global $CACHE; 
	$link_cache = $CACHE->readCache('link');
	?>
	<div class="cbx list2">
	<h3><span><?php echo $title; ?></span></h3>
	<div class="ctx">
	<ul id="link">
	<?php foreach($link_cache as $value): ?>
	<li><a href="<?php echo $value['url']; ?>" title="<?php echo $value['des']; ?>" target="_blank"><?php echo $value['link']; ?></a></li>
	<?php endforeach; ?>
	</ul>
	</div>
	</div>
<?php }?>
<?php
//blog：置顶
function topflg($istop){
	$topflg = $istop == 'y' ? "<img src=\"".TEMPLATE_URL."/images/import.gif\" title=\"置顶日志\" /> " : '';
	echo $topflg;
}
?>
<?php
//blog：编辑
function editflg($logid,$author){
	$editflg = ROLE == 'admin' || $author == UID ? '<a href="'.BLOG_URL.'admin/write_log.php?action=edit&gid='.$logid.'">编辑</a>' : '';
	echo $editflg;
}
?>
<?php
//blog：导航
function blog_navi(){
	global $CACHE; 
	$navi_cache = $CACHE->readCache('navi');
	?>
	<ul>
	<?php 
	foreach($navi_cache as $value):
		if($value['url'] == 'admin' && (ROLE == 'admin' || ROLE == 'writer')):
			?>
			<li class="common"><a href="<?php echo BLOG_URL; ?>admin/write_log.php">写日志</a></li>
			<li class="common"><a href="<?php echo BLOG_URL; ?>admin/">管理站点</a></li>
			<li class="common"><a href="<?php echo BLOG_URL; ?>admin/?action=logout">退出</a></li>
			<?php 
			continue;
		endif;
		$newtab = $value['newtab'] == 'y' ? 'target="_blank"' : '';
		$value['url'] = $value['isdefault'] == 'y' ? BLOG_URL . $value['url'] : trim($value['url'], '/');
		$current_tab = (BLOG_URL . trim(Dispatcher::setPath(), '/') == $value['url']) ? 'current' : 'common';
		?>
		<li class="common"><a href="<?php echo $value['url']; ?>" <?php echo $newtab;?> class="<?php echo $current_tab;?>"><?php echo $value['naviname']; ?></a></li>
	<?php endforeach; ?>
	<div class="clear"></div>
	</ul>
<?php }?>
<?php
//blog：分类
function blog_sort($blogid){
	global $CACHE; 
	$log_cache_sort = $CACHE->readCache('logsort');
	?>
	<?php if(!empty($log_cache_sort[$blogid])): ?>
	分类：<a href="<?php echo Url::sort($log_cache_sort[$blogid]['id']); ?>"><?php echo $log_cache_sort[$blogid]['name']; ?></a>
	<?php endif;?>
<?php }?>
<?php
//blog：分类4new
function blog_sort_4_new($blogid){
	global $CACHE; 
	$log_cache_sort = $CACHE->readCache('logsort');
	?>
	<?php if(!empty($log_cache_sort[$blogid])): ?>
	<a href="<?php echo Url::sort($log_cache_sort[$blogid]['id']); ?>"><?php echo $log_cache_sort[$blogid]['name']; ?></a> &nbsp;&raquo;&nbsp;
	<?php endif;?>
<?php }?>
<?php
//blog：文件附件
function blog_att($blogid){
	global $CACHE;
	$log_cache_atts = $CACHE->readCache('logatts');
	$att = '';
	if(!empty($log_cache_atts[$blogid])){
		$att .= '附件下载：';
		foreach($log_cache_atts[$blogid] as $val){
			$att .= '<br /><a href="'.BLOG_URL.$val['url'].'" target="_blank">'.$val['filename'].'</a> '.$val['size'];
		}
	}
	echo $att;
}
?>
<?php
//blog：日志标签
function blog_tag($blogid){
	global $CACHE;
	$log_cache_tags = $CACHE->readCache('logtags');
	if (!empty($log_cache_tags[$blogid])){
		$tag = '标签:';
		foreach ($log_cache_tags[$blogid] as $value){
			$tag .= "	<a href=\"".Url::tag($value['tagurl'])."\">".$value['tagname'].'</a>';
		}
		echo $tag;
	}
}
?>
<?php
//blog：日志作者
function blog_author($uid){
	global $CACHE;
	$user_cache = $CACHE->readCache('user');
	$author = $user_cache[$uid]['name'];
	$mail = $user_cache[$uid]['mail'];
	$des = $user_cache[$uid]['des'];
	$title = !empty($mail) || !empty($des) ? "title=\"$des $mail\"" : '';
	echo '<a href="'.Url::author($uid)."\" $title>$author</a>";
}
?>
<?php
//blog：相邻日志
function neighbor_log($neighborLog){
	extract($neighborLog);?>
	<?php if($prevLog):?>
	<span class="prev"> <a href="<?php echo Url::log($prevLog['gid']) ?>"><?php echo $prevLog['title'];?></a></span>
	<?php endif;?>
	<?php if($nextLog):?>
	<span class="next"><a href="<?php echo Url::log($nextLog['gid']) ?>"><?php echo $nextLog['title'];?></a></span>
	<?php endif;?>
<?php }?>
<?php
//blog：引用通告
function blog_trackback($tb, $tb_url, $allow_tb){
    if($allow_tb == 'y' && Option::get('istrackback') == 'y'):?>
	<div id="trackback_address">
	<p>引用地址: <input type="text" style="width:350px" class="input" value="<?php echo $tb_url; ?>">
	<a name="tb"></a></p>
	</div>
	<?php endif; ?>
	<?php foreach($tb as $key=>$value):?>
		<ul id="trackback">
		<li><a href="<?php echo $value['url'];?>" target="_blank"><?php echo $value['title'];?></a></li>
		<li>BLOG: <?php echo $value['blog_name'];?></li><li><?php echo $value['date'];?></li>
		</ul>
	<?php endforeach; ?>
<?php }?>
<?php
//blog：博客评论列表
function blog_comments($comments){
    extract($comments);
    if($commentStacks): $commnum = count($comments);
	?>
	<div id="commnents" class="commentsorping">
		<div class="commentsays">已经有<?php echo $commnum; ?>个回复</div>
		<div class="commentpart" style="color: rgb(34, 34, 34);"><span class="commentparttri" style="opacity: 1;"></span>展开评论 (<?php echo $commnum; ?>)</div>
		<div class="pingpart" style="color: rgb(153, 153, 153);"><span class="pingparttri" style="opacity: 0;"></span>收起评论</div>
		<div class="clear"></div>
	</div>
	
	<?php endif; ?>
	<div class="commentshow" style="display: block;">
	<?php
	$isGravatar = Option::get('isgravatar');
	foreach($commentStacks as $cid):
    $comment = $comments[$cid];
	$comment['poster'] = $comment['url'] ? '<a href="'.$comment['url'].'" target="_blank" rel="external nofollow">'.$comment['poster'].'</a>' : $comment['poster'];
	?>
	<ol class="commentlist">
		<li id="comment-<?php echo $comment['cid']; ?>">
			<div class="comment-body">
				<div class="commenttext">
					<?php if($isGravatar == 'y'): ?><div class="gravatar"><img width="32" height="32" src="<?php echo getGravatar($comment['mail']); ?>" /></div><?php endif; ?>
					<div class="comment-meta">
						<span class="commentid"> <?php echo $comment['poster']; ?> </span>
						<span class="commenttime"> ( <?php echo $comment['date']; ?> ) </span>
						<span class="commentidnext"> : </span>
					</div>
					<div class="commentp">
						<p>
							<?php echo $comment['content']; ?>
						</p>
						<span style="display: none;" class="reply"> <a class="comment-reply-link" onclick="commentReply(<?php echo $comment['cid']; ?>,this)">回复</a> </span>
					</div>
				</div>
				<div class="clearline"></div>
			</div>
			<?php blog_comments_children($comments, $comment['children']); ?>
		</li>
	</ol>
	<?php endforeach; ?>
    <div id="pagenavi" class="pagenavi">
	    <?php echo $commentPageUrl;?>
    </div>
	</div><!--end commentshow-->
<?php }?>
<?php
//blog：博客子评论列表
function blog_comments_children($comments, $children){
	$isGravatar = Option::get('isgravatar');
	foreach($children as $child):
	$comment = $comments[$child];
	$comment['poster'] = $comment['url'] ? '<a href="'.$comment['url'].'" target="_blank" rel="external nofollow">'.$comment['poster'].'</a>' : $comment['poster'];
	?>
	<ul class="children">
		<li id="comment-<?php echo $comment['cid']; ?>" class="comment">
			<div class="comment-body">
				<div class="commenttext">
					<?php if($isGravatar == 'y'): ?><div class="gravatar"><img width="32" height="32" src="<?php echo getGravatar($comment['mail']); ?>" /></div><?php endif; ?>
					<div class="comment-meta">
						<span class="commentid"> <?php echo $comment['poster']; ?> </span>
						<span class="commenttime"> ( <?php echo $comment['date']; ?> ) </span>
						<span class="commentidnext"> : </span>
					</div>
					<div class="commentp">
						<p>
							<?php echo $comment['content']; ?>
						</p>
						<?php if($comment['level'] < 4): ?>
						<span style="display: none;" class="reply"> <a class="comment-reply-link" onclick="commentReply(<?php echo $comment['cid']; ?>,this)">回复</a> </span>
						<?php endif; ?>
					</div>
				</div>
				<div class="clearline"></div>
			</div>
			<?php blog_comments_children($comments, $comment['children']);?>
		</li>
	</ul>
	<?php endforeach; ?>
<?php }?>
<?php
//blog：发表评论表单
function blog_comments_post($logid,$ckname,$ckmail,$ckurl,$verifyCode,$allow_remark){
	if($allow_remark == 'y'): ?>
	<div id="comment-place">
	<div id="comment-post" class="respond">
		<h2>说点什么吧</h2>
		<div class="cancel-reply" id="cancel-reply" style="display:none"><a href="javascript:void(0);" onclick="cancelReply()">取消回复</a></div>
		<form method="post" name="commentform" action="<?php echo BLOG_URL; ?>index.php?action=addcom" id="commentform">
			<div id="author_info">
				<input type="hidden" name="gid" value="<?php echo $logid; ?>" />
				<?php if(ROLE == 'visitor'): ?>
				<div class="writerinfodiv">
					<input type="text" name="comname" id="author" value="<?php echo $ckname; ?>" tabindex="1">
					<label for="author">
						昵称 (必填)
					</label>
				</div>
				<div class="writerinfodiv">
					<input type="email" name="commail" id="email" value="<?php echo $ckmail; ?>" tabindex="2">
					<label for="email">
						邮箱 (用于显<a href="http://www.gravatar.com" rel="external nofollow" target="_blank">Gravata</a>头像，必填)
					</label>
				</div>
				<div class="writerinfodiv">
					<input type="text" name="comurl" id="url" value="<?php echo $ckurl; ?>" tabindex="3">
					<label for="url">
						站点
					</label>
				</div>
				<?php endif; ?>
				<p><textarea name="comment" id="comment" rows="10" tabindex="4"></textarea></p>
				<p><span id="verify"><?php echo $verifyCode; ?> </span> <input type="submit" id="submit" value="发表评论" tabindex="6" /></p>
				<input type="hidden" name="pid" id="comment-pid" value="0" size="22" tabindex="1"/>
			</div>
		</form>
	</div><!--end #comment-post-->
	</div><!--end #comment-place-->
	<?php endif; ?>
<?php }?>

<?php 
//侧边栏获取日志输出
function sideBlogList($way = "new",$num=10){
	$date = time() - 3600 * 24 * $day;
	if($way=="new"){//最新发表
        $order = "hide='n' and type='blog' ORDER BY date DESC";
	}if($way=="rand"){//随机
        $order = "hide='n' and type='blog' ORDER BY rand()";
    }if($way=='view'){//点击次数
		$order = "hide='n' and type='blog' ORDER BY views DESC";
	}
	$db = MySql::getInstance();
	$sql = "SELECT gid,title,date,content,excerpt FROM ".DB_PREFIX."blog WHERE $order LIMIT 0,$num";
	$log = $db->query($sql);
	while($row = $db->fetch_array($log)) {
		echo'<li><a href="'.Url::log($row['gid']).'" title="'.$row['title'].'" >'.$row['title'].'</a></li>';
	}
}?>
