<?php

/*
 * 博闻广记免费版
 *
 * 清萍工作室打造  www.qpjk.cc
 * 一个爱好古风主题的工作室
 */

define( 'OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri() . '/inc/' );
require_once dirname( __FILE__ ) . '/inc/options-framework.php';

// Loads options.php from child or parent theme
$optionsfile = locate_template( 'options.php' );
load_template( $optionsfile );

/*
 * This is an example of how to add custom scripts to the options panel.
 * This one shows/hides the an option when a checkbox is clicked.
 *
 * You can delete it if you not using that option
 */
add_action( 'optionsframework_custom_scripts', 'optionsframework_custom_scripts' );

function optionsframework_custom_scripts() { ?>

<script>
jQuery(document).ready(function() {

    jQuery('#example_showhidden').click(function() {
        jQuery('#section-example_text_hidden').fadeToggle(400);
    });

    if (jQuery('#example_showhidden:checked').val() !== undefined) {
        jQuery('#section-example_text_hidden').show();
    }

});
</script>

<?php
}
?>


<?php
/**
 * Handles JavaScript detection.
 *
 * Adds a `js` class to the root `<html>` element when JavaScript is detected.
 *
 * @since bowenguangji 1.8
 */
function bowenguangji_javascript_detection() {
	echo "<script>(function(html){html.className = html.className.replace(/\bno-js\b/,'js')})(document.documentElement);</script>\n";
}
add_action( 'wp_head', 'bowenguangji_javascript_detection', 0 );

?>

<?php
//导航菜单
register_nav_menus( array( 
 'nav1' => '用于头部位置',
 ));

//菜单回调函数
function top_nav_fallback(){
  echo '<ul class="menu">'.'<li class="menu-item"><a href="/">首页</a></li><li class="menu-item"><a href="/wp-admin/nav-menus.php">设置菜单</a></li><li class="menu-item"><a href="/wp-admin/nav-menus.php">设置菜单</a></li><li class="menu-item"><a href="/wp-admin/nav-menus.php">设置菜单</a></li><li class="menu-item"><a href="/wp-admin/nav-menus.php">设置菜单</a></li><li class="menu-item"><a href="/wp-admin/nav-menus.php">设置菜单</a></li><li class="menu-item"><a href="/wp-admin/nav-menus.php">设置菜单</a></li><li class="menu-item"><a href="/wp-admin/nav-menus.php">设置菜单</a></li><li class="menu-item"><a href="/wp-admin/nav-menus.php">设置菜单</a></li><li class="menu-item"><a href="/wp-admin/nav-menus.php">设置菜单</a></li><li class="menu-item"><a href="/wp-admin/nav-menus.php">设置菜单</a></li>' .'</ul>';
}

// 过滤掉自定义菜单中无用的CLASS值
 function filter_nav_menu_css_class ($classes){
//想要通过的class值
 $do_class_name = array('current-menu-item');
 $outPut = array_intersect($do_class_name,$classes);
 array_filter( $classes );
 return $outPut;
};
add_filter('nav_menu_css_class','filter_nav_menu_css_class');

 ?>


 <?php
// 清除WordPress头部冗余代码
// 移除wordpress顶部工具栏css样式

add_filter('rest_enabled', '_return_false');
add_filter('rest_jsonp_enabled', '_return_false');
remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );
remove_action( 'wp_head', 'wp_oembed_add_discovery_links', 10 );
add_action('get_header', 'remove_admin_login_header');
function remove_admin_login_header() {
    remove_action('wp_head', '_admin_bar_bump_cb');
}
remove_action( 'wp_head', 'wp_enqueue_scripts', 1 ); //Javascript的调用
remove_action( 'wp_head', 'feed_links', 2 ); //移除feed
remove_action( 'wp_head', 'feed_links_extra', 3 ); //移除feed
remove_action( 'wp_head', 'rsd_link' ); //移除离线编辑器开放接口
remove_action( 'wp_head', 'wlwmanifest_link' );  //移除离线编辑器开放接口
remove_action( 'wp_head', 'index_rel_link' );//去除本页唯一链接信息
remove_action('wp_head', 'parent_post_rel_link', 10, 0 );//清除前后文信息
remove_action('wp_head', 'start_post_rel_link', 10, 0 );//清除前后文信息
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );
remove_action( 'wp_head', 'locale_stylesheet' );
remove_action('publish_future_post','check_and_publish_future_post',10, 1 );
remove_action( 'wp_head', 'noindex', 1 );
remove_action( 'wp_head', 'wp_print_styles', 8 );//载入css
remove_action( 'wp_head', 'wp_print_head_scripts', 9 );
remove_action( 'wp_head', 'wp_generator' ); //移除WordPress版本
remove_action( 'wp_head', 'rel_canonical' );
remove_action( 'wp_footer', 'wp_print_footer_scripts' );
remove_action( 'wp_head', 'wp_shortlink_wp_head', 10, 0 );
remove_action( 'template_redirect', 'wp_shortlink_header', 11, 0 );
add_action('widgets_init', 'my_remove_recent_comments_style');
function my_remove_recent_comments_style() {
global $wp_widget_factory;
remove_action('wp_head', array($wp_widget_factory->widgets['WP_Widget_Recent_Comments'] ,'recent_comments_style'));
}
?>


<?php
// 分页代码
function bowen_page_nav(){
global $wp_query;

$big = 999999999; // 需要一个不太可能的整数

echo '<div id="pagenavi" data-kui-anim="slideInUp">';
echo paginate_links( array(
  'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
  'format' => '',
  'current' => max( 1, get_query_var('paged') ),
  'total' => $wp_query->max_num_pages,
  'prev_text'    => '«',
  'next_text'    => '»',
) );
echo '</div>';
}
?>


<?php
//文章阅读次数统计
function get_post_views ($post_id) {   
  
    $count_key = 'views';   
    $count = get_post_meta($post_id, $count_key, true);   
  
    if ($count == '') {   
        delete_post_meta($post_id, $count_key);   
        add_post_meta($post_id, $count_key, '0');   
        $count = '0';   
    }   
  
    echo number_format_i18n($count);   
  
}   
  
function set_post_views () {   
  
    global $post;   
  
    $post_id = $post -> ID;   
    $count_key = 'views';   
    $count = get_post_meta($post_id, $count_key, true);   
  
    if (is_single() || is_page()) {   
  
        if ($count == '') {   
            delete_post_meta($post_id, $count_key);   
            add_post_meta($post_id, $count_key, '0');   
        } else {   
            update_post_meta($post_id, $count_key, $count + 1);   
        }   
  
    }   
  
}   
add_action('get_header', 'set_post_views');  
?>

<?php
// 侧边栏小工具widgets
register_sidebar( array(
 'name' => __( '默认侧边栏', 'Bing' ),//侧边的名字
 'id' => 'widget_default',//侧边栏的 ID，注册多个侧边栏的时候不要重复
 'description' => __( '侧边栏的描述', 'Bing' ),//侧边栏的描述，会在后台显示
 'before_widget' => '<div data-kui-anim="slideInUp" class="widget %2$s">',//侧边栏里的小工具的开头代码，可以在里边使用 %2$s 来调用小工具的 ID，实现给每个小工具添加不同的样式
 'after_widget' => '</div>',//侧边栏里的小工具的结尾代码
 'before_title' => '<h3 class="widget-title">',//侧边栏里的小工具的标题的开头代码
 'after_title' => '</h3>'//侧边栏里的小工具的标题的结尾代码
) );
?>


<?php
// 显示后台链接功能（友情链接）
add_filter( 'pre_option_link_manager_enabled', '__return_true' );
?>

<?php
/*
*显示页面查询次数、加载时间和内存占用 www.qpjk.cc
*调用方法：<?php if(function_exists('performance')) performance(ture) ;?>
*performance的参数 false 表示在页面前端不显示，ture只在html源码中可见
*/
function performance( $visible = false ) {
    $stat = sprintf(  '<li>查询数据库<span class="hongsezi">%d</span>次，耗时<span class="hongsezi">%.3f</span>秒。</li><li>内存消耗<span class="hongsezi"> %.2f MB</span></li>',
        get_num_queries(),
        timer_stop( 0, 3 ),
        memory_get_peak_usage() / 1024 / 1024
    );
    echo $visible ? $stat : "<!-- {$stat} -->" ;
}
?>

<?php
// 评论头像地址更改
function get_ssl_avatar($avatar) {
   $avatar = preg_replace('/.*\/avatar\/(.*)\?s=([\d]+)&.*/','<img src="https://secure.gravatar.com/avatar/$1?s=$2" class="avatar avatar-$2">',$avatar);
   return $avatar;
}
add_filter('get_avatar', 'get_ssl_avatar');
?>


<?php
// 禁用谷歌字体
if (!function_exists('remove_wp_open_sans')) : 
function remove_wp_open_sans() { 
wp_deregister_style( 'open-sans' ); 
wp_register_style( 'open-sans', false ); 
}
// 前台删除Google字体CSS 
add_action('wp_enqueue_scripts', 'remove_wp_open_sans');
// 后台删除Google字体CSS 
add_action('admin_enqueue_scripts', 'remove_wp_open_sans'); 
endif;
?>


<?php
//压缩html代码
function wp_compress_html(){
    function wp_compress_html_main ($buffer){
        $initial=strlen($buffer);
        $buffer=explode("<!--wp-compress-html-->", $buffer);
        $count=count ($buffer);
        for ($i = 0; $i <= $count; $i++){
            if (stristr($buffer[$i], '<!--wp-compress-html no compression-->')) {
                $buffer[$i]=(str_replace("<!--wp-compress-html no compression-->", " ", $buffer[$i]));
            } else {
                $buffer[$i]=(str_replace("\t", " ", $buffer[$i]));
                $buffer[$i]=(str_replace("\n\n", "\n", $buffer[$i]));
                $buffer[$i]=(str_replace("\n", "", $buffer[$i]));
                $buffer[$i]=(str_replace("\r", "", $buffer[$i]));
                while (stristr($buffer[$i], '  ')) {
                    $buffer[$i]=(str_replace("  ", " ", $buffer[$i]));
                }
            }
            $buffer_out.=$buffer[$i];
        }
        $final=strlen($buffer_out);   
        $savings=($initial-$final)/$initial*100;   
        $savings=round($savings, 2);   
        $buffer_out.="\n<!--压缩前的大小: $initial bytes; 压缩后的大小: $final bytes; 节约：$savings% -->";   
    return $buffer_out;
}
if ( !is_admin() ) { 
        ob_start("wp_compress_html_main");
    }
}
add_action('init', 'wp_compress_html');


//自动在存在高亮代码的文章收尾插入免压缩注释 By 张戈博客
  function Code_Box($content) {
    $matches = array();
    //一下是匹配高亮代码的关键词，本代码适用于 Crayon Syntax Highlighter 插件，其他插件请自行分析关键词即可
    $c = "/(crayon-|<\/pre>)/i";
    if(preg_match_all($c, $content, $matches) && is_single()) {
        $content = '<!--wp-compress-html--><!--wp-compress-html no compression-->'.$content;
        $content.= '<!--wp-compress-html no compression--><!--wp-compress-html-->';
     }
    return $content;
}
add_filter( "the_content", "Code_Box" );

?>

<?php
// 评论添加@，
function bamao_comment_add_at( $comment_text, $comment = '') { 
  if( $comment->comment_parent > 0) { 
    $comment_text = '<span class="hongsezi">@</span><a class="hongsezi" href="#comment-' . $comment->comment_parent . '">'.get_comment_author( $comment->comment_parent ) . '</a> ' . $comment_text; 
  } 
  return $comment_text; 
} 
add_filter( 'comment_text' , 'bamao_comment_add_at', 20, 2);
?>


<?php
//检测是否为手机
function em_is_mobile() {
    static $is_mobile;
    if ( isset($is_mobile) )
        return $is_mobile;
    if ( empty($_SERVER['HTTP_USER_AGENT']) ) {
        $is_mobile = false;
    } elseif ( strpos($_SERVER['HTTP_USER_AGENT'], 'Mobile') !== false
        || strpos($_SERVER['HTTP_USER_AGENT'], 'Android') !== false
        || strpos($_SERVER['HTTP_USER_AGENT'], 'Silk/') !== false
        || strpos($_SERVER['HTTP_USER_AGENT'], 'Kindle') !== false
        || strpos($_SERVER['HTTP_USER_AGENT'], 'BlackBerry') !== false
        || strpos($_SERVER['HTTP_USER_AGENT'], 'Opera Mini') !== false
        || strpos($_SERVER['HTTP_USER_AGENT'], 'Opera Mobi') !== false ) {
            $is_mobile = true;
    } else {
        $is_mobile = false;
    }
    return $is_mobile;
}
?>