<?php

class Cache {

	public $cache_time;
	public $cache_dir;
	public $cache_file;
	public $is_cache = false;

	function __construct($config_blog_file_arr,$web_request_arr){
 
		$this->cache_time = (int)$config_blog_file_arr['cfg_blog_cache_time'];
		$this->cache_dir  = App_Cache;
		$this->cache_file = App_Cache.md5(implode('/',$web_request_arr)).".php";
        $url_array_back_file = UrlRoute($web_request_arr,$config_blog_file_arr);
        if( $this->cache_time && $url_array_back_file['model'] == 'Home' && empty($_SESSION['uid']) && empty($_COOKIE['uid']) && empty($_GET['display']) ){
			if($url_array_back_file['action'] == 'index' || $url_array_back_file['action'] == 'post'){
				$this->is_cache  = true;
			}
        }
	}

	function GetCache(){
		if( $this->is_cache ){
			if(file_exists($this->cache_file)){
		        if(time() - filemtime($this->cache_file) < $this->cache_time){
 
					$content = file_get_contents($this->cache_file);
				 	$content = str_replace("\r\n", '', $content);
				    $content = str_replace("\n", '', $content);
				    $content = str_replace("\t", '', $content);
 
 
					preg_match('/<superword_html_begin>(.*?)<superword_html_end>/', $content, $match_html);
				    $html = $match_html['0'];
				    $html = str_replace("<superword_html_begin>", "", $html);
				    $html = str_replace("<superword_html_end>", "", $html);

					preg_match('/<superword_count_begin>(.*?)<superword_count_end>/', $content, $match_count);
				    $count = $match_count['0'];
				    $count = str_replace("<superword_count_begin>", "", $count);
				    $count = str_replace("<superword_count_end>", "", $count);

				    echo $html;

				    $count = $count+1;
				    $fp = fopen($this->cache_file, "w");
					fwrite($fp, '<superword_html_begin>'.$html.'<superword_html_end><superword_count_begin>'.$count.'<superword_count_end>');
					fclose($fp);
					exit;
		        }
			}
			ob_start();
		}
	}

	function SetCache(){
		if( $this->is_cache ){
			flush();
			$fp = fopen($this->cache_file, "w");

			$count = '0';
			$html = "<superword_html_begin>".ob_get_contents()."<superword_html_end>";
			$html .= "<superword_count_begin>".$count."<superword_count_end>";

			fwrite($fp, $html);
			fclose($fp);
		}
	}

	function CleanCache(){
		$dh = opendir($this->cache_dir);
		while ($file = readdir($dh)) {
			if($file!="." && $file!="..") {
			  	$fullpath = $this->cache_dir.$file;
			  	unlink($fullpath);
			}
		}
	}

}


?>