<?php
Class HomeAction extends Action{
	public $user;
   
 	//初始化过程,判断权限(完成)
 	function __construct(){
	    global $this_user;
	    $BlogUser = D("BlogUser");

	    if(!empty($_SESSION['uid']) && !empty($_SESSION['code'])){
		    $session_uid  = $_SESSION['uid'];
		    $session_code = $_SESSION['code'];
			$this_user = $BlogUser->where(" `uid`='$session_uid' ")->find();
			if($session_code !== md5($this_user['uid'].$this_user['email'].$this_user['pwd'])){
		    	Stop('该用户不存在,请重新登录');
			}else{
				$this->user = $this_user;
			}
	    }elseif(!empty($_COOKIE['uid']) && !empty($_COOKIE['code'])){
		    $cookie_uid  = $_COOKIE['uid'];
		    $cookie_code = $_COOKIE['code'];
			$this_user = $BlogUser->where(" `uid`='$cookie_uid' ")->find();
			if($cookie_code !== md5($this_user['uid'].$this_user['email'])){
				unset($_COOKIE['uid']);
				unset($_COOKIE['code']);
		    	Stop('该用户不存在,请重新登录');
			}else{
				$this->user = $this_user;
			}
	    }  
	}

 
	//列表页(首页)
	function index(){
		DefinePage();
	    Plug::go('before_data');
	    $this->common();
  
	    global $blog_config_arr;         //博客核心配置
	    global $page;                    //当前页码
	    global $query_count;             //每页查询数量
	    global $count_index;             //总记录数

	    //计算查询的开始位置和数量
	    if(!empty($_GET['page'])){
	    	$page = VerifyId($_GET['page']);
	    }else{
	    	$page = '1';
	    }
 
 		if($query_count ==""){
	    	$query_count = '5';
 		}
 		
	    $since = ($page - 1) * $query_count;

	    //初始化查询语句
	    $where_condition = " i.is_page ='0' and i.time_pub != '0' ";
 
		if( $page > 1){
	    	$index_page_info = '第'.$page.'页 - ';
		}else{
	    	$index_page_info = '';
		}

		//如果是主页或者全部分类查询
		if(defined('IS_INDEX')){
			$blog_config_arr['cfg_blog_page_title']       = $index_page_info.$blog_config_arr['cfg_blog_name'].' - '.$blog_config_arr['cfg_blog_wish'];
			$blog_config_arr['cfg_blog_page_keywords']    = $blog_config_arr['cfg_blog_keywords'];
			$blog_config_arr['cfg_blog_page_description'] = $blog_config_arr['cfg_blog_description'];

		}
 
	    //如果是类别查询
	    if(defined('IS_CATE')){ 
	    	$cate = StrCheck($_GET['cate']);
	    	$where_condition .= " and c.cate = '$cate' ";
			$BlogCate = D("BlogCate");
			$cate_info = $BlogCate->where("`cate`='$cate'")->find();
			$blog_config_arr['cfg_blog_page_title']       = $index_page_info.$cate_info['cate_name'].' - '.$blog_config_arr['cfg_blog_name'];
			$blog_config_arr['cfg_blog_page_keywords']    = $blog_config_arr['cfg_blog_keywords'].','.$cate_info['cate_name'].','.$cate_info['cate'];
			$blog_config_arr['cfg_blog_page_description'] = $blog_config_arr['cfg_blog_description'];
	    }
  
	    //如果是标签查询
	    if(defined('IS_TAG')){ 
	    	$tag = StrCheck(urldecode($_GET['tag']));
	    	$where_condition .= " and i.tags like '%$tag%' ";
			$blog_config_arr['cfg_blog_page_title']       = $index_page_info.$tag.' - '.$blog_config_arr['cfg_blog_name'];
			$blog_config_arr['cfg_blog_page_keywords']    = $blog_config_arr['cfg_blog_keywords'].','.$tag;
			$blog_config_arr['cfg_blog_page_description'] = $blog_config_arr['cfg_blog_description'];
	    }
 
	    //如果是搜索查询
	    if(defined('SEARCH')){ 
	    	$search = StrCheck(urldecode($_GET['search']));
	    	$where_condition .= " and (i.title like '%$search%' or i.tags like '%$search%') ";
			$blog_config_arr['cfg_blog_page_title']       = $index_page_info.$search.' - '.$blog_config_arr['cfg_blog_name'];
			$blog_config_arr['cfg_blog_page_keywords']    = $blog_config_arr['cfg_blog_keywords'].','.$search;
			$blog_config_arr['cfg_blog_page_description'] = $blog_config_arr['cfg_blog_description'];
	    }


		global $blog_index;
        $BlogInfo = D('BlogInfo');
		$count_index = $BlogInfo
					->left("BlogCate")->on("c.id=i.id_cate")
					->short("i,c")
					->where($where_condition)
					->count();

		$blog_index = $BlogInfo
					->left("BlogUser")->on("u.uid=i.id_user")
					->left("BlogCate")->on("c.id=i.id_cate")
					->short("i,u,c")
					->where($where_condition)
					->order("id desc")
					->field("i.*,u.uname,c.cate_name,c.cate")
					->limit($since,$query_count)
					->select();
  
		if(is_array($blog_index)){
			foreach ($blog_index as $key => $value) {
				$id = $value['id']; 
				if($value['id_str'] !=""){
					$id = $value['id_str'];
				}
				$blog_index[$key]['url'] = U('post',$id);
				if(is_null($value['cate_name'])){
					$blog_index[$key]['cate_name'] = '未分类';
				}
			}
		}
   

		//分页信息
		global $page_show;
		$Page = new Page($count_index, $query_count, $page);
		$page_show = $Page->setLink("center","","<",">");
 

	    Plug::go('after_data');
	    if(!empty($_GET['display']) && $_GET['display']=='json'){
	    	echo json_encode($blog_index);
	    }else{
			$this->display();
	    }
	}

	//内容页(日志/单页)
	function post(){
		DefinePage();
	    Plug::go('before_data');
	    $this->common();

	    global $web_request_arr;
 		global $blog_config_arr;
		global $blog_post;
		global $comment_index;


		//获取获取URL地址中的id,并且判断是数字id还是id_str
		if(!empty($_GET['id'])){
		    $id = StrCheck($_GET['id']);
		    if(is_numeric($id)){
		    	$id_sql = "id = '$id'";
		    }else{
		    	$id_sql = "id_str = '$id'";
		    }
		}

	    //获取该页面的缓存次数
	    $count = 0;
	    $cache_file = App_Cache.md5(implode('/',$web_request_arr)).".php";
	    if(file_exists($cache_file)){
			$content = file_get_contents($cache_file);
		 	$content = str_replace("\r\n", '', $content);
		    $content = str_replace("\n", '', $content);
		    $content = str_replace("\t", '', $content);
 
			preg_match('/<superword_count_begin>(.*?)<superword_count_end>/', $content, $match_count);
			$count = $match_count['0'];
			$count = str_replace("<superword_count_begin>", "", $count);
			$count = str_replace("<superword_count_end>", "", $count);

			$content = preg_replace('/<superword_count_begin>(.*?)<superword_count_end>/', '<superword_count_begin>0<superword_count_end>', $content);
			$fp = fopen($cache_file, "w");
			fwrite($fp, $content);
			fclose($fp);
	    }

	    //将最新的浏览次数写入数据库
		$count = $count + 1;
        $BlogInfo = D('BlogInfo');
        $BlogInfo->where($id_sql)->field("point_page")->upSum("+".$count);

	    //构建当前日志查询语句
	    $id_sql = "i.".$id_sql;
	    if(!empty($_GET['is_page']) && $_GET['is_page']){
	    	$where = $id_sql."  and i.is_page = '1' ";
	    }else{
	    	$where = $id_sql."  and i.is_page = '0' ";
	    }
   
		//查询当前日志信息,评论
    	$blog_post = $BlogInfo->left("BlogBody")->on("b.id=i.id")->left("BlogUser")->on("u.uid=i.id_user")->left("BlogCate")->on("c.id=i.id_cate")->short("i,b,u,c")->where($where)->field("i.*,b.body,u.uname,c.cate_name")->find();
		if(!is_array($blog_post)){
			$this->page_not_found();
			exit;
		}else{

			$blog_post['body']     = htmlspecialchars_decode($blog_post['body']);

			if(is_null($blog_post['cate_name'])){
				$blog_post['cate_name'] = '未分类';
			}

			$blog_post['tag_list'] = "";
			if($blog_post['tags'] != ""){
				$tag_arr = explode(',', $blog_post['tags']);
				$str = "";
				$suffix = "";
				if($blog_config_arr['cfg_rule_suffix'] !="" ){
					$suffix = ".".$blog_config_arr['cfg_rule_suffix'];
				}
				foreach ($tag_arr as $key => $value) {
					$str .= '<a href="'.$blog_config_arr['cfg_blog_website'].'/tag/'.urlencode($value).$suffix.'">'.$value.'</a>';
				}
				$blog_post['tag_list'] = $str;
			}

			//获取评论
			$aid = $blog_post['id']; 
			$BlogComment = D("BlogComment");
			$comment_index = $BlogComment->left("BlogUser")->on("u.uid = c.uid")->short("c,u")->where(" c.aid ='$aid' and c.is_spam='0' ")->order("c.id desc")->field("c.*,u.uname,u.head")->select();
		}
 
	    Plug::go('after_data');
		$this->display();
	}

	//评论处理
	function comment_handle(){
		define("IS_Comment_Handel",TRUE);
        $_POST = array_map("Dhtmlspecialchars",$_POST);

	    Plug::go('before_data');
	    global $blog_config_arr;

	  	if(empty($_POST)){
	     	exit('{"state":"false","reason":"post_is_empty"}');
	  	}
 
        if(empty($_POST['hash_comment_post']) || $_POST['hash_comment_post'] !== $_SESSION['hash']){
	     	//exit('{"state":"false","reason":"hash_is_wrong"}');
        }
 
        if(time() - $_SESSION['last_comment_time'] < 30){
	     	exit('{"state":"false","reason":"time_is_short"}');
        }
 
	  	//判断是否是垃圾评论(插件+本程序)
 		global $is_spam_from_plug;
	  	$is_spam_from_sw = false;

	  	if($is_spam_from_plug || $is_spam_from_sw){
	  		$is_spam = '1';
	  	}else{
	  		$is_spam = '0';
	  	}


	  	//获取当前用户信息
	  	if(!is_null($this->user)){
  			$uid   = $this->user['uid'];
	  		$uname = $this->user['uname'];
	  	}else{
		  	$uname     = trim($_POST['uname']);
		  	$email     = trim($_POST['email']);
		  	$website   = trim($_POST['website']);

	  		if(empty($uname))                               exit('{"state":"false","reason":"no_name"}');
	  		if(!filter_var($email, FILTER_VALIDATE_EMAIL))  exit('{"state":"false","reason":"email_is_wrong"}');

			$uid = $this->do_comment_user($uname,$email,$website);
			if(!$uid){
				exit('{"state":"false","reason":"user_is_none"}');
			}else{
				setcookie('uid',$uid,time()+7*24*3600,"/",str_ireplace('http://', '', $blog_config_arr['cfg_blog_website']));
				setcookie('code',md5($uid.$email),time()+7*24*3600,"/",str_ireplace('http://', '', $blog_config_arr['cfg_blog_website']));
			}
	  	}
 
 		//过滤评论内容
	  	$comment   = PostCheck(preg_replace('/回复.*?：/','',trim($_POST['comment'])));
	  	$aid       = VerifyId($_POST['aid']);
	  	$fid       = VerifyId($_POST['fid']);
	  	if(empty($comment))                             exit('{"state":"false","reason":"comment_is_none"}');
	  	if($aid==0)                                     exit('{"state":"false","reason":"aid_is_none"}');


 		//写入评论信息
		$BlogComment = D("BlogComment"); 
		$comment_data["uid"]      = $uid;
		$comment_data["fid"]      = $fid;
		$comment_data["aid"]      = $aid;
		$comment_data["comment"]  = $comment;
		$comment_data["is_spam"]  = $is_spam;
		$comment_data["ip"]       = GetIp();
		$comment_data["time_add"] = time();
	    $comment_id = $BlogComment->add($comment_data);

	    
	    //如果写入成功的话,执行后续操作
	    if(!$comment_id){
			exit('{"state":"false","reason":"comment_is_false"}');
	    }else{

	    	//设置本次评论提交时间
	    	$_SESSION['last_comment_time'] = time();

			//更新评论的统计字段
			$BlogInfo=D("BlogInfo");
			$BlogInfo->where("id='$aid'")->field("point_comment")->upSum("+1");
	    	
			//更新网站动态
			$this->create_dynamic($uid,'comment',$aid);
			$this->update_count('comment','+1');
  

	    	//有新评论,则通知日志发布者
 			if($blog_config_arr['email_is_receive'] && $is_spam==="0"){
				$BlogInfo = D("BlogInfo");
				$blog_user = $BlogInfo->left("BlogUser")->on("u.uid = i.id_user")->short("i,u")->where("i.id = '$aid'")->field("i.id,i.title,u.*")->find();
		    	
				if($blog_user['email'] != ""){
					$subject = "亲爱的".$blog_user['uname']."，".$uname."回复了您的日志";
				    $body="<p>".$blog_user['uname']."：</p>
				          <p style='text-indent:2em;'>您好，您的日志 <a href='".U('post',$aid)."'>".$blog_user['title']."</a> ,</p>
				          <p style='text-indent:2em;'>".$uname.",刚刚发表了新评论。</p>
			              <p style='text-indent:2em;'>他说：".$comment."</p>
			              <p style='text-indent:2em;'>快去看看吧！</p>
				          ";
				    SendMail($blog_user['email'],$subject,$body);
				}
 			}
  
			//当某人被回复的时候,邮件通知对方
			if($fid && $blog_config_arr['email_is_send'] && $is_spam==="0"){
				$BlogComment  = D("BlogComment");
				$comment_info = $BlogComment->left("BlogUser")->on("u.uid=c.uid")->left("BlogInfo")->on("i.id=c.aid")->short("c,u,i")->where(" c.id = '$fid'")->field("c.*,u.email,u.uname,i.title")->find();
 
				if($comment_info['email'] != ""){
					$subject = "亲爱的".$comment_info['uname']."，您在".$comment_info['title']."的评论有了回复。";
				   	$body="<p>亲爱的".$comment_info['uname'].":</p>
				          <p style='text-indent:2em;'>您好，您在 <a href='".U('post',$aid)."'>".$comment_info['title']."</a> 的评论,</p>
				          <p style='text-indent:2em;'>".$uname.",非常感兴趣，回复了您，快去看看吧。</p>";
				    SendMail($comment_info['email'],$subject,$body);
				}
			}

			if($is_spam !== "0"){
				exit('{"state":"false","reason":"comment_is_spam"}');
			}
 
			//在转跳或者输出之前,执行相关插件
	    	Plug::go('after_data');
 
			//如果是需求的格式是json的话,则直接输出,否则转跳回前一页
			if( !empty($_GET['display']) && $_GET['display'] == 'json' ){
				exit('{"state":"success","id":"'.$comment_id.'"}');
			}else{ 
				 $this->success("评论成功",$_SERVER['HTTP_REFERER'].'#comment_'.$comment_id);
			}
	    }
	}


	//hash 主要是防止form被远程提交
	function hash_handle(){
		$hash = md5(time().'superword');
		$_SESSION['hash'] = $hash;
		//echo $hash;
		echo 'document.getElementById("hash_comment_post").value = "'.$hash.'";';
	}



	//获取当前操作者的相关信息
    public function do_comment_user($uname,$email,$website){
		  $BlogUser=D("BlogUser"); 
	      $uid = $BlogUser->Where(" `email`='$email' ")->getField('uid');
		  if($uid){                                      //更新
			 $data["uname"]     = $uname;
			 $data["website"]   = $website;
			 $data["time_last"] = time();
             $BlogUser->where("`uid`='$uid'")->save($data);
		  }else{                                         //插入
			 $data["uname"]     = $uname;
             $data["email"]     = $email;
             $data["website"]   = $website;
             $data["head"]      = "http://7xizs0.com1.z0.glb.clouddn.com/superword_head_".rand(1,26).".jpg";
             $data["time_add"]  = time();
             $data["time_last"] = $data["time_add"];
             $data["is_bloger"] = '0';
	         $uid = $BlogUser->add($data);
		  }
		  return $uid;
	}


	//调用通用信息
	function common(){
		global $blog_config_arr;

		//调用导航菜单信息
		global $nav_index;
        $BlogNav = D('BlogNav');
		$nav_index = $BlogNav->select();

		//调用标签信息
		global $tag_index;
        $BlogTag = D('BlogTag');
		$tag_index = $BlogTag->order("count desc")->limit(0,10)->select();
 
		$suffix = "";
		if($blog_config_arr['cfg_rule_suffix'] !="" ){
			$suffix = ".".$blog_config_arr['cfg_rule_suffix'];
		}

		if(is_array($tag_index)){
			foreach ($tag_index as $key => $tag) {
				$tag_index[$key]['tag_url'] = $blog_config_arr['cfg_blog_website'].'/tag/'.urlencode($tag['tag']).$suffix;
			}
		}
  
		//调用广告信息
		global $ad_index;
        $BlogAd = D('BlogAd');
		$ad_list = $BlogAd->where("	`is_show`='1' ")->select();
		if(is_array($ad_list)){
			foreach ($ad_list as $key => $value) {
				$ad_index[$value['ad_postion']] = htmlspecialchars_decode($value['ad_code']);
			}
		}

		//调用链接信息
		global $link_index;
        $BlogLink = D('BlogLink');
		$link_index = $BlogLink->select();


		//调用推荐文章信息
		global $blog_index_rec;
        $BlogInfo = D('BlogInfo');
		$blog_index_rec = $BlogInfo->where("`is_page`='0' && `is_rec`='1'")->order("id desc")->limit(0,3)->select();
		if(is_array($blog_index_rec)){
			foreach ($blog_index_rec as $key => $value) {
				$id = $value['id']; 
				if($value['id_str'] !=""){
					$id = $value['id_str'];
				}
				$blog_index_rec[$key]['url'] = U('post',$id);
			}
		}

	}


	function rss(){
		global $blog_config_arr;
		$logo_url = $blog_config_arr['cfg_blog_website'].App_Tem.$blog_config_arr['cfg_blog_temple'].'/img/logo.png';
		$logo_url = str_replace('./', '/', $logo_url);
		$Rss= new Rss($blog_config_arr['cfg_blog_name'],$blog_config_arr['cfg_blog_website'],$blog_config_arr['cfg_blog_wish'],$logo_url);
		$Blog=D("BlogInfo");
		$blogs = $Blog->where("`time_pub` != '0' and `is_page` ='0' ")->field("id,title,info,time_add,litpic")->order("id desc")->limit(0,10)->select();
		foreach ($blogs as $key => $value) {
          $info = '<table><tr>'; 
          if($value['litpic'] != ""){
          	$info .= '<td><a href="'.U('post',$value['id']).'" title="'.$value['title'].'"><img src="'.$value['litpic'].'" alt="'.$value['title'].'" width="200" ></a></td>';
          }
          $info .= '<td  valign="top"><p style="text-indent:2em;line-height:24px;margin-left:10px;">'.$value['info'].'</p></td></tr><table>';
          $Rss->AddItem($value['title'],U('post',$value['id']),$info,date('Y-m-d',$value['time_add']));
		}
		$Rss->Display();
	}

	function sitemap(){
		global $blog_config_arr;
		$BlogInfo=D("BlogInfo");
		$blog_index = $BlogInfo->where(" `time_pub` != '0' ")->field("id,id_str,title")->order("id desc")->select();
		if(is_array($blog_index)){
			foreach ($blog_index as $key => $value) {
				$id = $value['id']; 
				if($value['id_str'] !=""){
					$id = $value['id_str'];
				}
				$blog_index[$key]['url'] = U('post',$id);

				echo $blog_index[$key]['url'].'<br>';
			}
		}

		$BlogTag=D("BlogTag");
		$tag_index = $BlogTag->select();
		$suffix = "";
		if($blog_config_arr['cfg_rule_suffix'] !="" ){
			$suffix = ".".$blog_config_arr['cfg_rule_suffix'];
		}

		if(is_array($tag_index)){
			foreach ($tag_index as $key => $tag) {
				$tag_index[$key]['tag_url'] = $blog_config_arr['cfg_blog_website'].'/tag/'.urlencode($tag['tag']).$suffix;
			
				echo $tag_index[$key]['tag_url'].'<br>';

			}
		}
		echo $blog_config_arr['cfg_blog_website'];
	}

	function page_not_found(){
		header('HTTP/1.1 404 Not Found');
 
		$this->display("404");
	}

}
?>