<?php
Class InstallAction extends Action{
 
	//介绍
	function step_one(){
  
		if(phpversion() < 5){
			Stop("PHP版本过低,最低要求5.0");
		}

		$file_config_blog = App_Core.'config_blog.php';
		$file_config_db   = App_Core.'config_db.php';
 
		if (!is_writable($file_config_blog)) { 
			Stop($file_config_blog."文件不可写入,请联系您的空间商");
		}

		if (!is_writable($file_config_db)) { 
			Stop($file_config_db."文件不可写入,请联系您的空间商");
		}
 
		$this->display();
	}
  
	//配置数据库
	function step_two(){
		if( $_SESSION['step_one'] ){
			$this->display();
		}else{
			$url = 'http://'.$_SERVER['HTTP_HOST'].'/step_one';
			Header("Location: $url"); 
		}
	}

	//配置博客
	function step_three(){
		if( $_SESSION['step_two'] && $_SESSION['step_one']){
			$this->display();
		}else{
			$url = 'http://'.$_SERVER['HTTP_HOST'].'/step_two';
			Header("Location: $url"); 
		}
	}
 
	//完成
	function step_four(){
		if($_SESSION['step_three'] && $_SESSION['step_two'] && $_SESSION['step_one']){

			$arr = array(
				"is_install"=>"1"
				);
		    RefreshConfig($arr,'config_blog');
			$this->display();
		}else{
			$url = 'http://'.$_SERVER['HTTP_HOST'].'/step_three';
			Header("Location: $url"); 
		}
	}

	//处理过程
	function deal_handle(){
        $_POST = array_map("Dhtmlspecialchars",$_POST);

		if( !empty($_POST['step']) && "one" === $_POST['step'] ){
			$_SESSION['step_one'] = true;
			$url = 'http://'.$_SERVER['HTTP_HOST'].'/step_two';
			Header("Location: $url"); 
		}
 
		if( !empty($_POST['step']) && "two" === $_POST['step'] ){
			$con = mysqli_connect($_POST['DB_Host'],$_POST['DB_User'],$_POST['DB_pwd'],$_POST['DB_Base'],$_POST['DB_Port']);
	        if (mysqli_connect_errno($con)){
	 			foreach ($_POST as $key => $value) {
	 				$str .= $key."=".$value."&";
	 			}
				$url = 'http://'.$_SERVER['HTTP_HOST'].'/step_two?'.$str;
				Header("Location: $url"); 
	        }else{
				RefreshConfig($_POST,'config_db');
				$_SESSION['step_two'] = true;
				$url = 'http://'.$_SERVER['HTTP_HOST'].'/step_three';
				Header("Location: $url"); 
	        }
		}
 
		if( !empty($_POST['step']) && "three" === $_POST['step'] ){
			//安装数据库

			$cfg_blog_name    = $_POST['cfg_blog_name'];
			$cfg_blog_website = $_POST['cfg_blog_website'];
			$uname            = $_POST['uname'];
			$email            = $_POST['email'];
			$pwd              = md5($_POST['pwd']."utf8");

			$this->sql_handle($cfg_blog_name,$cfg_blog_website,$uname,$email,$pwd);
		    $_SESSION['step_three'] = true;
			$url = 'http://'.$_SERVER['HTTP_HOST'].'/step_four';
			Header("Location: $url"); 
		}
 
	}


	//处理过程
	function sql_handle($cfg_blog_name,$cfg_blog_website,$uname,$email,$pwd){
 	 	$time = time();

		//建立表
		$sql_arr = array(
					"CREATE TABLE IF NOT EXISTS `sw_blog_ad` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `ad_postion` char(8) NOT NULL,
					  `ad_info` varchar(120) NOT NULL,
					  `ad_code` varchar(256) NOT NULL,
					  `time_add` int(11) NOT NULL,
					  `is_show` int(1) NOT NULL DEFAULT '0',
					  PRIMARY KEY (`id`),
					  UNIQUE KEY `ad_postion` (`ad_postion`)
					) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1",

					"CREATE TABLE IF NOT EXISTS `superword_blog_body` (
					  `id` int(11) NOT NULL,
					  `body` mediumtext NOT NULL,
					  PRIMARY KEY (`id`),
					  KEY `id` (`id`)
					) ENGINE=MyISAM DEFAULT CHARSET=utf8",
 
					"CREATE TABLE IF NOT EXISTS `superword_blog_cate` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `cate` char(20) NOT NULL,
					  `cate_name` char(20) NOT NULL,
					  PRIMARY KEY (`id`),
					  UNIQUE KEY `cate` (`cate`)
					) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1",

					"CREATE TABLE IF NOT EXISTS `superword_blog_comment` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `uid` int(11) NOT NULL,
					  `fid` int(11) NOT NULL,
					  `aid` int(11) NOT NULL,
					  `comment` char(140) NOT NULL,
					  `is_spam` int(1) NOT NULL DEFAULT '0',
					  `ip` char(16) NOT NULL,
					  `time_add` int(11) NOT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1",

					"CREATE TABLE IF NOT EXISTS `superword_blog_config` (
					  `cfg_id` int(11) NOT NULL AUTO_INCREMENT,
					  `cfg_name` char(20) NOT NULL,
					  `cfg_value` varchar(256) NOT NULL,
					  PRIMARY KEY (`cfg_id`),
					  UNIQUE KEY `cfg_name` (`cfg_name`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=33",
 
					"CREATE TABLE IF NOT EXISTS `superword_blog_dynamic` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `uid` int(11) NOT NULL,
					  `action` char(8) CHARACTER SET utf8 NOT NULL,
					  `aid` int(11) NOT NULL,
					  `time_add` int(11) NOT NULL,
					  `is_show` int(1) NOT NULL DEFAULT '0',
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2",
  
					"CREATE TABLE IF NOT EXISTS `superword_blog_info` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `id_str` char(128) NOT NULL,
					  `id_cate` int(2) NOT NULL DEFAULT '0',
					  `id_user` int(11) NOT NULL,
					  `title` char(60) NOT NULL,
					  `tags` char(60) NOT NULL,
					  `litpic` char(80) NOT NULL,
					  `description` char(200) NOT NULL,
					  `point_page` smallint(6) NOT NULL,
					  `point_comment` tinyint(4) NOT NULL,
					  `time_add` int(11) NOT NULL,
					  `time_pub` int(11) NOT NULL,
					  `is_page` int(1) NOT NULL DEFAULT '0',
					  `is_rec` int(1) NOT NULL DEFAULT '0',
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1",

					"CREATE TABLE IF NOT EXISTS `superword_blog_link` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `webname` char(20) NOT NULL,
					  `website` char(60) NOT NULL,
					  `time_add` int(11) NOT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1",

					"CREATE TABLE IF NOT EXISTS `superword_blog_nav` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `text` char(20) NOT NULL,
					  `url` char(60) NOT NULL,
					  `tag` char(10) NOT NULL,
					  `sort` int(4) NOT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2",
   
					"CREATE TABLE IF NOT EXISTS `sw_blog_tag` (
					  `tag` char(20) NOT NULL,
					  `count` int(4) NOT NULL,
					  PRIMARY KEY (`tag`)
					) ENGINE=MyISAM DEFAULT CHARSET=utf8",
 
					"CREATE TABLE IF NOT EXISTS `superword_blog_user` (
					  `uid` int(11) NOT NULL AUTO_INCREMENT,
					  `email` char(30) NOT NULL,
					  `tname` char(20) NOT NULL,
					  `uname` char(20) NOT NULL,
					  `pwd` char(32) NOT NULL,
					  `website` char(30) NOT NULL,
					  `head` char(100) NOT NULL,
					  `time_add` int(11) NOT NULL,
					  `time_last` int(11) NOT NULL,
					  `is_bloger` int(1) DEFAULT '0',
					  PRIMARY KEY (`uid`),
					  UNIQUE KEY `email` (`email`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2",



					"INSERT INTO `superword_blog_config` (`cfg_id`, `cfg_name`, `cfg_value`) VALUES
					(1, 'cfg_blog_name', '$cfg_blog_name'),
					(2, 'cfg_blog_website', '$cfg_blog_website'),
					(3, 'cfg_blog_description', ''),
					(4, 'cfg_blog_keywords', ''),
					(5, 'cfg_blog_welcome', '欢迎来到我的世界'),
					(6, 'cfg_blog_wish', ''),

					(7, 'cfg_blog_temple', 'default'),
					(8, 'cfg_blog_plus', ''),
					(9, 'cfg_blog_admin_dir', 'admin'),
					(10, 'cfg_blog_login_dir', 'login'),
					(11, 'cfg_blog_cate', ''),

					(12, 'cfg_blog_cache_time', '0'),
					(13, 'cfg_blog_record', ''),
					(14, 'cfg_blog_copy_right', '2015 © &lt;a href=&quot;http://www.superword.cn&quot;&gt;www.superword.cn&lt;/a&gt;'),
					(15, 'cfg_blog_statistics', '&lt;a href=&quot;#&quot;&gt;站长统计&lt;/a&gt;'),
					(16, 'cfg_blog_admin', '1'),
					(17, 'cfg_blog_found_time', '$time'),
					(18, 'cfg_blog_last_time', ''),
					(19, 'cfg_blog_open_cate', ''),

					(20, 'cfg_rule_suffix', 'html'),
					(21, 'cfg_rule_post', 'post/{id}'),
					(22, 'cfg_rule_index', 'page/{page}'),
					(23, 'cfg_rule_tag', 'tag/{tag}/page/{page}'),
					(24, 'cfg_rule_cate', 'cate/{cate}/page/{page}'),
					(25, 'cfg_rule_search', 'search/{search}/page/{page}'),
 
					(26, 'email_is_send', '0'),
					(27, 'email_is_receive', '0'),
					(28, 'email_send_host', 'smtp.qq.com'),
					(29, 'email_send_port', '465'),
					(30, 'email_send_email', '123456@qq.com'),
					(31, 'email_send_pwd', ''),
					(32, 'email_send_name', ''),
					
					(33, 'cfg_count_blog', '0'),
					(34, 'cfg_count_tag', '0'),
					(35, 'cfg_count_user', '1'),
					(36, 'cfg_count_link', '1'),
					(37, 'cfg_count_comment', '0')",	


	                "INSERT INTO `superword_blog_dynamic` (`id`, `uid`, `action`, `aid`, `time_add`) VALUES
					(1, 1, 'found', 0, '$time')",

                    "INSERT INTO `superword_blog_nav` (`id`, `text`, `url`, `tag`, `sort`) VALUES
					(1, '首页', '$cfg_blog_website', '', 0)",

                    "INSERT INTO `superword_blog_user` (`uid`, `email`, `tname`, `uname`, `pwd`, `website`, `head`, `time_add`, `time_last`, `is_bloger`) VALUES
					(1, '$email', '', '$uname', '$pwd', '', 'http://7xizs0.com1.z0.glb.clouddn.com/superword_head_10.jpg', '$time', '$time', 1)",

                    "INSERT INTO `superword_blog_ad` (`id`, `ad_postion`, `ad_info`, `ad_code`, `time_add`, `is_show`) VALUES
					(1, 'sider', '侧边栏广告', '&lt;img src=&quot;http://static.bootcss.com/www/assets/img/google-bootstrap.png&quot;&gt;', '$time', 1)",
 
	                "INSERT INTO `superword_blog_link` (`id`, `webname`, `website`, `time_add`) VALUES
					(1, 'SuperWord官方网站', 'http://www.superword.cn', '$time')"

			);

			$Mysql = new Mysql();
			foreach ($sql_arr as $key => $sql) {
			    $sql = StrReplaceOnce("superword_", C("DB_PREFIX")."_", $sql);
				$Mysql->query($sql);
			} 
	}
}
?>