<?php
//分页类
class Page{
      private $data_total;         //总记录数  
      private $page_size;          //每页显示多少条  
      private $page_total;         //总页数
      private $page_this;          //当前页  
      private $page_pre;           //前一页  
      private $page_next;          //后一页  

      //构造方法初始化  
      public function __construct($data_total, $page_size, $page_this) { 
         $this->data_total = (int)$data_total;  
         $this->page_size  = (int)$page_size;  
         $this->page_this  = (int)$page_this;  

         $this->page_total = ceil($this->data_total / $this->page_size); 

         if($page_this <= 0){
         	Stop("页面值不能小于0");
         }

         if($this->data_total>0){
           if($this->page_this > $this->page_total){
            Stop("页面值不能大于总数");
           }

           if($this->page_this == '1'){
            $this->page_pre = '1';
           }else{
            $this->page_pre = $this->page_this - 1 ;
           }

           if($this->page_this == $this->page_total){
            $this->page_next = $this->page_total;
           }else{
            $this->page_next = $this->page_this + 1 ;
           }
         }
      }  
 

      //组合链接
      public function setLink($postion = "left",$limit = false,$icon_pre="",$icon_next="") { 
        if($this->data_total === 0){
          return "";
        }
      	$link = "";
      	for ($i=1; $i<=$this->page_total ; $i++) { 
      		if($i == $this->page_this){
      			$link .= '<a class="active" href="'.$this->setUrl($i).'">'.$i.'</a>';
      		}else{
      			$link .= '<a href="'.$this->setUrl($i).'">'.$i.'</a>';
      		}
      	}
      	if($icon_pre == ""){
  			$link_pre = '<a href="'.$this->setUrl($this->page_pre).'">'.$this->page_pre.'</a>';
      	}else{
  			$link_pre = '<a href="'.$this->setUrl($this->page_pre).'">'.$icon_pre.'</a>';
      	}
      	if($icon_next == ""){
  			$link_next = '<a href="'.$this->setUrl($this->page_next).'">'.$this->page_next.'</a>';
      	}else{
  			$link_next = '<a href="'.$this->setUrl($this->page_next).'">'.$icon_next.'</a>';
      	}
  		if($postion == "left"){
      		$link = $link.$link_pre.$link_next;
  		}
  		if($postion == "center"){
      		$link = $link_pre.$link.$link_next;
  		}
  		if($postion == "right"){
      		$link = $link_pre.$link_next.$link;
  		}

  		return $link;
      }

      function setUrl($page_no){
      	global $blog_config_arr;

		if ($blog_config_arr['cfg_rule_suffix'] != "") {
		    $suffix =  ".".$blog_config_arr['cfg_rule_suffix'];
		}else{
		    $suffix =  '';
		}

      	if( App_Model =="AdminAction" ){
      		return $blog_config_arr['cfg_blog_website']."/".$blog_config_arr['cfg_blog_admin_dir']."/".App_Action."/page/".$page_no.$suffix;
      	}

      	if( App_Model =="HomeAction" ){
 
      		$page_url = "";
      		if(defined('IS_INDEX')){
      			$page_url = $blog_config_arr['cfg_rule_index'];
      		}
      		if(defined('IS_CATE')){
		    	$cate = StrCheck($_GET['cate']);
				$page_url = str_replace('{cate}', $cate, $blog_config_arr['cfg_rule_cate']);
      		}
      		if(defined('IS_TAG')){
	    		$tag = StrCheck(urldecode($_GET['tag']));
				$page_url = str_replace('{tag}', $tag, $blog_config_arr['cfg_rule_cate']);
      		}
      		if(defined('SEARCH')){
	    		$search = StrCheck(urldecode($_GET['search']));
				$page_url = str_replace('{search}', $search, $blog_config_arr['cfg_rule_cate']);
      		}

      		$url = $blog_config_arr['cfg_blog_website']."/".$page_url.$suffix ;
      		return str_replace("{page}", $page_no, $url);
      	}
 
      }
}
?>