<?php

/**
 * 自动加载类文件
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $className 类名
 * @return  无
 */
function __autoload($className) {
    if (file_exists(App_Class . $className . '.class.php')) {
        require_once (App_Class . $className . '.class.php');
    } else {
        Stop('Not Found: ' . App_Class . $className . '.class.php');
    }
}


/**
 * 读取数据库配置信息
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $string 类名
 * @return  string 配置信息
 */
function C($string) {
    $c = include (App_Core . 'config_db.php');
    return $c[$string];
}


/**
 * 执行Model类
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $string 表名(驼峰写法,例如 BlogConfig)
 * @return  object $model 实例化后的Model类
 */
function D($string) {
    $table_name = StringToTable($string);
    $model = new Model();
    $model->table_name = $table_name;
    return $model;
}


/**
 * URL地址生成
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $kind 类型(主要考虑到前后台不一样)
 * @param   string $arg1 对URL规则中的参数进行替换
 * @param   string $page 对URL规则中的参数进行替换(主要是替换{page})
 * @param   string $arg2 对URL进行补充(多用于请求字符串 &key=value 形式)
 * @return  string $url 返回生成后的URL地址
 */
function U($kind = "", $arg1 = "", $page = "", $arg2 = "") {
    global $blog_config_arr;
    $url = $blog_config_arr['cfg_blog_website'];
    if ($kind == "admin") {
        $url.= "/" . $blog_config_arr['cfg_blog_admin_dir'];
        if ($arg1 != "") {
            $url.= "/" . $arg1;
        }
    } elseif ($kind == "login") {
        $url.= "/" . $blog_config_arr['cfg_blog_login_dir'];
        if ($arg1 != "") {
            $url.= "/" . $arg1;
        }
    } elseif ($kind == "index") {
        $this_rule = $blog_config_arr['cfg_rule_index'];
        $this_rule = str_replace("{page}", $page, $this_rule);
        $url.= "/" . $this_rule;
    } elseif ($kind == "post") {
        $this_rule = $blog_config_arr['cfg_rule_post'];
        $this_rule = str_replace("{id}", $arg1, $this_rule);
        $url.= "/" . $this_rule;
    } elseif ($kind == "cate") {
        $this_rule = $blog_config_arr['cfg_rule_cate'];
        $this_rule = str_replace("{cate}", $arg1, $this_rule);
        $this_rule = str_replace("{page}", $page, $this_rule);
        $url.= "/" . $this_rule;
    } elseif ($kind == "tag") {
        $this_rule = $blog_config_arr['cfg_rule_tag'];
        $this_rule = str_replace("{tag}", $arg1, $this_rule);
        $this_rule = str_replace("{page}", $page, $this_rule);
        $url.= "/" . $this_rule;
    } elseif ($kind == "search") {
        if($arg1 != ""){
            $this_rule = $blog_config_arr['cfg_rule_search'];
            $this_rule = str_replace("{search}", $arg1, $this_rule);
            $this_rule = str_replace("{page}", $page, $this_rule);
            $url.= "/" . $this_rule;
        }else{
            $url.= "/" . 'search';
        }
    } else {
        if ($kind != "") {
            $url.= "/" . $kind;
        }
        if ($arg1 != "") {
            $url.= "/" . $arg1;
        }
        if ($page != "") {
            $url.= "/" . $page;
        }
    }
    
    if ($blog_config_arr['cfg_rule_suffix'] != "") {
        $url = $url . "." . $blog_config_arr['cfg_rule_suffix'];
    }

    if($arg2 != ""){
        $url = $url . $arg2;
    }
    return $url;
}


/**
 * 浏览器友好输出
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string|array|object $var  参数(字符串,数组,对象)
 * @param   bool   $echo   是否直接输出(默认是)
 * @param   string $label  提示标签
 * @return  string $output 直接打印或者输出
 */
function Dump($var, $echo = true, $label = null, $strict = true) {
    $label = ($label === null) ? '' : rtrim($label) . ' ';
    if (!$strict) {
        if (ini_get('html_errors')) {
            $output = print_r($var, true);
            $output = '<pre>' . $label . htmlspecialchars($output, ENT_QUOTES) . '</pre>';
        } else {
            $output = $label . print_r($var, true);
        }
    } else {
        ob_start();
        var_dump($var);
        $output = ob_get_clean();
        if (!extension_loaded('xdebug')) {
            $output = preg_replace('/\]\=\>\n(\s+)/m', '] => ', $output);
            $output = '<pre>' . $label . htmlspecialchars($output, ENT_QUOTES) . '</pre>';
        }
    }
    if ($echo) {
        echo ($output);
        return null;
    } else return $output;
}


/**
 * 删除文件夹及下面文件
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $dir  文件夹地址
 * @return  bool   true/false
 */
function DelDir($dir) {
    $dh = opendir($dir . "/");
    while ($file = readdir($dh)) {
        if ($file != "." && $file != "..") {
            $fullpath = $dir . "/" . $file;
            if (!is_dir($fullpath)) {
                unlink($fullpath);
            } else {
                DelDir($fullpath);
            }
        }
    }
    closedir($dh);
    if (rmdir($dir)) {
        return true;
    } else {
        return false;
    }
}


/**
 * 字符串转成表名
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $string 字符串(驼峰写法,例如 User转成user BlogConfig转成 blog_config)
 * @return  string $table_name (默认会加上表前缀)
 */
function StringToTable($string) {
    $arr = preg_split("/(?=[A-Z])/", $string);
    $arr = array_filter($arr);
    $table_name = C("DB_PREFIX");
    foreach ($arr as $key => $value) {
        $table_name.= "_" . $value;
    }
    $table_name = "`" . strtolower($table_name) . "`";
    return $table_name;
}


//字符串替换(只一次)
function StrReplaceOnce($needle, $replace, $haystack) {
    $pos = strpos($haystack, $needle);
    if ($pos === false) {
        return $haystack;
    }
    return substr_replace($haystack, $replace, $pos, strlen($needle));
}


/**
 * 分析当前URL地址
 * @author  汤姆大叔
 * @date    2015-5-14
 * @see     http://www.superword.cn
 *
 * @return  string $web_request_url 网页URL所实际请求地址
 */
function UrlRequest() {
 
    $script_name = $_SERVER['SCRIPT_NAME'];
    $script_name = str_ireplace('index.php', '', $script_name);
    $dir_child = trim($script_name,'/');
 
    if($dir_child!=""){
        $_SERVER['HTTP_HOST']   =  $_SERVER['HTTP_HOST'].'/'.$dir_child;
        $_SERVER['REQUEST_URI'] =  StrReplaceOnce($dir_child, '', $_SERVER['REQUEST_URI']);
    }

    $_SERVER['REQUEST_URI'] =  str_ireplace('//', '/', $_SERVER['REQUEST_URI']);
 
    $web_request_url = strtolower($_SERVER['REQUEST_URI']);
    if (strpos($web_request_url, '?') !== false) {
        $web_request_deal = explode('?', $web_request_url);
        $web_request_url  = $web_request_deal[0];
    }
    if (strpos($web_request_url, '.') !== false) {
        $web_request_deal = explode('.', $web_request_url);
        $web_request_url  = $web_request_deal[0];
    }
    $web_request_url = ltrim($web_request_url, '/');    
 
    return $web_request_url;
}

  

/**
 * 根据路由规则,判断请求
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   array $web_request_arr 以/为分隔符，分割页面请求URL所形成的数组
 * @param   array $blog_config_arr 路由规则所形成的数组
 * @return  array 包括model及action
 */
function UrlRoute($web_request_arr, $blog_config_arr) {
    //Dump($web_request_arr);
    //Dump($blog_config_arr);
    //首页(没有参数)
    if ($web_request_arr[0] == "") {
        $_GET['cate'] = 'index';
        $_GET['page'] = '1';
        return array(
            'model' => 'Home',
            'action' => 'index'
        );
    }
    //判断是登陆页(以及处理页)
    if ($web_request_arr[0] == $blog_config_arr['cfg_blog_login_dir']) {
        if (empty($web_request_arr[1]) || $web_request_arr[1] == '') {
            $action = 'index';
        } else {
            $action = $web_request_arr[1];
        }
        return array(
            'model' => 'Login',
            'action' => $action
        );
    }
    //只有一个参数(RSS,SiteMap,分类首页,单页,后台首页)
    if ($web_request_arr[0] != "" && count($web_request_arr) == 1) {
        //判断是否是RSS
        if ($web_request_arr[0] == "rss") {
            return array(
                'model' => 'Home',
                'action' => 'rss'
            );
        }
        //判断是否是SiteMap
        if ($web_request_arr[0] == "sitemap") {
            return array(
                'model' => 'Home',
                'action' => 'sitemap'
            );
        }
        //判断是否是搜索页
        if ($web_request_arr[0] == "search") {
            $_GET['search'] = $_POST['keywords'];
            $_GET['page'] = '1';
            return array(
                'model' => 'Home',
                'action' => 'index'
            );
        }
        //判断是否是分类首页
        if ($blog_config_arr['cfg_blog_cate'] != "") {
            $cate_arr = explode("|", $blog_config_arr['cfg_blog_cate']);
            if (in_array($web_request_arr[0], $cate_arr)) {
                $_GET['cate'] = $web_request_arr[0];
                $_GET['page'] = '1';
                return array(
                    'model' => 'Home',
                    'action' => 'index'
                );
            }
        }
        //判断是否是单页面
        if ($web_request_arr[0] != $blog_config_arr['cfg_blog_admin_dir']) {
            $_GET['is_page'] = True;
            $_GET['id'] = $web_request_arr[0];
            return array(
                'model' => 'Home',
                'action' => 'post'
            );
        }
        //后台主页
        if ($web_request_arr[0] == $blog_config_arr['cfg_blog_admin_dir']) {
            return array(
                'model' => 'Admin',
                'action' => 'index'
            );
        }
    }
    //两个参数(tag/参数 或者 search/参数)
    if ($web_request_arr[0] != "" && count($web_request_arr) == 2) {
        if ($web_request_arr[0] == "tag" || $web_request_arr[0] == "search") {
            $_GET[$web_request_arr[0]] = $web_request_arr[1];
            $_GET['page'] = '1';
            return array(
                'model' => 'Home',
                'action' => 'index'
            );
        }
    }
    //匹配前端页面
    foreach ($blog_config_arr as $key => $value) {
        if (strpos($key, "cfg_rule") !== false) {
            $this_arr = explode("/", $value);
            if (count($this_arr) == count($web_request_arr)) {
                $is_pipei = true;
                $arr_get = array();
                foreach ($this_arr as $k => $v) {
                    if ($this_arr[$k] != $web_request_arr[$k]) {
                        if (strpos($v, "{") === false) {
                            $is_pipei = false;
                        } else {
                            $v = rtrim($v, '}');
                            $v = ltrim($v, '{');
                            $arr_get[$v] = $web_request_arr[$k];
                        }
                    }
                }
                if ($is_pipei) {
                    //echo $key.'_'.$blog_config_arr[$key];
                    //Dump($arr_get);
                    foreach ($arr_get as $get_key => $get_value) {
                        $_GET[$get_key] = $get_value;
                    }
                    if ($key == 'cfg_rule_index') {
                        $_GET['cate'] = 'index';
                    }
                    if ($key == "cfg_rule_post") {
                        return array(
                            'model' => 'Home',
                            'action' => 'post'
                        );
                    } else {
                        return array(
                            'model' => 'Home',
                            'action' => 'index'
                        );
                    }
                }
            }
        }
    }
    //如果前台的URL路由都不匹配的话,那很可能是访问后台的页面
    $i = 0;
    foreach ($web_request_arr as $key => $value) {
        if ($key == 0) {
            $model = $value;
        } elseif ($key == 1) {
            $action = $value;
            if ($action == "") {
                $action = 'index';
            }
        } else {
            if ($i % 2 == 0) {
                $_GET[$web_request_arr[$i]] = $web_request_arr[$i + 1];
            }
        }
        $i++;
    }
    if ($model == $blog_config_arr['cfg_blog_admin_dir']) {
        $model = 'admin';
    }
    return array(
        'model' => $model,
        'action' => $action
    );
}


/**
 * 获取插件信息
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $where     标记(比如Name开头)
 * @param   string $file_info 文件内容
 * @return  string 返回该标记所对应的信息
 */
function GetPlugInfo($where, $file_info) {
    preg_match('/' . $where . '.*?\\n/', $file_info, $matches);
    if (is_array($matches)) {
        $s = $matches[0];
        $s = str_ireplace("\n", "", $s);
        $a = explode("|", $s);
        return $a[1];
    }
}


/**
 * 刷新核心设置
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $array     将要写入的信息数组
 * @param   string $file_name 文件名称(config_blog|config_db)
 * @return  无
 */
function RefreshConfig($array, $file_name) {
    if (!is_array($array)) {
        Stop("只接受数组格式");
    }
    $file = App_Core . $file_name . '.php';
    $str = file_get_contents($file);
    foreach ($array as $key => $value) {
        if (strpos($str, $key) !== false) {
            $str = preg_replace("/\'" . $key . ".*?\',/i", "'" . $key . "' => '" . $value . "',", $str);
        }
    }
    file_put_contents($file, $str);
}


/**
 * 友好时间显示
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $time 时间戳
 * @return  string 友好时间信息
 */
function FriendTime($time) {
    $time_dis = time() - $time;
    if (date('Y-m-d', time()) != date('Y-m-d', $time)) {
        if (date('Y', time()) != date('Y', $time)) {
            return date('Y年m月d日 H:i', $time);
        }
        return date('m月d日 H:i', $time);
    }
    if ($time_dis < 60) {
        return $time_dis . '秒前';
    }
    if ($time_dis < 3600) {
        return floor($time_dis / 60) . '分钟前';
    }
    if ($time_dis < 3600 * 24) {
        return floor($time_dis / 3600) . '小时前';
    }
}


/**
 * 网站动态中,各种操作所对应的中文
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $action 动作代码
 * @return  动作名称
 */
function ActionName($action) {
    if ($action == "comment") {
        return "评论";
    }
    if ($action == "create") {
        return "发表";
    }
    if ($action == "edit") {
        return "更新";
    }
    if ($action == "found") {
        return "创立";
    }
    return $action;
}


//获取IP地址
function GetIp() {
    if (getenv('HTTP_CLIENT_IP')) {
        $ip = getenv('HTTP_CLIENT_IP');
    } else if (getenv('HTTP_X_FORWARDED_FOR')) {
        $ip = getenv('HTTP_X_FORWARDED_FOR');
    } else if (getenv('REMOTE_ADDR')) {
        $ip = getenv('REMOTE_ADDR');
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}


/**
 * 发送邮件函数
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $to_address 对方的邮箱地址
 * @param   string $subject    邮件标题
 * @param   string $body       邮件内容(支持HTML)
 * @return  无
 */
function SendMail($to_address, $subject, $body, $test = false) {
    global $blog_config_arr;
    $mail = new Phpmailer;
    $mail->IsSMTP();
    $mail->CharSet = 'UTF-8';
    $mail->Port = $blog_config_arr['email_send_port'];
    $mail->Host = $blog_config_arr['email_send_host'];
    $mail->SMTPAuth = true;
    $mail->SMTPSecure = "ssl";
    $mail->Username = $blog_config_arr['email_send_email'];
    $mail->Password = $blog_config_arr['email_send_pwd'];
    $mail->From = $blog_config_arr['email_send_email'];
    $mail->FromName = $blog_config_arr['cfg_blog_name'];
    $mail->AddReplyTo($blog_config_arr['email_send_email'], $blog_config_arr['cfg_blog_name']);
    $mail->AddAddress($to_address);
    $mail->IsHTML(true);
    $mail->Subject = $subject;
    $mail->Body = $body;
    if (!$mail->Send() && $test === true) {
        Stop($mail->ErrorInfo);
    }
}


//自定义一个中断方法,代替exit,die
function Stop($str) {
    echo '<!DOCTYPE html><html lang="zh-CN"><head><meta charset="utf-8"><title>错误提醒 - ' . App_Name . '</title></head><style>body,h1,hr,h2{margin:0;padding:0}body{background:#fff;color:#666;font-size:14px}a{color:#666}hr{border:0;background-color:#ddd;height:1px}h1{font-size:16px;font-weight:100;padding:20px;letter-spacing:1px}h2{font-size:14px;font-weight:100;padding:20px}</style><body><h1>错误：' . $str . '</h1><hr><h2>Powerd By <a href="http://www.superword.cn">' . App_Name . ' </a> QQ Group：372118499</h2></body></html>';
    exit;
}


//根据相应参数,定义变量
function DefinePage() {
 
    if(!empty($_GET['cate'])){
        if($_GET['cate']=='index'){
            define("IS_INDEX",TRUE);
        }else{
            define("IS_CATE",TRUE); 
        }
    }

    if(!empty($_GET['tag']))    define("IS_TAG",TRUE);
    if(!empty($_GET['search'])) define("IS_SEARCH",TRUE);


    if(!empty($_GET['is_page']) && $_GET['is_page']){
        define("IS_PAGE",TRUE);
    }else{
        define("IS_POST",TRUE);
    }
}









//------------------------------过滤相关函数------------------------------//

/**
 * 转义用户提交的信息(addslashes过滤)
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string|array $string 需要过滤的信息
 * @param   int $force           是否强制
 * @return  string|array $string 返回过滤后的信息
 */
function Daddslashes($string, $force = 0) {
    if (empty($GLOBALS['magic_quotes_gpc']) || !$GLOBALS['magic_quotes_gpc'] || $force) {
        if (is_array($string)) {
            foreach ($string as $key => $val) {
                $string[$key] = Daddslashes($val, $force);
            }
        } else {
            $string = addslashes($string);
        }
    }
    return $string;
}


/**
 * 转义用户提交的信息(htmlspecialchars过滤)
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string|array $string 需要过滤的信息
 * @param   $force               标记
 * @return  string|array $string 返回过滤后的信息
 */
function Dhtmlspecialchars($string, $flags = null) {
    if (is_array($string)) {
        foreach ($string as $key => $val) {
            $string[$key] = Dhtmlspecialchars($val, $flags);
        }
    } else {
        if ($flags === null) {
            $string = str_replace(array(
                '&',
                '"',
                '<',
                '>'
            ) , array(
                '&amp;',
                '&quot;',
                '&lt;',
                '&gt;'
            ) , $string);
            if (strpos($string, '&amp;#') !== false) {
                $string = preg_replace('/&amp;((#(\d{3,5}|x[a-fA-F0-9]{4}));)/', '&\\1', $string);
            }
        } else {
            if (PHP_VERSION < '5.4.0') {
                $string = htmlspecialchars($string, $flags);
            } else {
                if (strtolower(CHARSET) == 'utf-8') {
                    $charset = 'UTF-8';
                } else {
                    $charset = 'ISO-8859-1';
                }
                $string = htmlspecialchars($string, $flags, $charset);
            }
        }
    }
    return $string;
}


/**
 * 检测字符串是否有危险字符(防止SQL注入)
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $sql_str 待检查的字符串
 * @return  bool    true|false
 */
function InjectCheck($sql_str) {
    return preg_match('/select|insert|and|or|update|delete|\'|\/\*|\*|\.\.\/|\.\/|union|into|load_file|outfile/', $sql_str);
}


/**
 * 检测id是否合法(防止SQL注入)
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   int $id 可接受的是int，不是将报错
 * @return  int $id
 */
function VerifyId($id = null) {
    if ($id == "") {
        Stop('数字为空');
    } elseif (InjectCheck($id)) {
        Stop('参数非法');
    } elseif (!is_numeric($id)) {
        Stop('不是数字');
    }
    $id = intval($id);
    return $id;
}


/**
 * 替换字符串中的敏感字符(比如 _ %)
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $str 待检查的字符串
 * @return  string $str
 */
function StrCheck($str) {
    if (InjectCheck($str)) {
        //Stop('参数非法');             //字符串去检测敏感字符,局限性太多
    }
    $str = str_replace("%", "\%", $str);
    return $str;
}


/**
 * 替换用户提交的多行文本
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $post 待检查的文本(用在表单中的textarea)
 * @return  string $post
 */
function PostCheck($post) {
    $post = StrCheck($post);
    $post = nl2br($post);
    return $post;
}

//------------------------------以下为模板输出所用函数------------------------------//

/**
 * 输出博客配置信息
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $string   博客配置信息的键名
 * @param   string $function 回调函数名字
 * @return  直接输出
 */
function BlogInfo($string, $function = "") {
    global $blog_config_arr;
    if ($function == "") {
        echo $blog_config_arr['cfg_blog_' . $string];
    } else {
        echo $function($blog_config_arr['cfg_blog_' . $string]);
    }
}


/**
 * 输出URL规则信息
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $string   博客URL规则信息的键名
 * @return  直接输出
 */
function UrlInfo($string) {
    global $blog_config_arr;
    echo $blog_config_arr['cfg_rule_' . $string];
}


/**
 * 输出邮箱配置信息
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $string   邮箱配置信息的键名
 * @return  直接输出
 */
function EmailInfo($string) {
    global $blog_config_arr;
    echo $blog_config_arr['email_' . $string];
}


/**
 * 输出前台主题的URL地址
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   无
 * @return  直接输出
 */
function TempDir() {
    global $blog_config_arr;
    $tem = ltrim(App_Tem_currt, '.');
    $tem = rtrim($tem, '/');
    echo $blog_config_arr['cfg_blog_website'] . $tem;
}


/**
 * 输出后台主题的URL地址
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   无
 * @return  直接输出
 */
function TempAdminDir() {
    global $blog_config_arr;
    if ($blog_config_arr['cfg_blog_website'] == "") {
        $url = 'http://' . $_SERVER['HTTP_HOST'];
    } else {
        $url = $blog_config_arr['cfg_blog_website'];
    }
    $tem = ltrim(App_Core, '.');
    $tem = rtrim($tem, '/');
    echo $url . $tem . '/view/res';
}


/**
 * 输出后台管理的URL地址
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   无
 * @return  直接输出
 */
function GetAdminUrl() {
    global $blog_config_arr;
    echo $blog_config_arr['cfg_blog_website'] . '/' . $blog_config_arr['cfg_blog_admin_dir'];
}


/**
 * 输出管理员登录的URL地址
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   无
 * @return  直接输出
 */
function GetLoginUrl() {
    global $blog_config_arr;
    echo $blog_config_arr['cfg_blog_website'] . '/' . $blog_config_arr['cfg_blog_login_dir'];
}


/**
 * 加载当前主题的相关文件
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $string 文件名
 * @return  无
 */
function GetTemp($string) {
    if (App_Model == "HomeAction") {
        $file = App_Tem_currt . $string . '.php';
    } else {
        $file = App_Core . "view/" . strtolower(App_Model) . "/" . $string . '.php';
        $file = str_ireplace("Action", "", $file);
    }
    if (!file_exists($file)) {
        Stop($file . ' 主题文件不存在');
    } else {
        require_once ($file);
    }
}


/**
 * 输出日志信息
 * @author  汤姆大叔
 * @date    2015-5-13
 * @see     http://www.superword.cn
 *
 * @param   string $string   日志信息键名
 * @param   string $function 回调函数名字
 * @return  直接输出
 */
function GetBlog($string, $function = "") {
    global $blog_post;
    if ($function === "") {
        echo $blog_post[$string];
    } else {
        echo $function($blog_post[$string]);
    }
}

//输出$_GET数组信息(主要在安装步骤第二步使用)
function GetToEcho($string) {
    if (empty($_GET[$string]) || $_GET[$string]=="") {
        echo '';
    } else {
        echo $_GET[$string];
    }
}