<!DOCTYPE html>
<html lang="zh-CN">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>日志 - <?php echo App_Name; ?></title>
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/common.css">
    <script src="<?php TempAdminDir(); ?>/js/jquery.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/bootstrap.min.js"></script>
 
    <script type="text/javascript">
      $(document).ready(function(){
        $('.del_link').popover();
      });
    </script>   
  </head>
  <body>
    <?php GetTemp('header'); ?>
    <div class="container">

      <div class="row">
        <div class="col-md-3">
          <div class="list-group">
            <?php GetTemp('menu_sider'); ?>
          </div>
        </div>

        <div class="col-md-9">
 
          <?php global $blog_index; if (is_null($blog_index)): ?>
            当前没有相关日志哦！
          <?php else: ?>
          <div class="panel panel-default">
            <table class="table table-bordered">
              <tr>
                <td>ID</td>
                <td>标题</td>
                <td>分类</td>
                <td>作者</td>
                <td>访问量</td>
                <td>评论量</td>
                <td>添加时间</td>
                <td>操作</td>
              </tr>
              <?php global $blog_index; foreach ($blog_index as $item): ?>
                <tr id="blog_<?php echo $item['id']; ?>">
                  <td><?php echo $item['id']; ?></td>
                  <td><?php echo $item['title']; ?></td>
                  <td><?php 
                      if($item['cate_name'] == ""){
                        echo '未分类';
                      }else{
                        echo $item['cate_name'];
                      }
                  ?></td>
                  <td><?php echo $item['uname']; ?></td>
                  <td><?php echo $item['point_page']; ?>
                  <td><?php echo $item['point_comment']; ?>
                    <td><?php echo date("n-d G:i", $item['time_add']); ?>
                  <td>
                    <a href="<?php echo U("admin","blog_edit/id/".$item['id']); ?>">编辑</a>
                    <a tabindex="0" 
                       class="del_link" 
                       role="button" 
                       data-toggle    = "popover" 
                       data-html      = "true"
                       data-title     = "确定删除?" 
                       data-placement = "bottom" 
                       data-content="<a href='<?php echo U('admin','blog_del/id/'.$item['id']); ?>' >删除</a>"
                    >删除</a>
                  </td>
                </tr>
              <?php endforeach; ?>
            </table>
          </div>
          <div class="page_show"><?php global $page_show; echo $page_show;?><div style="clear:both;"></div>
          <?php endif; ?>
 
      </div>
    </div>

    </div>
    <?php GetTemp('footer'); ?>
  </body>
</html>