﻿<!DOCTYPE html>
<html lang="zh-CN">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>日志分类 - <?php echo App_Name; ?></title>
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/common.css">
    <script src="<?php TempAdminDir(); ?>/js/jquery.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/bootstrap.min.js"></script>


    <!-- 加载 bootstrapvalidator -->
    <script src="<?php TempAdminDir(); ?>/js/bootstrapvalidator.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/superword_js_notice.js"></script>

    <script src="<?php TempAdminDir(); ?>/js/superword_ajax.js"></script>
  </head>
  <body>
    <?php GetTemp('header'); ?>
    <div class="container">

      <div class="row">
        <div class="col-md-3">
          <div class="list-group">
            <?php GetTemp('menu_sider'); ?>
          </div>
        </div>

        <div class="col-md-9">
 

          <div class="item_lable">分类列表</div>
 
          <?php global $cate_index; global $this_cate; if (is_null($cate_index)): ?>
            当前没有添加日志分类哦！
          <?php else: ?>
          <div class="panel panel-default">
            <table class="table table-bordered">
              <tr>
                <td>ID</td>
                <td>分类</td>
                <td>显示名</td>
                <td>操作</td>
              </tr>
                  
              <?php foreach ($cate_index as $cate): ?>
              <tr>
                <td><?php echo $cate['id']; ?></td>
                <td><?php echo $cate['cate']; ?></td>
                <td><?php echo $cate['cate_name']; ?></td>
                <td>
                  <a href="<?php echo U('admin','blog_cate/edit/'.$cate['id']);?>">编辑</a>
                  <a class="cate_del" data-id="<?php echo $cate['id'];?>">删除</a>
                </td>
              </tr>
              <?php endforeach; ?>
            </table>
          </div>
          <?php endif; ?>

          <div class="item_lable">新增/更新</div>

          <form class="form-horizontal" action="<?php echo U('admin','blog_cate_handle');?>" method="post">
  
            <div class="form-group">
              <label class="col-sm-1 control-label">分类</label>
              <div class="col-sm-5">
                <input type="text" class="form-control" name="cate" value="<?php echo $this_cate['cate'];?>">
              </div>
            </div>

            <div class="form-group">
              <label class="col-sm-1 control-label">显示名</label>
              <div class="col-sm-5">
                <input type="text" class="form-control" name="cate_name" value="<?php echo $this_cate['cate_name'];?>">
              </div>
            </div>
           
              <?php if(!is_null($this_cate)):?>
                <input type="hidden" class="form-control" name="id" value="<?php echo $this_cate['id'];?>">
              <?php endif; ?> 


            <div class="form-group">
              <div class="col-sm-offset-1 col-sm-10">
                <button type="button" class="btn btn-default pull-left" id="form_sumit">新增/更新</button>
                <span id="feed_back"></span>                
              </div>
            </div>
          </form>
 
      </div>
    </div>

    </div>
    <?php GetTemp('footer'); ?>
  </body>
</html>