<!DOCTYPE html>
<html lang="zh-CN">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>新日志 - <?php echo App_Name; ?></title>
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/common.css">
    <script src="<?php TempAdminDir(); ?>/js/jquery.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/bootstrap.min.js"></script>
 
    <!-- 加载 summernote -->
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/summernote.css">
    <script src="<?php TempAdminDir(); ?>/js/summernote.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/summernote-zh-CN.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/summernote-ext-video.js"></script>

    <!-- 加载 bootstrapvalidator -->
    <script src="<?php TempAdminDir(); ?>/js/bootstrapvalidator.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/superword_js_notice.js"></script>
 
    <script src="<?php TempAdminDir(); ?>/js/superword_ajax.js"></script>
  </head>
  <body>
    <?php GetTemp('header'); ?>
    <div class="container">
      <div class="row">

        <div class="col-md-3">
          <div class="list-group">
            <?php GetTemp('menu_sider'); ?>
          </div>
        </div>

        <div class="col-md-9">
 
              <form class="form-horizontal" action="<?php echo U('admin','blog_create_handle'); ?>" method ="post">
                
                <div class="form-group">
                  <label class="col-sm-1 control-label">标题</label>
                  <div class="col-sm-8">
                    <input type="text" class="form-control" name="title">
                  </div>
                </div>

                <div class="form-group">
                  <label class="col-sm-1 control-label">简介</label>
                  <div class="col-sm-8">
                    <textarea class="form-control" rows="3" name="description"></textarea>
                  </div>
                </div>


                <div class="form-group">
                  <label class="col-sm-1 control-label">分类</label>
                  <div class="col-sm-8">
                    <label class="radio-inline">
                      <input type="radio" name="id_cate" value="0" >未分类
                    </label>
                    <?php global $cate_index; if (!empty($cate_index)): ?>
                      <?php foreach ($cate_index as $cate): ?>
                        <label class="radio-inline">
                          <input type="radio" name="id_cate" value="<?php echo $cate['id']; ?>" ><?php echo $cate['cate_name']; ?>
                        </label>
                      <?php endforeach; ?>
                    <?php endif; ?>
                  </div>
                </div>

                <div class="form-group">
                  <label class="col-sm-1 control-label">属性</label>
                  <div class="col-sm-8">
                    <label class="checkbox-inline">
                      <input type="checkbox" name="is_delay" value="1" >延时发布？
                    </label>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="is_rec" value="1" >是否推荐？
                    </label>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="is_page" value="1" >是单页面？
                    </label>
                  </div>
                </div>

 
                <div class="form-group">
                  <label class="col-sm-1 control-label">标签</label>
                  <div class="col-sm-4">
                    <input type="text" class="form-control" name="tags" placeholder="多标签请空格">
                  </div>
                  <label class="col-sm-1 control-label">URL</label>
                  <div class="col-sm-3">
                    <input type="text" class="form-control" name="id_str" id="id_str">
                  </div>
                  <p class="col-sm-2 form-control-static" id="id_str_feedback"></p>
                </div>
              
                <div class="form-group" id="progress_show">
                  <label class="col-sm-1 control-label">上传中</label>
                  <div class="col-sm-11">
                      <div class="progress">
                        <div class="progress-bar progress-bar-danger progress-bar-striped active" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width:80%">
                        0%
                       </div>
                      </div>
                  </div>
                </div>

                <div class="form-group">
                  <label class="col-sm-1 control-label">正文</label>
                  <div class="col-sm-11">
                    <textarea class="form-control" name="body" id="summernote"></textarea>
                  </div>
                </div>


                <div class="form-group">
                  <div class="col-sm-offset-1 col-sm-11">
                    <button type="button" class="btn btn-danger" id="form_sumit" style="float:left;">立即添加</button>
                    <span id="feed_back"></span>
                  </div>
                </div>

              </form>
 
        </div>

      </div>
    </div>
    <?php GetTemp('footer'); ?>
  </body>
</html>