<!DOCTYPE html>
<html lang="zh-CN">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>仪表盘 - <?php echo App_Name; ?></title>
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/common.css">
    <script src="<?php TempAdminDir(); ?>/js/jquery.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/bootstrap.min.js"></script>
    <script>
      $(document).ready(function(){
        $("#notice_list").hide();
        $.get("http://www.superword.cn/open/blog",function(data,status){
          if(status == "success"){
            var dataObj = JSON.parse(data);
            var data_post = dataObj.post;
            var html = "";
            for(i = 0;i<data_post.length;i++){
              html = html + '<a href="'+data_post[i].url+'" class="list-group-item" target="_blank">' + data_post[i].title + '<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span></a>';
            }
            if(html != ""){
              $("#notice_list_top_div").css("display","none");
              $("#notice_list").show();
              $("#notice_list").html(html);
            }
          }
        });
      });
    </script>
  </head>
  <body>
    <?php GetTemp('header'); ?>
    <div class="container">
      <div class="row">

        <div class="col-md-3">
          <div class="list-group">
            <?php GetTemp('menu_sider'); ?>
          </div>
        </div>

        <div class="col-md-9">
          <div class="row">
            <div class="col-md-6">
              <div class="panel panel-default">
                <div class="panel-heading">博客动态</div>

                <?php global $dynamic_index; if (empty($dynamic_index)): ?>
                  <div class="panel-body">
                    当前没有博客动态！
                  </div>
                <?php else: ?>
                  <ul class="list-group">
                    <?php  foreach ($dynamic_index as $dynamic): ?>
                      <li class="list-group-item"><?php echo $dynamic['uname'];?> <?php echo ActionName($dynamic['action']);?>《<?php echo $dynamic['title'];?>》<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span></li>
                    <?php endforeach; ?>
                  </ul>
                <?php endif; ?>
 
              </div>
            </div>
            <div class="col-md-6">
              <div class="panel panel-default">
                <div class="panel-heading">官方通知</div>
                <div class="panel-body" id="notice_list_top_div">
                  当前没有官方通知！
                </div>
                <ul class="list-group" id="notice_list">正在加载..</ul>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-6">
              <div class="panel panel-default">
                <div class="panel-heading">博客概况</div>
                <div class="panel-body">
                  <ul class="list_count">
                    <?php global $blog_config_arr;?>
                    <li>日志总数：<?php echo $blog_config_arr['cfg_count_blog']; ?></li>
                    <li>评论总数：<?php echo $blog_config_arr['cfg_count_comment']; ?></li>
                    <li>标签总数：<?php echo $blog_config_arr['cfg_count_tag']; ?></li>
                    <li>分类总数：<?php echo $blog_config_arr['cfg_count_cate']; ?></li>
                    <li>链接总数：<?php echo $blog_config_arr['cfg_count_link']; ?></li>
                    <li>用户总数：<?php echo $blog_config_arr['cfg_count_user']; ?></li>
                    <li>建站时间：<?php echo date('Y-m-d',$blog_config_arr['cfg_blog_found_time']); ?></li>
                    <li>最后更新：<?php 
                                      if($blog_config_arr['cfg_blog_last_time'] != ""){
                                          echo date('Y-m-d',$blog_config_arr['cfg_blog_last_time']);
                                      }else{
                                          echo '没有更新';
                                      }
                                  ?>
                    </li>

                  </ul>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="panel panel-default">
                <div class="panel-heading">版权说明</div>
                <div class="panel-body" style="line-height:24px;">
                  <p>SuperWord秉承开源原则，遵循GPL协议。您可以在www.surperword.cn上获得更多相关信息。</p><p style="margin-bottom:0px;">欢迎您加入SuperWord的交流QQ群：372118499</p>
                </div>

                <ul class="list-group">
                  <li class="list-group-item">架构&程序&设计：汤姆大叔</li>
                </ul>

              </div>
            </div>
          </div>
        </div>
      </div>

    </div>
    <?php GetTemp('footer'); ?>
  </body>
</html>