<!DOCTYPE html>
<html lang="zh-CN">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>邮箱设置 - <?php echo App_Name; ?></title>
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/common.css">
    <script src="<?php TempAdminDir(); ?>/js/jquery.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/bootstrap.min.js"></script>

    <!-- 加载 bootstrapvalidator -->
    <script src="<?php TempAdminDir(); ?>/js/bootstrapvalidator.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/superword_js_notice.js"></script>
    
    <script src="<?php TempAdminDir(); ?>/js/superword_ajax.js"></script>
  </head>
  <body>
    <?php GetTemp('header'); ?>
    <div class="container">
      <div class="row">

        <div class="col-md-3">
          <div class="list-group">
            <?php GetTemp('menu_sider'); ?>
          </div>
        </div>
        <div class="col-md-9">
          <div class="panel panel-default">
            <div class="panel-heading">邮箱设置</div>
            <div class="panel-body">
              <form class="form-horizontal" action="<?php echo U('admin','confighandle'); ?>" method ="post">
              
                <div class="form-group">
                  <label class="col-sm-2 control-label">接受通知</label>
                  <div class="col-sm-6">
                  <div class="checkbox">
                    <label>
                        <input type="checkbox" name="email_is_receive" value="1"
                          <?php global $blog_config_arr; 
                            if($blog_config_arr['email_is_receive']){
                              echo ' checked="checked"';
                            }
                          ?>
                        >当有新评论时候,是否通知日志发布者？
                    </label>
                  </div>
                  </div>
                </div>

                <div class="form-group">
                  <label class="col-sm-2 control-label">发送通知</label>
                  <div class="col-sm-6">
 
                    <div class="checkbox">
                      <label>
                        <input type="checkbox" name="email_is_send" value="1"
                          <?php global $blog_config_arr; 
                            if($blog_config_arr['email_is_send']){
                              echo ' checked="checked"';
                            }
                          ?>
                        >当被他人评论时候,是否发送邮件通知?
                      </label>
                    </div>

                  </div>
                </div>
                
                <div class="form-group">
                  <label class="col-sm-2 control-label">STMP服务器</label>
                  <div class="col-sm-6">
                    <input type="text" class="form-control" name="email_send_host" value="<?php EmailInfo('send_host'); ?>">
                  </div>
                  <p class="col-sm-4 form-control-static">例如：smtp.qq.com</p>
                </div>
                
                <div class="form-group">
                  <label class="col-sm-2 control-label">STMP端口</label>
                  <div class="col-sm-6">
                    <input type="text" class="form-control" name="email_send_port" value="<?php EmailInfo('send_port'); ?>">
                  </div>
                  <p class="col-sm-4 form-control-static">例如：465</p>
                </div>
                
                <div class="form-group">
                  <label class="col-sm-2 control-label">邮箱</label>
                  <div class="col-sm-6">
                    <input type="text" class="form-control" name="email_send_email" value="<?php EmailInfo('send_email'); ?>">
                  </div>
                  <p class="col-sm-4 form-control-static">例如：123456@qq.com</p>
                </div>
                
                <div class="form-group">
                  <label class="col-sm-2 control-label">密码</label>
                  <div class="col-sm-6">
                    <input type="text" class="form-control" name="email_send_pwd" value="<?php EmailInfo('send_pwd'); ?>">
                  </div>
                  <p class="col-sm-4 form-control-static">若是QQ邮箱,则是邮箱独立密码</p>
                </div>
  
                <input type="hidden" name="is_from" value="email">
                <div class="form-group">
                  <div class="col-sm-offset-2 col-sm-10">
                    <button type="button" class="btn btn-danger" id="form_sumit" style="float:left;">确认修改</button>
                    <span id="feed_back"></span>
                  </div>
                </div>

              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
    <?php GetTemp('footer'); ?>
  </body>
</html>