<!DOCTYPE html>
<html lang="zh-CN">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>插件设置 - <?php echo App_Name; ?></title>
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/common.css">
    <script src="<?php TempAdminDir(); ?>/js/jquery.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/bootstrap.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/superword_ajax.js"></script>
  </head>
  <body>
    <?php GetTemp('header'); ?>
    <div class="container">
      <div class="row">

        <div class="col-md-3">
          <div class="list-group">
            <?php GetTemp('menu_sider'); ?>
          </div>
        </div>
        <div class="col-md-9">


          <div class="alert alert-info alert-dismissible" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <strong>敬告!</strong> 该插件正在使用,不可删除
          </div>

          <?php global $plug_list; if (empty($plug_list)): ?>
            当前没有任何插件
          <?php else: ?>

          <?php foreach ($plug_list as $key => $plug): ?>
          <div class="panel panel-default" id="<?php echo $key; ?>">

            <div class="panel-heading">
              <span class="glyphicon glyphicon-paperclip" aria-hidden="true"></span>
              <div><?php echo $plug['name']; ?></div>
              <?php 
                if($plug['is_active']){ 
                  echo '<a class="plug_stop"   data-name="'.$key.'">停用</a>';
                }else{ 
                  echo '<a class="plug_start" data-name="'.$key.'">启用</a>';
                }
                  echo '<a class="plug_del"   data-name="'.$key.'">删除</a>';
              ?>
            </div>

            <div class="panel-body">
                <div class="media">
                  <div class="media-body">
                    <h4 class="media-heading"><?php echo $plug['info']; ?></h4>
                    <ul class="list-inline">
                        <li>脚本:<?php echo $plug['file']; ?></li>
                        <li>作者:<?php echo $plug['author']; ?></li>
                        <li>主页:<?php echo $plug['url']; ?></li>
                    </ul>
                  </div>
                </div>
            </div>
 
          </div>
          <?php endforeach; ?>
          <?php endif; ?>
 
        </div>
      </div>
    </div>
    <?php GetTemp('footer'); ?>
  </body>
</html>