<!DOCTYPE html>
<html lang="zh-CN">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>主题设置 - <?php echo App_Name; ?></title>
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/common.css">
    <script src="<?php TempAdminDir(); ?>/js/jquery.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/bootstrap.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/superword_ajax.js"></script>
  </head>
  <body>
    <?php GetTemp('header'); ?>
    <div class="container">
      <div class="row">

        <div class="col-md-3">
          <div class="list-group">
            <?php GetTemp('menu_sider'); ?>
          </div>
        </div>
        <div class="col-md-9">
          <div class="alert alert-info alert-dismissible" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <strong>敬告!</strong> 该主题正在使用,不可删除
          </div>
          <?php global $temp_list; foreach ($temp_list as $key => $temp): ?>
          <div class="panel panel-default">

            <div class="panel-heading">
              <span class="glyphicon glyphicon-paperclip" aria-hidden="true"></span>
              <div><?php echo $temp['name']; ?></div>

              <?php if($temp['is_active']){ 
                echo '<a class="disabled">使用中</a>';
              }else{ 
                echo '<a class="temp_start" data-name="'.$key.'">启用</a>';
              } ?>
              <a  class="temp_del" data-name="<?php echo $key;?>">删除</a>
            </div>

            <div class="panel-body">
                <div class="media">
                  <div class="media-left"><img class="media-object" src="<?php echo $temp['screen']; ?>" alt="..."></div>
                  <div class="media-body">
                    <h4 class="media-heading"><?php echo $temp['info']; ?></h4>
                    <ul class="list-inline">
                        <li>目录:<?php echo $key; ?></li>
                        <li>作者:<?php echo $temp['author']; ?></li>
                        <li>主页:<?php echo $temp['url']; ?></li>
                    </ul>
                  </div>
                </div>
            </div>
 
          </div>
          <?php endforeach; ?>

        </div>
      </div>
    </div>
    <?php GetTemp('footer'); ?>
  </body>
</html>