<!DOCTYPE html>
<html lang="zh-CN">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>用户管理 - <?php echo App_Name; ?></title>
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php TempAdminDir(); ?>/css/common.css">
    <script src="<?php TempAdminDir(); ?>/js/jquery.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/bootstrap.min.js"></script>


    <!-- 加载 bootstrapvalidator -->
    <script src="<?php TempAdminDir(); ?>/js/bootstrapvalidator.min.js"></script>
    <script src="<?php TempAdminDir(); ?>/js/superword_js_notice.js"></script>
 
    <script src="<?php TempAdminDir(); ?>/js/superword_ajax.js"></script>

    <script type="text/javascript">
      $(document).ready(function(){
        $('.del_link').popover({
          "html":true,
        });
      });
    </script>   

  </head>
  <body>
    <?php GetTemp('header'); ?>
    <div class="container">

      <div class="row">
        <div class="col-md-3">
          <div class="list-group">
            <?php GetTemp('menu_sider'); ?>
          </div>
        </div>

        <div class="col-md-9">
 

          <div class="item_lable">用户列表</div>
 
          <?php global $user_index; if (is_null($user_index)): ?>
            当前没有用户哦！
          <?php else: ?>
  
          <div class="panel panel-default">
            <table class="table table-bordered">
              <tr>
                <td>UID</td>
                <td>昵称</td>
                <td>姓名</td>
                <td>邮箱</td>
                <td>添加时间</td>
                <td>最后登录</td>
                <td>操作</td>
              </tr>
                  
              <?php global $user_index; foreach ($user_index as $user): ?>
              <tr>
                <td><?php echo $user['uid']; ?></td>
                <td><?php echo $user['uname']; ?></td>
                <td><?php echo $user['tname']; ?></td>
                <td><?php echo $user['email']; ?></td>
                <td><?php echo date('Y-m-d',$user['time_add']); ?></td>
                <td><?php echo date('Y-m-d',$user['time_last']); ?></td>
                <td>
                  <a tabindex="0" class="del_link" role="button" data-toggle="popover" data-trigger="focus" title="确定删除?" data-placement="bottom" data-content="<a href='<?php echo U('admin','tool_user/del/'.$user['uid']); ?>'>删除</a>">删除</a>
                </td>
              </tr>
              <?php endforeach; ?>
            </table>
          </div>
          <?php endif; ?>

          <div class="item_lable">新增用户</div>

          <form class="form-horizontal" action="<?php echo U('admin','tool_user_handle');?>" method="post">
            <div class="form-group">
              <label class="col-sm-1 control-label">邮箱</label>
              <div class="col-sm-5">
                <input type="text" class="form-control" name="email">
              </div>
            </div>

            <div class="form-group">
              <label class="col-sm-1 control-label">昵称</label>
              <div class="col-sm-5">
                <input type="text" class="form-control" name="uname">
              </div>
            </div>

            <div class="form-group">
              <label class="col-sm-1 control-label">密码</label>
              <div class="col-sm-5">
                <input type="password" class="form-control" name="pwd">
              </div>
            </div>
           
            <div class="form-group">
              <div class="col-sm-offset-1 col-sm-10">
                <button type="button" class="btn btn-default pull-left" id="form_sumit">添加用户</button>
                <span id="feed_back"></span>
              </div>
            </div>
          </form>
 
      </div>
    </div>
    </div>
    <?php GetTemp('footer'); ?>
  </body>
</html>