$(document).ready(function() { 
    $('form').bootstrapValidator({ 
        message: '当前值是无效的', 
        feedbackIcons: { 
            valid: 'glyphicon glyphicon-ok', 
            invalid: 'glyphicon glyphicon-remove', 
            validating: 'glyphicon glyphicon-refresh' 
        }, 
        fields: { 

//----------阅读权限文件,全站唯一-------------------------------//
            read_license: {
                validators: {
                    notEmpty: {
                        message: '请先阅读使用说明'
                    }
                }
            },

//----------数据库相关配置,验证-------------------------------//
            DB_Host: {
                validators: {
                    notEmpty: {
                        message: '数据库主机不能为空'
                    }
                }
            },
            DB_Port: {
                validators: {
                    notEmpty: {
                        message: '连接端口不能为空'
                    },
                   regexp: { 
                        regexp: /^[0-9]*$/, 
                        message: '连接端口应是纯数字' 
                    } 
                }
            },
            DB_User: {
                validators: {
                    notEmpty: {
                        message: '用户名不能为空'
                    }
                }
            },
            DB_Base: {
                validators: {
                    notEmpty: {
                        message: '数据库名称不能为空'
                    }
                }
            },
            DB_PREFIX: {
                validators: {
                    notEmpty: {
                        message: '表前缀不能为空'
                    }
                }
            },

//----------博客核心配置相关选项-------------------------------//
            cfg_blog_name: { 
                validators: { 
                    notEmpty: { 
                        message: '博客名称不能为空' 
                    }, 
                } 
            }, 

            cfg_blog_website: { 
                validators: { 
                    notEmpty: { 
                        message: '博客网址不能为空' 
                    }, 
                    regexp: { 
                        regexp: /^http:\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\’:+!]*([^<>\"])*$/, 
                        message: '不是有效的网址格式' 
                    } 
                } 
            }, 

            cfg_blog_login_dir: { 
                validators: { 
                    notEmpty: { 
                        message: '登录地址不能为空' 
                    }
                } 
            }, 

            cfg_blog_admin_dir: { 
                validators: { 
                    notEmpty: { 
                        message: '管理地址不能为空' 
                    }
                } 
            }, 


//----------友情链接相关-------------------------------//
            webname: { 
                validators: { 
                    notEmpty: { 
                        message: '网站名称不能为空' 
                    }, 
                } 
            }, 
            website: { 
                validators: { 
                    notEmpty: { 
                        message: '网站地址不能为空' 
                    }, 
                    regexp: { 
                        regexp: /^http:\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\’:+!]*([^<>\"])*$/, 
                        message: '不是有效的网址格式' 
                    } 
                } 
            },

//----------广告相关-------------------------------//
            ad_postion: { 
                validators: { 
                    notEmpty: { 
                        message: '广告位置不能为空' 
                    }, 
                } 
            }, 
            ad_code: { 
                validators: { 
                    notEmpty: { 
                        message: '广告代码不能为空' 
                    }, 
                } 
            },

//----------日志分类相关-------------------------------//
            cate: { 
                validators: { 
                    notEmpty: { 
                        message: '分类不能为空' 
                    }, 
                } 
            }, 
            cate_name: { 
                validators: { 
                    notEmpty: { 
                        message: '分类显示名不能为空' 
                    }, 
                } 
            },

//----------日志操作相关-------------------------------//
            title: { 
                validators: { 
                    notEmpty: { 
                        message: '日志标题不能为空' 
                    }, 
                } 
            }, 

 
//----------评论操作相关-------------------------------//
            comment: { 
                validators: { 
                    notEmpty: { 
                        message: '评论内容不能为空' 
                    }, 
                } 
            }, 



//----------用户相关设置选项-------------------------------//
            uname: { 
                validators: { 
                    notEmpty: { 
                        message: '昵称不能为空' 
                    }
                } 
            }, 
            email: { 
                validators: { 
                    notEmpty: { 
                        message: '邮箱地址不能为空' 
                    }, 
                    emailAddress: { 
                        message: '邮箱地址不正确' 
                    } 
                } 
            }, 

            pwd: { 
                validators: { 
                    notEmpty: { 
                        message: '密码不能为空' 
                    }, 
                 stringLength: {
                        min: 8,
                        max: 32,
                        message: '密码最低8位，最高32位'
                    },
                    regexp: { 
                        regexp: /^[a-zA-Z0-9_]+$/, 
                        message: '密码只接受数字,字母及下划线' 
                    } 
                } 
            }, 

 

            re_pwd: { 
                validators: { 
                    notEmpty: { 
                        message: '密码不能为空' 
                    }, 
                 stringLength: {
                        min: 8,
                        max: 32,
                        message: '密码最低8位，最高32位'
                    },
                    regexp: { 
                        regexp: /^[a-zA-Z0-9_]+$/, 
                        message: '密码只接受数字,字母及下划线' 
                    } 
                } 
            }, 























        } 
    }); 
}); 