<?php

/**
 * 功能：SurperWord博客程序的主要流程控制
 * 介绍：包含了整个程序运行的主要变量，常量，方法，流程等。
 * 例如定义常量，分析URL，读取核心配置，是否安装，是否缓存，加载主题，加载插件，执行分支程序。
 * 作者：汤姆大叔
 * 邮箱：tangpanqing@qq.com
 * 日期：2015.5.12
 */

header('Content-type:text/html;charset=utf-8');
session_start();

//1.定义常量
define('App_Name', 'SuperWord');
define('App_Root', './');
define('App_Core',    App_Root . 'core/');
define('App_Files',   App_Root . 'files/');
define('App_Plugins', App_Root . 'plugins/');
define('App_Tem',     App_Root . 'temple/');

define('App_Cache',   App_Core . 'cache/');
define('App_Class',   App_Core . 'class/');
define('App_Update',  App_Core . 'update/');

define('App_Files_Upload',   App_Files . 'upload/');
define('App_Files_Down',     App_Files . 'download/');
define('App_Files_Attached', App_Files . 'attached/');


//2.加载核心方法库
require_once App_Core . 'function.php';

//addslashes过滤用户提交的所有信息
if(!get_magic_quotes_gpc()) { 
    $_COOKIE = Daddslashes($_COOKIE);
    $_POST   = Daddslashes($_POST);
    $_GET    = Daddslashes($_GET);  
    //$_FILES = Daddslashes($_FILES);
} 

//数据库连接计数
$query_count = 0;

//3.读取分析页面URL(重要参数$web_request_url $web_request_arr)
$web_request_url = UrlRequest(); 
$web_request_arr = explode('/', $web_request_url);

//4.加载博客配置文件
$config_blog_file_arr = (require_once App_Core . 'config_blog.php');

//5.如果是新安装
if (!$config_blog_file_arr['is_install']) {
    if ($web_request_arr[0] == '') {
        $step = 'step_one';
    } else {
        $step = $web_request_arr[0];
    }
    define('App_Model', 'InstallAction');
    define('App_Action', strtolower($step));
    $Install = new InstallAction();
    $Install->{$step}();
    die;
}

//6.如果开启缓存(缓存只对前台有效)
if ($config_blog_file_arr['cfg_blog_cache_time']) {
    $cache = new Cache($config_blog_file_arr, $web_request_arr);
    $cache->GetCache();
}
 
//7.读取博客所有配置(重要参数blog_config_arr)
$BlogConfig  = D('BlogConfig');
$blog_config = $BlogConfig->select();
foreach ($blog_config as $key => $value) {
    $blog_config_arr[$value['cfg_name']] = $value['cfg_value'];  
}

if (!empty($blog_config_arr['cfg_blog_copy_right'])) {
    $blog_config_arr['cfg_blog_copy_right'] = htmlspecialchars_decode($blog_config_arr['cfg_blog_copy_right']);
}
if (!empty($blog_config_arr['cfg_blog_statistics'])) {
    $blog_config_arr['cfg_blog_statistics'] = htmlspecialchars_decode($blog_config_arr['cfg_blog_statistics']);
}
if($blog_config_arr['cfg_blog_cate'] != ""){
    $blog_config_arr['cfg_count_cate'] = substr_count($blog_config_arr['cfg_blog_cate'], '|');
}else{
    $blog_config_arr['cfg_count_cate'] = '0';
}
 

//8.定义当前主题目录,加载主题function.php
define('App_Tem_currt', App_Tem . $blog_config_arr['cfg_blog_temple'] . '/');
if (!file_exists(App_Tem_currt . 'function.php')) {
    Stop(App_Tem_currt . 'function.php' . ' 模板文件不存在');
} else {
    require_once App_Tem_currt . 'function.php';
}

//9.加载激活的插件
if ($blog_config_arr['cfg_blog_plus'] != '') {
    $blog_plus_arr = explode(',', $blog_config_arr['cfg_blog_plus']);
    $blog_plus_arr = array_filter($blog_plus_arr);
    foreach ($blog_plus_arr as $key => $value) {
        if (!file_exists(App_Plugins . $value . '.php')) {
            Stop($value . '插件不存在。');
        }
        if (!(require_once App_Plugins . $value . '.php')) {
            Stop($value . '插件加载失败。');
        }
    }
}

//执行插件before_url
Plug::go('before_url');

//10.对比页面URL与博客路由规则,判断意图(重要参数url_array_back)
$url_array_back = UrlRoute($web_request_arr, $blog_config_arr);
 
//执行插件after_url
Plug::go('after_url');

//11.转到相应的分支程序
$model  = ucfirst(strtolower($url_array_back['model'])) . 'Action';
$action = strtolower($url_array_back['action']);
define('App_Model', $model);
define('App_Action', $action);
$m = new $model();
$m->{$action}();

//12.如果启用缓存,并且缓存文件不存在,则写入
if ($config_blog_file_arr['cfg_blog_cache_time']) {
    $cache->SetCache();
}
?>