<!DOCTYPE html>
<html lang="zh-CN">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php BlogInfo('page_title'); ?></title>
    <meta name="keywords" content="<?php BlogInfo('page_keywords'); ?>" />
    <meta name="description" content="<?php BlogInfo('page_description'); ?>" />
    
    <link rel="stylesheet" href="<?php TempDir(); ?>/css/css.css">
    <link rel="stylesheet" href="<?php TempDir(); ?>/css/fontello.css">
    <?php Plug::go('before_body'); ?>
  </head>
  <body>
    
    <div class="wrap">
      <?php GetTemp('header');?>
      <div class="main_mid">

          <!--输出索引日志,输出分页信息-->
          <?php global $blog_index; if (empty($blog_index)): ?>
            当前没有相关日志哦！
          <?php else: ?>
            <div class="index_list">
               <?php  foreach ($blog_index as $blog): ?>
                  <div class="main_blog">
                    <div class="mid_common mid_title"><a href="<?php echo $blog['url'];?>" title="<?php echo $blog['title'];?>"><?php echo $blog['title'];?></a></div>
                    <div class="mid_common mid_info">由 <a href="#"><?php echo $blog['uname'];?></a> 发表在 <span><?php echo $blog['cate_name'];?></span></div>
                    <hr>
                    <div class="mid_common mid_data"><i class="icon-calendar-empty"></i> <?php echo FriendTime($blog['time_add']);?>    <i class="icon-eye"></i> <?php echo $blog['point_page'];?> 浏览   <i class="icon-comment-empty"></i> <?php echo $blog['point_comment'];?> 评论</div>
                    <?php if(!empty($blog['litpic'])): ?>
                    <a href="<?php echo $blog['url'];?>"><img src="<?php echo $blog['litpic'];?>" alt="<?php echo $blog['title'];?>"></a>
                    <?php endif; ?>
                    <div class="des"><?php echo $blog['description'];?></div>
                    <div class="link"><a href="<?php echo $blog['url'];?>">阅读详情</a></div>
                    <div class="clear"></div>
                  </div>
              <?php endforeach; ?>
            </div>
            <div class="index_page">
              <?php global $page_show; echo $page_show; ?>
            </div>
          <?php endif; ?>

      </div>
      <?php GetTemp('sider');?>
      <div class="clear"></div>
    </div>
    <?php GetTemp('footer');?>
    <?php Plug::go('after_body'); ?>
  </body>
</html>