<!DOCTYPE html>
<html lang="zh-CN">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php GetBlog('title'); ?> - <?php BlogInfo('name'); ?></title>
    <meta name="description" content="<?php GetBlog('description');?>" />
    <meta name="keywords" content="<?php GetBlog('tags');?>" />
    <link rel="stylesheet" href="<?php TempDir(); ?>/css/css.css">
    <link rel="stylesheet" href="<?php TempDir(); ?>/css/fontello.css">
    <script src="<?php TempDir(); ?>/js/jquery.min.js"></script>
    <script>
      $(document).ready(function(){
        
        $(".reply_user").click(function(){
          $("#fid").val($(this).attr("comment_id"));
          $("#comment").val("回复 "+$(this).attr("comment_user") + "：");
        });

        $("#post_comment").click(function(){
          $(".show_back").html("发送中..");
          $.post("<?php echo U('home','comment_handle','','?display=json'); ?>",
            { uname:$("#uname").val(),
              email:$("#email").val(),
              website:$("#website").val(),
              comment:$("#comment").val(),
              aid:$("#aid").val(),
              uid:$("#uid").val(),
              fid:$("#fid").val(),
              hash_comment_post:$("#hash_comment_post").val()
            },
            function(result){
 
              var dataObj = JSON.parse(result);
              var data_post = dataObj.post;

              if(dataObj.state == 'false'){
                //$(".show_back").html("评论失败|"+result);
                if(dataObj.reason == 'post_is_empty'){
                  $(".show_back").html("没有提交信息");
                }
                if(dataObj.reason == 'hash_is_wrong'){
                  $(".show_back").html("hash错误");
                }
                if(dataObj.reason == 'time_is_short'){
                  $(".show_back").html("时间间隔太短");
                }
                if(dataObj.reason == 'no_name'){
                  $(".show_back").html("没有昵称");
                }
                if(dataObj.reason == 'email_is_wrong'){
                  $(".show_back").html("Email格式不对");
                }
                if(dataObj.reason == 'user_is_none'){
                  $(".show_back").html("没有该用户");
                }
                if(dataObj.reason == 'comment_is_none'){
                  $(".show_back").html("没有评论内容");
                }
                if(dataObj.reason == 'aid_is_none'){
                  $(".show_back").html("缺少日志ID");
                }
                if(dataObj.reason == 'comment_is_false'){
                  $(".show_back").html("评论未成功");
                }
                if(dataObj.reason == 'comment_is_spam'){
                  $(".show_back").html("该评论需要审核");
                }
                $(".show_back").fadeToggle(3000);
              }

              if(dataObj.state == 'success'){
                $("#comment").val("");
                $(".show_back").html("发表成功");
                location = location;
              }
 
            });
          });
      });
    </script>
    <?php Plug::go('before_body'); ?>
  </head>
  <body>
    
    <div class="wrap">
      <?php GetTemp('header');?>
      <div class="main_mid">
   
                 <!--日志信息-->
                  <div class="main_blog">
                    <div class="mid_common mid_title"><?php GetBlog('title');?></div>
                    <div class="mid_common mid_info">由 <a href="#"><?php GetBlog('uname');?></a> 发表在 <span><?php GetBlog('cate_name');?></span></div>
                    <hr>
                    <div class="mid_common mid_data"><i class="icon-calendar-empty"></i> <?php GetBlog('time_add','FriendTime');?>    <i class="icon-eye"></i> <?php GetBlog('point_page');?> 浏览   <i class="icon-comment-empty"></i> <?php GetBlog('point_comment');?> 评论</div>
                    <div class="body"><?php GetBlog('body');?></div>
                    <div class="clear"></div>
                  </div>
 
                 <!--标签列表-->
                  <div class="show_tag">
                    <div class="meta">标签</div>
                    <?php GetBlog('tag_list');?>
                    <div class="clear"></div>
                  </div>


                <!--评论列表-->
                <hr id="comment_list">
                <?php global $comment_index; if (!empty($comment_index)): ?>
                <div class="meta comment_meta"><?php echo count($comment_index); ?>条评论</div>
                <?php foreach ($comment_index as $comment): ?>
                  <div class="comment_item" id="comment_<?php echo $comment['id']; ?>">
                    <div class="comment_img"><img src="<?php echo $comment['head']; ?>"></div>
                    <div class="comment_info">
                      <div class="comment_user"><?php echo $comment['uname']; ?></div>
                      <div class="comment_time"><?php echo FriendTime($comment['time_add']); ?></div>
                      <div class="comment_body"><?php echo $comment['comment']; ?></div>
                      <a href="#comment_post" comment_id="<?php echo $comment['id']; ?>" comment_user="<?php echo $comment['uname']; ?>" class="reply_user">回复</a>
                    </div>
                    <div class="clear"></div>
                    <hr>
                  </div>
                <?php endforeach; ?>
                <?php endif; ?>
 
                  <!--发表评论form-->
                  <div class="meta comment_meta" id="comment_post">发表评论</div>
                  <form class="form-horizontal" action="<?php echo U('home','comment_handle');?>" method="post">
                  <?php global $this_user; if (!empty($this_user)): ?>
                    <div class="comment_item">
                      <div class="comment_img"><img src="<?php echo $this_user['head']; ?>" alt="<?php echo $this_user['uname']; ?>"></div>
                      <div class="comment_info">
                        <div class="comment_user" style="margin-bottom:10px;"><?php echo $this_user['uname']; ?></div>
                        <a href="<?php echo U('home','login_out');?>">退出</a>
                      </div>
                      <div class="clear"></div>
                    </div>
                  <?php else: ?>
                    <label>昵称(*)</label>
                    <input tpye="text" name="uname" id="uname">
                    <label>邮箱(*)</label>
                    <input tpye="text" name="email" id="email">
                    <label>网址</label>
                    <input tpye="text" name="website" id="website">
                  <?php endif; ?>
                    <label>内容(*)</label>
                    <textarea tpye="text"   name="comment" id="comment"></textarea>
                    <input    type="hidden" name="aid"     id="aid" value="<?php GetBlog('id'); ?>" >
                    <input    type="hidden" name="fid"     id="fid" value="0">
                    <button   type="button" id="post_comment">发表评论</button>
                    <div class="show_back"></div>
                  </form>
      <div class="clear"></div>
      </div>
      <?php GetTemp('sider');?>
      <div class="clear"></div>
    </div>
    <?php GetTemp('footer');?>
    <?php Plug::go('after_body'); ?>
  </body>
</html>