<?php
/*
 * MCMS Copyright (c) 2012-2013 ZhangYiYeTai Inc.
 *
 *  http://www.mcms.cc
 *
 * The program developed by loyjers core architecture, individual all rights reserved,
 * if you have any questions please contact loyjers@126.com
 */

require_once(dirname(__FILE__) . "/../../init.php"); //公用引导启动文件
check_login();
check_level('C07',AJAX);
$time_start = H :: getmicrotime(); //开始时间

// 动作处理
call_mfunc();

// 模板处理
$tpl=isset($_GET['tpl'])?$_GET['tpl']:'';

if($tpl=='recover'){
    require_once(assign_tpl('data.backup.recover.php', 'admin'));
}else{
    require_once(assign_tpl(basename(__FILE__), 'admin'));
}

// ******************************************************* 函数方法 *******************************************************
function m__list() {
	global $dbm,$result,$result2;
	$rs = $dbm->query('show tables');
	$result = array();
	$tb_pre = strlen(TB_PRE);
	foreach($rs['list'] as $v) {
		$tab_name = '';
		foreach($v as $v2) { $tab_name = $v2; }
		if(substr($tab_name,0,$tb_pre) !== TB_PRE) continue;
		//表数据条数
		$count = $dbm->query("select count(1) as t from ".$tab_name);
		$count = $count['list'][0]['t'];
		//表占用磁盘大小
		$dbm->select_db('information_schema');
		$size = $dbm->query("select data_length,index_length from tables where table_schema='".DB_DBNAME."' and table_name='".$tab_name."'");
		$size = $size['list'][0];
		$create_time = $dbm->query("select create_time from tables where table_name='".$tab_name."'");
		$create_time = $create_time['list'][0]['create_time'];
		$dbm->select_db(DB_DBNAME);
		$tmp = array('tab_name'=>$tab_name,'count'=>$count,'create_time'=>$create_time,'size'=>$size);
		$result[] = $tmp;
	}

	$backup_path = ROOT_PATH.'/config/cache/backup/';
	$result2 = array();
	if(is_dir($backup_path)) {
		$backup_list = H::get_dirs($backup_path);
		foreach($backup_list as $v) {
			$tmp = array('backup_time'=>'','backup_size'=>'','is_all'=>0);
			$tmp['backup_time'] = substr($v,0,19);
			$tmp['backup_size'] = H::num_bitunit(H::dirsize($backup_path.$v));
			$a = H::get_dirs($backup_path.$v);
			if(count($a) == count($result)) $tmp['is_all'] = 1;
			$result2[] = $tmp;
		}
	}
	//print_r($result2);
	//print_r($result);
	//exit;
}

//还原文件的列表
function m__recover() {
	global $dbm,$result;
	$_GET=H::sqlxss($_GET);
	$_GET['file'] = isset($_GET['file']) ? trim($_GET['file']) : '';
	if(strlen($_GET['file']) != 19) H::error_show('{"code":"1","msg":"备份文件有误"}');
	$backup_path = ROOT_PATH.'/config/cache/backup/';
	if(!is_dir($backup_path)) H::error_show('{"code":"1","msg":"备份文件有误"}');
	$backup_list = H::get_dirs($backup_path);
	$file_name = '';
	foreach($backup_list as $v) {
		if(strpos($v,$_GET['file']) !== false) $file_name = $v;
	}
	if($file_name == '') H::error_show('{"code":"1","msg":"备份文件有误"}');
	$result = H::get_dirs($backup_path.$file_name);
	//print_r($result);
}

//删除备份文件
function m__del() {
	global $dbm;
	$_GET=H::sqlxss($_GET);
	$_POST=H::sqlxss($_POST);
	$_POST['file'] = isset($_POST['file']) ? trim($_POST['file']) : '';
	if($_POST['file'] == '')  die('{"code":"1","msg":"需要删除的备份的名称有误"}');
	$backup_path = ROOT_PATH.'/config/cache/backup/';
	if(!is_dir($backup_path)) H::error_show('{"code":"1","msg":"备份文件有误"}');
	$backup_list = H::get_dirs($backup_path);
	$file_name = '';
	foreach($backup_list as $v) {
		if(strpos($v,$_POST['file']) !== false) $file_name = $v;
	}
	if($file_name == '') die('{"code":"1","msg":"需要删除的备份的名称有误"}');
	logs('删除备份 '.substr($file_name,0,19),8);
	if(H::del_dir($backup_path.$file_name)) die('{"code":"0","msg":"操作成功","id":"'.$_POST['file'].'"}');
	die('{"code":"1","msg":"操作失败，没有删除权限"}');
}

//准备 还原时的数组
function m__ready_recover() {
	$_GET=H::sqlxss($_GET);
	$_POST=H::sqlxss($_POST);
	if(count($_POST) < 2) die('{"code":"1","msg":"没有选中项，无法操作"}');

	$backup_path = ROOT_PATH.'/config/cache/backup/';
	if(!is_dir($backup_path)) H::error_show('{"code":"1","msg":"备份文件有误"}');
	$backup_list = H::get_dirs($backup_path);
	$file_name = '';
	foreach($backup_list as $v) {
		if(strpos($v,$_POST['file']) !== false) $file_name = $v;
	}
	if($file_name == '') die('{"code":"1","msg":"备份文件有误"}');

	$file_list = H::get_dirs($backup_path.$file_name);
	$arr = array();
	$_SESSION['progress_bar_new'] = 0;
	$_SESSION['progress_bar'] = 1;
	foreach($file_list as $k=>$v) {
		if(!in_array($v,$_POST)) continue;
		$tmp = array('tab_name'=>$v,'insert_file'=>'');
		$tmp['insert_file'] = get_files($backup_path.$file_name.'/'.$v,1);
		$tmp['insert_file'] = H::array_sort($tmp['insert_file'],'paixu');
		$tmp2 = array();
		foreach($tmp['insert_file'] as $k2=>$v2) {
			$tmp2[] = $v2;
		}
		$insert_count = count($tmp2);
		$insert_count = $insert_count == 0 ? 1 : $insert_count;
		$_SESSION['progress_bar'] += $insert_count;
		$tmp['insert_file'] = $tmp2;
		$arr[] = $tmp;
	}
	$_SESSION['progress_bar'] = 100/$_SESSION['progress_bar']; //还原进度条
	H::cache(array('time'=>3600*24,'key'=>'recover_data','val'=>array('dir'=>$backup_path.$file_name.'/','data'=>$arr,'cache_type'=>'file_cache')));
	unset($arr);
	unset($file_list);
	unset($tmp);
	logs('还原数据 '.substr($file_name,0,19),8);
	die('{"code":"0","msg":"开始还原数据，请勿进行其它操作!"}');
}

//开始还原跳转
function m__recover_ing() {
	global $dbm;
	$_GET=H::sqlxss($_GET);
	if(!isset($_GET['tab_id']) || !isset($_GET['insert_id'])) {
		$selfurl = 'data.backup.php?m=recover_ing&struct=1&tab_id=0&insert_id=0';
		$content = '<span style=\"color:#F31933;\">开始还原数据，请勿进行其它操作!</span>';

		$fun = 'parent.show_status("还原数据",\''.$content.progress_bar(0).'\');';

		$str = '<script type="text/javascript">setTimeout(function(){window.location.href="' . $selfurl . '";},2000);'.$fun.'</script>';

		die($str);
	}
	$recover_data = H::cache(array('key'=>'recover_data','cache_type'=>'file_cache'));
	//还原表结构
	if(!file_exists($recover_data['dir'].DB_DBNAME.'.sql')) {
		die('<span style="color:#F31933;">表结构不存在!</span>');
	}
	if(isset($_GET['struct'])) {
		$tab_struct = file_get_contents($recover_data['dir'].DB_DBNAME.'.sql');
		$tab_struct = explode(";\n",$tab_struct);
		$tab_struct = array_chunk($tab_struct,2);
		$tmp = array();
		foreach($recover_data['data'] as $v) {$tmp[] = $v['tab_name'];}

		foreach($tab_struct as $k=>$v) {
			$tab_name_tmp = str_replace('DROP TABLE IF EXISTS','',$v[0]);
			$tab_name_tmp = trim($tab_name_tmp);
			if(!in_array($tab_name_tmp,$tmp)) unset($tab_struct[$k]);
		}
		foreach($tab_struct as $v) {
			$dbm->query_update($v[0]); //执行删除表结构语句
			$dbm->query_update($v[1]); //执行创建表结构语句
		}
		$selfurl = 'data.backup.php?m=recover_ing&tab_id=0&insert_id=0';
		$content = '<span style=\"color:#139441;\">表结构已还原，开始还原表数据!</span>';
		$_SESSION['progress_bar_new'] = $_SESSION['progress_bar'];
		$fun = 'parent.show_status("还原数据",\''.$content.progress_bar($_SESSION['progress_bar_new']).'\');';

		$str = '<script type="text/javascript">setTimeout(function(){window.location.href="' . $selfurl . '";},500);'.$fun.'</script>';

		die($str);
	}
	//还原数据
	$_GET['tab_id'] = intval($_GET['tab_id']);
	$_GET['insert_id'] = intval($_GET['insert_id']);
	//还原时读取的具体文件
	$file_data = isset($recover_data['data'][$_GET['tab_id']]['insert_file'][$_GET['insert_id']]['name'])?$recover_data['data'][$_GET['tab_id']]['insert_file'][$_GET['insert_id']]['name']:'';
	//还原时跳转的次数
	$count = isset($recover_data['data'][$_GET['tab_id']]['insert_file'])?count($recover_data['data'][$_GET['tab_id']]['insert_file']):0;
	//表名
	$tab_name = isset($recover_data['data'][$_GET['tab_id']]['tab_name'])?$recover_data['data'][$_GET['tab_id']]['tab_name']:'';
	//文件地址
	$file_dir = $recover_data['dir'].$tab_name.'/'.$file_data;
	//开始还原动作
	recover_action($file_dir);

	//判断下一次还原
	$_GET['insert_id'] = $_GET['insert_id'] + 1; //还原下一卷数据
	if($count == 0 || $count == $_GET['insert_id']) { //没有需要还原的数据 或 所有数据都已经还原完成 则跳入下一张表
		$_GET['insert_id'] = 0;
		$_GET['tab_id'] = $_GET['tab_id'] + 1;
	}

	if($tab_name == '') {
		//数据还原完成
		unset($recover_data,$_SESSION['progress_bar'],$_SESSION['progress_bar_new']);
		@unlink(ROOT_PATH.'/config/cache/recover_data.php');
		$selfurl = 'parent.window.location.href=\'data.backup.php\';';
		$content = '<span style=\"color:#139441;\">数据还原完成!</span>';

		$fun = 'parent.show_status("还原数据",\''.$content.progress_bar(100).'\');';

		$str = '<script type="text/javascript">setTimeout(function(){' . $selfurl . '},500);'.$fun.'</script>';

		die($str);

	}else{
		$juan = $file_data == '' ? array('') : get_juan($file_data);
		$selfurl = 'data.backup.php?m=recover_ing&tab_id='.$_GET['tab_id'].'&insert_id='.$_GET['insert_id'];
		$content = $file_data == ''? $tab_name.' 表已还原完成，将开始还原下一张表。' : '正在还原 '.$tab_name.' 表的第 <b>'.$juan[0].'</b> 卷的第 <b>'.$juan[1].'</b> 个文件。';

		$_SESSION['progress_bar_new'] += $_SESSION['progress_bar'];

		$fun = 'parent.show_status("还原数据",\''.$content.progress_bar($_SESSION['progress_bar_new']).'\');';

		$str = '<script type="text/javascript">setTimeout(function(){window.location.href=\'' . $selfurl . '\';},500);'.$fun.'</script>';

		die($str);
	}
	die();
}

//还原动作
function recover_action($file_dir) {
	global $dbm;
	if(!is_file($file_dir)) return;
	$data = file_get_contents($file_dir);
	$rs = $dbm->query_update($data); //执行插入语句
}

//准备 备份时的数组
function m__ready_backup() {
	global $dbm;
	$_GET=H::sqlxss($_GET);
	$_POST=H::sqlxss($_POST);

	if(count($_POST) == 0) die('{"code":"1","msg":"没有选中项，无法操作"}');

	//检查备份目录是否有可写的权限
	$backup_path = ROOT_PATH.'/config/cache/';
	$is_write = 0;
	if (is_dir($backup_path)) {
		$hd = @fopen($backup_path . 'helloword.txt', 'w+');
		if($hd) {
			$is_write = 1;
			fclose($hd);
			@unlink($backup_path . 'helloword.txt');
		}
	}
	if(!$is_write) die('{"code":"1","msg":"目录没有写的权限"}');

	$tmp = array();
	$tb_pre = strlen(TB_PRE);
	$_SESSION['progress_bar'] = 0; //备份进度条
	foreach($_POST as $v) {
		if(substr($v,0,$tb_pre) !== TB_PRE) die('{"code":"1","msg":"表&nbsp;<span style=\"color:red;\">'.$v.'</span>&nbsp;不正确!"}');
		$count = $dbm->query("select count(1) as t from ".$v);
		if($count['error'] != '') die('{"code":"1","msg":"表&nbsp;<span style=\"color:red;\">'.$v.'</span>&nbsp;不正确!"}');
		$count = $count['list'][0]['t'];
		$limit = get_limit_str($count,2000); //每次读取数据的条数
		$count_limit = count($limit);
		$_SESSION['progress_bar'] += $count_limit == 0 ? 1 : $count_limit;
		$tmp[] = array('tab_name'=>$v,'count'=>$count,'limit'=>$limit);
	}

	if(count($tmp) == 0) die('{"code":"1","msg":"没有选中项，无法操作"}');

	//备份进度条
	$_SESSION['progress_bar'] = 100/$_SESSION['progress_bar'];
	$_SESSION['progress_bar_new'] = 0;
    //print_r($tmp);
	//备份时用到的数组
	H::cache(array('time'=>3600*36,'key'=>'backup_data','val'=>$tmp,'cache_type'=>'file_cache'));

	//备份时间
	$_SESSION['backup_time'] = date('Y-m-d-h-i-s',time()).'-'.uniqid();

	//备份时写文件的大小
	$rs = $dbm->query("show global variables like 'max_allowed_packet'");
	$_SESSION['max_allowed_packet'] = isset($rs['list'][0]['Value']) ? ($rs['list'][0]['Value'] - 20*1024) : 1024*1000;

	logs('备份数据 '.substr($_SESSION['backup_time'],0,19),8);
	die('{"code":"0","msg":"开始备份，请勿进行其它操作!"}');
}

//开始备份跳转
function m__backup_ing() {
	global $dbm;
	$_GET=H::sqlxss($_GET);

	if(!isset($_GET['tab_id']) || !isset($_GET['limit_id'])) {
		$selfurl = 'data.backup.php?m=backup_ing&tab_id=0&limit_id=0';

		$content = '<span style=\"color:#F31933;\">开始备份，请勿进行其它操作!</span>';

		$fun = 'parent.show_status("备份数据",\''.$content.progress_bar(0).'\');';

		$str = '<script type="text/javascript">setTimeout(function(){window.location.href="' . $selfurl . '";},2000);'.$fun.'</script>';
		die($str);
	}

	$backup_data = H::cache(array('key'=>'backup_data','cache_type'=>'file_cache'));
	$_GET['tab_id'] = intval($_GET['tab_id']);
	$_GET['limit_id'] = intval($_GET['limit_id']);

	$tab_name = isset($backup_data[$_GET['tab_id']]['tab_name']) ? $backup_data[$_GET['tab_id']]['tab_name'] : ''; //表名
	$count = isset($backup_data[$_GET['tab_id']]['count'])?$backup_data[$_GET['tab_id']]['count']:0; //当前表中的数据条数
	$limit = isset($backup_data[$_GET['tab_id']]['limit'])?$backup_data[$_GET['tab_id']]['limit']:array();
	$limit_count = count($limit); //备份当前表时数据limit次数
	$limit = isset($limit[$_GET['limit_id']]) ? ' limit '.$limit[$_GET['limit_id']] : ''; //limit语句
	$juan = $_GET['limit_id'] + 1; //备份卷数
	//执行备份动作
	backup_action($tab_name,$limit,$juan);
	//判断下一次备份
	$_GET['limit_id'] = $_GET['limit_id'] + 1;
	if($count == 0 || $limit_count == $_GET['limit_id']) {
		$_GET['limit_id'] = 0;
		$_GET['tab_id'] = $_GET['tab_id'] + 1;
	}
    echo('<script>top.show_staus(title,content);</script>');
	if($tab_name == '') {
		//数据备份完成
		unset($backup_data,$_SESSION['backup_time'],$_SESSION['max_allowed_packet'],$_SESSION['progress_bar_new'],$_SESSION['progress_bar']);
		@unlink(ROOT_PATH.'/config/cache/backup_data.php');
		$selfurl = 'parent.window.location.href="data.backup.php";';
		$content = '<span style=\"color:#139441;\">数据备份完成!</span>';

		$fun = 'parent.show_status("备份数据",\''.$content.progress_bar(100).'\');';

		$str = '<script type="text/javascript">setTimeout(function(){' . $selfurl . '},2000);'.$fun.'</script>';
		die($str);
	}else{

		$selfurl = 'data.backup.php?m=backup_ing&tab_id='.$_GET['tab_id'].'&limit_id='.$_GET['limit_id'];

		$content = ($limit == '' ||  $limit_count == $juan) ? $tab_name.' 表已备份完成，将开始备份下一张表。' : '正在备份 '.$tab_name.' 表的第 <b>'.$juan.'</b> 卷。';

		$_SESSION['progress_bar_new'] += $_SESSION['progress_bar'];

		$fun = 'parent.show_status("备份数据",\''.$content.progress_bar($_SESSION['progress_bar_new']).'\');';
		$str = '<script type="text/javascript">setTimeout(function(){window.location.href="' . $selfurl . '";},500);'.$fun.'</script>';
		die($str);
	}
	die();
}
//备份动作
function backup_action($tab_name,$limit,$juan) {
	global $dbm;
	if($tab_name == '') return;
	$backup_name = $tab_name.'_'.$juan;
	$backup_path = ROOT_PATH.'/config/cache/backup/'.$_SESSION['backup_time'].'/';
	$single_tab_dir = $backup_path.$tab_name.'/';
	H::mkdirs($backup_path);

	//备份表结构
	$tab_struct = $backup_path.DB_DBNAME.'.sql';
	if(!is_dir($single_tab_dir)) {
		$creattable = "DROP TABLE IF EXISTS $tab_name;\n";
		$rs = $dbm->query("SHOW CREATE TABLE $tab_name");
		$creattable .= $rs['list'][0]['Create Table'].";\n\n";
		file_put_contents($tab_struct,$creattable,FILE_APPEND);
		H::mkdirs($single_tab_dir);
	}

	//备份数据
	if($limit=='') return;
	$rs = $dbm->query("select * from ".$tab_name." ".$limit);
	//print_r(count($rs['list']).$rs['sql']);
	//print_r(H::num_bitunit(memory_get_usage()));
	$bakupdata = '';
	$i = 0;
	foreach($rs['list'] as $k=>$v) {
		if($k==0) {
			$tablefields = implode("`,`", array_keys($v));
			$bakupdata = "INSERT INTO $tab_name (`" . $tablefields . "`) VALUES \n";
		}
		$tablevalues = preg_replace('~(\n)|(\r)~', '',implode("','", array_values($v)));
		$bakupdata .= "('" . $tablevalues . "'),\n";
		if(strlen($bakupdata) > $_SESSION['max_allowed_packet']) {
			$bakupdata = substr($bakupdata,0,-2);
			$handle = fopen($single_tab_dir.$backup_name.'_'.$i.'.sql',"wb");
			fputs($handle, $bakupdata);
			fclose($handle);
			$i++;
			$tablefields = implode("`,`", array_keys($v));
			$bakupdata = "INSERT INTO $tab_name (`" . $tablefields . "`) VALUES \n";
		}
	}
	$bakupdata = substr($bakupdata,0,-2);
	$handle = fopen($single_tab_dir.$backup_name.'_'.$i.'.sql',"wb");
	fputs($handle, $bakupdata);
	fclose($handle);
	unset($handle);
	unset($rs);
	unset($bakupdata);
}
//获取limit大小
function get_limit_str($count,$limit_size) {
	$tmp = array();
	$num = floor($count/$limit_size);
	for($i=0;$i<=$num;$i++) {
		if($i == $num) {
			if($i*$limit_size != $count) $tmp[] = ($i*$limit_size).','.$limit_size;
		}else{
			$tmp[] = ($i*$limit_size).','.$limit_size;
		}
	}
	return $tmp;
}

//转换时间样式
function convert_time($a) {
	$a = explode('-',$a);
	$b = '';
	foreach($a as $k=>$v) {
		if($k == 0) $s='年';
		if($k == 1) $s='月';
		if($k == 2) $s='日';
		if($k == 3) $s='时';
		if($k == 4) $s='分';
		if($k == 5) $s='秒';
		$b .= $v.$s;
	}
	return $b;
}
//获取备份的卷数
function get_juan($a) {
	$a = substr($a,0,-4);
	$a = explode('_',$a);
	return array($a[count($a)-2],($a[count($a)-1]+1));
}
//获取文件夹下的所有文件 与H类中的不同 请勿删除
function get_files($dir,$is_paixu=0) {
	$key = 0;
	$files = array();
	if ($handle = opendir($dir)) {
        while (($file = readdir($handle)) !== false) {
            if ($file != ".." && $file != ".") {
                if (!is_dir($dir . "/" . $file)) {
                    $files[$key]['name'] = $file;
					if($is_paixu) {
						$a = get_juan($file);
						$a[1] = $a[1]/1000;
						$files[$key]['paixu'] = ($a[0]+$a[1]);
					}
					$key++;
                }
            }
        }
        closedir($handle);
        return $files;
    }
}
//返回进度条
function progress_bar($a) {
	return '<br/><div style="margin: 5px 0 5px 0;width:100%;height:7px;border:1px solid #19a97b"><div style="background-color: #19a97b;width:'.$a.'%;height:7px;">&nbsp;</div></div>';
}
?>