<?php
/*
 * MCMS Copyright (c) 2012-2013 ZhangYiYeTai Inc.
 *
 *  http://www.mcms.cc
 *
 * The program developed by loyjers core architecture, individual all rights reserved,
 * if you have any questions please contact loyjers@126.com
 */

require_once(dirname(__FILE__) . "/../../init.php"); //公用引导启动文件
check_login();
check_level('GA01',AJAX);
$time_start = H :: getmicrotime(); //开始时间

// 动作处理
call_mfunc();
// 模板处理
$tpl=isset($_GET['tpl'])?$_GET['tpl']:'';

if($tpl=='view'){
    require_once(assign_tpl('gov.shop.order.view.php', 'admin'));
}else if($tpl=='print') {
    require_once(assign_tpl('gov.shop.order.print.php', 'admin'));
}else if($tpl=='map'){
    require_once(assign_tpl('gov.shop.order.map.php', 'admin'));
}else{
    require_once(assign_tpl(basename(__FILE__), 'admin'));
}


// ******************************************************* 函数方法 *******************************************************
/*
 *后台订单列表
 */
function m__list(){
    global $dbm,$result,$V,$p,$tpl;
    $_GET = H::sqlxss($_GET);
    $params = array();
    $order_num = isset($_GET['order_num']) ? $_GET['order_num'] : '';
	$uname = isset($_GET['uname']) ? $_GET['uname'] : '';
    $start_time = isset($_GET['start_time']) ? $_GET['start_time'] : '';
    $end_time = isset($_GET['end_time']) ? $_GET['end_time'] : '';
    $send_status = isset($_GET['send_status']) ? $_GET['send_status'] : -1;
    $order_status = isset($_GET['order_status']) ? $_GET['order_status'] : -1;
    $pay_status = isset($_GET['pay_status']) ? $_GET['pay_status'] : -1;
    $pay_type = isset($_GET['pay_type']) ? $_GET['pay_type'] : '';

	$params['where'] = " 1=1";
	if ($order_num!='') $params['where'].= " and order_num_local='$order_num' or order_num_remote='$order_num'";
    if($uname!='') $params['where'] .= " and uname='$uname'";
    if($start_time!='' && $end_time!='') {
        $params['where'].=" and create_time>=".strtotime($start_time)." and create_time<=".strtotime($end_time);
    }
    if($start_time!='' && $end_time=='') {
        $params['where'].=" and create_time>=".strtotime($start_time);
    }
    if($start_time=='' && $end_time!='') {
        $params['where'].=" and create_time<=".strtotime($end_time);
    }
    if($send_status >=0) $params['where'] .= " and send_status='$send_status'";
    if($order_status >=0) $params['where'] .= " and order_status='$order_status'";
    if($pay_status >=0) $params['where'] .= " and pay_status='$pay_status'";
    if($pay_type !='') $params['where'] .= " and pay_type='$pay_type'";
    $params['table_name'] = TB_PRE . "order";
    $params['suffix'] = " order by order_id desc ";
    $params['count'] = 1 ;
    if($tpl=='map') {
        $params['count'] = 0 ;
    } else {
        $params['pagesize'] = get_pagesize(PAGESIZE_ADMIN);
        $params['suffix'] .= $dbm -> get_limit_sql($params['pagesize'], $p);
    }
    $result = $dbm -> single_query($params);
    
    foreach($result['list'] as $k=>$v) {
        $result['list'][$k]['address'] = json_decode($v['order_address'],true);
    }
    
    $result['order_status'] = htmlspecialchars($V->input_str(array('node'=>'order_status','type'=>'select_single','default'=>'-1')));
    $result['pay_status'] = htmlspecialchars($V->input_str(array('node'=>'pay_status','type'=>'select_single','default'=>'-1')));
    $result['send_status'] = htmlspecialchars($V->input_str(array('node'=>'send_status','type'=>'select_single','default'=>'-1')));

}

/*
 *查看订单
 */
function m__view(){
    global $dbm,$result,$V,$C,$order_id;
    check_level('GA0101',AJAX);
    $_GET['order_id'] = isset($_GET['order_id']) ? trim($_GET['order_id']) : '';
    $sql="select * from ".TB_PRE."order_comment where order_id=".$_GET['order_id'];
    $rs = $dbm->query($sql);
    $result = get_order_info($_GET['order_id']);
    $result['order_comment'] = $rs['list'];
    $order_id = explode(',',$_GET['order_id']);
    //print_r($order_id);
}


//批量移除订单
function m__del(){
    global $dbm,$C;
    check_level('GA0106',AJAX);
    $_POST=H::sqlxss($_POST);
    $_POST['params']=isset($_POST['params'])?trim($_POST['params']):'';
    $_POST['params']=explode(',',$_POST['params']);
    foreach($_POST['params'] as $v){
        $order_id=intval($v);
        if($order_id <=0) continue;
            $sql="delete from ".TB_PRE."order where order_id='$order_id'";
            $rs=$dbm->query_update($sql);
    }
    die('{"code":"0","msg":"操作成功"}');
}


/*
 *确认订单状态
 */
function m__order(){
    global $dbm;
    check_level('GA0105',AJAX);
    $_POST=H::sqlxss($_POST);
    $_POST['params']=isset($_POST['params'])?trim($_POST['params']):'';
    $_POST['params']=explode(',',$_POST['params']);
    $_GET['order_status'] = isset($_GET['order_status']) ? intval($_GET['order_status']) : 1;
    if($_GET['order_status']<0) die('{"code":"1","msg":"请选订单状态"}');
    foreach($_POST['params'] as $v){
        $order_id=intval($v);
        if($order_id <=0) continue;
        $sql = "update ".TB_PRE."order set order_status='{$_GET['order_status']}' where order_id='$order_id'";
        $rs=$dbm->query_update($sql);
    }
    die('{"code":"0","msg":"操作成功"}');
}

/*
 *确认付款状态
 */
function m__pay(){
    global $dbm;
    check_level('GA0103',AJAX);
    $_POST=H::sqlxss($_POST);
    $_POST['params']=isset($_POST['params'])?trim($_POST['params']):'';
    $_POST['params']=explode(',',$_POST['params']);
    $_GET['pay_status'] = isset($_GET['pay_status']) ? intval($_GET['pay_status']) : 1;
    if($_GET['pay_status']<0) die('{"code":"1","msg":"请选付款状态"}');
    foreach($_POST['params'] as $v){
        $order_id=intval($v);
        if($order_id <=0) continue;
        $sql = "update ".TB_PRE."order set pay_status='{$_GET['pay_status']}' where order_id='$order_id'";
        $rs=$dbm->query_update($sql);
    }
    die('{"code":"0","msg":"操作成功"}');
}

/*
 *确认发货状态
 */
function m__send(){
    global $dbm;
    check_level('GA0104',AJAX);
    $_POST=H::sqlxss($_POST);
    $_POST['params']=isset($_POST['params'])?trim($_POST['params']):'';
    $_POST['params']=explode(',',$_POST['params']);
    $_GET['send_status'] = isset($_GET['send_status']) ? intval($_GET['send_status']) : 2;
    if($_GET['send_status']<0) die('{"code":"1","msg":"请选发货状态"}');
    foreach($_POST['params'] as $v){
        $order_id=intval($v);
        if($order_id <=0) continue;
        $sql = "update ".TB_PRE."order set send_status='{$_GET['send_status']}' where order_id='$order_id'";
        $rs=$dbm->query_update($sql);
    }
    die('{"code":"0","msg":"操作成功"}');
}

/* 获取订单信息*/
function get_order_info($order_id) {
    global $dbm, $C;
    $result = array();
    $order_id = intval($order_id);
    if($order_id <1) return $result;
    $sql="select * from " . TB_PRE . "order where order_id='$order_id' limit 1";
    $res = $dbm->query($sql);
    if(count($res['list'])==1) {
        $result = $res['list'][0];
        if($result['order_address']!='') {
            $result['order_address'] = json_decode($result['order_address'],true);
        }
        if($result['order_desc']!='') {
            $result['order_desc'] = json_decode($result['order_desc'],true);
            foreach($result['order_desc'] as $k=>$v) {
                if(isset($v['goods'])){
                    $result['order_desc'][$k]['price'] = 0;
                    $result['order_desc'][$k]['goods_name'] = array();
                    foreach($v['goods'] as $k1=>$v1) {
                        $con = $C->get_content($v1['info_id']);
                        $result['order_desc'][$k]['goods_name'][] = $con['info_title'];
                        if(strpos($v['name'],'篮子')===false) {
                            $result['order_desc'][$k]['num'] = $v1['num'];
                            $result['order_desc'][$k]['price']= $con['model_fields']['price'];
                            $result['order_desc'][$k]['weight']= $con['model_fields']['weight'];
                        }  else {
                            $result['order_desc'][$k]['num'] = 1;
                            $result['order_desc'][$k]['price'] += $con['model_fields']['price']*$v1['num'];
                            $result['order_desc'][$k]['weight']= '';
                        }
                    }
                }
                
            }
            
        }
        $order_month = $dbm->query("select * from ".TB_PRE."order_month where order_id='$order_id'");
        $result['order_month'] = array();
        if(count($order_month['list'])>0) {
            foreach ($order_month['list'] as $a=>$b ) {
               $b['month_date'] = date('Y年n月j日', $b['month_date']);
                array_push($result['order_month'], $b['month_date']);
            }
        }
    }
    return $result;
}
/*
 *检查新订单并且语音提醒
 *
 */
function m__check_order() {
    global $dbm;
    if(!isset($_SESSION['last_check']) || $_SESSION['last_check']=='') {

        $_SESSION['last_check'] = time();

        die('{"code":1,"msg":"","order_id":""}');
    }

    $sql = "select order_id from ".TB_PRE."order where create_time >=".$_SESSION['last_check'];

    $_SESSION['last_check'] = time();

    $new_order = $dbm -> scalar($sql);

    if(!empty($new_order)) die('{"code":0,"msg":"您有个新订单","order_id":"'.$new_order['order_id'].'"}');
    
    die('{"code":1,"msg":"没找到新订单","order_id":""}');
}

function m__save_reply() {
    global $dbm;
    $order_comment_id = isset($_POST['order_comment_id']) ? intval($_POST['order_comment_id']) : 0;
    $reply = isset($_POST['reply']) ? trim($_POST['reply']) : '';
    if ($order_comment_id > 0) {
        if(strlen($reply)<1) die('{"code":1,"msg":"请输入回复内容"}');
        $dbm->single_update(TB_PRE."order_comment",array('reply'=>$reply),"order_comment_id=$order_comment_id");
        die('{"code":0,"msg":"您已成功回复对方"}');
    }
    die('{"code":1,"msg":"输入有错，请检查参数"}');
}

function get_reply($order_comment_id) {
    global $dbm;
    $sql = "select reply from ".TB_PRE."order_comment where order_comment_id='$order_comment_id'";
    $result = $dbm->query($sql);
    if(count($result['list'])==1) {
        $reply = $result['list'][0];
        return $reply['reply'];
    }
    return '';
}
?>