<?php
/*
 * MCMS Copyright (c) 2012-2013 ZhangYiYeTai Inc.
 *
 *  http://www.mcms.cc
 *
 * The program developed by loyjers core architecture, individual all rights reserved,
 * if you have any questions please contact loyjers@126.com
 */

require_once(dirname(__FILE__) . "/../../init.php"); //公用引导启动文件

$time_start = H :: getmicrotime(); //开始时间

// 动作处理
call_mfunc();

// 模板处理
require_once(assign_tpl(basename(__FILE__), 'admin'));

// ******************************************************* 函数方法 *******************************************************
function m__list(){

}
/**
 * 登录
 */
function m__login() {
    global $dbm,$U;
    $_COOKIE=H::sqlxss($_COOKIE);
    $uname = isset($_POST['uname']) ? H::sqlxss(trim($_POST['uname'])) : '';
    $upass = isset($_POST['upass']) ? trim($_POST['upass']) : '';
    if(strlen($uname)==0) die('{"code":1,"msg":"请输入账号"}');
    if(strlen($upass)==0) die('{"code":1,"msg":"请输入密码"}');


    //获取用户信息，比对账号密码
    $user = $U->get($uname);
    if(!$user) die('{"code":1,"msg":"账号不存在"}');

    $upass = H::password_encrypt_salt($upass, $user['login_salt']);
    if($upass != $user['login_pass']) die('{"code":1,"msg":"账号密码不匹配"}');

    if($user['login_status']!=0)  die('{"code":1,"msg":"该账号禁止登陆"}');

    //用户组和权限拼接
    $user['login_group'] = explode(',',$user['login_group']);
    $user['group']=array();
    foreach($user['login_group'] as $v) {
        $rs = $dbm->query("select group_level,group_name from ".TB_PRE."group where group_id =".$v." limit 2");
        if(count($rs['list'])==1) {
            array_push($user['group'],$rs['list'][0]);
        }
    }
    $group_level=array();
    $group_name=array();
    foreach($user['group'] as $v){
        array_push($group_level,$v['group_level']);
        array_push($group_name,$v['group_name']);
    }
    //记录SESSION
    $_SESSION['user']['uid']=$uid=$user['uid'];
    $_SESSION['user']['login_name']=$user['login_name'];
    $_SESSION['user']['group_name']=implode(',',$group_name);
    $_SESSION['user']['group_level']=implode(',',$group_level);//组权限
    $_SESSION['user']['login_level']=$user['login_level'];//附加权限
    $_SESSION['user']['login_no_level']=$user['login_no_level'];//禁止权限

    if($user['avatar']==''){
        $_SESSION['user']['avatar']=DOMAIN_CSS.'/sty_default/images/default_face.png';
    }else{
        $_SESSION['user']['avatar']=H::preview_url($user['avatar']);
    }
    //print_r($_SESSION);die();

    //记录登录信息
    $fields['login_ip']=H::getip();
    $fields['login_time']=time();
    $fields['login_num']=$user['login_num']+1;
    $dbm->single_update(TB_PRE."user",$fields,"uid='$uid'");

    logs('登录成功 '.$_SESSION['user']['login_name'],1);

    die('{"code":0,"msg":"登录成功"}');
}

// 退出登录
function m__logout() {
    session_destroy();
    header('Location: login.php');
    die();
}

/**
 *
 * 重启账号
 */
function m__restart() {
	global $dbm,$U;
	if(!isset($_SESSION['user']['uid'])) die('{"code":"1","msg":"请先登录"}');
	if($_SESSION['user']['group_level'] == 100) die('{"code":"0","msg":"重启成功"}');
	$user = $U->get($_SESSION['user']['uid']);
	//用户组和权限拼接
    $user['login_group'] = explode(',',$user['login_group']);
    $user['group']=array();
    foreach($user['login_group'] as $v) {
        $rs = $dbm->query("select group_level,group_name from ".TB_PRE."group where group_id =".$v." limit 2");
        if(count($rs['list'])==1) {
            array_push($user['group'],$rs['list'][0]);
        }
    }

    $group_level=array();
    $group_name=array();
    foreach($user['group'] as $v){
        array_push($group_level,$v['group_level']);
        array_push($group_name,$v['group_name']);
    }
    //记录SESSION
    $_SESSION['user']['uid']=$uid=$user['uid'];
    $_SESSION['user']['login_name']=$user['login_name'];
    $_SESSION['user']['group_name']=implode(',',$group_name);
    $_SESSION['user']['group_level']=implode(',',$group_level);//组权限
    $_SESSION['user']['login_level']=$user['login_level'];//附加权限
    $_SESSION['user']['login_no_level']=$user['login_no_level'];//禁止权限

    if($user['avatar']==''){
        $_SESSION['user']['avatar']=DOMAIN_CSS.'/sty_default/images/default_face.png';
    }else{
        $_SESSION['user']['avatar']=H::preview_url($user['avatar']);
    }

	die('{"code":"0","msg":"重启成功"}');
} // end func

?>