<?php
/*
 * MCMS Copyright (c) 2012-2013 ZhangYiYeTai Inc.
 *
 *  http://www.mcms.cc
 *
 * The program developed by loyjers core architecture, individual all rights reserved,
 * if you have any questions please contact loyjers@126.com
 */

require_once(dirname(__FILE__) . "/../../init.php"); //公用引导启动文件
check_login();
check_level('C08',AJAX);
$time_start = H :: getmicrotime(); //开始时间
change_replace_num('index.php?tpl=list_info&cid={cid}&p={p}');
// 动作处理
call_mfunc();

// 模板处理
require_once(assign_tpl(basename(__FILE__), 'admin'));

// ******************************************************* 函数方法 *******************************************************
function m__list(){
    global $dbm,$result;
    $sql="select * from ".TB_PRE."url_rewrite";
    $rs=$dbm->query($sql);
    $result['list']=$rs['list'];
}
//批量修改
function m__save_all(){
    global $dbm,$C;
    check_level('A0202',AJAX);
    $_POST=H::sqlxss($_POST);

    foreach($_POST['params'] as $v){
        $url_id=intval($v['id']);unset($v[0]);unset($v['id']);

        $dbm->single_update(TB_PRE."url_rewrite",$v,"url_id='$url_id'");
        logs('批量修改伪静态规则 '.H::sqlxss(H::json_encode_ch($v)));
    }
    $C->update_cache_rewrite();
    die('{"code":"0","msg":"操作成功"}');
}
//保存
function m__save(){
    global $dbm,$C,$V;

    $_POST=H::sqlxss($_POST);
    $fields['url_title']=isset($_POST['url_title'])?trim($_POST['url_title']):'';
    $fields['url_rule']=isset($_POST['url_rule'])?trim($_POST['url_rule']):'';
    $fields['url_true']=isset($_POST['url_true'])?trim($_POST['url_true']):'';
    //print_r($_POST);
	if($fields['url_title'] == '') die('{"code":"1","msg":"请填写规则节点名称"}');
	if($fields['url_rule'] == '') die('{"code":"1","msg":"请填写伪静态地址"}');
	if($fields['url_true'] == '') die('{"code":"1","msg":"请填写动态地址"}');
    $sql="select * from ".TB_PRE."url_rewrite where url_title='{$fields['url_title']}' limit 1";
    $rs=$dbm->query($sql);
    if(count($rs['list'])>0) die('{"code":"1","msg":"规则节点名称不可重复"}');

    $rs=$dbm->single_insert(TB_PRE.'url_rewrite',$fields);
    if($rs['error']!='') die('{"code":"1","msg":"'.$rs['error'].'"}');
    logs('添加规则 '.$fields['url_title']);
    $C->update_cache_rewrite();
    die('{"code":"0","msg":"操作成功"}');

}
//批量删除
function m__del(){
    global $dbm,$C;
    check_level('A0203',AJAX);
    $_POST=H::sqlxss($_POST);
    $_POST['params']=isset($_POST['params'])?trim($_POST['params']):'';
    $_POST['params']=explode(',',$_POST['params']);
    foreach($_POST['params'] as $v){
        $url_id=intval($v);
        $sql="delete from ".TB_PRE."url_rewrite where url_id='$url_id'";
        $rs=$dbm->query_update($sql);
        logs('批量修改分类 '.H::sqlxss($sql));
    }
    $C->update_cache_rewrite();
    die('{"code":"0","msg":"操作成功"}');
}
//生成伪静态规则文件
function m__update_rule_file(){
    global $C,$dbm;
    $file=isset($_POST['file'])?$_POST['file']:'';
    $txt='';

    switch($file){
        case '.htaccess':
            $txt.='<IfModule mod_rewrite.c>'.chr(10);
            $txt.='RewriteEngine on'.chr(10);
            $txt.='ErrorDocument 403 /404.html'.chr(10);
            $txt.='ErrorDocument 404 /404.html'.chr(10);
            foreach($C->rewrites as $v){
                $v['url_rule']=str_replace(array('{id}','{p}','{cid}','{cpy}'),array('(\d+)','(\d+)','(\d+)','(\w+?)'),$v['url_rule']);
                $v['url_true']=change_replace_num($v['url_true']);
                $txt.="RewriteRule {$v['url_rule']} {$v['url_true']}".chr(10);
            }
            //生成伪静态识别前缀标识
            $sql="select * from ".TB_PRE."category where url_dir<>''";
            $rs=$dbm->query($sql);
            $cates=array();
            foreach($rs['list'] as $v) $cates[$v['url_dir']]=$v;
            foreach($cates as $kc=>$vc){
                foreach($C->rewrites as $v){//print_r($v);
                    if(substr($v['url_title'],0,4)=='list') {
                        $v['url_rule'] = str_replace(array('{id}', '{p}', '{cid}', '{cpy}'), array('(\d+)', '(\d+)', '(\d+)', '(\w+?)'), $v['url_rule']);
                        $v['url_true'] = change_replace_num($v['url_true']);
                        $url_rule=$v['url_rule'];
                        $url_rule=$kc.substr($url_rule,strpos($url_rule,'/'));
                        $txt .= "RewriteRule {$url_rule} {$v['url_true']}" . chr(10);
                    }
                }
            }

            $txt.='</IfModule>';
            break;
        case 'httpd.ini':
            $txt.='[ISAPI_Rewrite]'.chr(10);
            $txt.='CacheClockRate 3600'.chr(10);
            $txt.='RepeatLimit 32'.chr(10);
            foreach($C->rewrites as $v){
                $v['url_rule']=str_replace(array('{id}','{p}','{cid}','{cpy}'),array('(\d+)','(\d+)','(\d+)','(\w+?)'),$v['url_rule']);
                $v['url_true']=change_replace_num($v['url_true'],2);
                $v['url_rule']=str_replace('.','\\\.',$v['url_rule']);
                $v['url_true']=str_replace('?','\\\?',$v['url_true']);
                $txt.="RewriteRule ^(.*)/{$v['url_rule']}$ \${$v['url_true']}".chr(10);
            }
            //生成伪静态识别前缀标识
            $sql="select * from ".TB_PRE."category where url_dir<>''";
            $rs=$dbm->query($sql);
            $cates=array();
            foreach($rs['list'] as $v) $cates[$v['url_dir']]=$v;
            foreach($cates as $kc=>$vc){
                foreach($C->rewrites as $v){//print_r($v);
                    if(substr($v['url_title'],0,4)=='list') {
                        $v['url_rule']=str_replace(array('{id}','{p}','{cid}','{cpy}'),array('(\d+)','(\d+)','(\d+)','(\w+?)'),$v['url_rule']);
                        $v['url_true']=change_replace_num($v['url_true'],2);
                        $v['url_rule']=str_replace('.','\\\.',$v['url_rule']);
                        $v['url_true']=str_replace('?','\\\?',$v['url_true']);
                        $url_rule=$v['url_rule'];
                        $url_rule=$kc.substr($url_rule,strpos($url_rule,'/'));
                        $txt .= "RewriteRule ^(.*)/{$url_rule} {$v['url_true']}" . chr(10);
                    }
                }
            }
            break;
        case 'web.config.rewrite':
            $txt.='<?xml version="1.0"?>'.chr(10);
            $txt.='<configuration>'.chr(10);
            $txt.='<system.webServer>'.chr(10);
            $txt.='<system.rewrite>'.chr(10);
            $txt.='<system.rules>'.chr(10);
            foreach($C->rewrites as $v){
                $v['url_rule']=str_replace(array('{id}','{p}','{cid}','{cpy}'),array('(\d+)','(\d+)','(\d+)','(\w+?)'),$v['url_rule']);
                $v['url_true']=change_replace_num_iis($v['url_true']);
                $txt.="<rule name=\"{$v['url_title']}\">".chr(10);
                $txt.="<match url=\"^{$v['url_rule']}$\" />".chr(10);
                $txt.="<action type=\"Rewrite\" url=\"{$v['url_true']}\" />".chr(10);
                $txt.="</rule>".chr(10);
            }
            //生成伪静态识别前缀标识
            $sql="select * from ".TB_PRE."category where url_dir<>''";
            $rs=$dbm->query($sql);
            $cates=array();
            foreach($rs['list'] as $v) $cates[$v['url_dir']]=$v;
            foreach($cates as $kc=>$vc){
                foreach($C->rewrites as $v){//print_r($v);
                    if(substr($v['url_title'],0,4)=='list') {
                        $v['url_rule']=str_replace(array('{id}','{p}','{cid}','{cpy}'),array('(\d+)','(\d+)','(\d+)','(\w+?)'),$v['url_rule']);
                        $v['url_true']=change_replace_num_iis($v['url_true']);

                        $url_rule=$v['url_rule'];
                        $url_rule=$kc.substr($url_rule,strpos($url_rule,'/'));
                        $txt.="<rule name=\"".$kc."_".$v['url_title']."\">".chr(10);
                        $txt.="<match url=\"^{$url_rule}$\" />".chr(10);
                        $txt.="<action type=\"Rewrite\" url=\"{$v['url_true']}\" />".chr(10);
                        $txt.="</rule>".chr(10);
                    }
                }
            }
            $txt.='</system.rules>'.chr(10);
            $txt.='</system.rewrite>'.chr(10);
            $txt.='</system.webServer>'.chr(10);
            $txt.='</configuration>'.chr(10);
            break;
        case 'nginx.conf':
            foreach($C->rewrites as $v){
                $v['url_rule']=str_replace(array('{id}','{p}','{cid}','{cpy}'),array('(\d+)','(\d+)','(\d+)','(\w+?)'),$v['url_rule']);
                $v['url_true']=change_replace_num($v['url_true'],2);
                $txt.="rewrite \"^(.*)/{$v['url_rule']}$\" $1/{$v['url_true']} last;".chr(10);
            }
            //生成伪静态识别前缀标识
            $sql="select * from ".TB_PRE."category where url_dir<>''";
            $rs=$dbm->query($sql);
            $cates=array();
            foreach($rs['list'] as $v) $cates[$v['url_dir']]=$v;
            foreach($cates as $kc=>$vc){
                foreach($C->rewrites as $v){//print_r($v);
                    if(substr($v['url_title'],0,4)=='list') {
                        $v['url_rule']=str_replace(array('{id}','{p}','{cid}','{cpy}'),array('(\d+)','(\d+)','(\d+)','(\w+?)'),$v['url_rule']);
                        $v['url_true']=change_replace_num($v['url_true'],2);
                        $url_rule=$v['url_rule'];
                        $url_rule=$kc.substr($url_rule,strpos($url_rule,'/'));
                        $txt .= "rewrite \"^(.*){$url_rule} {$v['url_true']}" . chr(10);
                    }
                }
            }
            break;
        default:
            die('{"code":1,"msg":"非法伪静态文件名"}');
    }
    file_put_contents(ROOT_PATH.'/'.$file, $txt);
    die('{"code":"0","msg":"操作成功，以下是伪静态规则，请仔细检查是否有误<textarea style=\"width:600px;height:300px;\">'.  htmlspecialchars(str_replace(array('\\',chr(10)),array('\\\\','\n'),$txt)).'</textarea>"}');
}
//转换{}替换字符为对应的数字序号$1,$2
function change_replace_num($url,$pos=1){
    $urlo=$url;
    $url=preg_match_all('~\{.*?\}~',$url,$a);
    if(is_array($a[0])){
        $i=$pos;
        foreach($a[0] as $v){
            $urlo=str_replace($v,'$'.$i,$urlo);
            $i++;
        }
    }
    return $urlo;
}
function change_replace_num_iis($url,$pos=1){
    $urlo=$url;
    $url=preg_match_all('~\{.*?\}~',$url,$a);
    if(is_array($a[0])){
        $i=$pos;
        foreach($a[0] as $v){
            $urlo=str_replace($v,'{R:'.$i.'}',$urlo);
            $i++;
        }
    }
    return $urlo;
}
?>