<?php
/*
 * MCMS Copyright (c) 2012-2013 ZhangYiYeTai Inc.
 *
 *  http://www.mcms.cc
 *
 * The program developed by loyjers core architecture, individual all rights reserved,
 * if you have any questions please contact loyjers@126.com
 */

require_once(dirname(__FILE__) . "/../../init.php"); //公用引导启动文件
check_login();
check_level('B01',AJAX);
$time_start = H :: getmicrotime(); //开始时间

// 动作处理
call_mfunc();
// 模板处理
$tpl=isset($_GET['tpl'])?$_GET['tpl']:'';

if($tpl=='edit'){
    require_once(assign_tpl('user.edit.php', 'admin'));
}else{
    require_once(assign_tpl(basename(__FILE__), 'admin'));
}


// ******************************************************* 函数方法 *******************************************************
function m__list() {
	global $dbm,$result,$V,$p,$U;
    $_POST = H::sqlxss($_POST);
    $_GET = H::sqlxss($_GET);
    //查询用户列表
	$params['table_name']=TB_PRE.'user';
	$params['where'] = ' 1=1 ';

	$params['fields']='uid,login_name,login_email,login_mobile,login_status,login_group,true_name';
	$params['count']=1;

	$params['pagesize']= get_pagesize(PAGESIZE_ADMIN);
	$params['suffix']='order by uid desc '.$dbm->get_limit_sql($params['pagesize'],$p);

	//判断用户组
	$_GET['login_group']=isset($_GET['login_group'])?intval($_GET['login_group']):0;
	if($_GET['login_group']>0){
	   $params['where'] .=' and login_group='.$_GET['login_group'];
	}

	//判断查询条件
	$_GET['usearch']=isset($_GET['usearch'])?intval($_GET['usearch']):0;
	$_GET['uval']=isset($_GET['uval'])?trim($_GET['uval']):'';

	if($_GET['uval'] != '') {
		if($_GET['usearch'] == 0) $params['where'] .= " and login_name='{$_GET['uval']}'";
		if($_GET['usearch'] == 1) $params['where'] .= " and login_email='{$_GET['uval']}'";
		if($_GET['usearch'] == 2) $params['where'] .= " and login_mobile='{$_GET['uval']}'";
		if($_GET['usearch'] == 3) $params['where'] .= " and true_name='{$_GET['uval']}'";
	}

	//判断用户状态
	$_GET['login_status']=isset($_GET['login_status'])?intval($_GET['login_status']):-1;
	if(in_array($_GET['login_status'], array(0,1,2))) {
	   $params['where'] .=' and login_status='.$_GET['login_status'];
	}

	$result = $dbm->single_query($params);
	$result['groups'] = $dbm->query("select group_name as txt,group_id as value from ".TB_PRE."group");
	$result['groups'] = $result['groups']['list'];
	array_unshift($result['groups'],array('txt'=>'请选择用户组','value'=>0));

	//print_r($result);exit;
}


/**
 * 启用禁用
 */
function m__ban() {
    global $dbm,$U;
    check_level('B0104',AJAX);
    $_POST = H::sqlxss($_POST);

    $_POST['login_status'] = isset($_POST['login_status']) ? intval($_POST['login_status']) : 0;
	$_POST['params'] = isset($_POST['params']) ? explode(',',$_POST['params']) : array();
	$str_id = '';
	foreach($_POST['params'] as $v) {
		$v = intval($v);
		if($v == 1 || $v == $_SESSION['user']['uid']) continue;
		$rs = $U->get($v,'login_group',1);
		if(!isset($rs['login_group']) || $rs['login_group'] == 0) continue;
		$rs = $dbm->query_update("update ".TB_PRE."user set login_status=".$_POST['login_status']." where uid=".$v);
		$str_id .= $str_id == '' ? $v : ','.$v;
	}

    //记录日志
    $type=($_POST['login_status'] == 1 ? '禁用' : ($_POST['login_status']==0?'启用':'未激活')).'用户：'.$str_id;
    logs($type,3);
    die('{"code":"0","msg":"操作成功"}');
}

/**
 * 添加
 */
function m__save() {
    global $dbm,$U;
    check_level('B0101',AJAX);
    foreach($_POST as $k => $v) {
        if ($k != 'login_pass') $_POST[$k] = H :: sqlxss($v);
    }

    $fields['login_name'] = isset($_POST['login_name']) ? trim($_POST['login_name']) : '';
    $fields['true_name'] = isset($_POST['true_name']) ? trim($_POST['true_name']) : '';
    $fields['login_pass'] = isset($_POST['login_pass']) ? trim($_POST['login_pass']) : '';
    $fields['login_email'] = isset($_POST['login_email']) ? trim($_POST['login_email']) : '';
    $fields['login_mobile'] = isset($_POST['login_mobile']) ? trim($_POST['login_mobile']) : '';
    $fields['login_group'] = isset($_POST['login_group']) ? intval($_POST['login_group']) : 0;
    $fields['gender'] = isset($_POST['gender']) ? intval($_POST['gender']) : 2;

	$verify = verify::verify_uname($fields['login_name']);
    if($verify != '') die('{"code":"1","msg":"<br>'.$verify.'","id":"login_name"}');

	$verify = verify::verify_upass($fields['login_pass']);
	if($verify != '') die('{"code":"1","msg":"<br>'.$verify.'","id":"login_pass"}');


	if(strlen($fields['true_name'])<1) die('{"code":"1","msg":"请填写姓名","id":"true_name"}');

	if($fields['login_email'] != '') {
		$verify = verify::verify_email($fields['login_email']);
		if($verify != '') die('{"code":"1","msg":"'.$verify.'","id":"login_email"}');
		if($U->get($fields['login_email'],'login_email',3)) die('{"code":"1","msg":"该邮箱已被占用","id":"login_email"}');
	}

	if($fields['login_mobile'] != '') {
		$verify = verify::verify_mobile($fields['login_mobile']);
		if($verify != '') die('{"code":"1","msg":"'.$verify.'","id":"login_mobile"}');
		if($U->get($fields['login_mobile'],'login_mobile',4)) die('{"code":"1","msg":"该号码已被占用","id":"login_mobile"}');
	}

	if($fields['login_group'] == 0) die('{"code":"2","msg":"请选择用户组","id":"login_group"}');
	if($U->get($fields['login_name'],'login_name',2)) die('{"code":"1","msg":"该用户已经存在","id":"login_name"}');


	$autoid = $U->add($fields);

	if(!is_numeric($autoid) || $autoid==0) die('{"code":"3","msg":"添加用户失败"}');

	logs('添加用户：'.$fields['login_name'].'('.$autoid.')',2);
	die('{"code":"0","msg":"添加用户成功"}');
}

/**
 * 重置密码
 */
function m__resetpwd() {
	global $dbm,$U;
    check_level('B0102',AJAX);
	$_POST['params'] = isset($_POST['params']) ? explode(',',$_POST['params']) : array();
	$_POST['login_pass'] = isset($_POST['login_pass']) ? trim($_POST['login_pass']) : '';
	$str_id = '';
	foreach($_POST['params'] as $v) {
		$v = intval($v);
		if($v<=0) continue;
		$rs = $U->get($v,'login_salt',1);
		if($rs == false) continue;
		$rs = $dbm->query_update("update ".TB_PRE."user set login_pass='".H::password_encrypt_salt($_POST['login_pass'], $rs['login_salt'])."' where uid=".$v);

		$str_id .= $str_id == '' ? $v : ','.$v;
	}
	logs('重置密码：'.$str_id,2);
	die('{"code":"0","msg":"操作成功"}');
}

/**
 * 批量修改
 */
function m__save_all() {
	global $dbm,$U;
    $_POST = H::sqlxss($_POST);

	$arr = array();
	foreach($_POST['params'] as $k=>$v) {
		$uid = $v['id'];
		unset($v['id']);
		unset($v[0]);
		unset($v['login_group']);

		if($v['login_email'] != '') {
			$verify = verify::verify_email($v['login_email']);
			if($verify != '') {
				if(!in_array($v['login_email'],$arr)) $arr[] = $v['login_email'];
				continue;
			}
			$rs = $U->get($v['login_email'],'uid',3);
			if($rs && $rs['uid'] != $uid) {
				if(!in_array($v['login_email'],$arr)) $arr[] = $v['login_email'];
				continue;
			}
		}

		if($v['login_mobile'] != '') {
			$verify = verify::verify_mobile($v['login_mobile']);
			if($verify != '') {
				if(!in_array($v['login_mobile'],$arr)) $arr[] = $v['login_mobile'];
				continue;
			}
			$rs = $U->get($v['login_mobile'],'uid',4);
			if($rs && $rs['uid'] != $uid) {
				if(!in_array($v['login_mobile'],$arr)) $arr[] = $v['login_mobile'];
				continue;
			}
		}

		$rs = $U->get($v['login_name'],'uid',2);
		if($rs && $rs['uid'] != $uid) {
			if(!in_array($v['login_name'],$arr)) $arr[] = $v['login_name'];
			continue;
		}

		$rs = $dbm->single_update(TB_PRE."user",$v,"uid='$uid'");
	}
	$msg = implode('，',$arr);
	$msg = $msg == '' ? '操作成功' : '以下信息重复或不正确<p style=\"width: 320px; overflow-x: auto;height: 45px;\">'.$msg.'</p>';
	die('{"code":"0","msg":"'.$msg.'"}');
}

//会员充值积分
function m__recharge(){
    global $dbm;
    check_level('C0503',AJAX);
    $fields = array();
    $_POST['params']=isset($_POST['params'])?trim($_POST['params']):'';
    $_POST['params']=explode(',',$_POST['params']);
    $_POST['point'] = isset($_POST['point'])?intval($_POST['point']):0;
    if(count($_POST['params'])==0) die('{"code":"1","msg":"请选择会员","id":"user"}');
    if($_POST['point']==0) die('{"code":"2","msg":"请输入积分数","id":"point"}');
    foreach($_POST['params'] as $v){
        $fields = array('uid'=>$v,'point'=>$_POST['point'],'create_time'=>time(),'point_type'=>4);
        $ret = $dbm->single_insert(TB_PRE."point",$fields);
    }
    die('{"code":"0","msg":"充值成功"}');
}

/**
 *用户组
 */
function user_group($id) {
    global $dbm;
    if($id == 0) return '';
    $rs = $dbm->query("select group_name,group_level from ".TB_PRE."group where group_id ={$id} limit 1");
    return isset($rs['list'][0]) ? $rs['list'][0] : '';
}

/**
 *用户积分
 */
function user_point($id) {
    global $dbm;
    if($id == 0) return 0;
    $rs = $dbm->query("select sum(point) as t from ".TB_PRE."point where uid ={$id}");
    return isset($rs['list'][0]['t']) ? $rs['list'][0]['t'] : 0;
}

//获取具体被编辑用户的具体信息
function m__get_edit_user() {
	global $dbm,$result,$V,$p,$U;
    $_POST = H::sqlxss($_POST);
    $_GET = H::sqlxss($_GET);
    //查询用户列表
	$params['table_name']=TB_PRE.'user';

	if(isset($_GET['uid']) && intval($_GET['uid'])!=$_SESSION['user']['uid']) check_level('B0102');
    $_GET['uid']=  isset($_GET['uid']) ? intval($_GET['uid']) : $_SESSION['user']['uid'];

	$params['where'] = " uid='{$_GET['uid']}' limit 1";

	$result = $dbm->single_query($params);
	if(count($result['list']) != 1) H::error_show('{"code":"1","msg":"该用户不存在，请联系管理员"}');

	$result['groups'] = $dbm->query("select group_name as txt,group_id as value from ".TB_PRE."group");
	$result['groups'] = $result['groups']['list'];
	array_unshift($result['groups'],array('txt'=>'请选择用户组','value'=>0));
	//print_r($result);exit;
}

//保存编辑的用户
function m__save_edit() {
	global $dbm,$U;
	$_POST = H::sqlxss($_POST);

    check_level('B0102',AJAX);

	$uid = isset($_POST['uid']) ? intval($_POST['uid']) : 0;

    $fields['login_name'] = isset($_POST['login_name']) ? trim($_POST['login_name']) : '';
    $fields['true_name'] = isset($_POST['true_name']) ? trim($_POST['true_name']) : '';
    $fields['login_email'] = isset($_POST['login_email']) ? trim($_POST['login_email']) : '';
    $fields['login_mobile'] = isset($_POST['login_mobile']) ? trim($_POST['login_mobile']) : '';
    $fields['login_group'] = isset($_POST['login_group']) ? intval($_POST['login_group']) : 0;
    $fields['avatar'] = isset($_POST['avatar']) ? trim($_POST['avatar']) : '';
    $fields['gender'] = isset($_POST['gender']) ? intval($_POST['gender']) : 0;
    $fields['login_status'] = isset($_POST['login_status']) ? intval($_POST['login_status']) : 0;

	$verify = verify::verify_uname($fields['login_name']);
    if($verify != '') die('{"code":"1","msg":"<br>'.$verify.'","id":"login_name"}');

	if($fields['login_group'] == 0) die('{"code":"2","msg":"请选择用户组","id":"login_group"}');

	$rs = $U->get($fields['login_name'],'login_name',2);
	if($rs && $rs['login_name'] != $fields['login_name']) die('{"code":"1","msg":"该用户已经存在","id":"login_name"}');

	if($fields['login_email'] != '') {
		$verify = verify::verify_email($fields['login_email']);
		if($verify != '') die('{"code":"1","msg":"'.$verify.'","id":"login_email"}');
		$rs = $U->get($fields['login_email'],'login_email,uid',3);
		if($rs && $rs['uid'] != $uid) die('{"code":"1","msg":"该邮箱已被占用","id":"login_email"}');
	}

	if($fields['login_mobile'] != '') {
		$verify = verify::verify_mobile($fields['login_mobile']);
		if($verify != '') die('{"code":"1","msg":"'.$verify.'","id":"login_mobile"}');
		$rs = $U->get($fields['login_mobile'],'login_mobile,uid',4);
		if($rs && $rs['uid'] != $uid) die('{"code":"1","msg":"该号码已被占用","id":"login_mobile"}');
	}

	if($uid == 1) $fields['login_group'] = 1;

	$rs = $dbm->single_update(TB_PRE."user",$fields," uid='$uid'");
	$_SESSION['user']['avatar'] = $fields['avatar'];

	logs('编辑用户：'.$fields['login_name'].'('.$uid.')',2);

	die('{"code":"0","msg":"编辑用户成功"}');
}

?>