<?php if(!defined('INC_MCMS')) die('No Access !');?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo('公司地图-'.SITE_NAME);?></title>
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no">
    <script type="text/javascript" src="<?php echo(DOMAIN_CSS);?>/libs/jquery-1.7.1.min.js"></script>
    <script type="text/javascript" src="<?php echo(DOMAIN_CSS);?>/libs/common.js"></script>
    <link href="<?php echo(DOMAIN_CSS.'/sty_'.SKIN);?>/style_wap.css" rel="stylesheet" type="text/css">
</head>
<body>
    <section>
        <div>
            <div id="dituContent" style="width:100%;height:100px;"></div>
            <style type="text/css">
                .iw_poi_title {color:#CC5522;font-size:14px;font-weight:bold;overflow:hidden;padding-right:13px;white-space:nowrap}
                .iw_poi_content {font:12px arial,sans-serif;overflow:visible;padding-top:4px;white-space:-moz-pre-wrap;word-wrap:break-word}
            </style>
            <script type="text/javascript" src="http://api.map.baidu.com/api?key=&v=1.1&services=true"></script>
            <script type="text/javascript">

                //创建和初始化地图函数：
                function initMap(){
                    createMap();//创建地图
                    setMapEvent();//设置地图事件
                    //addMapControl();//向地图添加控件
                    addMarker();//向地图中添加marker
                }

                //创建地图函数：
                function createMap(){
                    var map = new BMap.Map("dituContent");//在百度地图容器中创建一个地图
                    var point = new BMap.Point(<?php echo(LATITUDE);?>,<?php echo(LONGITUDE);?>);//定义一个中心点坐标
                    map.centerAndZoom(point,15);//设定地图的中心点和坐标并将地图显示在地图容器中
                    window.map = map;//将map变量存储在全局
                }

                //地图事件设置函数：
                function setMapEvent(){
                    map.enableDragging();//启用地图拖拽事件，默认启用(可不写)
                    map.enableScrollWheelZoom();//启用地图滚轮放大缩小
                    map.enableDoubleClickZoom();//启用鼠标双击放大，默认启用(可不写)
                    map.enableKeyboard();//启用键盘上下左右键移动地图
                }

                //地图控件添加函数：
                function addMapControl(){
                    //向地图中添加缩放控件
                    var ctrl_nav = new BMap.NavigationControl({anchor:BMAP_ANCHOR_TOP_LEFT,type:BMAP_NAVIGATION_CONTROL_SMALL});
                    map.addControl(ctrl_nav);
                    //向地图中添加比例尺控件
                    var ctrl_sca = new BMap.ScaleControl({anchor:BMAP_ANCHOR_TOP_LEFT});
                    map.addControl(ctrl_sca);
                }
                var area_pos=[];
                area_pos.push({title:"<?php echo(COMPANY_NAME);?>",content:"电话：<?php echo(COMPANY_PHONE);?><br>地址：<?php echo(COMPANY_ADDRESS);?>",point:"<?php echo(LATITUDE);?>,<?php echo(LONGITUDE);?>"});
                //标注点数组
                var markerArr = [];
                for(var i=0;i<area_pos.length;i++){
                    markerArr.push({title:area_pos[i].title,content:area_pos[i].content,point:area_pos[i].point,isOpen:0,icon:{w:21,h:25,l:46,t:21,x:6,lb:15}});
                }
                //创建marker
                function addMarker(){
                    for(var i=0;i<markerArr.length;i++){
                        var json = markerArr[i];
                        var p0 = json.point.split(",")[0];
                        var p1 = json.point.split(",")[1];
                        var point = new BMap.Point(p0,p1);
                        //var iconImg = createIcon(json.icon);
                        var marker = new BMap.Marker(point);
                        var iw = createInfoWindow(i);
                        var label = new BMap.Label('',{"offset":new BMap.Size(json.icon.lb-json.icon.x+10,-20)});
                        marker.setLabel(label);
                        map.addOverlay(marker);
                        label.setStyle({
                            borderColor:"#808080",
                            color:"#333",
                            cursor:"pointer"
                        });

                        (function(){
                            var index = i;
                            var _iw = createInfoWindow(i);
                            var _marker = marker;
                            _marker.addEventListener("click",function(){
                                this.openInfoWindow(_iw);
                            });
                            _iw.addEventListener("open",function(){
                                _marker.getLabel().hide();
                            })
                            _iw.addEventListener("close",function(){
                                _marker.getLabel().show();
                            });
                            _marker.openInfoWindow(_iw);
                            label.addEventListener("click",function(){
                                _marker.openInfoWindow(_iw);
                            });
                            if(!!json.isOpen){
                                label.hide();
                                _marker.openInfoWindow(_iw);
                            }
                        })()
                    }
                }
                //创建InfoWindow
                function createInfoWindow(i){
                    var json = markerArr[i];
                    var iw = new BMap.InfoWindow("<b class='iw_poi_title' title='" + json.title + "'>" + json.title + "</b><div class='iw_poi_content'>"+json.content+"</div>");
                    return iw;
                }
                //创建一个Icon
                function createIcon(json){
                    var icon = new BMap.Icon("http://s.zhiyuanyun.com/www.bv2008.cn/news/bvf.png", new BMap.Size(21,25))
                    return icon;
                }

                initMap();//创建和初始化地图
                $(function(){
                    $('#dituContent').height($(window).height()-60);//alert($(window).height()-140);
                })
            </script>

        </div>
    </section>
    <?php require_once(assign_tpl_inc("inc.front.foot.php"));?>
    </body>
</html>