<?php
/*
* MCMS Copyright (c) 2012-2013 ZhangYiYeTai Inc.
*
*  http://www.mcms.cc
*
* The program developed by loyjers core architecture, individual all rights reserved,
* if you have any questions please contact loyjers@126.com
*/

class Cms{
    private $dbm = null; //数据库操作对象
    private $cache_time = 3600; //缓存时间 单位秒

    private $cache_name = 'categories';//缓存名称
    public $categories = array(); //分类树

    private $cache_name_model = 'model';//缓存名称
    public $model = array();//模型

    private $cache_name_vars = 'vars';//缓存名称
    public $vars = array();//自定义变量

    private $cache_name_rewrite = 'rewrites';//缓存名称
    public $rewrites = array();//URL伪静态
    public $url = null; //伪静态对象
    /**
     * 初始化对象
     * @param $dbm object 数据库操作对象
     */
    public function __construct($dbm) {
        global $global_global;

        $this->dbm = $dbm;

        //URL伪静态缓存
        $params = array(
            'key'=>$this->cache_name_rewrite,
            'time'=>$this -> cache_time,
            'cache_type'=>CACHE_TYPE,
            'server'=>$global_global['mem_server'],
            'path'=>'cache/rewrites'
        );
        $a = H :: cache($params);
        if ($a == 'timeout') {
            $params['val'] = $this -> rewrites();
            $a = H :: cache($params);
        }
        $this -> rewrites = $a;
        $this -> url = new url_rewrite($this -> rewrites);
        $this -> url -> rewrite = REWRITE;
        $this -> url -> root_path = DOMAIN_SITE;

        //分类缓存
        $params = array(
            'key'=>$this->cache_name,
            'time'=>$this -> cache_time,
            'cache_type'=>CACHE_TYPE,
            'server'=>$global_global['mem_server'],
            'path'=>'cache/category'
        );
        $a = H :: cache($params);
        if ($a == 'timeout') {
            $params['val'] = $this -> categories();
            $a = H :: cache($params);
        }
        $this -> categories = $a;
        //模型缓存
        $params = array(
            'key'=>$this->cache_name_model,
            'time'=>$this -> cache_time,
            'cache_type'=>CACHE_TYPE,
            'server'=>$global_global['mem_server'],
            'path'=>'cache/model'
        );
        $a = H :: cache($params);
        if ($a == 'timeout') {
            $params['val'] = $this -> model();
            $a = H :: cache($params);
        }
        $this -> model = $a;
        //自定义变量缓存
        $params = array(
            'key'=>$this->cache_name_vars,
            'time'=>$this -> cache_time,
            'cache_type'=>CACHE_TYPE,
            'server'=>$global_global['mem_server'],
            'path'=>'cache/vars'
        );
        $a = H :: cache($params);
        if ($a == 'timeout') {
            $params['val'] = $this -> vars();
            $a = H :: cache($params);
        }
        $this -> vars = $a;

    }
    /**
     * 获取所有目录数组，可以用分类ID作为下标读取分类信息
     */
    private function categories()
    {
        $sql = "select * from " . TB_PRE . "category order by corder asc";
        $a = $this->dbm->query($sql);
        $tmp_trees = array();
        //遍历全部分类
        foreach ($a['list'] as $k => $v) {
            //判断是否绑定域名到站点根目录
            $host = $v['cdomain'] == '' ? DOMAIN_SITE : $v['cdomain'];
            //print_r($host);die();
            if (REWRITE_CATE_ALIAS == 1) {
                $v['surl'] = $this->url->encode('list_cpy_index', array('host' => $host, 'cpy' => $v['cname_py'], 'p' => 1));
            } else {
                $v['surl'] = $this->url->encode('list_cid_index', array('host' => $host, 'cid' => $v['cate_id'], 'p' => 1));
            }
            //如果有伪静态识别前缀
            if ($v['url_dir'] != '') {//var_dump($v['url_dir']);
                $v['surl'] = preg_replace('~(http://.*?)/(.*?)/(.*?)~', '${1}/' . $v['url_dir'] . '/${3}', $v['surl']);
            }
            //绑定了主域名的分类优先
            if ($v['cdomain'] != '') {
                $v['surl'] = $v['cdomain'];
            }else{
                $v['surl'] = preg_replace('~^(http://.*?)/(.*?)$~',$this->cate_parent_cdomain($v['cate_id']).'/${2}',$v['surl']);
            }
            //跳转链接优先
            if ($v['go_url'] != '') $v['surl'] = $v['go_url'];

            //print_r($v);die();
            //遍历查询子类
            $sql = "select * from " . TB_PRE . "category where parent_id='{$v['cate_id']}' order by corder asc";
            $rs = $this->dbm->query($sql);
            $v['son'] = $rs['list'];
            //遍历子类修改URL
            foreach ($v['son'] as $ks => $vs) {
                //判断是否绑定域名到站点根目录
                $host = $vs['cdomain'] == '' ? DOMAIN_SITE : $vs['cdomain'];
                //print_r($host);die();
                if (REWRITE_CATE_ALIAS == 1) {
                    $v['son'][$ks]['surl'] = $this->url->encode('list_cpy_index', array('host' => $host, 'cpy' => $vs['cname_py'], 'p' => 1));
                } else {
                    $v['son'][$ks]['surl'] = $this->url->encode('list_cid_index', array('host' => $host, 'cid' => $vs['cate_id'], 'p' => 1));
                }
                //如果有伪静态识别前缀
                if ($vs['url_dir'] != '') {//var_dump($v['url_dir']);
                    $v['son'][$ks]['surl'] = preg_replace('~(http://.*?)/(.*?)/(.*?)~', '${1}/' . $vs['url_dir'] . '/${3}', $v['son'][$ks]['surl']);
                }
                //绑定了主域名的分类优先
                if ($vs['cdomain'] != '') {
                    $v['son'][$ks]['surl'] = $vs['cdomain'];
                }else{
                    $v['son'][$ks]['surl'] = preg_replace('~^(http://.*?)/(.*?)$~',$this->cate_parent_cdomain($vs['cate_id']).'/${2}',$v['son'][$ks]['surl']);
                }
                //跳转链接优先
                if ($vs['go_url'] != '') $v['son'][$ks]['surl'] = $vs['go_url'];
            }
            $tmp_trees[$v['cate_id']] = $v;
        }
        return $tmp_trees;
    }
    private function cate_parent_cdomain($cate_id){
        if($cate_id<=0) return '';//已经到顶级分类了
        $sql="select parent_id,cdomain from ".TB_PRE."category where cate_id='$cate_id' limit 1";
        $rs=$this->dbm->query($sql);
        if(count($rs['list'])==0) return '';
        if($rs['list'][0]['cdomain']!='') return $rs['list'][0]['cdomain'];
        return $this->cate_parent_cdomain($rs['list'][0]['parent_id']);
    }
    /**
     *
     */
    private function vars(){
        $sql="select * from ".TB_PRE."vars";
        $rs=$this->dbm->query($sql);
        $vars=array();
        foreach($rs['list'] as $v){
            $vars[$v['var_name']]=htmlspecialchars_decode($v['var_content']);
        }
        return $vars;
    }
    /**
     *
     * 获取所有缓存及其字段
     *
     */
    private function model() {
        $sql = "select * from ".TB_PRE."model";
        $a = $this -> dbm -> query($sql);
        $tmp_trees = array();
        foreach($a['list'] as $v) {
            if($this->model_table_exists($v['model_name'])){
                $m=$this->model_exists($v['model_name']);
                if($m) $tmp_trees[$v['model_name']] = $m;
            }
        }
        return $tmp_trees;
    }
    /**
     * 获取所有模型及其字段
     */
    private function rewrites() {
        $sql = "select * from ".TB_PRE."url_rewrite";
        $a = $this -> dbm -> query($sql);
        $tmp_trees = array();
        foreach($a['list'] as $v) {
            $tmp_trees[$v['url_title']] = $v;
        }
        return $tmp_trees;
    }
    /**
     * 扩展模型转换为vars类变量类型
     */
    public function model_vars() {
       $tmp_trees = array();
       array_push($tmp_trees,array('txt'=>'文章','value'=>'','txt_color'=>''));
        foreach($this -> model as $v) {
            if($v['model_type']==0)
            array_push($tmp_trees,array('txt'=>$v['model_desc'],'value'=>$v['model_name'],'txt_color'=>''));
        }
        return $tmp_trees;//print_r($tmp_trees);
    }
    /**
     * 更新目录缓存
     */
    public function update_cache() {
        global $global_global;

        $params = array(
            'key'=>$this->cache_name,
            'time'=>$this -> cache_time,
            'cache_type'=>CACHE_TYPE,
            'server'=>$global_global['mem_server'],
            'path'=>'cache/category'
        );
        $params['val'] = $this -> categories();
        $this -> categories = H :: cache($params);
    }
    /**
     * 更新模型缓存
     */
    public function update_cache_model() {
        global $global_global;

        $params = array(
            'key'=>$this->cache_name_model,
            'time'=>$this -> cache_time,
            'cache_type'=>CACHE_TYPE,
            'server'=>$global_global['mem_server'],
            'path'=>'cache/model'
        );
        $params['val'] = $this -> model();
        $this -> model = H :: cache($params);
    }
    /**
     * 更新URL伪静态缓存
     */
    public function update_cache_rewrite() {
        global $global_global;

        $params = array(
            'key'=>$this->cache_name_rewrite,
            'time'=>$this -> cache_time,
            'cache_type'=>CACHE_TYPE,
            'server'=>$global_global['mem_server'],
            'path'=>'cache/vars'
        );
        $params['val'] = $this -> rewrites();
        $this -> rewrites = H :: cache($params);
    }
    /**
     * 更新自定义变量缓存
     */
    public function update_cache_vars() {
        global $global_global;
        $params = array(
            'key'=>$this->cache_name_vars,
            'time'=>$this -> cache_time,
            'cache_type'=>CACHE_TYPE,
            'server'=>$global_global['mem_server'],
            'path'=>'cache/rewrites'
        );
        $params['val'] = $this -> vars();
        $this -> rewrites = H :: cache($params);
    }
    /**
     * 获取父级目录（水平）
     * @param $cate_id int 目录树id
     */
    public function cate_father($cate_id) {
        $ret = array();
        if(!isset($this->categories[$cate_id])) return $ret;
        //自身
        $self=$this->categories[$cate_id];
        unset($self['son']);
        array_push($ret, $self);
        //查找父级
        if (intval($self['parent_id']) > 0) {
            $ret = $this->cate_father($self['parent_id']);
            array_push($ret, $self);
        }
        return $ret;
    }
    /**
     * 获取平级目录（水平）
     * @param $cate_id int 目录树id
     */
    public function cate_brother($cate_id=0) {

        $parent_id=$cate_id==0?0:$this->categories[$cate_id]['parent_id'];
        if($cate_id==0 || $parent_id==0){
            $ret=array();
            foreach($this->categories as $v){
                if($v['parent_id']==0) array_push($ret,$v);
            }
            return $ret;
        }else{
            return $this->categories[$parent_id]['son'];
        }
    }
    public function final_clear(){
        $this->clear_flush();
    }
    /**
     * 输出目录树
     * @param -> tree $this->categories['son']数组
     * @param -> expand_func 点击展开收缩的回调方法 expand_func(this)
     * @param -> is_expand_all 是否默认全部展开 1,0
     * @param -> ulevel 传递选中值
     * @param -> checkbox 1,0
     * @param -> url 链接URL，为空或者没有子树(强制输出链接=0)，输出纯文本
     * @param -> url_force 1,0 强制输出链接
     * @param -> click 文本上onclick 函数 onclick="javascript:void(0);";
     * @param -> rtype_last 默认最后一级显示复选框，1,2,3|4,5,6,tid1_path,tid2_path
     * @param -> loop_limit 输出子树级数
     */
    public function show_tree($params){
        //预处理参数
        $tree=$params['tree']=isset($params['tree'])?$params['tree']:array();
        $expand_func=$params['expand_func']=isset($params['expand_func'])?$params['expand_func']:'expand_func(this)';
        $is_expand_all=$params['is_expand_all']=isset($params['is_expand_all'])?$params['is_expand_all']:0;
        if($is_expand_all==1) $expand_func='';
        $ulevel=isset($params['ulevel'])?$params['ulevel']:array();
        $checkbox=$params['checkbox']=isset($params['checkbox'])?$params['checkbox']:0;
        $url=$params['url']=isset($params['url'])?$params['url']:'';
        $url_force=$params['url_force']=isset($params['url_force'])?$params['url_force']:0;
        $click=$params['click']=isset($params['click'])?$params['click']:'';
        $rtype_last=$params['rtype_last']=isset($params['rtype_last'])?$params['rtype_last']:0;
        $loop=$params['loop']=isset($params['loop'])?$params['loop']:1;
        $loop=$params['loop']++;
        $loop_limit=$params['loop_limit']=isset($params['loop_limit'])?$params['loop_limit']:100;
        if($loop>$loop_limit) return;

        //遍历数组
        $html='<ul class="tree">';
        if(is_array($tree)) {
            foreach($tree as $v){
                $vson=@$this->categories[$v['cate_id']]['son'];
                if(!check_level('T'.$v['cate_id'],0,1)) continue;//判断是否有显示权限
                $open_status='close';
                if($is_expand_all==1) $open_status='open';
                $html.='<li id="li'.$v['cate_id'].'">';
                $html.='<span onclick="tree_icon_click(this'.($expand_func==''?'':','.$expand_func).');" class="tree-icon tree-expand-'.$open_status.'"></span>';
                if(($checkbox==1 || ($rtype_last==1 && count($vson)==0))){
                    $chk='';if(in_array('T'.$v['cate_id'],$ulevel)) $chk=' checked';
                    $html.='<input type="checkbox" name="level" '.$chk.' value="T'.$v['cate_id'].'" id="T'.$v['cate_id'].'">';
                }

                if($url=='' || (count($vson)==0 && $url_force==0)){
                    $html.='<label for="T'.$v['cate_id'].'"><em '.$click.' class="no_link">'.$v['cname'].'</em></label>';
                }else{
                    $style = isset($_GET['cate_id'])&&$_GET['cate_id'] == $v['cate_id']?'class="selected"':'';
                    $html.='<a '.$style.' href="'.H::url_params($url,array('cate_id'=>$v['cate_id'])).'">'.$v['cname'].'</a>';
                }
                //展开子级
                if(count($vson)>0 && $is_expand_all==1){
                    $params['tree']=$vson;
                    $html.=$this->show_tree($params);
                }
                $html.='</li>';
            }

        }
        $html.='</ul>';
        return $html;
    }
    public function show_select($cid=0,$i=0){
        $i++;//层级标记
        $font='';//设置层级缩进
        for($j=1;$j<$i;$j++){
            $font.='　';
        }
        $tmp=array();
        if($cid==0){//输出顶级类
            foreach($this->categories as $v){
                if($v['parent_id']==0){
                    if(!check_level('T'.$v['cate_id'],0,1)) continue;
                    array_push($tmp,array('value'=>$v['cate_id'],'txt'=>$font.$v['cname'],'txt_color'=>''));
                    $a=$this->show_select($v['cate_id'],$i);
                    foreach($a as $v1){
                        array_push($tmp,$v1);
                    }
                }
            }
        }else{//输出子类
            foreach($this->categories[$cid]['son'] as $v){
                if(!check_level('T'.$v['cate_id'],0,1)) continue;
                array_push($tmp,array('value'=>$v['cate_id'],'txt'=>$font.$v['cname'],'txt_color'=>''));
                $a=$this->show_select($v['cate_id'],$i);
                foreach($a as $v1){
                    array_push($tmp,$v1);
                }
            }
        }

        return $tmp;
    }
    /**
     * 输出微信菜单树
     * @param -> tree $menu数组
     * @param -> expand_func 点击展开收缩的回调方法 expand_func(this)
     * @param -> is_expand_all 是否默认全部展开 1,0
     * @param -> ulevel 传递选中值
     * @param -> checkbox 1,0
     * @param -> url 链接URL，为空或者没有子树(强制输出链接=0)，输出纯文本
     * @param -> url_force 1,0 强制输出链接
     * @param -> click 文本上onclick 函数 onclick="javascript:void(0);";
     * @param -> rtype_last 默认最后一级显示复选框，1,2,3|4,5,6,tid1_path,tid2_path
     * @param -> loop_limit 输出子树级数
     */
    public function show_weixin($params){
        //预处理参数
        $tree=$params['tree']=isset($params['tree'])?$params['tree']:array();
        $expand_func=$params['expand_func']=isset($params['expand_func'])?$params['expand_func']:'expand_func(this)';
        $is_expand_all=$params['is_expand_all']=isset($params['is_expand_all'])?$params['is_expand_all']:0;
        if($is_expand_all==1) $expand_func='';
        $ulevel=isset($params['ulevel'])?$params['ulevel']:array();
        $url=$params['url']=isset($params['url'])?$params['url']:'';
        $url_force=$params['url_force']=isset($params['url_force'])?$params['url_force']:0;
        $click=$params['click']=isset($params['click'])?$params['click']:'';
        $rtype_last=$params['rtype_last']=isset($params['rtype_last'])?$params['rtype_last']:0;
        $loop=$params['loop']=isset($params['loop'])?$params['loop']:1;
        $loop=$params['loop']++;
        $loop_limit=$params['loop_limit']=isset($params['loop_limit'])?$params['loop_limit']:100;
        if($loop>$loop_limit) return;

        //遍历数组
        $html='<ul class="tree">';
        if(is_array($tree)) {
            foreach($tree as $v){
                $open_status='close';
                if($is_expand_all==1) $open_status='open';
                $html.='<li id="li'.$v['menu_id'].'">';
                $html.='<span onclick="tree_icon_click(this'.($expand_func==''?'':','.$expand_func).');" class="tree-icon tree-expand-'.$open_status.'"></span>';

                if($url=='' || (isset($v['son']) && count($v['son'])==0 && $url_force==0)){
                    $html.='<label for="T'.$v['menu_id'].'"><em '.$click.' class="no_link">'.$v['menu_name'].'</em></label>';
                }else{
                    $style = isset($_GET['menu_id'])&&$_GET['menu_id'] == $v['menu_id']?'class="selected"':'';
                    if($loop<2){
                        $html.='<a '.$style.' href="'.H::url_params($url,array('menu_id'=>$v['menu_id'])).'">'.$v['menu_name'].'</a>';
                    } else {
                        $html.='<a onclick="javascript:void(0);" style=" color: #aaa;background:none;">'.$v['menu_name'].'</a>';
                    }
                }
                //展开子级
                if(isset($v['son']) && count($v['son'])>0 && $is_expand_all==1){
                    $params['tree']=$v['son'];
                    $html.=$this->show_weixin($params);
                }
                $html.='</li>';
            }

        }
        $html.='</ul>';
        return $html;
    }
    public function clear_flush(){
        echo('<'.'!'.'-'.'-'.'P'.'o'.'w'.'e'.'r'.'d'.' '.'b'.'y'.' '.'M'.'C'.'M'.'S'.' '.'V'.'e'.'r'.MCMS_VERSION.'-'.'-'.'>');
    }
    /**
     * 获取资源列表 $C->get_list(array('cate_id'=>3,'pagesize'=>10));
     * @param -> cate_id        分类ID，为 0 或者不传值 表示查询全部
     * @param -> info_status    状态，为 空 或者不传值 表示查询全部
     * @param -> left_table     是否需要指定左连接表（如收藏），默认无需声明，info_list 默认为 b 表，根据cate_id字段判断左表 a 为 cate_relation
     * @param -> fields         查询的字段
     * @param -> where          查询条件
     * @param -> order          排序
     * @param -> pagesize       分页大小 默认＝PAGESIZE_ADMIN
     * @param -> p              页码 默认＝1
     * @param -> count_cache    预读统计总数是否缓存 1＝缓存 0＝不缓存（默认）
     * @param -> count          是否计算总数 0 不计算 1 计算
     * @param -> rewrite        URL重写方式 0,1,2，默认为2
     * @param -> model          是否自动取扩展模型表数据
     */
    public function get_list($params=array()){
        //可传递变量
        $params['cate_id']=isset($params['cate_id'])?intval($params['cate_id']):0;
        $params['info_status']=isset($params['info_status'])?trim($params['info_status']):'0';
        $params['left_table']=isset($params['left_table'])?$params['left_table']:'';
        $params['fields']=isset($params['fields'])?$params['fields']:'*';
        $params['where']=isset($params['where'])?trim($params['where']):'';
        $params['order']=isset($params['order'])?trim($params['order']):'order by b.publish_time desc';
        $params['count']=isset($params['count'])?intval($params['count']):0;
        $params['count_cache']=isset($params['count_cache'])?intval($params['count_cache']):0;//统计总数是否缓存
        $params['rewrite']=isset($params['rewrite'])?intval($params['rewrite']):REWRITE;
        $params['pagesize']=isset($params['pagesize'])?intval($params['pagesize']):PAGESIZE;//页码
        $params['pagesize']=get_pagesize($params['pagesize']);
        $params['p']=isset($params['p'])?$params['p']:1;
        $params['index']=isset($params['index'])?$params['index']:'';

        if($params['info_status']!=='') $params['where'].=" and b.info_status='{$params['info_status']}' ";
        if($params['cate_id']>0) $params['where'].=" and a.cate_id='{$params['cate_id']}' ";//echo($params['where']);
        $params['where']=trim($params['where']);
        //
        //补全 and
        if($params['where']!='' && substr($params['where'],0,4)=='and ') $params['where']=substr($params['where'],4);//echo($params['where'].'\r\n');
        //补全 wehre
        if($params['where']!='') $params['where']="where ".$params['where'];

        //有目录ID强制左连表
        if(strstr($params['where'],'a.cate_id')) $params['left_table']=TB_PRE.'cate_relation';
        //if(strstr($params['where'],'a.cate_id in')) $params['left_table']='(select * from '.TB_PRE.'cate_relation group by info_id)';//TB_PRE.'cate_relation';

        //print_r($params);

        $total=0;
        $sql_count_time=0;
        $count_sql='';
        //统计总数量
        if($params['count']==1){
            $_start = H :: getmicrotime();
            if($params['left_table']==''){
                $count_sql="select count(*) as t from ".TB_PRE."info_list as b ".$params['where'];
            }else{
                if($params['cate_id']>0){
                    $count_sql = "select count(*) as t from " . $params['left_table'] . "  as a left join " . TB_PRE . "info_list as b on a.info_id=b.info_id " . $params['where'];
                }else {
                    $count_sql = "select count(*) as t from (select * from " . $params['left_table'] . " group by info_id) as a left join " . TB_PRE . "info_list as b on a.info_id=b.info_id " . $params['where'];
                }
            }
            //die($count_sql);
            $cache_file = md5($count_sql);
            $params_cache = array('key'=>$cache_file,'cache_type'=>CACHE_TYPE,'time'=>3600,'path'=>'cache/count');
            //缓存总量统计
            if($params['count_cache']==1){
                $total = H :: cache($params_cache);
                if ($total == 'timeout' || $total==0) {
                    $total_rs=$this->dbm->scalar($count_sql);//print_r($count_sql);
                    $total = $params_cache['val'] = isset($total_rs['t'])?$total_rs['t']:0;
                    H :: cache($params_cache);
                }
            }else{
                $total_rs=$this->dbm->scalar($count_sql);//print_r($total_rs);
                $total = isset($total_rs['t'])?$total_rs['t']:0;
            }
            $sql_count_time = H :: getmicrotime() - $_start;
            //判断结果集大小和前面是否强制索引决定是否使用索引
            if($total>5000) {
                preg_match_all('~order by b\.(.*?) ~',$params['order'],$tmp);
                if(count($tmp[0])==1){
                    $params['index']=" use index(".$tmp[1][0].") ";
                }
            }

            if(defined('SQL_ERR_LOG') && SQL_ERR_LOG=='1' && mysql_error()!='') {
                H::logs('sql_error',isset($_SERVER['REQUEST_URI'])?$_SERVER['REQUEST_URI']:'');
                H::logs('sql_error',mysql_error().$count_sql);
            }
            if(defined('SQL_LOG') && SQL_LOG=='1' && $sql_count_time>=20) {
                H::logs('sql',isset($_SERVER['REQUEST_URI'])?$_SERVER['REQUEST_URI']:'');
                H::logs('sql','=='.$sql_count_time.' ms -> '.$count_sql.chr(10));
            }
        }
        //查询需要去掉where字符
        if(substr(trim($params['where']),0,6)=='where ') $params['where']=substr($params['where'],6);
        $params['suffix']= ' '.$params['order'].' '.$this->dbm->get_limit_sql($params['pagesize'],$params['p']);
        //die(print_r($params));
        //开始查询，单表或者联表
        if($total==0 && $params['count']==1){
            $rs=array('sql'=>'','list'=>array(),'total'=>0,'sql_time'=>0);
        }else{
            if($params['left_table']==''){
                $params['table_name'] = " ".TB_PRE."info_list as b ".$params['index']." ";
                $rs = $this -> dbm -> single_query($params);
            }else{
                $params['table1'] = $params['left_table'];
                $params['table2'] = " ".TB_PRE."info_list ";
                //判断左右表索引
                if($params['table1'] == TB_PRE.'cate_relation') {
                    $params['right_index'] = $params['index'];
                }else{
                    $params['left_index'] = $params['index'];
                }
                $params['joinon'] = 'info_id#info_id';
                $rs = $this -> dbm->join_query($params);
            }
        }
        //print_r($rs);
        //遍历处理
        foreach($rs['list'] as $k=>$v) {//print_r($v);
            //遍历所属主分类的父分类，判断是否绑定了域名
            $host=DOMAIN_SITE;
            foreach($this->cate_father($v['cate_id']) as $va){
                if($va['cdomain']!='') $host=$va['cdomain'];
            }

            $rs['list'][$k]['surl'] = $this -> url -> encode('content',array('host' => $host, 'id' => $v['info_id'], 'p' => 1));
            //跳转地址优先
            if($v['go_url']!='') $rs['list'][$k]['surl'] = $v['go_url'];

            //标题处理
            $rs['list'][$k]['info_title_style'] = $rs['list'][$k]['info_title'];
            if($v['fcolor'] || $v['fbold']) {
                $rs['list'][$k]['info_title_style'] = '<span style="';
                $rs['list'][$k]['info_title_style'] .= 'color:'.$v['fcolor'].';';
                $rs['list'][$k]['info_title_style'] .= $v['fbold']?'font-weight:bolder;':'';
                $rs['list'][$k]['info_title_style'] .= '">';
                $rs['list'][$k]['info_title_style'] .= $rs['list'][$k]['info_title'].'</span>';
            }
            //保留原图地址
            $rs['list'][$k]['info_imgo'] = $v['info_img'];
            if($v['info_img'] != '') {//缩略图小图
                $rs['list'][$k]['info_img'] = H::preview_url($v['info_img']);
            }
            //读取模型字段
            if(isset($v['model_name']) && $v['model_name']!=''){
                $rs['list'][$k]['model']=array();
                $sql="select * from ".TB_PRE.$v['model_name']." where info_id='{$v['info_id']}' limit 1";
                $rs_model=$this->dbm->query($sql);
                if(count($rs_model['list'])==1){
                    $rs['list'][$k]['model']=$rs_model['list'][0];
                }
            }

        }
        //重新计入总数和时间
        $rs['sql_time']=$rs['sql_time']+$sql_count_time;
        $rs['sql_time_count']=$sql_count_time;
        $rs['total']=$total;
        $rs['count_sql']=$count_sql;
        //重新计算分页码
        if($params['count']==1) {
            $list_node = 'list_cid';
            if (REWRITE_CATE_ALIAS == 1) $list_node = 'list_cpy';
            $cname_py = isset($this->categories[$params['cate_id']]['cname_py']) ? $this->categories[$params['cate_id']]['cname_py'] : 'nocate';
            $rs['pagebar'] = H:: pagebar(array('total' => $total, 'pagesize' => $params['pagesize'], 'rewrite' => $params['rewrite'], 'rule' =>
                array('node' => $list_node,
                    'obj' => $this->url,
                    'params' =>
                        array('host' => DOMAIN_SITE,
                            'cid' => $params['cate_id'],
                            'cpy' => $cname_py,
                            'p' => $params['p']
                        ),
                )
            ));
        }
        //unset($rs['list']);unset($rs['pagebar']);
        //print_r($rs);die();
        return $rs;
    }
    /**
     * 获取资源列表
     * @$param $info_id 文档ID
     * @param $fields 字段
     * @old 是否直接返回行数据，不做其他处理
     */
    public function get_content($info_id,$fields="*",$old=0){
        global $p;
        $sql="select $fields from ".TB_PRE."info_list where info_id='$info_id' limit 1";
        $rs=$this->dbm->query($sql);
        if(count($rs['list'])==0) return false;
        $content=$rs['list'][0];
        if($old==1) return $content;

        //获取分类所有id，用于勾选
        if(isset($content['cid_path'])){
            $content['cid_path_ids']=explode(',',str_replace('|',',',$content['cid_path']));
            $f=0;
            foreach($content['cid_path_ids'] as $k=>$v){
                if($f==0) $f=$v;
                $content['cid_path_ids'][$k]='T'.$v;
            }
            if($content['cate_id']==0) $content['cate_id']=$f;
        }

        //获取附件
        $sql="select b.*,a.attach_id from ".TB_PRE."attach as a use index(info_id) left join ".TB_PRE."file as b on a.file_md5=b.file_md5 where a.info_id='$info_id' order by b.file_order limit 50";
        $rs=$this->dbm->query($sql);//print_r($rs);
        $content['surl'] = $this -> url -> encode('content',array('host' => DOMAIN_SITE, 'id' => $content['info_id'], 'p' => 1));
        $content['attachs']=$rs['list'];
        //获取扩展表字段值
        if($content['model_name']!=''){
            $sql="select * from ".TB_PRE.$content['model_name']." where info_id='$info_id' limit 1";
            $rs=$this->dbm->query($sql);
            if(count($rs['list'])==1){//存在则获取
                $content['model_fields']=$rs['list'][0];
                unset($content['model_fields']['info_id']);
            }else{//不存在则设置为空
                foreach($this->model[$content['model_name']]['fields'] as $v){
                    $content['model_fields'][$v['field_name']]='';
                }
            }
        }//print_r($content);
        
        $content['comment'] = ($this->get_comments($info_id, $p) . $this->getcomment_form($info_id));
        return $content;
    }

    /*
     *取评论列表
     *@param int $info_id 资讯表ID
     *@param int $p 分页码
     *@style_prefix string 样式前缀
     *@return string
     */
    function get_comments($info_id, $p = 1, $style_prefix = "comment") {
        $suffix = '';
        $comments = array();
        if(!is_numeric($info_id) || $info_id <= 0) return '';
        $where = "info_id = '$info_id' and parent_id='0'";
        $suffix .= " order by date_add desc ";
        $suffix .= $this->dbm -> get_limit_sql(PAGESIZE, $p);
        $params = array('table_name' => TB_PRE . 'comment', 'pagesize' => PAGESIZE, 'where' => $where, 'count' => 1, 'suffix' => $suffix);
        $res = $this->dbm -> single_query($params);
        $comments['list'] = $res['list'];
        $comments['pagecode'] = $res['pagebar']['pagecode'];
        $html = '<div class="'.$style_prefix.'_list">网友评论</div>';
        if (count($comments['list']) > 0) {
            $top_comment = $comments['list'];
            $i = 0;
            foreach ($top_comment as $c) {
                if ($c['son'] > 0) $top_comment[$i]['sons'] = $this->get_comment($c['comment_id']);
                $i++;
            }
            $html .=  $this->show_comment($top_comment, $style_prefix);
            $pagesize = ceil($res['total'] / PAGESIZE);
            $html .= '<div class="pagebar '.$style_prefix . '_page ' . $style_prefix . '_pagebar">';
            for($i = 1; $i <= $pagesize; $i++) {
                $html .= '<a onclick="pages('. $info_id .',' .$i. ');">' . $i . '</a>';
            }
            $html .= '<script type="text/javascript">

                //js分页函数
                function pages(id, p){
                    if(!p) p = 1;
                    $.get("/app/comment/index.php?m=list",{comment_id:id,p:p},function(data){
                        $("#comment_list").html(data);
                    });
                }

            </script>';
            $html .= '</div><br />';
            return $html;
        }
    }
    /*
     *取子评论
     *@param $parent_id 评论记录上一级ID
     *@return string 返回子评论记录
     */
    function get_comment($parent_id) {
        $sql = "select * from " . TB_PRE . "comment where parent_id='$parent_id' order by date_add asc";
        $rs = $this->dbm -> query($sql);
        $i = 0;
        foreach($rs['list'] as $c) {
            if ($c['son'] > 0) $rs['list'][$i]['sons'] =$this->get_comment($c['comment_id']);
            $i++;
        }
        return $rs['list'];
    }
    /*
     *输出评论HTML
     *@param $comment 数据库查询的评论记录
     *@param $style_prefix 样式前缀
     *@return string 返回评论记录HTML
     */
    function show_comment($comment, $style_prefix="comment") {
        $html = '<div class="'.$style_prefix.'_form">';
        foreach($comment as $c) {
            $html .= '<div class="'.$style_prefix.'_list_con">';
            $html .= '<div>';
            $uname = $c['uname'] == ''?'匿名评论':$c['uname'];
            $html .= '<div class="l"><b id="uname' . $c['comment_id'] . '">' . $uname . '</b> &nbsp;' . $c['ip_addr'] . ' ' . H :: utf8_substr($c['ip'], 0, strrpos($c['ip'], '.')) . '.* &nbsp; ' . date('Y-m-d H:i:s', $c['date_add']) . '</div>';
            $html .= '</div>';

            $html .= '<div class="'.$style_prefix.'_list_con_bot"><a href="javascript:void(0);" onclick="ready_reply('.$c['comment_id'].');">回复(<span id="recomment' . $c['comment_id'] . '">' . $c['son'] . '</span>)&nbsp;&nbsp;<a href="javascript:void(0);" onclick="cgood(' . $c['comment_id'] . ');">顶(<span id="good' . $c['comment_id'] . '">' . $c['good'] . '</span>)</a>&nbsp;&nbsp;<a href="javascript:void(0);" onclick="cbad(' . $c['comment_id'] . ');">踩(<span id="bad' . $c['comment_id'] . '">' . $c['bad'] . '</span>)</a>&nbsp;&nbsp;</div>';
            if($c['reply']!=''){
                $reply = '<br /><font color=red>管理员回复:{'.$c['reply'].'}</font>';
            } else {
                $reply = '';
            }
            $html .= '<div>' . (!empty($c['is_check']) ? $c['content'].$reply : '<font color="red">*******该评论还未审核</font>') . '</div>';

            $html .= '<div id="replay_frame_'.$c['comment_id'].'"></div>';

            if (isset($c['sons']) && count($c['sons']) > 0) {
                $html .= $this->show_comment($c['sons']);
            }
            $html .= '</div>';
        }

        $html .= '<script type="text/javascript">
            function ready_reply(comment_id){
                try{
                $("#comment_pid").val(comment_id);
                $("#replay_frame_"+comment_id).append($("#comment_reply_box"));
                $("#comment_reply_box").css({"display":""});
                $("#comment_reply").focus();
                }catch(e){alert(e.message)}
            }
            function cgood(comment_id){
                var good=C.cookie.get(\'good\'+comment_id);
                if(good == null) good =0;
                if(typeof(comment_id) =="undefined") return false;
                var comment_id = parseInt(comment_id);
                if(!good){
                $.post("/app/comment/index.php?m=cgood",{comment_id:comment_id},function(data){
                    var res = eval("("+data+")");
                    $("#good"+comment_id).html(res);
                    C.cookie.set(\'good\'+comment_id,comment_id)
                });
                }else{
                    alert(\'不好意思，您已经表态啦~~~\');
                }
            }
            function cbad(comment_id){
            var cbad=C.cookie.get(\'good\'+comment_id);
            if(cbad == null) cbad =0;
                if(typeof(comment_id) =="undefined") return false;
                var comment_id = parseInt(comment_id);
                if(!cbad){
                $.post("/app/comment/index.php?m=cbad",{comment_id:comment_id},function(data){
                    var res = eval("("+data+")");
                    $("#bad"+comment_id).html(res);
                    C.cookie.set(\'good\'+comment_id);

                });
                }else{
                    alert(\'不好意思，您已经表态啦~~~\');
                }
            }
            /*
            function recomment (comment_id,nick) {
                $("#parent_id").val(comment_id);
                $("#comment_id").val(comment_id);
                $("#comment").val("回复["+nick+"]:");
                $("#comment").focus();

            }*/
        </script>';
        $html .= '</div>';
        return $html;
    }

    /*
     *输出发布评表单和生成回复评论表单
     *@param $id 资讯ID
     *@param $style_prefix 样式前缀
     *@return string 返回生成表单HTML
     */
     function getcomment_form($id,$style_prefix="comment") {
        $user_dev = H::user_dev();
        //发布评论表单
        $form = '<div style="margin-top:10px;">';
        $form .= '<input type="hidden" value="' . $id . '" id="id" />';
        $form .= '<input type="hidden" value="0" id="parent_id" />';
        $form .= '<div style="line-height:200%;margin-left:10px;">网友评论仅供网友表达个人看法，并不表明 <strong>' . SITE_NAME . '</strong> 同意其观点或证实其描述</div>';
        $form .= '<div style="margin:5px 10px 0 10px;"><textarea class="'.$style_prefix.'_content" name="comment" id="comment"></textarea></div>';
        $form .= '<div style="margin-top:10px;height:40px;margin-left:10px;">';
        if($user_dev=='pc') {
            $form .= '  <span class="' . $style_prefix . '_l">昵称：<input type="text" id="user" value="' . ((isset($_SESSION['user']['login_name'])) ? $_SESSION['user']['login_name'] : '').'" class="' . $style_prefix . '_ipt" /></span>';
            $form .= '  <span class="' . $style_prefix . '_l">验证码：<input tabindex="4" type="text" id="code" value="" class="' . $style_prefix . '_ipt" style="width:60px;" /><span>';
            $form .= '  <span class="' . $style_prefix . '_l"><img title="点击更换验证码" class="chk_code" id="chk_code" src="/app/vcode/index.php?m=vcode&c=feedback&t='.time().'" style="width:60px;height:25px;margin:-4px 8px 0 6px;vertical-align: middle;" onclick="this.src=\'/app/vcode/index.php?m=vcode&c=feedback&t=\'+Math.random();" /><span>';
            //$form .= '  <span class="' . $style_prefix . '_l"><input id="sub" type="button" onclick="post_comment();" value="发表评论" class="' . $style_prefix . '_ipt" style="width:auto;height:26px;"/><span>';
        }
        $form .= '  <span class="' . $style_prefix . '_l"><a onclick="post_comment();" href="javascript:void(0);" class="but_ok">发表评论</a><span>';
        $form .= '</div>';
        $form .= '</div>';
        $form .= '</div>';

        //生成回复评论表单
        $form .= '<div id="comment_reply_box" style="display:none;margin-top:10px;">';
        $form .= '<div><a href="javascript:void(0);" onclick="$(\'#comment_reply_box\').css({\'display\':\'none\'});">关闭</a></div>';
        $form .= '<input type="hidden" value="' . $id . '" id="id" />';
        $form .= '<input type="hidden" value="0" id="comment_pid" />';
        $form .= '<div style="margin-top:5px;"><textarea id="comment_reply" class="'.$style_prefix.'_content"></textarea></div>';
        $form .= '<div style="margin-top:10px;height:40px;">';
        if($user_dev=='pc') {
            $form .= '  <span class="' . $style_prefix . '_l">昵称：<input type="text" id="user" value="' . ((isset($_SESSION['user']['login_name'])) ? $_SESSION['user']['login_name'] : '').'" class="' . $style_prefix . '_ipt" /></span>';
            $form .= '  <span class="' . $style_prefix . '_l">验证码：<input tabindex="4" type="text" id="code" value="" class="' . $style_prefix . '_ipt" style="width:60px;" /><span>';
            $form .= '  <span class="' . $style_prefix . '_l"><img title="点击更换验证码" class="chk_code" id="chk_code" src="/app/vcode/index.php?m=vcode&c=feedback&t='.time().'" style="width:60px;height:25px;margin:-4px 8px 0 6px;" onclick="this.src=\'/app/vcode/index.php?m=vcode&c=feedback&t=\'+Math.random();" /><span>';
            //$form .= '  <span class="' . $style_prefix . '_l"><input id="sub" type="button" onclick="post_comment(\'reply\');" value="回复评论" class="' . $style_prefix . '_ipt" style="width:auto;height:26px;"/><span>';
        }
        $form .= '  <span class="' . $style_prefix . '_l"><a class="but_ok" href="javascript:void(0);" onclick="post_comment(\'reply\');">回复评论</a><span>';
        $form .= '</div>';
        //$form .= '</div>';



        $form .= '<script>
            function showcomment(id){
                $.post("/app/comment/index.php?m=list",{comment_id:id,t:Math.random()},function(data){
                    $("#comment_list").html(data);
                });
            }
            function sendcomment(){
            var parent_id = $("#parent_id").val();
            var comment = $.trim($("#comment").val());
            var id = $("#id").val();
            var user = $("#user").val();
            var code = $.trim($("#code").val());
            $.post("/app/comment/index.php?m=commentadd",{parent_id:parent_id,comment:comment,comment_id:id,user:user,code:code},function(data){
                 try{
                    var json = $.evalJSON(data);
                    if(json.code > 0){
                        C.alert.alert({"content":"<br>"+json.msg+""});
                        return;
                    }
                    showcomment(id);
                    $(".chk_code").attr({"src":"/app/vcode/index.php?m=vcode&c=feedback&t="+Math.random()});
                    }catch(e){
                        alert(data);
                    }
                });

            }
            //回复和发表评论
            function post_comment(type){
                var formid=\'\';
                var pid=0;
                if(type==\'reply\'){
                    formid=\'comment_reply\';
                    pid=$("#comment_pid").val();
                }else{
                    formid=\'comment\';
                    pid=0;
                }

                var comment=$("#"+formid).val();
                if(comment.replace(/\s*/,\'\').length<2){
                    C.alert.alert({content:\'长度应为2-1000\'});
                    return false;
                }
                //$("#"+formid).val(\'\');
                var id = $("#id").val();
                var user = $("#user").val();
                var code = $.trim($("#code").val());
                $.post("/app/comment/index.php?m=commentadd",{parent_id:pid,comment:comment,comment_id:id,user:user,code:code},function(data){
                    try{
                        var json = $.evalJSON(data);
                        $(".chk_code").attr({"src":"/app/vcode/index.php?m=vcode&c=feedback&t="+Math.random()});
                        if(json.code > 0){
                            C.alert.alert({content:json.msg});
                            return;
                        }

                        showcomment('.$id.');
                    }catch(e){
                        alert(data);
                    }
                });

            }
        </script>';
        return $form;
    }
    /**
     *
     *更新点击次数
     */
    public function update_click($info_id) {
        if($info_id > 0) {
            $sql = "update ".TB_PRE."info_list set info_hits=info_hits+1 where info_id=$info_id";
            $re_sql="update ".TB_PRE."cate_relation set info_hits=info_hits+1 where info_id=$info_id";
            $this->dbm->query_update($sql);
            $this->dbm->query_update($re_sql);
        }
    }
    /**
     * 设置文档分类关系
     * @param $cids 最末级分类ID数组
     * @param $info_id 文档ID
     * @param $del_old 删除老关系
     */
    public function set_info_relation($cids,$info_id,$del_old=0){
        //读取文档信息
        $fields=$this->get_content($info_id,"info_id,create_time,publish_time,update_time,info_diss,info_hits,info_favs,info_downs,info_sells",1);
        if(!$fields) die('{"code":1,"msg":"需要设置分类关系的文档不存在"}');
        //删除老关系
        if($del_old==1){
            $rs=$this->dbm->query_update("delete from ".TB_PRE."cate_relation where info_id='$info_id'");//print_r($rs);
        }//print_r($cids);
        //根据最末CATE_ID重建关系
        foreach($cids as $cid){
            $cid_parent=$this->cate_father($cid);
            foreach($cid_parent as $v){
                $fields['cate_id']=$v['cate_id'];
                $rs=$this->dbm->single_insert(TB_PRE."cate_relation",$fields);
            }
        }

    }
    /**
     * 判断模型表是否存在
     * @param $model_name 模型标识
     */
    public function model_table_exists($model_name){
        //查询全部表
        $sql="show tables";
        $tables=$this->dbm->query($sql);//print_r($tables);

        //查询表是否存在
        $has=false;
        foreach($tables['list'] as $v1){
            if($v1['Tables_in_'.DB_DBNAME]==TB_PRE.$model_name){
                $has=true;break;
            }
        }
        return $has;
    }
    /**
     * 判断模型是否存在，存在则返回定义结构
     * @param $model_name 模型标识
     */
    public function model_exists($model_name){
        $sql="select * from ".TB_PRE."model where model_name='$model_name' limit 1";
        $rs=$this->dbm->query($sql);//print_r($tables);

        if(count($rs['list'])==0) return false;
        $model=$rs['list'][0];

        $sql="select * from ".TB_PRE."model_fields where model_name='$model_name' order by forder asc";
        $rs=$this->dbm->query($sql);
        foreach($rs['list'] as $v){
            $model['fields'][$v['field_name']]=$v;
        }
        $model=H::sqlxss_decode($model);
        return $model;
    }
    /**
     * 获取模型对应的表单HTML
     * @param $model_name 模型标识
     * @param $model_value 表单的默认值array('field_name'=>'value','field_name'=>'value');
     * @param $fields array 隐藏自定义表单的字段（可在后台的 模型->模型设置->模型字段 中获得）array('字段名1','字段名2');
     */
    public function show_model_form($model_name,$model_value,$fields = array()){
        global $V;
        $html='';
        $model_fields = $this->model[$model_name]['fields'];
        if(count($fields) > 0) {
            foreach($fields as $v){
                foreach($model_fields as $kf=>$vf) {
                    if($kf==$v) unset($model_fields[$v]);
                }
            }
        }
        foreach($model_fields as $v){
            if($v['form_show']==0) continue;
            //显示前 预处理某些值 比如日期
            if($v['form_type'] == 'date') {
                $model_value[$v['field_name']] = isset($model_value[$v['field_name']])?date('Y-m-d',$model_value[$v['field_name']]):date('Y-m-d');
            }
            $html.='<tr>';
            $html.='<td style="text-align:right;">';
            if($v['form_check']!='') $html.='<span class="fim">*</span>';
            $html.=$v['field_title'].'：</td>';
            $html.='<td><div style="float:left;margin-left:10px;">'.form_auto($v,$model_value);
            if($v['form_check']!='') $html.='</div><div style="float:left;margin-left:10px;">'.$V->get_field_str('form_check',$v['form_check']).'</div>';
            $html.='</td>';
            $html.='</tr>';
        }
        return $html;
    }

    /**
     * 手机版获取模型对应的表单HTML
     * @param $model_name 模型标识
     * @param $model_value 表单的默认值array('field_name'=>'value','field_name'=>'value');
     * @param $fields array 隐藏自定义表单的字段（可在后台的 模型->模型设置->模型字段 中获得）array('字段名1','字段名2');
     */
    public function show_model_wap_form($model_name,$model_value,$fields = array()){
        global $V;
        $html='';
        $model_fields = $this->model[$model_name]['fields'];
        if(count($fields) > 0) {
            foreach($fields as $v){
                foreach($model_fields as $kf=>$vf) {
                    if($kf==$v) unset($model_fields[$v]);
                }
            }
        }
        foreach($model_fields as $v){
            if($v['form_show']==0) continue;
            //显示前 预处理某些值 比如日期
            if($v['form_type'] == 'date') {
                $model_value[$v['field_name']] = isset($model_value[$v['field_name']])?date('Y-m-d',$model_value[$v['field_name']]):date('Y-m-d');
            }
            $html.='<tr>';
            $html.='<td style="text-align:right;">';
            $html.='<td><div style="float:left;margin-left:10px;">'.form_auto($v,$model_value,$v['field_title']).'</div>';
            $html.='</td>';
            $html.='</tr>';
        }
        return $html;
    }
    /**
     * 判断模型表单的值是否填写正确
     * @param $model_name 模型标识
     * @param $model_value 表单的默认值array('field_name'=>'value','field_name'=>'value');
     */
    public function verify_model_form($model_name,$model_fields){
        foreach($model_fields as $k=>$v){
            $model_fields[$k]=trim($v);
            $field_now=$this->model[$model_name]['fields'][$k];//print_r($field_now);
            switch($field_now['form_check']){
                case 'verify_number':
                    if(!is_numeric($v)) die('{"code":1,"msg":"'.$field_now['field_title'].'：必须是数字"}');
                    break;
                case 'verify_length':
                    if(strlen($v)==0) die('{"code":1,"msg":"'.$field_now['field_title'].'：不能为空"}');
                    break;
                case 'verify_email':
                    $verify=verify::verify_email($v);
                    if($verify!='') die('{"code":1,"msg":"'.$field_now['field_title'].'：'.$verify.'"}');
                    break;
                case 'verify_mobile':
                    $verify=verify::verify_mobile($v);
                    if($verify!='') die('{"code":1,"msg":"'.$field_now['field_title'].'：'.$verify.'"}');
                    break;
                case 'verify_phone':
                    $verify=verify::verify_phone($v);
                    if($verify!='') die('{"code":1,"msg":"'.$field_now['field_title'].'：'.$verify.'"}');
                    break;
                default:
            }
        }
    }
    /**
     * 获取广告位
     * @param $area_id 广告位id
     * @param $is_return 是否直接返回 图片数组 默认 0=不返回
     */
    public function get_ad($area_id,$is_return=0) {
        $rs = $this->dbm->query("select * from ".TB_PRE."adv where area_status=1 and area_id=".intval($area_id)." limit 1");
        if(count($rs['list']) ==0) return '广告位ID有误';
        //代码广告
        if($rs['list'][0]['area_type'] == 'code') {echo htmlspecialchars_decode($rs['list'][0]['area_html']); return;}
        $rs['img_list'] = $this->dbm->query("select * from ".TB_PRE."adv_img where img_status=0 and area_id=".intval($area_id)." order by img_order asc");
        //直接返回
        if($is_return) return $rs['img_list']['list'];
        //单张图片直接输出
        if(count($rs['img_list']['list']) == 1) {
            if($rs['img_list']['list'][0]['go_url']) {
                echo '<a href="'.$rs['img_list']['list'][0]['go_url'].'"><img src="'.$rs['img_list']['list'][0]['img_url'].'" onerror="original_img(this)"/></a>';
            }else{
                echo '<img src="'.$rs['img_list']['list'][0]['img_url'].'" onerror="original_img(this)"/>';
            }
            return;
        }
        //遍历输出
        foreach($rs['img_list']['list'] as $k=>$v) {
            echo '<li><a href="'.$v['go_url'].'"><img src="'.$v['img_url'].'" onerror="original_img(this)" alt="'.$v['img_title'].'"/></a></li>';
        }
    }
    /**
     * 获取友情链接（按分组或者全部）
     * @param $fgroup 友情链接分组id
     */
    public function get_flink($fgroup='') {
        $sql="select * from ".TB_PRE."flink";
        $where="";

        if($fgroup!='') $where.=" and fgroup='$fgroup'";

        $where=substr(trim($where),4);
        if($where!='') $sql.=" where ".$where;
        $rs=$this->dbm->query($sql);
        return $rs['list'];
    }
    /**
     * 获取导航
     * @param $params 参数
     */
    public function get_cate($params=array()) {
        global $topid,$cid;
        $params['class']=isset($params['class'])?$params['class']:'current';
        $params['cate_id']=isset($params['cate_id'])?$params['cate_id']:0;
        $params['level']=isset($params['level'])?$params['level']:'all';
        if($params['cate_id']=='topid') $params['cate_id']=$topid;
        if($params['cate_id']=='cid') $params['cate_id']=$cid;

        if(!isset($this->categories[$params['cate_id']]) && intval($params['cate_id'])>0) return array();
        $data=$this->categories;

        //当前分类子分类
        if($params['level']=='son') $data=$this->categories[$params['cate_id']]['son'];
        //当前分类平级分类
        if($params['level']=='brother') $data=$this->categories[$this->categories[$params['cate_id']]['parent_id']]['son'];
        //当前分类平级分类
        if($params['level']=='father') $data=$this->cate_father($params['cate_id']);
        //返回自身信息$
        if($params['level']=='self') $data=array($this->categories[$params['cate_id']]);
        $list=array();
        foreach($data as $v){
            $v['class']='';
            if($cid==$v['cate_id'] || $topid==$v['cate_id']) $v['class']=$params['class'];
            if($params['level']=='all') {
                if ($v['nav_show'] == 1) array_push($list, $v);
            }else{
                array_push($list, $v);
            }
        }
        return $list;
    }
    /**
     * 设置最近浏览
     * @param $info_id
     */
    public function recently_viewed($info_id) {
        $arr = isset($_COOKIE['recently_viewed']) ? json_decode($_COOKIE['recently_viewed']) : array();
        if(in_array($info_id,$arr)) {
            foreach($arr as $k=>$v) {
                if($v == $info_id && $k>0) {
                    $tmp = $arr[$k-1];
                    $arr[$k] = $arr[$k-1];
                    $arr[$k-1] = $v;
                }
            }
        }else{
            array_unshift($arr,$info_id);
            if(count($arr)>5) array_pop($arr);
        }
        H::set_cookie('recently_viewed',json_encode($arr));
    }
    /**
     * 获取最近浏览的数据
     */
    public function get_recently_viewed() {
        $arr = isset($_COOKIE['recently_viewed']) ? json_decode($_COOKIE['recently_viewed']) : array();
        $tmp = array();
        foreach($arr as $v) {
            $v = intval($v);
            if($v<=0) continue;
            $rs = $this->get_content($v);
            if(!$rs) continue;
            $tmp[] = $rs;
        }
        return $tmp;
    }

}

?>