<?php
/*
 * MCMS Copyright (c) 2012-2013 ZhangYiYeTai Inc.
 *
 *  http://www.mcms.cc
 *
 * The program developed by loyjers core architecture, individual all rights reserved,
 * if you have any questions please contact loyjers@126.com
 */

/**
 * 检查用户是否登陆，如果没有登录，跳转到登录页面
 * @param $url 跳转路径
 * @param $ajax 是否ajax请求，默认为非ajax请求
 */
function check_login($ajax=0,$url='login.php') {
    if (!isset($_SESSION['user']) || !is_array($_SESSION['user'])) {
        session_destroy();
        if(intval($ajax)==1){//如果是ajax请求，返回JSON串
            die('{"code":1,"msg":"登录状态失效，请重新登录","url":"'.$url.'"}');
        }
        //否则直接跳转
        header("Location: $url");
        die();
    }
    if(isset($_SESSION['user']['login_from']) && $_SESSION['user']['login_from']=='front' && !strstr(str_replace('\\','/',$_SERVER['PHP_SELF']),'/app/user/')){
        H::error_show('{"code":1,"msg":"前台用户不允许登录后台","url":"'.$url.'"}');
    }
}


/**
 * 检查用户是否有合法的操作权限
 * @param  $level 需要判断的权限值
 * @param  $ajax 是否ajax请求
 * @param  $return   是否返回 1=返回 true,false 0，按是否ajax状态输出信息
 */
function check_level($level,$ajax=0,$return=0) {
    $has_level=false;
    //分解登录后的用户权限代码
    $group_level=explode(',',isset($_SESSION['user']['group_level'])?$_SESSION['user']['group_level']:'');//组权限
    $user_level=explode(',',isset($_SESSION['user']['login_level'])?$_SESSION['user']['login_level']:'');//用户允许权限
    $user_no_level=explode(',',isset($_SESSION['user']['login_no_level'])?$_SESSION['user']['login_no_level']:'');//用户禁止权限
    //重组权限代码
    $level_all=array();
    foreach($group_level as $v) $level_all[$v]=$v;
    foreach($user_level as $v) $level_all[$v]=$v;
    foreach($user_no_level as $v) if(isset($level_all[$v])) unset($level_all[$v]);
    //如果需要判断的权限代码是分类权限
    if(substr($level,0,1)=='T'){
        //如果有分类页面权限
        if(in_array('A02',$level_all)){//echo($level);
            $has_level=true;
        }
    }
    //系统管理员权限默认为100
    if(isset($_SESSION['user']['group_level']) && $_SESSION['user']['group_level'] == 100) {
        $has_level=true;
    }else{
        if(in_array($level,$level_all)){
            $has_level=true;
        }
    }
    //如果需要返回 true false
    if($return) return $has_level;
    //没有权限,终止信息
    if(!$has_level){
        if($ajax==1){
            die('{"code":1,"msg":"没有权限，请联系管理员"}');
        }else{
            H::error_show('{"code":1,"msg":"没有权限，请联系管理员"}');
        }
    }
}

/**
 * 动作处理函数调用，占用固定GET参数 m
 */
function call_mfunc(){

    $_GET['m'] = isset($_GET['m'])?$_GET['m']:'list';
    $_GET['m']=H::sqlxss($_GET['m']);
    if (function_exists("m__" . $_GET['m'])) {
        call_user_func("m__" . $_GET['m']);
    }else{
        if($_GET['m']!='list'){
            die(' <b>m__'.$_GET['m'].'</b> function is not exists(Code:003)');
        }
    }
}

/**
 * 调用模板,$file 为当前主程序的文件名，需要根据文件名去找对应目录的模板文件,$app_dir 应用目录名称
 */
function assign_tpl($file, $app_dir = '',$tpl_prefix='tpl.',$is_die=1) {
    $visit = isset($_COOKIE['visit']) ? $_COOKIE['visit'] : 0;
    if(!defined('INC_MCMS')) define('INC_MCMS',1);//防止直接访问模板页面
    $tpl_arr=explode(',',TPL_SORT);//模板查找顺序
    //判断浏览设备
    $device=H::user_dev();
    $skin=SKIN;
    
    if($visit == 1) {
        $device = 'pc';
    }
    if($visit== 2) {
        $device = 'wap';
    }
    //判断需要判断的浏览设备目录
    $loop_dev=0;
    foreach($tpl_arr as $k=>$v){
        if($device==$v) {
            $loop_dev=$k;break;
        }
    }
    //判断独立域名
    if(defined('DOMAIN_WAP') && DOMAIN_WAP==$_SERVER['HTTP_HOST']){
        $device='wap';
    }
    $app_dir=($app_dir=='')?'':$app_dir.'/';
    $error='';
    //指定设备+指定皮肤
    $tpl_file = ROOT_PATH.'/app_tpl_'.$device.'/'.$skin.'/'.$app_dir.$tpl_prefix.$file;
    if(file_exists($tpl_file)){
        $error='';
    }else{
        $error='The file does not exist : '.$tpl_file.'<br>';//echo($error);
        //指定设备+默认皮肤
        $tpl_file = ROOT_PATH.'/app_tpl_'.$device.'/default/'.$app_dir.$tpl_prefix.$file;
        if(file_exists($tpl_file)){
            $error='';
        }else{
            $error='The file does not exist : '.$tpl_file.'<br>';//echo($tpl_file);
            //其他设备
            for($i=$loop_dev;$i<count($tpl_arr);$i++){
                $tpl_file = ROOT_PATH.'/app_tpl_'.$tpl_arr[$i].'/'.$skin.'/'.$app_dir.$tpl_prefix.$file;//echo($tpl_file);
                if(file_exists($tpl_file)){
                    $error='';break;
                }else{
                    $error='The file does not exist : '.$tpl_file.'<br>';//echo($error);
                    //其他设备+默认皮肤
                    $tpl_file = ROOT_PATH.'/app_tpl_'.$tpl_arr[$i].'/default/'.$app_dir.$tpl_prefix.$file;
                    if(file_exists($tpl_file)){
                        $error='';
                    }else{
                        $error='The file does not exist : '.$tpl_file.'<br>';//echo($error);
                    }
                }
            }
        }
    }

    //返回模板
    if ($error=='') {//echo($tpl_file);
        if(!defined('TPL_CACHE_TIME')) return $tpl_file;
        /*
        //开启模板引擎，处理标签
        if (strpos($tpl_file,'/cms/')>0 || strpos($tpl_file,'/inc.')>0 || strpos($tpl_file,'/widget')>0 ) {
            $tpl_file_cache=ROOT_PATH . '/config/cache/templates/' . $file . '/'.$device.'.' . md5($tpl_file) . '.php';
            $time_expire=false;//缓存过期
            if(TPL_CACHE_TIME>0 && file_exists($tpl_file_cache) && time() - filemtime($tpl_file_cache) > TPL_CACHE_TIME*60) $time_expire=true;
            if(TPL_CACHE_TIME==0) $time_expire=true;
            if (!file_exists($tpl_file_cache) || $time_expire) {//echo('123');
                //HTML模板标签处理
                $tpl_tmp=file_get_contents($tpl_file);
                $tpl_tmp=TPL::parse($tpl_tmp,$tpl_file_cache);
                //创建模板目录
                H::mkdirs(ROOT_PATH . '/config/cache/templates/' . $file);
                //写入缓存
                file_put_contents($tpl_file_cache, $tpl_tmp);
            }
            //返回缓存模板
            return $tpl_file_cache;
        }
        */
        //不使用模板引擎
        return $tpl_file;
    }else{
        H :: logs('file_not_exists_', $error);
        if($is_die){
            die($file.' : The file does not exist, may be affected by the impact of directory permissions(Code:001)');
        }else{
            return '';
        }
    }
}

/**
 * 包含皮肤目录里的顶级文件，如头部文件，尾部文件 $file=inc.head.php,inc.foot.php 等
 */
function assign_tpl_inc($file,$is_die=0) {
    $tpl_file=  assign_tpl($file,"","",0);
    if($tpl_file==''){
        $error='The file does not exist : '.$file.'<br>';//echo($error);
        H :: logs('file_not_exists_', $error);
        if($is_die){
            die($file.' : The file does not exist, may be affected by the impact of directory permissions(Code:002)');
        }else{
            return '';
        }
    }else{
        return $tpl_file;
    }
}

/**
 * 输出用户登录后功能菜单
 */
function user_menu(){
    global $global_menu;//print_r($global_menu);
    $template='';
    if (isset($_SESSION['user']) && is_array($_SESSION['user'])) {
        // 显示菜单
        echo('<ul>');
        foreach($global_menu as $a) {
            if(isset($a['hidden']) && $a['hidden']=='1') continue;
            // 验证权限
            if (!check_user_level($a['level']) && !check_group_level($a['level'])) continue;

            echo('<li>');
            // 获取子导航的第一个地址。给父导航显示连接地址
            foreach($a['sonmenu'] as $son) {//print_r($son);
                if(isset($son['hidden']) && $son['hidden']=='1') continue;
                // 验证权限
                if (!check_user_level($son['level']) && !check_group_level($son['level'])) continue;
                if (check_user_level($son['level']) || check_group_level($son['level'])) {
                    echo('<a href="' . $son['url'] . '" class="menu_1">' . $a['title'] . '</a>');
                    break;
                }
            }
            foreach($a['sonmenu'] as $b) {
                if(isset($b['hidden']) && $b['hidden']=='1') continue;
                // 验证权限
                if (!check_user_level($b['level']) && !check_group_level($b['level'])) continue;
                $current = '';
                if($_SERVER["PHP_SELF"]==$b['url']) $current=' current';
                echo('<a href="' . $b['url'] . '" class="menu_2' . $current . '">' . $b['title'] . '</a>');
            }
            echo('</li>');
        }
        echo('</ul>');
    }
}

/**
 * 输出权限子菜单
 */
function son_menu($level){
    global $global_struct;
    foreach($global_struct as $v){
        if($v['level']==$level){
            $i=0;
            foreach($v['sonmenu'] as $v1){
                if($i>0 && $i%11==0) echo('<li style="clear:both;margin:0;padding:0;height:10px;display:block;width:100%;"></li>');
                // 验证权限
                if (!check_level($v1['level'],0,1)) continue;
                if (isset($v1['hidden'])) continue;
                if($v1['url']==pathinfo($_SERVER['PHP_SELF'],PATHINFO_BASENAME)) {
                    $class=' class="current"';
                }else{
                    $class='';
                }
                echo('<li><a href="'.$v1['url'].'"'.$class.'>'.$v1['title'].'</a></li>');
                $i++;
            }

        }
    }
}
/**
 * 查找第一个有权限的URL
 */
function find_first_page(){
    global $global_struct;
    foreach($global_struct as $v){
        foreach($v['sonmenu'] as $v1){
            if(check_level($v1['level'],0,1)) return $v1['url'];
        }
    }
    return '';
}
/**
 * 操作日志记录，每进行一次操作都需要记录一次
 * @param  $content 要记录的内容
 * @param $type 用户登录=1 用户管理=2 禁止/解禁用户=3 文档操作=4 类别操作=5 模型操作=6 广告操作=7 数据备/份还原=8
 */
function logs($content = '',$type=0,$obj_id=0) {
    global $dbm;
    $params['uid'] = isset($_SESSION['user'])?$_SESSION['user']['uid']:0;
    $params['uname'] = isset($_SESSION['user'])?$_SESSION['user']['login_name']:'';
    $params['create_time'] = time();
    $params['log_type']=$type;
    $params['ip'] = H :: getip();
    $params['obj_id']=intval($obj_id);
    $params['content'] = H::sqlxss($content);
    $rs = $dbm -> single_insert(TB_PRE."log", $params);
    if ($rs['error']!='') {
        die('{"code":"1","msg":"日志插入错误'.$rs['error'].'"}');
    }
}

/* 计算URL
 * @key URL参数名
 * @val URL参数值
 * @txt 链接文字
 */
function surl($key,$val,$txt){
    global $get_params;
    $getarr=array();
    foreach($get_params as $v){
        $_GET[$v]=isset($_GET[$v])?$_GET[$v]:'';
        if($key==$v){
            array_push($getarr,$v."=".$val);
        }else{
            if($_GET[$v]!='')
            array_push($getarr,$v."=".$_GET[$v]);
        }
    }
    $url=implode('&',$getarr);
    if($val==$_GET[$key]){
        return '<a href="javascript:void(0);" class="selected">'.$txt.'</a>';
    }else{
        return '<a href="?'.$url.'">'.$txt.'</a>';
    }
}

/* 组合url
 * @script_file 要组合的url文件名或路径
 * @txt URL a链接文字
 * @get_params URL参数值需要传入数组 k为参数名，v参数值
 */
function http_url($script_file='',$txt='',$get_params=array()){
    
    if(count($get_params)>0) {
        $url = http_build_query($get_params);
    } else {
        $getarr = array();
        if(count($_GET)>0) {
            foreach($_GET as $k=>$v) {
                array_push($getarr,$k."=".$v);
            }
        }
        $url=implode('&',$getarr);
    }
    if($script_file=='') $script_file = $_SERVER['SCRIPT_NAME'];
    return '<a href="'.$script_file.'?'.$url.'">'.$txt.'</a>';
}

/**
 * 获取分页大小
 *
 * @param 默认分页大小 默认10
 */
function get_pagesize($pagesize=10) {
	global $V;
    $key = isset($_SERVER['SCRIPT_FILENAME'])?$_SERVER['SCRIPT_FILENAME']:$_SERVER['SCRIPT_NAME'];
	$key = str_replace(array('\\','.'),array('/','_'),$key);
    $key = explode('/',$key);
    $key = 'page_'.substr($key[count($key)-2].'_'.$key[count($key)-1],0,-4);
    if(isset($_COOKIE[$key])) {
		$pages = $V->get_fields('pagesize');
        foreach($pages as $v) {
            if($_COOKIE[$key] == $v['value']) {$pagesize = $_COOKIE[$key]; break;}
        }
    }
    return $pagesize;
}


/**
 * 获取微信自定义菜单列表
 *
 * @param $order 排序
 */
function menu_list($order='asc'){
    global $dbm,$C;
    $rs=$dbm->query("select * from ".TB_PRE."weixin_menu where parent_id=0 order by menu_order $order");
    $menu=array();
    foreach($rs['list'] as $n=>$m){ $menu[$m['menu_id']] = $m; }
    foreach($menu as $k=>$v){
        $menu[$k]['menu_key_url']=($v['menu_type']=='view')?$v['menu_url']:$v['menu_key'];
        $rs=$dbm->query("select * from ".TB_PRE."weixin_menu where parent_id='{$v['menu_id']}' order by menu_order asc");
        foreach($rs['list'] as $a=>$b){
            if($b['menu_type']=='click'){
                $rs['list'][$a]['menu_key_url']=$b['menu_key'];
            }else{
                $rs['list'][$a]['menu_key_url']=$b['menu_url'];
            }
        }
        $menu[$k]['son']=$rs['list'];
    }

    return $menu;
}

/**
 * 保存配置
 *
 * @param  $name 名称
 * @param  $value 值
 * @param  $ &$file  配置文件引用
 */
function set_config($name, $value, &$file) {
    if (!isset($value)) $value = '';
    if (preg_match('~"' . $name . '"~', $file)) {
        $file = preg_replace('~define\("' . $name . '"\s*,\s*"(.*)"\)\s*;~i', 'define("' . $name . '", "' . $value . '");', $file, 1);
    } else {
        $file .= chr(13) . chr(10) . 'define("' . $name . '","' . $value . '");';
    }
}

/**
 * 自动表单
 *
 * @param  $form 表单数组
 * @param $value 默认值数组
 * @param $title placehoder 提示文字
 * @code 绑定的代码位数组
 */
function form_auto($form,$value=array(),$title='',$code=array()) {
    global $V,$T;
    $type = $form['form_type'];
    $name = $form['field_name'];
    $form_value = $form['form_value'];//print_r($form);print_r($value);die();
    if(count($value)>0 && isset($value[$name])){ $v = $value[$name];} else { $v=''; }
    $html = '';
    if ($type == 'text') { // 文本框
        $html .= '<input placeholder="' . $title . '" type="text" class="comm_ipt" id="extern___' . $name . '" name="extern___' . $name . '" value="' . $v . '">';
        if($form_value!='') $html.=' <span style="color:#888;">如：'.$form_value.' , </span>';
    }
    if ($type == 'textarea') { // 多行文本框
        $html .= '<textarea placeholder="' . $title . '" class="comm_ipt" style="height:50px;" id="extern___' . $name . '" name="extern___' . $name . '">' . $v . '</textarea>';
    }
    if ($type == 'checkbox') { // 复选框
        $fv = explode('|', $form_value);
        $fvarr=array();
        foreach($fv as $vs){
            $fvarr[$vs]=$vs;
        }
        //如果存在代码位则覆盖
        if(isset($T->trees[$form_value])){
            $fvarr=array();
            foreach($T->trees[$form_value]['son'] as $vs){//print_r($vs);die();
                //array_push($fvarr,array($vs['code_id']=>$vs['txt']));
                $fvarr[$vs['code_id']]=$vs['txt'];
            }
        }
        $tmpa=array();
        foreach($fvarr as $ks=>$vs) {
            array_push($tmpa,array('txt'=>$vs,'value'=>$ks));
        }
        $html .= '</select>';
        //vars::$fields['extern___'.$name]=$tmpa;
        $V->set_fields('extern___'.$name,$tmpa);
        $html=$V->input_str(array('node'=>'extern___'.$name,'type'=>'checkbox','default'=>$v));
    }
    if ($type == 'select_single') { // 单选下拉框
        $fv = explode('|', $form_value);
        $fvarr=array();
        foreach($fv as $vs){
            $fvarr[$vs]=$vs;
        }
        //如果存在代码位则覆盖
        if(isset($T->trees[$form_value])){
            $fvarr=array();
            foreach($T->trees[$form_value]['son'] as $vs){//print_r($vs);die();
                //array_push($fvarr,array($vs['code_id']=>$vs['txt']));
                $fvarr[$vs['code_id']]=$vs['txt'];
            }
        }
        $tmpa=array(array('txt'=>'请选择','value'=>''));
        foreach($fvarr as $ks=>$vs) {
            array_push($tmpa,array('txt'=>$vs,'value'=>$ks));
        }
        //vars::$fields['extern___'.$name]=$tmpa;
        $V->set_fields('extern___'.$name,$tmpa);
        $html=$V->input_str(array('node'=>'extern___'.$name,'type'=>'select_single','default'=>$v));
    }
    if ($type == 'select_multi') { // 多选下拉框
        $fv = explode('|', $form_value);
        $fvarr=array();
        foreach($fv as $vs){
            $fvarr[$vs]=$vs;
        }
        //如果存在代码位则覆盖
        if(isset($T->trees[$form_value])){
            $fvarr=array();
            foreach($T->trees[$form_value]['son'] as $vs){//print_r($vs);die();
                //array_push($fvarr,array($vs['code_id']=>$vs['txt']));
                $fvarr[$vs['code_id']]=$vs['txt'];
            }
        }
        $tmpa=array();
        foreach($fvarr as $ks=>$vs) {
            array_push($tmpa,array('txt'=>$vs,'value'=>$ks));
        }
        //vars::$fields['extern___'.$name]=$tmpa;
        $V->set_fields('extern___'.$name,$tmpa);
        $html=$V->input_str(array('node'=>'extern___'.$name,'type'=>'select_multi','default'=>$v));
    }
    if ($type == 'date') { // 日期选择
        // $html .='<div style="position:absolute;">';
        $html .= '<input placeholder="' . $title . '" type="text" class="comm_ipt" id="extern___' . $name . '" name="extern___' . $name . '" value="'.$v.'"  onclick="new Calendar().show(this);">';
        // $html .='</div>';
    }
    if ($type == 'image') { // 上传控件
        $html = '<div><div style="float:left;"><input placeholder="' . $title . '" type="text" class="comm_ipt" id="extern___' . $name . '" name="extern___' . $name . '" value="' . $v . '"></div>';
        $html .='<div style="float:left;width:119px;height:30px;overflow:hidden;margin-right:10px;">';
        $html .='<iframe src="/app/cms/upload.form.php?type=single_upload&id=extern___' . $name.'" width="100%" scrolling="no" height="100%" frameborder="no" allowtransparency="yes" marginheight="0"  border="0" marginwidth="0"></iframe>';
        $html .='</div>';
    }
    if($type=='editor'){
        $html .='<textarea name="extern___' . $name . '" id="extern___' . $name . '" style="display:block">'.$v.'</textarea>';
        $html .='<script type="text/javascript">';
        $html .='    var extern___' . $name . ' = CKEDITOR.replace( "extern___' . $name . '",{height:150,width:"95%",skin:"kama",menu_subMenuDelay:0,';
        $html .=' toolbar : ckeditor_toolbar';
        $html .='   });';
        $html .='</script>';
    }

    return $html;
}

//打印函数
function P() {
    $args=func_get_args();
    if(count($args)<1){
        echo '必须为p()函数提供参数!';
        return;
    }
    echo '<div style=\'width: 100%; text-align: left; margin: 15px 0px; clear: both;\'><pre>';
    foreach($args as $arg){
        if(is_array($arg)){
            print_r($arg);
            echo '<br>';
        }else if(is_string($arg)){
            echo $arg.'<br>';
        }else{
            var_dump($arg);
            echo '<br>';
        }
    }
    echo '</pre></div>';
}


/*
 *短信发送函数
 *
 */
function send_sms($phone='',$msg=''){
    require_once(ROOT_PATH."/class/yuntongxun.sdk.class.php");
     // 初始化REST SDK
    $rest = new REST(YTX_SERVER_IP,YTX_SERVER_PORT,YTX_VERSION);
    $rest->setAccount(YTX_ACCOUNT_SID,YTX_ACCOUNT_TOKEN);
    $rest->setAppId(YTX_APPID);
    // 发送模板短信
    $result = $rest->sendTemplateSMS($phone,array($msg,'60'),YTX_SMS_TPL);
    
    if($result == NULL) {
        die('{"code":1,"msg":"发送失败"}');
    }
    if(intval($result['statusCode'])==0){
        die('{"code":0,"msg":"发送成功，请查看手机短信"}');
    }else{
        die('{"code":1,"msg":"'.$result['statusMsg'].'"}');
    }
}

/*
 *发送邮件
 */
function send_mail($send_email='',$email_title='',$email_tpl=''){
    require_once(ROOT_PATH."/class/phpmailer/class.phpmailer.php");
    require_once(ROOT_PATH."/class/phpmailer/class.smtp.php");
    $mail = new phpMailer();
    $mail -> IsSMTP();
    $mail -> SMTPAuth = true;
    $mail -> Host = SMTP_HOST;
    $mail -> Username = SMTP_UNAME;
    $mail -> Password = SMTP_UPASS;
    $mail -> IsHTML(true);
    $mail -> CharSet = 'utf-8';
    $mail -> From = SMTP_UNAME;
    $mail -> FromName = SITE_NAME;
    $mail -> AddAddress($send_email);
    $mail -> Subject = SITE_NAME.$email_title;
    $mail -> Body = str_replace(array('\n','\r',chr(10),chr(13)), '<br>', $email_tpl);
    if (!$mail -> Send()) {
        $result = $mail -> ErrorInfo;
        die('{"code":0,"msg":"发送失败 '.$result.'"}');
    }
    return true;
}




 /**
 * 是否为AJAX提交
 * @return boolean
 */
function ajax_request() {
	if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest')
		return true;
	return false;
}

//判断是否拥有文档的所属分类权限
function check_info_cate_level($info_id,$ajax=1){
    global $dbm;
    //非系统管理员组判断是否有分类权限
    if($_SESSION['user']['group_level']!='100') {
        $sql = "select cate_id from " . TB_PRE . "cate_relation where info_id='$info_id'";
        $rs = $dbm->query($sql);//print_r($rs);die();
        $has_level=false;
        foreach ($rs['list'] as $v) {
            if(check_level('T'.$v['cate_id'],0,1)) {
                $has_level=true;break;
            }
        }
        if(!$has_level) {
            if($ajax==1){
                die('{"code":"1","msg":"没有该文档的分类权限"}');
            }else{
                H::error_show ('{"code":"1","msg":"没有该文档的分类权限"}');
            }

        }
    }
}
/**
 * 
 * 插件开发者的功能函数文件 /class/function 目录中，文件名以 “插件名称.php” 的格式命名比较好，防止跟其他开发者冲突
 */
foreach(glob(dirname(__FILE__).'/function/*.php') as $v){
    @require_once($v);
}

