<?php
class TPL{
    public static function parse($con,$tpl_file_cache=''){
        //处理主模板中区域模板
        $con = TPL::parse_inc($con,$tpl_file_cache);
        //处理访问权限
        $con = TPL::parse_access($con);
        //处理常量
        $con = TPL::parse_const($con);
        //处理字符串变量
        $con = TPL::parse_var($con);
        //处理PHP代码
        $con = TPL::parse_php($con);
        //处理6层循环
        $con = TPL::parse_loop($con);
        if(strpos($con,'<mcms:list')>0)
            $con = TPL::parse_loop($con);
        if(strpos($con,'<mcms:list')>0)
            $con = TPL::parse_loop($con);
        if(strpos($con,'<mcms:list')>0)
            $con = TPL::parse_loop($con);
        if(strpos($con,'<mcms:list')>0)
            $con = TPL::parse_loop($con);
        if(strpos($con,'<mcms:list')>0)
            $con = TPL::parse_loop($con);
        //die($con);
        return $con;
    }
    /**
     * 获取属性字符串种某个属性的值
     * @param  $level 属性字符串
     * @param  $attr_name 属性名称
     * @param  $return   返回某个节点的属性值，不存在则返回空值
     */
    public static function get_attr($node_str,$attr_name){
        $attrs=TPL::get_attrs($node_str);
        if(isset($attrs[$attr_name])){
            return $attrs[$attr_name];
        }else{
            return '';
        }
    }
    //同上，获取所有属性
    public static function get_attrs($node_str){
        preg_match_all('~([^\s]*?)="([^\s]*?)"~',$node_str,$arr);//print_r($arr);
        $attrs=array();
        foreach($arr[0] as $k=>$v){
            $attrs[strtolower(trim($arr[1][$k]))]=trim($arr[2][$k]);
        }
        return $attrs;
    }

    //处理常量值标签
    public static function parse_const($con){
        preg_match_all('~<mcms:const\s([^>]*)/>~',$con,$a);
        //print_r($a[0]);die();
        $nodes=$a[0];//全部节点
        $attrs=$a[1];//属性
        foreach($nodes as $k=>$v) {
            $const_name=strtoupper(TPL::get_attr($attrs[$k],'name'));
            $rule='~' . $v . '~';
            $replace='<?php echo(defined(\'' . $const_name . '\')?' . $const_name . ':\'\');?>';//echo($rule);echo($replace);
            $con = preg_replace($rule, $replace, $con);
        }
        return $con;
    }
    //处理字符串变量值标签
    public static function parse_var($con){
        preg_match_all('~<mcms:(echo|print_r|var_dump)\s([^>]*)/>~',$con,$a);
        //print_r($a);die();
        $nodes=$a[0];//全部节点
        $func=$a[1];//属性
        $attrs=$a[2];//属性
        foreach($nodes as $k=>$v) {
            $var_name=TPL::get_attr($attrs[$k],'name');
            if(strpos($var_name,'<<')>0) $var_name=str_replace('<<','->',$var_name);//替换类符号->
            if(strpos($var_name,'<')>0) {//替换数组下标
                $var_name_arr=explode('<',$var_name);
                $tmp='';
                foreach($var_name_arr as $k2=>$v2) {
                    if($k2==0) $tmp .= $v2 . "['";
                    if($k2>0 && $k2<count($var_name_arr)-1) $tmp .= $v2."']['";
                    if($k2==count($var_name_arr)-1) $tmp .= $v2 . "']";
                }
                $var_name=$tmp;
            }

            $rule='~' . $v . '~';
            $replace='<?php '.$func[$k].'($'.$var_name.');?>';//echo($rule);echo($replace);
            $con = preg_replace($rule, $replace, $con);
        }
        return $con;
    }

    //处理单层循环
    public static function parse_loop($con){
        preg_match_all('~(<mcms:list\s([^>]*)>)((?:(?!<mcms:list).|\n)*?)(</mcms:list>)~',$con,$a);
        //print_r($a);die();
        $nodes=$a[0];//全部节点
        $start=$a[1];//<mcms 属性>
        $attrs=$a[2];//属性
        $body=$a[3];//内容
        $end=$a[4];//</mcms>
        foreach($nodes as $k=>$v) {
            $rule = '~' . $start[$k] . '[\w\W]*?' . $end[$k] . '~';//echo($rule);

            $rstart = '';
            //判断循环数据源
            $attr_list = TPL::get_attrs($attrs[$k]);//print_r($attr_list);
            $attr_func = TPL::get_attr($attrs[$k], 'func');
            $attr_key = TPL::get_attr($attrs[$k], 'key');

            //取文档
            if ($attr_func == 'get_list') {
                $rstart = '<?php $a=$C->get_list(' . H::array_eval($attr_list) . ');foreach($a[\'list\'] as $' . ($attr_key==''?'v':$attr_key) . '){ ?>';
            }
            //取广告
            if ($attr_func == 'get_ad') {
                $attr_area_id = intval(TPL::get_attr($attrs[$k], 'area_id'));
                $rstart = '<?php $a=$C->get_ad(' . $attr_area_id . ',1);foreach($a as $' . ($attr_key==''?'v':$attr_key) . '){ ?>';
            }
            //取导航
            if ($attr_func == 'get_cate') {
                $rstart = '<?php $a=$C->get_cate(' . H::array_eval($attr_list) . ',1);foreach($a as $' . ($attr_key==''?'v':$attr_key) . '){ ?>';
            }
            //取文档
            if ($attr_func == 'get_content'){
                $attr_info_id=TPL::get_attr($attrs[$k], 'info_id');
                $rstart = '<?php $a=array($C->get_content(' . $attr_info_id . '));foreach($a as $' . ($attr_key==''?'v':$attr_key) . '){ ?>';
            }
            //取友链
            if ($attr_func == 'get_flink') {
                $attr_group_name=TPL::get_attr($attrs[$k], 'group_name');
                $rstart = '<?php $a=$C->get_flink(\'' . $attr_group_name . '\');foreach($a as $' . ($attr_key==''?'v':$attr_key) . '){ ?>';
            }

            //如果是数组
            $attr_data=TPL::get_attr($attrs[$k], 'data');
            if($attr_data !=''){
                $var_name=$attr_data;
                if(strpos($var_name,'<<')>0) $var_name=str_replace('<<','->',$var_name);//替换类符号->
                if(strpos($var_name,'<')>0) {//替换数组下标
                    $var_name_arr=explode('<',$var_name);
                    $tmp='';
                    foreach($var_name_arr as $k2=>$v2) {
                        if($k2==0) $tmp .= $v2 . "['";
                        if($k2>0 && $k2<count($var_name_arr)-1) $tmp .= $v2."']['";
                        if($k2==count($var_name_arr)-1) $tmp .= $v2 . "']";
                    }
                    $var_name=$tmp;
                }

                $rstart = '<?php foreach($'.$var_name.' as $k=>$' . ($attr_key==''?'v':$attr_key) . '){ ?>';
            }

            $rend = '<?php } ?>';

            if ($rstart != '') {
                //替换循环区内变量
                $rbody = TPL::parse_loop_var($body[$k], $attr_key);

                $replace = $rstart . $rbody . $rend;//echo($replace);
                $con = preg_replace($rule, $replace, $con);
            }
        }
        return $con;
    }

    //处理循环值标签
    public static function parse_loop_var($con,$key){//die($con);
        if($key=='') {
            $key='v';
            preg_match_all('~<mcms:([^>]*?)/>~', $con, $a);
        }else{
            preg_match_all('~<mcms:'.$key.':([^>]*?)/>~', $con, $a);
        }
        //print_r($a);die();
        $nodes=$a[0];//全部节点
        $body=$a[1];//属性字符串
        foreach($nodes as $k=>$v) {
            $value_name = trim($body[$k]);
            $vars=$key.'[\'' . $value_name . '\']';
            if($value_name=='') $vars=$key;
            $con = preg_replace('~' . $v . '~', '<?php echo($'.$vars.');?>', $con);
        }
        return $con;
    }
    //处理访问权限
    public static function parse_access($con){
        $con=preg_replace('~<mcms:access/>~','<?php if(!defined(\'INC_MCMS\')) die(\'No Access !\');?>',$con);
        return $con;
    }
    //处理PHP代码
    public static function parse_php($con){//die($con);
        $con=str_replace('<mcms:php>','<?php ', $con);
        $con=str_replace('</mcms:php>',' ?> ', $con);
        return $con;
    }
    //处理区域模板
    public static function parse_inc($con,$tpl_file_cache){
        preg_match_all('~<mcms:inc\s([^>]*?)/>~', $con, $a);
        //print_r($a);die();
        $nodes=$a[0];//全部节点
        $body=$a[1];//属性字符串
        foreach($nodes as $k=>$v) {
            $attr_name=TPL::get_attr($body[$k],'name');//echo($attr_name);
            $attr_file=TPL::get_attr($body[$k],'file');
            $inc_name=assign_tpl_inc($attr_name);//echo($inc_name.'<br>');
            $inc_file=assign_tpl($attr_file);

            $con=preg_replace('~'.$v.'~','<?php require_once("'.$inc_name.'");?>',$con);
            $con=preg_replace('~'.$v.'~','<?php require_once("'.$inc_file.'");?>',$con);
        }
        return $con;
    }

}
