<?php
/*
 * MCMS Copyright (c) 2012-2013 ZhangYiYeTai Inc.
 * 
 *  http://www.mcms.cc
 * 
 * The program developed by loyjers core architecture, individual all rights reserved, 
 * if you have any questions please contact loyjers@126.com
 */

class Tree{
    private $dbm = null; //数据库操作对象
    private $cache_time = 0; //缓存时间 单位秒
    private $cache_name = 'trees';//缓存名称
    public $trees = array(); //目录树
    

    /**
     * 初始化对象
     * @param $dbm object 数据库操作对象
     */
    public function __construct($dbm) {
        global $global_global;
        
        $this->dbm = $dbm;
        $params = array(
            'key'=>$this->cache_name,
            'time'=>$this -> cache_time,
            'cache_type'=>CACHE_TYPE,
            'server'=>$global_global['mem_server'],
            'path'=>'cache/code'
        );
        $a = H :: cache($params);
        if ($a == 'timeout') {
            $params['val'] = $this -> trees();
            $a = H :: cache($params);
        }
        $this -> trees = $a;
    }
    /**
     * 获取所有目录数组，可以用分类ID作为下标读取分类信息
     */
    private function trees() {
        $sql = "select code_id,parent_code_id,txt from ".TB_PRE."code";
        $a = $this -> dbm -> query($sql);
        $tmp_trees = array();
        foreach($a['list'] as $v) {
            $sql = "select code_id,parent_code_id,txt from ".TB_PRE."code where parent_code_id='{$v['code_id']}' order by corder asc";
            $rs=$this->dbm->query($sql);
            $v['son']=$rs['list'];
            $tmp_trees[$v['code_id']] = $v;
        }
        return $tmp_trees;
    }
    /**
     * 更新目录缓存
     */
    public function update_cache() {
        global $global_global;
        
        $params = array(
            'key'=>$this->cache_name,
            'time'=>$this -> cache_time,
            'cache_type'=>CACHE_TYPE,
            'server'=>$global_global['mem_server'],
            'path'=>'cache/code'
        );
        $params['val'] = $this -> trees();
        $this -> trees = H :: cache($params);
    }
    /**
     * 获取父级目录（水平）
     * @param $code_id int 目录树id
     */
    public function tree_father($code_id) {
        $ret = array();
        if(!isset($this->trees[$code_id])) return $ret;
        //自身
        $self=$this->trees[$code_id];
        unset($self['son']);
        array_push($ret, $self);
        //查找父级
        if (intval($self['parent_code_id']) > 0) {
            $ret = $this->tree_father($self['parent_code_id']);
            array_push($ret, $self);
        }
        return $ret;
    }
    /**
     * 获取平级目录（水平）
     * @param $code_id int 目录树id
     */
    public function tree_brother($code_id=0) {
        $parent_id=$code_id;
        if($code_id>0) $parent_id = $this->trees[$code_id]['parent_code_id'];
        $sql = "select code_id,parent_code_id,txt from ".TB_PRE."code where parent_code_id='$parent_id' order by corder asc";
        $rs=$this->dbm->query($sql);
        $ret=$rs['list'];
        return $ret;
    }
    /**
     * 输出目录树
     * @param -> tree $this->trees['son']数组
     * @param -> expand_func 点击展开收缩的回调方法 expand_func(this)
     * @param -> is_expand_all 是否默认全部展开 1,0
     * @param -> ulevel 传递选中值
     * @param -> checkbox 1,0
     * @param -> url 链接URL，为空或者没有子树(强制输出链接=0)，输出纯文本
     * @param -> url_force 1,0 强制输出链接
     * @param -> click 文本上onclick 函数 onclick="javascript:void(0);";
     * @param -> rtype_last 默认最后一级显示复选框，1,2,3|4,5,6,tid1_path,tid2_path
     * @param -> loop_limit 输出子树级数
     */
    public function show_tree($params){
        //预处理参数
        $tree=$params['tree']=isset($params['tree'])?$params['tree']:array();
        $expand_func=$params['expand_func']=isset($params['expand_func'])?$params['expand_func']:'expand_func(this)';
        $is_expand_all=$params['is_expand_all']=isset($params['is_expand_all'])?$params['is_expand_all']:0;
        if($is_expand_all==1) $expand_func='';
        $ulevel=isset($params['ulevel'])?$params['ulevel']:array();
        $checkbox=$params['checkbox']=isset($params['checkbox'])?$params['checkbox']:0;
        $url=$params['url']=isset($params['url'])?$params['url']:'';
        $url_force=$params['url_force']=isset($params['url_force'])?$params['url_force']:0;
        $click=$params['click']=isset($params['click'])?$params['click']:'';
        $rtype_last=$params['rtype_last']=isset($params['rtype_last'])?$params['rtype_last']:0;
        $loop=$params['loop']=isset($params['loop'])?$params['loop']:1;
        $loop=$params['loop']++;
        $loop_limit=$params['loop_limit']=isset($params['loop_limit'])?$params['loop_limit']:100;
        if($loop>$loop_limit) return;

        //遍历数组
        $html='<ul class="tree">';
        if(is_array($tree)) {
            foreach($tree as $v){
                $vson=@$this->trees[$v['code_id']]['son'];
                $open_status='close';
                if($is_expand_all==1) $open_status='open';
                $html.='<li id="li'.$v['code_id'].'">';
                $html.='<span onclick="tree_icon_click(this'.($expand_func==''?'':','.$expand_func).');" class="tree-icon tree-expand-'.$open_status.'"></span>';
                if(($checkbox==1 || ($rtype_last==1 && count($vson)==0))){
                    $chk='';if(in_array('T'.$v['code_id'],$ulevel)) $chk=' checked';
                    $html.='<input type="checkbox" name="level" '.$chk.' value="T'.$v['code_id'].'" id="T'.$v['code_id'].'">';
                }
                
                if($url=='' || (count($vson)==0 && $url_force==0)){
                    $html.='<label for="T'.$v['code_id'].'"><em '.$click.' class="no_link">'.$v['txt'].'</em></label>';
                }else{
                    $style = isset($_GET['code_id'])&&$_GET['code_id'] == $v['code_id']?'class="selected"':'';
                    $html.='<a '.$style.' href="'.H::url_params($url,array('code_id'=>$v['code_id'])).'">'.$v['txt'].'</a>';
                }
                //展开子级
                if(count($vson)>0 && $is_expand_all==1){
                    $params['tree']=$vson;
                    $html.=$this->show_tree($params);
                }
                $html.='</li>';
            }

        }
        $html.='</ul>';
        return $html;
    }
    /**
     * 地区联动JSON数组
     */
    public function tree_json(){
        $cates=array();
        //省级
        $cates[0]=array('value' => '0','txt' => '请选择所属省份','son'=>array());
        foreach($this->trees as $c1){
            if($c1['parent_code_id']==1){
                $cates[$c1['code_id']]=array('value'=>$c1['code_id'],'txt'=>$c1['txt'],'son'=>array());
                //市级
                $cates[$c1['code_id']]['son'][0]=array('value' => '0','txt' => '请选择所属市/区/县','son'=>array());
                foreach($this->trees[$c1['code_id']]['son'] as $c2){//
                    $cates[$c1['code_id']]['son'][$c2['code_id']]=array('value'=>$c2['code_id'],'txt'=>$c2['txt'],'son'=>array());
                    //乡镇
                    $cates[$c1['code_id']]['son'][$c2['code_id']]['son'][0]=array('value' => '0','txt' => '请选择所属乡镇/街道','son'=>array());
                    foreach($this->trees[$c2['code_id']]['son'] as $c3){
                        $cates[$c1['code_id']]['son'][$c2['code_id']]['son'][$c3['code_id']]=array('value' => $c3['code_id'],'txt' => $c3['txt'],'son'=>array());
                    }
                }
            }
        }
        return $cates;
    }
}

?>