<?php
/*
 * MCMS Copyright (c) 2012-2013 ZhangYiYeTai Inc.
 *
 *  http://www.mcms.cc
 *
 * The program developed by loyjers core architecture, individual all rights reserved,
 * if you have any questions please contact loyjers@126.com
 */
class User {
    private $dbm = null; //数据库操作对象
    /**
     * 初始化对象
     * @param $dbm object 数据库操作对象
     */
    public function __construct($dbm) {
        $this->dbm = $dbm;
    }

    /**
     * 添加单个用户
     * @return void  成功返回 自增ID 失败返回具体信息
     */
    public function add($fields) {
        $fields['login_salt'] = H::security_code();
        $fields['login_pass'] = H::password_encrypt_salt($fields['login_pass'], $fields['login_salt']);
        $fields['create_ip'] = H::getip();
        $fields['create_time'] = time();
        $a = $this->dbm->single_insert(TB_PRE.'user',$fields);
        if($a['error']) {
            die('{"code":"1","msg":"插入用户失败"}');
        }
        return $a['autoid'];
    }

    /**
     * 获取用户信息
     * @param $uid 用户ID或者用户名
     * @param $fields 需要查询的字段 默认 *
     * @param $type 查询方式，1=用户ID，2=用户名，3=手机，4=邮箱
     */
    public function get($uid,$fields='*',$type=1) {
        $uid=trim($uid);
        //自动判断，由于用户ID基本无法达到100亿（11位数字）级别，所以，认为纯数字类型的和手机号码判断不冲突
        if(verify::verify_uname($uid)=='') $type=2;
        if(verify::verify_mobile($uid)=='') $type=3;
        if(verify::verify_email($uid)=='') $type=4;

        if($type==1){
            $sql = "select $fields from ".TB_PRE."user where uid='$uid' limit 2";
        }
        if($type==2){
            $sql = "select $fields from ".TB_PRE."user use index(login_name) where login_name='$uid' limit 2";
        }
        if($type==3){
            $sql = "select $fields from ".TB_PRE."user use index(login_mobile) where login_mobile='$uid' limit 2";
        }
        if($type==4){
            $sql = "select $fields from ".TB_PRE."user use index(login_email) where login_email='$uid' limit 2";
        }

        $rs = $this -> dbm -> query($sql);//唯一用户则返回全部用户数据
	    //print_r($rs);die();
        if (count($rs['list'])==1) {
            $user = $rs['list'][0];
            return $user;
        }else{
            return false;
        }
    }

    /**
     * 删除用户
     * @param $uid 用户ID
     */
    public function del($uid) {
        $this->dbm->query_update("delete from ".TB_PRE."user where uid='$uid'");
    }

	//获取用户积分
	public function get_point() {
		$rs = $this->dbm->query("select sum(point) as t from ".TB_PRE."point where uid=".$_SESSION['user']['uid']);
		if(count($rs['list'])>0) {
			if($rs['list'][0]['t']!='') return $rs['list'][0]['t'];
		}
		return '0';
	}

	//统计单个用户支付状态
	public function get_pay_status($status=0) {
		$rs = $this->dbm->query("select count(1) as t from ".TB_PRE."order where uid=".$_SESSION['user']['uid']." and pay_status=".$status);
		return isset($rs['list'][0]['t']) ? $rs['list'][0]['t'] : 0;
	}
    //统计我的订单数
	public function get_order_num() {
		$rs = $this->dbm->query("select count(1) as t from ".TB_PRE."order where uid=".$_SESSION['user']['uid']);
		return isset($rs['list'][0]['t']) ? $rs['list'][0]['t'] : 0;
	}

	//统计单个用户送货状态
	public function get_send_status($status=0) {
		$rs = $this->dbm->query("select count(1) as t from ".TB_PRE."order where uid=".$_SESSION['user']['uid']." and send_status=".$status);
		return isset($rs['list'][0]['t']) ? $rs['list'][0]['t'] : 0;
	}
    /**
     * 积分增减操作
     */
    public function update_point($params){
        $fields['uid'] = isset($params['uid']) ? intval($params['uid']) : intval($_SESSION['user']['uid']);
        $fields['point'] = isset($params['point']) ? $params['point'] : 5;
        $fields['point_type'] = isset($params['point_type']) ? $params['point_type'] : 0;
        $fields['create_time'] = time();
        $ret = $this->dbm->single_insert(TB_PRE."point",$fields);
        if($ret['error']=='' && $ret['autoid']>0) return true;
        return false;
    }

}

?>