
-- 用户表 --

create table if not exists `mcms_user`(
    `uid` int(11) not null auto_increment comment '用户ID',
    `login_name` varchar(20) not null default '' comment '通行证用户名',
    `login_email` varchar(50) not null default '' comment '登录邮箱',
    `login_mobile` varchar(20) not null default '' comment '登录手机号码',
    `login_pass` varchar(50) not null default '' comment '通行证密码',
    `login_salt` varchar(8) not null default '' comment '混合码，安全加密用，注册时生成',
    `login_status` int(1) not null default 0 comment '用户状态：0=正常，1=禁用，2=未激活',
    `login_group` varchar(100) not null default 2 comment '用户组ID',
    `login_level` varchar(1000) not null default '' comment '用户允许权限',
    `login_no_level` varchar(1000) not null default '' comment '用户禁止权限，优先级最高',
    `true_name` varchar(50) not null default '' comment '真实姓名',
    `avatar` varchar(100) not null default '' comment '头像',
    `gender` int(1) not null default 0 comment '性别0=女性，1=男性，2=保密',
    `date_birth` int(11) not null default 0 comment '出生日期',
    `province` int(11) not null default 0 comment '所属省份',
    `district` int(11) not null default 0 comment '所属市/区/县',
    `street` int(11) not null default 0 comment '所属乡镇/街道',
    `committee` int(11) not null default 0 comment '所属村组/社区',
    `address` varchar(100) not null default '' comment '详细地址',
    `longitude`  double not null default 0 comment '经度' ,
    `latitude`  double not null default 0 comment '纬度' ,
    `create_time` int(11) not null  default 0 comment '创建时间',
    `create_ip` varchar(30) not null  default '' comment '创建ip',
    `login_time` int(11) not null  default 0 comment '最后登录时间',
    `login_ip` varchar(20) not null  default 0 comment '最后登录IP',
    `login_num` int(11) not null  default 0 comment '登录次数',
 primary key(`uid`),
    unique key (`login_name`),
    index `login_email`(`login_email`),
    index `login_mobile`(`login_mobile`),
    index `login_group`(`login_group`)
) engine=myisam default charset=utf8 comment '用户表';

-- 用户组表 --

create table if not exists `mcms_group` (
    `group_id` int(11) unsigned not null auto_increment,
    `group_name` varchar(100) not null default '' comment '组名称',
    `group_level` text not null comment '组权限',
    `group_type` int(1) not null default 1 comment '组类型（0=内置，不可删除，1=自定义，可删除）',
    `group_remark` varchar(1000) not null default '' comment '组备注描述',
    `create_time` int(11) not null default 0 comment '创建时间',
 primary key (`group_id`),
 unique key (`group_name`)
) engine=myisam default charset=utf8 comment '用户组表';


-- 文档上传附件表 --

create table if not exists `mcms_attach` (
    `attach_id` int(11) unsigned not null auto_increment,
    `info_id` int(11) not null default 0 comment '文档ID',
    `file_md5` varchar(100) not null default 0 comment '文件MD5值',
 primary key (`attach_id`),
    index `file_md5`(`file_md5`),
    index `info_id`(`info_id`)
) engine=myisam default charset=utf8 comment '附件文档关系表';

-- 上传文件详情表 --

create table if not exists `mcms_file` (
    `file_md5` varchar(100) not null default 0 comment '文件MD5值',
    `file_url` varchar(100) not null default '' comment '上传后文件路径',
    `file_oname` varchar(100) not null default '' comment '文件原名称',
    `file_name` varchar(100) not null default '' comment '自定义文件新名称',
    `file_extension` varchar(20) not null default '' comment '文件原后缀（统一为小写如jpg）',
    `file_size` int(11) not null default 0 comment '文件大小',
    `img_width` int(11) not null default 0 comment '图片宽度',
    `img_height` int(11) not null default 0 comment '图片高度',
    `file_order` int(11) not null default 0 comment '顺序',
    `create_time` int(11) not null default 0 comment '时间',
 primary key (`file_md5`),
  index create_time(`create_time`)
) engine=myisam default charset=utf8 comment '文件详情表';

-- 日志记录表 --

create table if not exists `mcms_log` (
    `log_id` int(11) unsigned not null auto_increment,
    `uid` int(11) not null default 0 comment '操作者id',
    `uname`  varchar(20) not null default '' comment '操作者账号',
    `log_type` int(3) not null default 0 comment '操作日志类型1=用户登录(登录成功)，2=用户管理(增删改用户，删角色，设置权限)，3=禁止/解禁用户，4=文档管理(增删改审)，5=类别操作(增删改移)，6=模型操作(增删改)，7=广告操作(增删改)',
    `content` varchar(8000) not null default '' comment '操作内容',
    `create_time` int(11) not null default 0 comment '创建时间',
    `ip` varchar(24) not null default '' comment '操作者ip',
    `obj_id`  int(11) not null default 0 comment '被操做对象id',
 primary key (`log_id`),
    index `log_type`(`log_type`)
) engine=myisam default charset=utf8 comment '用户操作日志表';

-- 栏目表 --

create table if not exists `mcms_category` (
    `cate_id` int(11) unsigned not null auto_increment comment '类别id',
    `parent_id` int(11) not null default 0 comment '父类id',
    `cdomain` varchar(200) not null default '' comment '绑定独立域名，为空则不绑定',
    `cname` varchar(100) not null default '' comment '分类名称',
    `cname_py` varchar(100) not null default '' comment '分类字母别名',
    `cname_cn` varchar(100) not null default '' comment '分类别名',
    `ctitle` varchar(500) not null default '' comment 'SEO标题',
    `ctotal` int(11) not null default 0 comment '该分类下信息总数',
    `go_url` varchar(200) not null default '' comment '跳转URL，优先级高于cdomain',
    `tpl_index` varchar(500) not null default '' comment  '封面模板',
    `tpl_list` varchar(500) not null default '' comment  '列表变量模板',
    `tpl_content` varchar(500) not null default '' comment  '内容页模板',
    `nav_show` int(1) not null default 1 comment '主导航显示，0=否，1=是',
    `nav_show_wap` int(1) not null default 1 comment 'wap端主导航显示，0=否，1=是',
    `ckey` varchar(500) not null default '' comment 'SEO关键词',
    `cdesc` varchar(500) not null default '' comment 'SEO描述',
    `corder` int(11) not null default 100 comment '分类排序',
    `clogo` varchar(200) not null default '' comment '分类LOGO图',
    `cintro` varchar(8000) not null default '' comment '分类简介',
    `area_id` int(11) not null default 0 comment '绑定广告位id',
    `url_dir` varchar(100) not null default '' comment '伪静态识别前缀',
    `clogo_hover` varchar(200) not null default '' comment '分类LOGO替换图',
 primary key (`cate_id`),
    index `parent_id`(`parent_id`)
) engine=myisam default charset=utf8 comment '分类表';

-- 分类文档关系表 --

create table if not exists `mcms_cate_relation` (
    `relation_id` int(11) unsigned not null auto_increment comment '关系ID',
    `cate_id` int(11) not null default 0 comment '分类ID',
    `info_id` int(11) not null default 0 comment '文档ID',
    `create_time` int(11) not null default 0 comment '创建时间',
    `update_time` int(11) not null default 0 comment '更新时间',
    `publish_time` int(11) not null default 0 comment '发布时间/排序',
    `info_diss` int(11) not null default 0 comment '评论量',
    `info_hits` int(11) not null default 0 comment '浏览量',
    `info_favs` int(11) not null default 0 comment '收藏量',
    `info_downs` int(11) not null default 0 comment '下载量',
    `info_sells` int(11) not null default 0 comment '销量',
 primary key (`relation_id`),
    unique key (`info_id`,`cate_id`),
    index `create_time` (`create_time`),
    index `update_time` (`update_time`),
    index `publish_time` (`publish_time`),
    index `info_sells` (`info_sells`),
    index `info_diss` (`info_diss`),
    index `info_hits` (`info_hits`),
    index `info_favs` (`info_favs`),
    index `info_downs` (`info_downs`)
) engine=myisam default charset=utf8 comment '分类和文档信息关系表';

-- 文档信息表 --

create table if not exists `mcms_info_list` (
    `info_id` int(11) unsigned not null auto_increment comment '文档id',
    `cid_path` varchar(1200) not null default '' comment '分类ID，层级分类之间用逗号分隔，多个不同层级分类用竖线分隔',
    `cate_id` int(11) not null default 0 comment '主分类ID',
    `model_name` varchar(100) not null default '' comment '模型ID',
    `info_title` varchar(500) not null default '' comment '标题',
    `info_stitle` varchar(500) not null default '' comment '副标题',
    `seo_title` varchar(500) not null default '' comment 'SEO标题',
    `fbold` int(1) not null default 0 comment '标题是否加粗：0=否，1=是',
    `fcolor` varchar(16) not null default '' comment '标题颜色',
    `info_img` varchar(500) not null default '' comment '文档缩略图',
    `info_desc` varchar(500) not null default '' comment '摘要',
    `info_body` text not null  comment '详情',
    `info_tags` varchar(1000) not null default '' comment '标签',
    `related_ids` varchar(200) not null default '' comment '关联字段列表',
    `info_from` varchar(500) not null default '' comment '来源',
    `uid` int(11) not null default 0 comment '发布人ID',
    `uname` varchar(100) not null default '' comment '发布人',
    `check_uid` int(11) not null default 0 comment '审核人ID',
    `check_uname` varchar(100) not null default '' comment '审核人',
    `go_url` varchar(500) not null default '' comment '跳转外部URL',
    `create_time` int(11) not null default 0 comment '创建时间',
    `update_time` int(11) not null default 0 comment '更新时间',
    `publish_time` int(11) not null default 0 comment '发布时间/排序',
    `info_status` int(2) not null default -1 comment '文档状态：-1=草稿，0=已通过，1=已删除，2=审核中，3=未通过',
    `info_diss` int(11) not null default 0 comment '评论量',
    `info_hits` int(11) not null default 0 comment '浏览量',
    `info_favs` int(11) not null default 0 comment '收藏量',
    `info_downs` int(11) not null default 0 comment '下载量',
    `info_sells` int(11) not null default 0 comment '销量',
 primary key (`info_id`),
    index `model_name`(`model_name`),
    index `uid`(`uid`),
    index `check_uid`(`check_uid`),
    index `info_status` (`info_status`),
    index `info_diss` (`info_diss`),
    index `info_hits` (`info_hits`),
    index `info_favs` (`info_favs`),
    index `info_downs` (`info_downs`),
    index `info_sells` (`info_sells`),
    index `create_time` (`create_time`),
    index `update_time` (`update_time`),
    index `publish_time` (`publish_time`),
    index `info_status_uid`(`info_status`,`uid`),
    index `info_status_check_uid`(`info_status`,`check_uid`),
    index `info_status_model_name`(`info_status`,`model_name`)
) engine=myisam default charset=utf8 comment '文档信息表';

-- 模型表 --

create table if not exists `mcms_model` (
    `model_type` int(2) not null default 0 comment '模型类型：0=扩展表，1=独立表',
    `model_name` varchar(100) not null  not null comment '表名，必须是英文字符和下划线数字组合',
    `model_desc` varchar(100) not null default '' not null comment '扩展模型描述',
 primary key (`model_name`)
) engine=myisam default charset=utf8 comment '扩展模型';

-- 模型字段表 --

create table if not exists `mcms_model_fields` (
    `field_id` int(11) unsigned not null auto_increment comment '字段ID',
    `model_name` varchar(50) not null default 0 comment '表名',
    `field_title` varchar(50) not null default '' not null comment '字段文字',
    `field_name` varchar(50) not null default '' comment '字段名称，必须是英文字符和下划线数字组合',
    `field_type` varchar(100) not null default '' not null comment '字段类型SQL',
    `form_type` varchar(100) not null default '' not null comment '表单类型，如下拉，文本框，文本域，日期框等',
    `form_value` varchar(1000) not null default '' not null comment '表单默认值，竖线分开为多值表单的项',
    `form_check` varchar(20) not null default '' not null comment '表单的备注，比如不能为空等，此处存储verify.class.php中的函数名，都有对应的JS函数名',
    `form_show` int(1) not null default 1 comment '表单是否显示出来',
    `forder` int(11) not null default 100 comment '字段显示排序',
 primary key (`field_id`),
    index `model_name`(`model_name`)
) engine=myisam default charset=utf8 comment '扩展模型字段';

-- 友链表 --

create table if not exists `mcms_flink` (
    `fid` int(11) unsigned not null auto_increment comment '友情ID',
    `ftitle` varchar(100) not null default '' comment '链接文字',
    `fimg` varchar(500) not null default '' comment '链接图片',
    `furl` varchar(500) not null default '' comment '链接地址',
    `fscope` int(2) not null default 0 comment '-1=全站，0=首页，大于等于1=分类ID',
    `fgroup` varchar(20) not null default '友情链接' comment '友情链接分组',
    `forder` int(11) not null default 100 comment'排序',
 primary key(`fid`)
)engine=myisam default charset=utf8 comment '友情链接表';

-- 伪静态规则表 --

create table if not exists `mcms_url_rewrite`(
    `url_id` int(11) not null auto_increment,
    `url_title` varchar(400) not null default '' comment '地址名称',
    `url_true` varchar(400) not null default '' comment '真实地址',
    `url_rule` varchar(400) not null default '' comment '伪静态规则',
 primary key(`url_id`)
) engine=myisam default charset=utf8 comment '伪静态规则表';

-- 搜索关键词表 --

create table if not exists `mcms_qword` (
  `qid` int(11) unsigned null null auto_increment,
  `qword` varchar(200) not null default '' comment '搜索关键字',
  `qnum` int(11) unsigned not null default 0 comment '搜索次数',
  `qorder` int(11) unsigned not null default 100 comment '关键字排序',
  `qgroup` varchar(100) not null default '搜索词' comment '搜索关键字',
   primary key (`qid`),
    index `qorder` (`qorder`),
    index `qgroup` (`qgroup`)
) engine=myisam default charset=utf8 comment '搜索关键字记录表';

-- 代码值表 --

create table if not exists `mcms_code` (
 `code_id` int(11) unsigned not null auto_increment comment '代码ID',
 `parent_code_id` int(11) not null default 0 comment '父级代码ID',
 `value` varchar(20) not null default '' comment '代码值',
 `txt` varchar(100) not null default '' comment '代码文本',
 `txt_color` varchar(100) not null default '' comment '文本颜色',
 `desc` varchar(100)    not null default '' comment '代码描述',
 `corder` int(11) not null default 100 comment '代码排序',
 `start_num` int(11) not null default 0 comment '初始值',
 `is_show` int(11) not null default 1 comment '是否启用1=启用0=禁用',
 primary key (`code_id`),
 index `parent_code_id` (`parent_code_id`)
) engine=myisam default charset=utf8 comment '系统代码定义表';

-- 广告位表 --

create table if not exists `mcms_adv` (
    `area_id` int(11) unsigned not null auto_increment comment '广告位ID',
    `title` varchar(100) not null default '' comment '位置标题',
    `area_type` varchar(20) not null default 0 comment '类型：code=代码广告（支持上传图片和视频），img=图片轮播',
    `area_remarks` varchar(1000) not null default '' comment '备注',
    `area_html` varchar(8000) not null default '' comment '代码广告内容',
    `area_status` int(11) not null default 0 comment '是否启用，0=启用，1=禁用',
 primary key (`area_id`)
) engine=myisam default charset=utf8 comment '推荐位置';

-- 广告表 --

create table if not exists `mcms_adv_img` (
    `img_id` int(11) unsigned not null auto_increment comment '广告ID',
    `img_title` varchar(100) not null default '' comment '广告文本',
    `img_desc` varchar(100) not null default '' comment '广告描述',
    `area_id` int(11) not null default 0 comment '广告位ID',
    `img_url` varchar(500) not null default '' comment '链接图片',
    `go_url` varchar(500) not null default '' comment '跳转地址',
    `img_order` int(11) not null default 100 comment'排序',
    `img_status` int(11) not null default 0 comment'是否启用，0=启用，1=禁用',
 primary key(`img_id`),
    index `area_id`(`area_id`)
)engine=myisam default charset=utf8 comment '友情链接表';

-- 微信菜单 --

create table if not exists `mcms_weixin_menu`(
 `menu_id` int(11) not null auto_increment,
 `menu_name` varchar(100) not null default '' comment '菜单名称',
 `menu_type` varchar(100) not null default '' comment '菜单类型',
 `menu_url` varchar(400) not null default '' comment '菜单URL地址',
 `menu_key` varchar(400) not null default '' comment '事件名称',
 `parent_id` int(11) unsigned not null default '0' comment '父级菜单',
 `menu_order` int(11) unsigned not null default 100 comment '菜单排序',
 primary key(`menu_id`)
) engine=myisam default charset=utf8 comment '微信自定义菜单表';

-- 微信自动回复 --

create table if not exists `mcms_weixin_auto_msg`(
 `msg_id` int(11) not null auto_increment,
 `msg_key` varchar(2000) not null default '' comment '预定义关键词',
 `msg_desc` varchar(200) not null default '' comment '消息备注',
 `msg_body` varchar(500) not null default '' comment '消息体',
 `msg_pic` varchar(200) not null default '' comment '图文消息图片URL',
 `msg_url` varchar(200) not null default '' comment '图文消息链接',
 `msg_order` int(11) unsigned not null default 100 comment '消息排序',
 primary key(`msg_id`)
) engine=myisam default charset=utf8 comment '自动回复消息';

-- 评论表 --

create table if not exists `mcms_comment` (
  `comment_id` int(11) unsigned not null auto_increment comment '评论id',
  `info_id` int(11) not null default 0 comment '信息ID	',
  `content` varchar(500) not null default '' comment '评论内容',
  `date_add` int(11) not null default 0 comment '发布时间',
  `uid` int(11) not null default 0 comment '用户id',
  `uname` varchar(500) not null default '' comment '昵称',
  `ip` varchar(20) not null default 0 comment 'ip地址',
  `ip_addr` varchar(200) not null default '' comment '地理位置',
  `parent_id` int(11) not null default 0 comment '上级id',
  `is_check` int(1) not null default 1 comment '是否审核',
  `son` int(11) not null default 0 comment '子评论数',
  `good` int(11) not null default 0 comment '赞',
  `bad` int(11) not null default 0 comment '踩',
  `reply` varchar(1000) not null default '' comment '评论管理员回复',
  primary key  (`comment_id`),
  index (`info_id`)
) engine=myisam default charset=utf8 comment '评论表';

-- 产品表 --
create table if not exists `mcms_product` (
  `info_id` int(11) NOT NULL DEFAULT 0 COMMENT '文档信息ID',
  `price` float(11,2) NOT NULL DEFAULT 0 COMMENT '价格',
  PRIMARY KEY (`info_id`)
) engine=myisam default charset=utf8 comment '产品表';

-- 留言表 --
create table if not exists `mcms_message` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `create_time` int(11) NOT NULL DEFAULT 0,
  `update_time` int(11) NOT NULL DEFAULT 0,
  `true_name` varchar(100) NOT NULL DEFAULT '' COMMENT '姓名',
  `phone` varchar(100) NOT NULL DEFAULT '' COMMENT '电话',
  `content` varchar(100) NOT NULL DEFAULT '' COMMENT '内容',
  PRIMARY KEY (`message_id`)
) engine=myisam default charset=utf8 comment '留言表';

-- 自定义变量表 --
create table if not exists `mcms_vars` (
  `var_id` int(11) NOT NULL AUTO_INCREMENT,
  `var_name` varchar(50) NOT NULL DEFAULT '',
  `var_content` varchar(4000) NOT NULL DEFAULT '',
  PRIMARY KEY (`var_id`)
) engine=myisam default charset=utf8 comment '自定义变量';

-- 用户积分表 --
create table if not exists `mcms_point`(
    `point_id` int(11) not null auto_increment comment '积分ID',
    `uid` int(11) not null default 0 comment '用户ID',
    `point` int(11) not null default 0 comment '积分，扣除用负值',
    `point_type` int(2) not null default 0 comment '积分获取方式',
    `create_time` int(11) not null default 0 comment '获取时间',
    PRIMARY KEY  (`point_id`),
    index `uid`(`uid`)
) engine=myisam default charset=utf8 comment '账号积分表';

-- 收货人信息表 --
create table if not exists `mcms_address` (
    `addr_id` int(11) unsigned not null auto_increment comment '地址ID',
    `province` int(11) not null default 0 comment '省份',
    `district` int(11) not null default 0 comment '行政区域',
    `address` varchar(200) not null default '' comment '详细地址',
    `longitude`  double not null default 0 comment '经度' ,
    `latitude`  double not null default 0 comment '纬度' ,
    `addr_order` int(11) not null default 100 comment '排序',
    `is_default` int(11) not null default 0 comment '默认地址',
    `uid` int(11) unsigned not null default 0 comment '用户ID',
    `true_name` varchar(100) not null comment '姓名',
    `addr_postcode` varchar(10) not null comment '邮编',
    `addr_phone` varchar(50) not null comment '联系电话（手机/座机）',
    `addr_email` varchar(50) not null comment '联系邮箱',
    primary key (`addr_id`),
    index `uid`(`uid`)
) engine=myisam default charset=utf8 comment '收货人信息表';

-- 邮件短信验证码表 --
create table if not exists `mcms_verify`(
    `code` varchar(100) not null default '' comment '重置密码验证字符串',
    `create_user` varchar(50) not null default '' comment '邮箱或者手机号码',
    `update_time` int(11) not null default 0 comment '更新时间',
    PRIMARY KEY  (`code`),
    index `create_user`(`create_user`),
    index `code`(`code`)
) engine=myisam default charset=utf8 comment '邮件短信验证码表';

-- 订单表 --
create table if not exists `mcms_order` (
    `order_id` int(11) unsigned not null auto_increment comment '订单ID',
    `order_num_local` varchar(50) not null default '' comment '本站订单号',
    `order_num_remote` varchar(50) not null default '' comment '支付渠道订单号',
    `order_desc` text not null comment '订单描述JSON：[{"name":"水果篮N/商品名称","goods":[{"info_id":"","title":"",num":""},{},{}]},{},{}]',
    `pay_money_original` float(10,2) not null default 0 comment '原价总金额',
    `pay_money_over` float(10,2) not null default 0 comment '实际支付总金额（扣除优惠券抵扣）',
    `pay_type` varchar(50) not null default 'arrival' comment '支付方式：arrival=货到付款',
    `send_type` varchar(50) not null default '直接配送' comment '配送方式：直接配送，其他直接写快递名称',
    `send_num` varchar(50) not null default '' comment '配送快递单号',
    `order_status` int(11) not null default 0 comment '订单状态：0=待确认，1=已确认，2=交易成功，3=交易失败',
    `pay_status` int(11) not null default 0 comment '付款状态：0=未付款，1=付款中，2=已付款，3=已退款',
    `send_status` int(11) not null default 0 comment '发货状态：0=未发货，1=配货中，2=已发货，3=已退货',
    `deal_desc` varchar(4000) not null default '' comment '订单处理备注，多次累加<br>',
    `order_message` varchar(500) not null default '' comment '客户订单留言',
    `uid` int(11) not null default 0 comment '用户ID',
    `uname` varchar(20) not null default '' comment '用户名',
    `order_address` varchar(1000) not null default '' comment '收货信息JSON：{"true_name":"","province":"","address":"","addr_phone":"","addr_email":"","addr_postcode":""}',
    `create_time` int(11) not null default 0 comment '创建时间',
    `update_time` int(11) not null default 0 comment '处理时间',
    `send_time` varchar(100) not null default '' comment '配送时间',
 primary key (`order_id`),
    index `order_status`(`order_status`),
    index `pay_status`(`pay_status`),
    index `send_status`(`send_status`),
    index `uid`(`uid`),
    index `order_num_local`(`order_num_local`),
    index `order_num_remote`(`order_num_remote`)
) engine=myisam default charset=utf8 comment '订单表';