<?php
/*
 * MCMS Copyright (c) 2012-2013 ZhangYiYeTai Inc.
 * 
 *  http://www.mcms.cc
 * 
 * The program developed by loyjers core architecture, individual all rights reserved, 
 * if you have any questions please contact loyjers@126.com
 */

date_default_timezone_set('Asia/Shanghai'); //默认时区
error_reporting(0); //报告所有错误，0为忽略所有错误
ini_set('display_errors','0'); //开启错误提示
ini_set('magic_quotes_runtime', '0'); //魔法反斜杠转义关闭
ini_set('default_charset', 'utf-8'); //默认编码

define("ROOT_PATH",str_replace('\\','/',dirname(__FILE__)));//根目录物理路径
require_once(ROOT_PATH . "/class/helper.class.php"); //通用方法类
require_once(ROOT_PATH . "/config/global.php"); //基本配置
//
//SESSION放MEMCACHE缓存
if(defined('MEM_SERVER_SESSION') && MEM_SERVER_SESSION!=''){
    ini_set("session.save_handler", "memcached");
    ini_set("session.save_path", MEM_SERVER_SESSION);
}
if (!session_id()) 
    session_start(); //开启SESSION


// 兼容 DOCUMENT_ROOT 变量
$_SERVER['DOCUMENT_ROOT'] = str_replace('\\', '/', substr($_SERVER['SCRIPT_FILENAME'], 0, 0 - strlen($_SERVER['PHP_SELF'])));

if (!isset($_SERVER['QUERY_STRING']) || empty($_SERVER['QUERY_STRING'])) $_SERVER['QUERY_STRING']='';
if (!isset($_SERVER['REQUEST_URI']) || empty($_SERVER['REQUEST_URI'])) $_SERVER['REQUEST_URI']='';
if (!isset($_SERVER['HTTP_HOST']) || empty($_SERVER['HTTP_HOST'])) $_SERVER['HTTP_HOST']='zyy';

require_once(ROOT_PATH . "/config/conn.php"); //数据库连接
require_once(ROOT_PATH . "/config/struct.php"); //结构

require_once(ROOT_PATH . "/class/database.class.php"); //数据库操作类
require_once(ROOT_PATH . "/class/vars.class.php"); //词组变量
require_once(ROOT_PATH . "/class/function.php"); //前后台公用方法
require_once(ROOT_PATH . "/class/verify.class.php"); //验证类
require_once(ROOT_PATH . "/class/url.rewrite.class.php"); //伪静态类
require_once(ROOT_PATH . "/class/templates.class.php"); //模板解析器类

require_once(ROOT_PATH . "/class/cms.class.php"); //CMS类
require_once(ROOT_PATH . "/class/tree.class.php"); //树
require_once(ROOT_PATH . "/class/user.class.php"); //用户
require_once(ROOT_PATH . "/class/weixin.class.php");



// 开启GZIP压缩，如果报错则注释此处
// ob_start('H::ob_gzip');

//判断请求方式ajax提交或者地址栏跳转
//define('AJAX',isset($_GET['ajax'])?1:0);
define('AJAX',ajax_request()?1:0);

$p = isset($_GET['p'])?intval($_GET['p']):1; //分页页码
if ($p==0) $p = 1;

//变量，用于下拉表单等输出
$global_vars=H::cache(array('key'=>'vars','time'=>0,'cache_type'=>'file_cache'));
/*
if($global_vars=='timeout') {
    $global_vars=H::cache(array('key'=>'vars','time'=>0,'cache_type'=>'file_cache'));
    H::cache(array('key'=>'vars','val'=>$global_vars,'time'=>0,'cache_type'=>CACHE_TYPE));
}
*/

//初始化数据库
$dbm = new db_mysql();
//初始化类
$V = new Vars($global_vars);//变量类
$C = new Cms($dbm);//CMS类
$U = new User($dbm);//用户类
$T = new Tree($dbm);//树类

$timestamp=time();//JS防止缓存或者上传需要标识
?>