<?php
header('Content-type: text/html; charset=UTF-8');
date_default_timezone_set('Asia/Shanghai'); //默认时区
error_reporting(0); //报告所有错误，0为忽略所有错误
ini_set('display_errors','0'); //开启错误提示
ini_set('magic_quotes_runtime', '0'); //魔法反斜杠转义关闭
ini_set('default_charset', 'utf-8'); //默认编码

session_start();

$_GET['action'] = isset($_GET['action']) ? intval($_GET['action']) : 1;
if(!in_array($_GET['action'],array(1,2,3,4,5))) $_GET['action'] = 1;

define('ROOT',str_replace('\\','/',substr(__FILE__,0,-17))); //最后带了 /

$_GET['m'] = isset($_GET['m']) ? trim($_GET['m']):'';

require(ROOT.'class/helper.class.php');
require(ROOT.'class/verify.class.php');
require(ROOT.'config/global.php');

$_GET  = H::sqlxss($_GET);
$_POST  = H::sqlxss($_POST);

if(file_exists(ROOT.'install/install.lock.php')) die('您已经安装过MCMS，删除install/install.lock.php可以重新安装');
if(count(explode('/',$_SERVER['PHP_SELF']))>3) die('只允许安装在根目录');
if (function_exists("m__" . $_GET['m'])) call_user_func("m__" . $_GET['m']);

switch ($_GET['action']) {
    case '1':
        H::get_contents(MCMS_API."/installed.php?a=".$_SERVER['HTTP_HOST']."&b=".session_id());
		break;
	case '2':
		is_read_write();
		break;
	case '3':
		if(!$_SESSION['is_through']) die('<script type="text/javascript">window.location.href="index.php?action=2";</script>');
	    break;
	case '4':
		if(!$_SESSION['is_create']) die('<script type="text/javascript">window.location.href="index.php?action=2";</script>');
	    break;
	case '5':
		if(!$_SESSION['is_create']) die('<script type="text/javascript">window.location.href="index.php?action=2";</script>');
		session_destroy();
		file_put_contents(ROOT.'install/install.lock.php','感谢使用mcms');
	    break;
}

require('./step/install-'.$_GET['action'].'.php');

die();


/**
 *
 * 检测安装环境
 */
function is_read_write() {
	global $result;
	$_SESSION['is_through'] = true; //环境检测通过
	//运行环境
	$result[0]  = array();
	$result[0]['sys'] = php_uname('s');
	$result[0]['web_server'] = function_exists('apache_get_version')?apache_get_version():"";

	$PHP_GD = '';
	if (extension_loaded('gd')) {
		if (function_exists('imagepng')) $PHP_GD .= 'png';
		if (function_exists('imagejpeg')) $PHP_GD .= ' jpg';
		if (function_exists('imagegif')) $PHP_GD .= ' gif';
	}else{
		$_SESSION['is_through'] = false;
	}
	$result[0]['gd'] = $PHP_GD;

	$PHP_JSON = '0';
	if (extension_loaded('json')) {
		if (function_exists('json_decode') && function_exists('json_encode')) $PHP_JSON = '1';
	}else{
		$_SESSION['is_through'] = false;
	}
	$result[0]['json'] = $PHP_GD;

	//目录权限
	$test_dir = array(
		ROOT.'config/',
		ROOT.'config/cache/',
		ROOT.'static/',
	);

	$tmp_test_dir = array();
	foreach ($test_dir as $k=>$v ) {
		$is_write = 0;
		if (is_dir($v)) {
			$hd = fopen($v . 'helloword.txt', 'w+');
			if($hd) {
				$is_write = 1;
				fclose($hd);
				unlink($v . 'helloword.txt');
			}else{
				$_SESSION['is_through'] = false;
			}
		}else{
			$_SESSION['is_through'] = false;
		}
		$tmp_test_dir[] = array($v,$is_write);
	}

	//文件权限
	$test_file = array(
		ROOT.'config/conn.php',
		ROOT.'config/cache/global.php',
		ROOT.'data/structure.sql',
		ROOT.'data/init_database.sql',
	);

	$tmp_test_file = array();
	foreach ($test_file as $k=>$v ) {
		$is_write = 1;
		$a = fopen($v,'r+');
		if($a === false) {
			$is_write = 0;
			$_SESSION['is_through'] = false;
		}else{
			fclose($a);
		}
		$tmp_test_file[] = array($v,$is_write);
	}

	$result[1] = array_merge($tmp_test_file,$tmp_test_dir);
	//print_r($result);
} // end func


/**
 *
 * 测试数据库读写环境 并创建数据
 */
function m__test_database() {
	$_SESSION['is_create'] = false; //安装数据库完毕
	$_POST['dbhost'] = isset($_POST['dbhost']) ? trim($_POST['dbhost']) : '';
	$_POST['dbuser'] = isset($_POST['dbuser']) ? trim($_POST['dbuser']) : '';
	$_POST['dbpw'] = isset($_POST['dbpw']) ? trim($_POST['dbpw']) : '';
	$_POST['dbname'] = isset($_POST['dbname']) ? trim($_POST['dbname']) : '';
	$_POST['pre'] = isset($_POST['pre']) ? trim($_POST['pre']) : '';
	$_POST['manager'] = isset($_POST['manager']) ? trim($_POST['manager']) : '';
	$_POST['manager_pwd'] = isset($_POST['manager_pwd']) ? trim($_POST['manager_pwd']) : '';
	$_POST['manager_email'] = isset($_POST['manager_email']) ? trim($_POST['manager_email']) : '';
    $_POST['admin_path'] = isset($_POST['admin_path']) ? trim($_POST['admin_path']) : 'admin';

	if(strlen($_POST['dbhost']) == 0) die('{"code":1,"msg":"请填写 数据库服务器地址"}');
	if(strlen($_POST['dbuser']) == 0) die('{"code":1,"msg":"请填写 数据库服务器用户名"}');
	if(strlen($_POST['dbpw']) == 0) die('{"code":1,"msg":"请填写 数据库服务器密码"}');
	if(strlen($_POST['dbname']) == 0) die('{"code":1,"msg":"请填写 数据库名"}');

	if($_POST['pre'] !== '') {
		if(!preg_match('~^[A-Za-z][A-Za-z]*[a-z0-9_]*$~', $_POST['pre'])){
			die('{"code":"1","msg":"数据库表前缀 必须以字母开头，只允许字母、数字、下划线"}');
		}
	}
    //判断后台管理目录
    if(strstr($_POST['admin_path'],'admin') || strstr($_POST['admin_path'],'manage')) die('{"code":"1","msg":"后台管理目录不允许含有敏感字符"}');
	$verify = verify::verify_uname($_POST['manager']);
    if($verify != '') die('{"code":"1","msg":"'.$verify.'"}');

	if(strlen($_POST['manager_pwd']) == 0) die('{"code":1,"msg":"请填写管理员密码"}');
	if (strlen($_POST['manager_pwd']) < 6) die('{"code":"1","msg":"密码太短"}');
    if (strlen($_POST['manager_pwd']) > 20) die('{"code":"1","msg":"密码太长"}');

	if(!mysql_connect($_POST['dbhost'], $_POST['dbuser'], $_POST['dbpw'])) die('{"code":"1","msg":"服务器用户名 或 服务器密码 不正确"}');

	if(!mysql_select_db($_POST['dbname'])) {
		if(!mysql_query("CREATE DATABASE " .$_POST['dbname'])) die('{"code":"2","msg":"已连接数据库服务器，但不能创建数据库"}');
		mysql_select_db($_POST['dbname']);
	}

	mysql_query("set names utf8");

	$_SESSION['db_info'] = $_POST;

	//修改配置
	$str = <<<Eof
<?php
/*
 * MCMS Copyright (c) 2012-2013 ZhangYiYeTai Inc.
 *
 *  http://www.mcms.cc
 *
 * The program developed by loyjers core architecture, individual all rights reserved,
 * if you have any questions please contact loyjers@126.com
 */
//数据库地址
define('DB_HOST', '{$_POST['dbhost']}');
//数据库编码
define('DB_CHARSET', 'utf8');
//数据库
define('DB_DBNAME', '{$_POST['dbname']}');
//数据库用户名
define('DB_USERNAME', '{$_POST['dbuser']}');
//数据库密码
define('DB_PASS', '{$_POST['dbpw']}');
//表名前缀
define('TB_PRE', '{$_POST['pre']}');
Eof;
	file_put_contents(ROOT.'config/conn.php',$str);

	//修改域名
	$str = file_get_contents(ROOT.'config/cache/global.php');
	$str =  preg_replace("~\'domain_site\' => \'(.*?)\',~", "'domain_site' => 'http://".$_SERVER['HTTP_HOST']."',", $str, 1);
	file_put_contents(ROOT.'config/cache/global.php',$str);

    $cfile=ROOT.'config/global.php';
    file_replace($cfile,'~define\(\s*"ADMIN_PATH"\s*,\s*"(.*?)"\);~i','define("ADMIN_PATH","'.$_POST['admin_path'].'");');

    //修改后台目录
    @rename(ROOT."app/admin",ROOT."app/".$_POST['admin_path']);

    //读取安装数据
	$structure = file_get_contents(ROOT.'data/structure.sql');
	$init_database = file_get_contents(ROOT.'data/init_database.sql');

	//替换表前缀
	if($_POST['pre'] != 'mcms_') {
		$structure = str_replace('`mcms_','`'.$_POST['pre'],$structure);
		$init_database = str_replace('`mcms_','`'.$_POST['pre'],$init_database);
	}

	//新建数据表
	$structure = explode(";\n",$structure);

	$rs = array();
	foreach($structure as $k=>$v) {
		mysql_query($v);
		$tmp = str_replace(array('comment','\'',';'),'',substr($v,strripos($v,'comment')));
		$rs[] = array(mysql_error(),$tmp.' '.(mysql_error() ? '创建失败' : '创建成功'),(mysql_error() ? 'error_span' : 'correct_span'));
	}

	//插入默认数据
	$sql = array();
	$sql[] = "insert into ".$_POST['pre']."group (group_id,group_name,group_level,group_type,group_remark,create_time) values ('1', '系统管理员', '100', '0', '内置', '".time()."')";
	$sql[] = "insert into ".$_POST['pre']."group (group_id,group_name,group_level,group_type,group_remark,create_time) values ('2', '注册会员', '', '0', '内置', '".time()."')";
	$login_salt = H::security_code();
	$sql[] = "insert into ".$_POST['pre']."user(uid,login_name,login_email,login_pass,login_salt,login_group,login_level,create_time) values('1','".$_POST['manager']."','".$_POST['manager_email']."','".H::password_encrypt_salt($_POST['manager_pwd'],$login_salt)."','".$login_salt."','1','100','".time()."')";

	foreach($sql as $v) {
		mysql_query($v);
	}

	//初始化数据
	$init_database = explode(";\n",$init_database);
	foreach($init_database as $k=>$v) {
		if(empty($v)) continue;
		mysql_query($v);
		if(mysql_error()) {
			$rs[] = array(mysql_error().$v,(mysql_error() ? '插入失败' : '插入成功'),(mysql_error() ? 'error_span' : 'correct_span'));
		}
	}

	$_SESSION['is_create'] = true;

	$_SESSION['create_info'] = $rs;

	die('{"code":"0","msg":"index.php?action=4"}');
} // end func

//正则修改文件配置
function file_replace($file,$rule,$value){
    $fc = file_get_contents($file);
    $fc = preg_replace($rule,$value,$fc);
    file_put_contents($file,$fc);
}

?>