<?php



/**

 * The Header for our theme.

 *

 * Displays all of the <head> section and everything up till <div id="main">

 *

 * @package WordPress

 * @subpackage Magazine

 * 

 */



?><!DOCTYPE html>

<!--[if IE 7]>

<html class="ie ie7" <?php language_attributes(); ?>>

<![endif]-->

<!--[if IE 8]>

<html class="ie ie8" <?php language_attributes(); ?>>

<![endif]-->

<!--[if IE 9]>

<html class="ie ie9" <?php language_attributes(); ?>>

<![endif]-->

<!--[if !(IE 7) | !(IE 8) | !(IE 9)  ]><!-->

<html <?php language_attributes(); ?>>

<!--<![endif]-->



<head>



<title><?php

	/*

	 * Print the <title> tag based on what is being viewed.

	 */

	global $page, $paged;



	wp_title( '|', true, 'right' );



	// Add the blog name.

	bloginfo( 'name' );



	// Add the blog description for the home/front page.

	$site_description = get_bloginfo( 'description', 'display' );

	if ( $site_description && ( is_home() || is_front_page() ) )

		echo " | $site_description";



	// Add a page number if necessary:

	if ( $paged >= 2 || $page >= 2 )

		echo ' | ' . sprintf( __( 'Страница %s', 'magazine' ), max( $paged, $page ) );

	?></title>



<meta charset="<?php bloginfo( 'charset' ); ?>" />

<?php

$favicon = of_get_option('magz_favicon');
if($favicon) {
?>
<link rel="shortcut icon" href="<?php echo $favicon; ?>" title="Favicon"/>
<?php } else { ?>
<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/images/favicon.png" title="Favicon"/>
<?php } ?>

<meta name="viewport" content="width=device-width" />

<meta name="description" content="<?php echo of_get_option('magz_seodesc'); ?>" />

<meta name="keywords" content="<?php echo of_get_option('magz_seokeywords'); ?>" />

<link rel="profile" href="http://gmpg.org/xfn/11" />

<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />



<?php wp_head(); ?>



</head>



<body <?php body_class(); ?>>


<div id="page">


	<?php 
		// Header Ads
		magazine_header_ads(); 
	?> 


	<header id="header" class="container">

		<hgroup id="mast-head">

			<?php if ( (of_get_option('magz_logo')) !='' ) { ?>

			<div id="logo">

			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php echo of_get_option('magz_logo'); ?>" alt="<?php bloginfo('name'); ?>" /></a>

			</div>

			<?php } else {?>

			<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>

			<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>

			<?php } ?>

		</hgroup>



        <nav class="navbar navbar-inverse clearfix nobot">

            <button type="button" class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse">

              <span class="icon-bar"></span>

              <span class="icon-bar"></span>

              <span class="icon-bar"></span>

            </button>



            <!-- Responsive Navbar Part 2: Place all navbar contents you want collapsed withing .navbar-collapse.collapse. -->

            <div class="nav-collapse collapse">



			<ul class="nav">

				<li><a href="<?php echo home_url( '/' ); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/home.png"></a></li>



				<?php

				if ( function_exists( 'has_nav_menu' ) && has_nav_menu( 'primary' ) ) {

					wp_nav_menu( array( 'depth' => 6, 'sort_column' => 'menu_order', 'container' => '', 'items_wrap' => '%3$s', 'theme_location' => 'primary' ) );

				} else {

					wp_list_categories( 'sort_column=menu_order&depth=6&title_li=' );

				} ?>



			</ul>



            </div><!--/.nav-collapse -->



        </nav><!-- /.navbar -->



	</header><!-- #masthead -->





<?php if ( 1 == of_get_option('magz_headline') ) { ?>



	<div id="headline" class="container">

	<div class="row-fluid">

		<?php

			$args = array(

			'posts_per_page' => 4,

			'post_type' => array( 'post', 'page' ),

			'meta_key' => 'magz_headline', // metabox ID (prefix) + field ID

			'meta_value' => 'on' // this is checked checkbox

		);



		// The Query

		$query = new WP_Query( $args );



		// The Loop

		if ( $query->have_posts() ) {

			while ( $query->have_posts() ) {

				$query->the_post(); ?>

				<div class="span3">

				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

				<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( __( 'Permalink to %s', 'magazine' ), the_title_attribute( 'echo=0' ) ) ); ?>" rel="bookmark">

				<?php if ( has_post_thumbnail() ) { 

					the_post_thumbnail('thumbs', array('class' => 'thumb')); 

					} else { ?>

					<img class="thumb" src="<?php echo get_template_directory_uri(); ?>/images/thumb_225x136.png">

				<?php } ?>

				</a>

					<div class="entry">

					<h3><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( __( 'Permalink to %s', 'magazine' ), the_title_attribute( 'echo=0' ) ) ); ?>" rel="bookmark"><?php the_title_limit('', '...', true, '35'); ?></a></h3>

					<p><?php echo human_time_diff( get_the_time('U'), current_time('timestamp') ) . ' назад'; ?> </p>

					</div><div class="clearfix"></div>

				</article>

				</div>

			<?php	}

		} else {



		// no posts found

		}



		/* Restore original Post Data */

		wp_reset_postdata();

		?>



	</div>

	</div>

<?php } ?>



	<div id="intr" class="container">

		<div class="row-fluid">



		<?php if ( 1 == of_get_option('magz_brnews') ) { ?>



		<div class="brnews span9">

			<h3>Горячие новости</h3>

				<ul id="scroller">



				<?php

					$args = array(

						'posts_per_page' => 4,

						'post_type' => array( 'post', 'page' ),

						'meta_key' => 'magz_topnews', // metabox ID (prefix) + field ID

						'meta_value' => 'on' // this is checked checkbox

						);



					$loop = new WP_Query($args);



						if ( $loop->have_posts() ) {

							while ( $loop->have_posts() ) {

							$loop->the_post(); ?>

								<li>

									<p><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( __( 'Permalink to %s', 'magazine' ), the_title_attribute( 'echo=0' ) ) ); ?>" rel="bookmark"><span class="title"><?php the_title_limit('', '...', true, '20'); ?></span>

									<?php echo get_excerpt(50); ?><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( __( 'Permalink to %s', 'magazine' ), the_title_attribute( 'echo=0' ) ) ); ?>" rel="bookmark"></a></p>

								</li>

							<?php	} 

						} else {



						// no posts found

						}



					/* Restore original Post Data */

					wp_reset_postdata();

				?>

				</ul>

		</div>

		<?php } ?>



		<div class="search span3"><div class="offset1"><?php get_search_form(); ?></div></div><div class="clear"></div>

		

		</div>

	</div>



	<div id="content" class="container">