<?php
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');
	
	if ( post_password_required() ) { ?>
		This post is password protected. Enter the password to view comments.
	<?php
		return;
	}
?>
<div id="pir_comments" class="cf">
	<?php 
		$pirenko_options=get_option('zuper_theme_options');
		if ( have_comments() ) : ?>
        
        <div id="comments" class="cf">
            <h3><?php comments_number($pirenko_options['z-comments_no_response'], $pirenko_options['z-comments_one_response'], '% ' . $pirenko_options['z-comments_oneplus_response'] );?></h3>
        </div>
    
        <div class="navigation_cmt cf">
            <div class="next-posts"><?php previous_comments_link() ?></div>
            <div class="prev-posts"><?php next_comments_link() ?></div>
        </div>
    
        <ol class="commentlist cf">
            <?php str_replace( 'Hola', '', wp_list_comments() ); ?>
        </ol>
    
        <div class="navigation_cmt cf">
            <div class="next-posts"><?php previous_comments_link() ?></div>
            <div class="prev-posts"><?php next_comments_link() ?></div>
        </div>
        
     <?php else : // this is displayed if there are no comments so far ?>
    
        <?php if ( comments_open() ) : ?>
            <!-- If comments are open, but there are no comments. -->
            <div id="empty_comments"><h4><?php echo $pirenko_options['z-no_comments_yet']; ?></h4></div>
         <?php else : // comments are closed ?>
            <div id="empty_comments"><h3><?php echo $pirenko_options['z-comments_closed']; ?></h3></div>
    
        <?php endif; ?>
        
    <?php endif; ?>
    
    <?php if ( comments_open() ) : ?>
    
    <div id="respond">
        <div id="respond_title">
            <h3><?php comment_form_title( $pirenko_options['z-comments_leave_reply'], $pirenko_options['z-comments_leave_reply'] . ' to %s' ); ?></h3>
        </div>
        <div class="cancel-comment-reply">
            <?php cancel_comment_reply_link(); ?>
        </div>
    
        <?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
            <p>You must be <a href="<?php echo wp_login_url( get_permalink() ); ?>">logged in</a> to post a comment.</p>
        <?php else : ?>
    
        <form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">
    
            <?php if ( is_user_logged_in() ) : ?>
    
                <p>Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="Log out of this account">Log out &raquo;</a></p>
    
            <?php else : ?>
    
                <div>
                	<div class="form_name_icon man_icon">À</div>
                    <input type="text" class="pirenko_highlighted" name="author" id="author" value="<?php echo esc_attr($comment_author); ?>" size="36" tabindex="1" <?php if ($req) echo "aria-required='true'"; ?> placeholder="<?php echo $pirenko_options['z-comments_name_text']; ?>" />
               
                    <?php 
					if (!isset($message_error))
						$message_error='';
					if($message_error != '') 
                    { 
                        ?>
                        <p class="error"><?php echo $message_error;?></p>
                        <?php 
                    } 
                    ?>
                </div>
                <div>
                	<div class="form_name_icon">5</div>
                    <input type="text" class="pirenko_highlighted" name="email" id="email" value="<?php echo esc_attr($comment_author_email); ?>" size="36" tabindex="2" <?php if ($req) echo "aria-required='true'"; ?> 
                    placeholder="<?php echo $pirenko_options['z-comments_email_text']; ?>" />
                </div>
    
                <div>
                	<div class="form_name_icon link_icon">Õ</div>
                    <input type="text" class="pirenko_highlighted" name="url" id="url" value="<?php echo esc_attr($comment_author_url); ?>" size="36" tabindex="3"  
                    placeholder="<?php echo $pirenko_options['z-comments_website_text']; ?>" />
                </div>
    
            <?php endif; ?>
    
            <!--<p>You can use these tags: <code><?php echo allowed_tags(); ?></code></p>-->
    
            <div>
                <textarea name="comment" class="pirenko_highlighted" id="comment" cols="74" rows="10" tabindex="4"></textarea>
            </div>
    		<?php
				if (!isset($pirenko_options['z-comments_submit']))
					$pirenko_options['z-comments_submit']='Submit Comment';
			?>
            <div>
                <input name="submit" type="submit" id="submit" class="all_button default_button" tabindex="5" value="<?php echo $pirenko_options['z-comments_submit']; ?>" />
                <?php comment_id_fields(); ?>
            </div>
            
            <?php do_action('comment_form', $post->ID); ?>
            <div id="comment_ok">
                <?php echo "Please Wait..." ?>
            </div>
        </form>
    
        <?php endif; // If registration required and not logged in ?>
        
    </div>
    <?php endif; ?>
</div>
<script type="text/javascript">
	jQuery(document).ready(function()
    {
		<?php echo get_option('siteurl'); ?>
    	var template_directory = '<?php bloginfo('template_directory'); ?>';
		var template_name = '<?php bloginfo('name'); ?>';
		var wordpress_directory = '<?php echo get_option('siteurl'); ?>';
		jQuery("#commentform").submit(function(e) 
		{
			//PREVENT DEFAULT PROCESSING
            e.preventDefault();	
			//REMOVE PREVIOUS ERRORS IF THEY EXIST
            jQuery("#commentform .error,#commentform p").remove();
            var value, theID, empty_error, email_error, error, emailReg, contact_wait, contact_ok;
            empty_error = '<p class="error">' + jQuery("#php_contact_error").html() + '</p>';
         	email_error = '<p class="error">' + jQuery("#php_contact_error_email").html() + '</p>';
			contact_ok='<p>' + jQuery("#php_contact_ok").html() + '</p>';
            error = false;
            emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;				
            //DATA VALIDATION
            jQuery('#commentform textarea, #author, #email').each(function()
            {
 	            value = jQuery(this).val();
              	theID = jQuery(this).attr('id');
            	if(value == '')
             	{
                	jQuery(this).parent().append('<p class="error">'+empty_error+'</p>');
                 	error = true;
                }
             	if(theID == 'email' && value != '' && !emailReg.test(value))
                {
              		jQuery(this).parent().append('<p class="error">'+email_error+'</p>');
                    error = true;
                }
         	});
			//SEND COMMENT IF THERE ARE NO ERRORS
           	if(error == false)
          	{
				//HIDE THE SEND BUTTON
				jQuery("#submit").fadeTo("slow",0,
				function() //ON COMPLETE MAKE THE BUTTON INVISIBLE
				{
      				jQuery("#submit").addClass("hidden_div");	
					jQuery("#comment_ok").fadeIn("slow");
					//POST COMMENT
					jQuery.ajax({  
					type: "POST",  
					url: wordpress_directory+"/wp-comments-post.php",  
					data: jQuery("#commentform").serialize(),  
					success: function(resp)
					{  		
						jQuery("#comment_ok").html("Thank you for your feedback!");
					},  
					error: function(e)
					{  
						alert('Error: ' + e);  
					}  
				});
   			});
			}
		});	
	});
</script>
