<?php
/*
Template Name: Contact Page
*/
?>
	<?php
    get_header();
    //INITIALIZE VARIABLES
    $name_error = '';
    $email_error = '';
    $subject_error = '';
    $message_error = '';
    //GET CUSTOM THEME OPTIONS
	if (isset($_REQUEST['c_submitted']))
	{
		if($_REQUEST['c_submitted'])
		{
			$c_name = trim($_REQUEST['c_name']);
			$c_email = trim($_REQUEST['c_email']);
			$c_subject = trim($_REQUEST['c_subject']);
			$c_message = trim($_REQUEST['c_message']);
			//SEND EMAIL IF THERE ARE NO ERRORS
			if($error != true) 
			{
				$email_to =$pirenko_options['z-email_address']; 
				$message_body = "Name: $c_name \n\nEmail: $c_email \n\nComments: $c_message";
				$headers = "From: ".get_bloginfo('title')."\r\n" .'Reply-To: ' . $c_email;
				mail($email_to, $c_subject, $message_body, $headers);
				$email_sent = true;
			}
		}
	}
    ?>
	<div id="center_area">
		<div id="posts_wrapper_c">
			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>     
                <div class="post_page" id="post-<?php the_ID(); ?>">
        			<div class="home_block_no_margin boxed_shadow">
                    	<h2><?php the_title(); ?></h2>
        			</div><!-- m_page_header -->
                    <div id="google-maps" class="white_bg boxed_shadow cf">
            	<?php echo $pirenko_options['z-google-maps']; ?>
         	</div><!-- google_maps -->
                    <div id="contact-form_wrapper" class="contact_block white_bg boxed_shadow cf">
                        <h3>
								<?php the_content(); ?>
                        </h3>
        
                        <?php wp_link_pages(array('before' => 'Pages: ', 'next_or_number' => 'number')); ?>
        		
                    
    
            <?php endwhile; endif; ?>
         	<div >
           		<form action="" id="contact-form" method="post">
                	<div>
                    	<div class="form_name_icon man_icon">À</div>
                    	<input type="text" class="pirenko_highlighted" name="c_name" id="c_name" size="28" 
                        placeholder="<?php echo $pirenko_options['z-contact_name_text']; ?>" />
                   	<?php if($name_error != '') 
					{ 
						?>
                    	<p class="error"><?php echo $name_error;?></p>
                        <?php 
					} 
					?>
                    </div>
                    <div>
                    	<div class="form_name_icon">5</div>
                     	<input type="text" class="pirenko_highlighted" name="c_email" id="c_email" size="28" 
                        placeholder="<?php echo $pirenko_options['z-contact_email_text']; ?>" />
                    <?php if($email_error != '')
					{ 
						?>
                       	<p class="error"><?php echo $email_error;?></p>
                    	<?php 
					} 
					?>
                    </div>
                    <div>
                    	<div class="form_name_icon info_icon">%</div>
                      	<input type="text" class="pirenko_highlighted" name="c_subject" id="c_subject" size="28" 
                        placeholder="<?php echo $pirenko_options['z-contact_subject_text']; ?>" />
                    </div>
                   	<div>
                   		<textarea class="pirenko_highlighted" name="c_message" id="c_message" rows="6"></textarea>
                   	</div>
                   	<?php if($message_error != '') 
					{ 
						?>
                        <p class="error"><?php echo $message_error;?></p>
                        <?php 
					} 
					if (!isset($pirenko_options['z-contact_submit']))
						$pirenko_options['z-contact_submit']='Send Message';
					?>
                    <input type="hidden" id="full_subject" name="full_subject" value="" />
                   	<input type="hidden" name="rec_email" value="<?php echo $pirenko_options['z-email_address']; ?>" />
                   	<input type="submit" class="all_button default_button" name="c_submit" id="c_submit" value="<?php echo $pirenko_options['z-contact_submit']; ?>">
                   	<input type="hidden" name="c_submitted" id="c_submitted" value="true" />
                  	<div id="contact_ok"><?php echo $pirenko_options['z-contact_wait_text']; ?></div>
     			</form>
       		</div><!-- contact-form -->
            </div>
            <div id="contact_address" class="white_bg boxed_shadow cf">
            	<h3><?php echo do_shortcode($pirenko_options['z-contact-info_title']); ?></h3>
                <?php
					if ($pirenko_options['z-contact-address']!="")
					{
						?>
                        <div class="contact_address_block cf">
                            <?php echo home_icon_shortcode(); ?> 
                            <h5 class="contact_address_right">
                                <?php echo do_shortcode($pirenko_options['z-contact-address']); ?>
                            </h5>
                        </div>
                        <?php
					}
					if ($pirenko_options['z-contact-info_tel']!="")
					{
						?>
                        <div class="contact_address_block cf">
                            <?php echo phone_icon_shortcode(); ?> 
                            <h5 class="contact_address_right_single">
                                <?php echo do_shortcode($pirenko_options['z-contact-info_tel']); ?>
                            </h5>
                        </div>
                        <?php
					}
					if ($pirenko_options['z-contact-info_fax']!="")
					{
						?>
                        <div class="contact_address_block cf">
                            <?php echo fax_icon_shortcode(); ?> 
                            <h5 class="contact_address_right_single">
                                <?php echo do_shortcode($pirenko_options['z-contact-info_fax']); ?>
                            </h5>
                        </div>
                        <?php
					}
					//FUNCTION TO PROTECT EMAIL SPAM
					function hide_email($email, $display)
					{ 
						$character_set = '+-.0123456789@ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz';
						$key = str_shuffle($character_set); $cipher_text = ''; $id = 'e'.rand(1,999999999);
						for ($i=0;$i<strlen($email);$i+=1) $cipher_text.= $key[strpos($character_set,$email[$i])];
						$script = 'var a="'.$key.'";var b=a.split("").sort().join("");var c="'.$cipher_text.'";var d="";';
						$script.= 'for(var e=0;e<c.length;e++)d+=b.charAt(a.indexOf(c.charAt(e)));';
						$script.= 'document.getElementById("'.$id.'").innerHTML="<a href=\\"mailto:"+d+"\\">' . $display . '</a>"';
						$script = "eval(\"".str_replace(array("\\",'"'),array("\\\\",'\"'), $script)."\")"; 
						$script = '<script type="text/javascript">/*<![CDATA[*/'.$script.'/*]]>*/</script>';
						return '<span id="'.$id.'">[javascript protected email address]</span>'.$script;
					}

					if ($pirenko_options['z-contact-info_email']!="")
					{
						?>
                        <div class="contact_address_block cf">
                            <?php echo email_icon_shortcode(); ?> 
                            <h5 class="contact_address_right_single">
                                <?php echo hide_email($pirenko_options['z-contact-info_email'], $pirenko_options['z-contact-info_email']);?>
                            </h5>
                        </div>
                        <?php
					}
				?>
                <div class="contact_address_block cf pir_italic">
                    	<h6>
							<?php echo do_shortcode($pirenko_options['z-contact-address_info_msg']); ?>
                       	</h6>
                </div>
            </div>
            
        
                </div> 
		</div><!-- posts_wrapper --> 
		<script type="text/javascript">
            jQuery(document).ready(function()
            {
                
				var template_directory = '<?php bloginfo('template_directory'); ?>';
				var template_name = '<?php bloginfo('name'); ?>';
				jQuery("#contact-form").submit(function(e) 
				{				
					//PREVENT DEFAULT PROCESSING
                    e.preventDefault();	
					//REMOVE PREVIOUS ERRORS IF THEY EXIST
                    jQuery("#contact-form .error,#contact-form p").remove();
        
					//ADD THE TEMPLATE NAME TO THE SUBJECT
					helper=jQuery('#c_subject').attr('value');
					jQuery('#full_subject').attr('value',template_name+' - '+helper);
					
                    var value, theID, empty_error, email_error, error, emailReg, contact_wait, contact_ok;
                    empty_error = '<p class="error">' + jQuery("#php_contact_error").html() + '</p>';
                    email_error = '<p class="error">' + jQuery("#php_contact_error_email").html() + '</p>';
					contact_ok='<p>' + jQuery("#php_contact_ok").html() + '</p>';
                    error = false;
                    emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;				
        
                    //DATA VALIDATION
                    jQuery('#contact-form textarea, #c_name, #c_email, #c_message').each(function()
                    {
                        value = jQuery(this).val();
                        theID = jQuery(this).attr('id');
                        if(value == '')
                        {
                            jQuery(this).parent().append('<p class="error">'+empty_error+'</p>');
                            error = true;
                        }
                        if(theID == 'c_email' && value != '' && !emailReg.test(value))
                        {
                            jQuery(this).parent().append('<p class="error">'+email_error+'</p>');
                            error = true;
                        }
                    });
					jQuery('#contact-form_wrapper,#contact_address').css({'height':'auto'});
					if (jQuery('#contact_address').height()<jQuery('#contact-form_wrapper').height())
					{
						jQuery('#contact_address').height(jQuery('#contact-form_wrapper').height());	
					}
					else
					{
						jQuery('#contact-form_wrapper').height(jQuery('#contact_address').height());
					}
					
					//SEND EMAIL IF THERE ARE NO ERRORS
                    if(error == false)
                    {
						//HIDE THE SEND BUTTON
						jQuery("#c_submit").fadeTo("slow",0,
						function() //ON COMPLETE MAKE THE BUTTON INVISIBLE
						{
      						jQuery("#c_submit").addClass("hidden_div");	
							jQuery("#contact_ok").fadeIn("slow");
							//SEND EMAIL
							jQuery.ajax({  
							type: "POST",  
							url: template_directory+"/includes/pirenko_contact_form.php",  
							data: jQuery("#contact-form").serialize(),  
							success: function(resp)
							{  
								if(resp == 'sent') 
								{
									jQuery("#contact_ok").html(contact_ok);
								}
								else 
								{
									jQuery("#contact_ok").html(resp);
								}
								
							},  
							error: function(e)
							{  
								alert('Error: ' + e);  
							}  
						});
   						});
					}
				});	
        
            });
        </script>
<?php get_footer(); ?>