<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
<head profile="http://gmpg.org/xfn/11">
	<meta charset="UTF-8"/>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<?php if (is_search()) 
	{ ?>
	   <meta name="robots" content="noindex, nofollow" /> 
	<?php 
	}
	?>
	<title>
		<?php 
			if (function_exists('is_tag') && is_tag())  		
			{ 			
				single_tag_title("Tag Archive for &quot;"); 
				echo '&quot; - '; 
			} 		      
			elseif (is_archive()) 
			{ 		         
				wp_title(''); 
				echo ' Archive - '; 
			} 		      
			elseif (is_search()) 
			{ 		         
				echo 'Search for &quot;'.esc_html($s).'&quot; - '; 
			} 		      
			elseif (!(is_404()) && (is_single()) || (is_page())) 
			{ 		         
				wp_title(''); 
				echo ' - '; 
			} 		      
			elseif (is_404()) 
			{ 		         
				echo 'Not Found - '; 
			} 		      
			if (is_home()) 
			{ 		         
				bloginfo('name'); 
				echo ' - '; 
				bloginfo('description'); 
			} 		      
			else 
			{ 		          
				bloginfo('name'); 
			} 		      
			if ($paged>1) 
			{ 		         
				echo ' - page '. $paged; 
			} 		   
		?>
    </title>
	<!--CSS CUSTOM FILES-->
	<link href="<?php bloginfo('template_directory'); ?>/js/jquery.qtip.css" rel="stylesheet" type='text/css' />
	<link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/includes/plugins/anything_slider/css/anythingslider.css" />
	<link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/includes/plugins/anything_slider/css/theme-cs-portfolio.css" />
    <link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/includes/fonts/iconic_font/stylesheet.css" type="text/css" charset="utf-8" />
	<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); echo '?' . filemtime( get_stylesheet_directory() . '/style.css'); ?>" type="text/css" />
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
    <?php
		if ( is_singular() ) 
			wp_enqueue_script( 'comment-reply' ); 
		wp_head();
		//GET THE THEME OPTIONS AND ADJUST CONTENT
		zuper_head(); 
		global $pirenko_options; 
		$pirenko_options=get_option('zuper_theme_options');
		//OVERRIDE OPTIONS ONLY IF IN PREVIEW MODE
		if (isset($_SESSION['front_active_color']))
		{
			if ($_SESSION['front_active_color']!="")
				$pirenko_options['z-active_color']=$_SESSION['front_active_color'];
		}
		if (isset($_SESSION['front_skin']))
		{
			if ($_SESSION['front_skin']!="")
			{
				$pirenko_options['z-icon_set']=$_SESSION['front_skin'];
				if ($_SESSION['front_skin']=="dark")
				{
					$pirenko_options['z-background_color']="0d0d0d";
					$pirenko_options['z-custom_opacity']=88;
					
				}
				else
				{
					$pirenko_options['z-background_color']="ffffff";
					$pirenko_options['z-custom_opacity']=70;
				}
			}
		}
		
		if (isset($_SESSION['front_pattern']))
		{
			if ($_SESSION['front_pattern']!="")
				$pirenko_options['z-pattern']=$_SESSION['front_pattern'];
		}
		if (isset($post->ID) ? $post->ID=="1364" : false)
		{
			$pirenko_options['z-icon_set']="dark";
		}
		add_action('wp_footer','pluginname_ajaxurl');
		function pluginname_ajaxurl() 
		{
			$pirenko_options_ajax=get_option('zuper_theme_options');
			//GET PORTFOLIO PAGE LINK
			$pages_port = get_pages(array(
				'meta_key' => '_wp_page_template',
				'meta_value' => 'template-portfolio.php'
			)); 
			foreach($pages_port as $page_port)
			{
				$z_portfolio_link=get_page_link( $page_port->post_id ); 
			}
			if (!is_single() || get_post_type()=="merc_news")
				$z_portfolio_link="false";
			//GET NEWS PAGE LINK
			$pages_ajax = get_pages(array(
				'meta_key' => '_wp_page_template',
				'meta_value' => 'template-news.php'
			)); 
			foreach($pages_ajax as $page_ajax)
			{
				$z_news_link_ajax=get_page_link( $page_ajax->post_id ); 
				$z_news_title_ajax = $page_ajax->post_title;
			}
			if (is_page_template ('template-news.php'))
				$z_news_link_ajax="false";
			$responsiveness="false";
			if (isset($pirenko_options_ajax['z-responsive']))
			{
				$responsiveness=$pirenko_options_ajax['z-responsive'];
				if ($responsiveness=="")
					$responsiveness="false";
			}
			
			?>
			<script type="text/javascript">
				var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
				var use_lightbox="<?php echo $pirenko_options_ajax['z-use_lightbox']; ?>";
				var home_slide_autoplay="<?php echo $pirenko_options_ajax['z-autoplay_home']; ?>";
				var home_slide_delay="<?php echo $pirenko_options_ajax['z-delay_home']; ?>";
				var home_slide_buildcontrols="<?php echo $pirenko_options_ajax['z-controls_home']; ?>";
				var portfolio_slide_autoplay="<?php echo $pirenko_options_ajax['z-autoplay_portfolio']; ?>";
				var portfolio_slide_buildcontrols="<?php echo $pirenko_options_ajax['z-controls_portfolio']; ?>";
				var portfolio_slide_delay="<?php echo $pirenko_options_ajax['z-delay_portfolio']; ?>";
				var news_slide_autoplay="<?php echo $pirenko_options_ajax['z-autoplay_news']; ?>";
				var news_link="<?php echo $z_news_link_ajax; ?>";
				var port_link="<?php echo $z_portfolio_link ?>";
				var responsiveness="<?php echo $responsiveness; ?>";
			</script>
			<?php
		} 
	?>
     <!-- GOOGLE FONTS - IF NEEDED -->
     <?php
	 	if (is_google_font($pirenko_options['z-header_font']))
		{
			?>
            <link href='http://fonts.googleapis.com/css?family=<?php echo ($pirenko_options['z-header_font']); ?>' rel='stylesheet' type='text/css' />
            <?php
		}
		else
		{
			?>
            <link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/includes/fonts/<?php echo ($pirenko_options['z-header_font']); ?>/stylesheet.css" type="text/css" charset="utf-8">
            <?php
		}
	?>
    
    <?php 
		if ($pirenko_options['z-body_font']!="Arial")
		{
			?>
			<link href='http://fonts.googleapis.com/css?family=<?php echo ($pirenko_options['z-body_font']); ?>' rel='stylesheet' type='text/css' />
            <?php
		}
	?>
     <?php
		if (isset($pirenko_options['z-favicon']))
		{
			?>
			<link rel="shortcut icon" href="<?php echo $pirenko_options['z-favicon']; ?>">
            <?php
		}
		else
		{
			?>
			<link rel="shortcut icon" href="<?php bloginfo('template_directory'); ?>/images/favicon.ico">
            <?php
		}
	?>
		
</head>
<body <?php body_class(); ?>>
	<?php
		//FOR PREVIEW ONLY
		if (is_page("1364"))
		{
			$pirenko_options['z-icon_set']="dark";
			$pirenko_options['z-background_color']="0d0d0d";
			$pirenko_options['z-custom_opacity']=88;
			$pirenko_options['z-pattern']="classy_fabric.png";
		}
		if (is_page("1442")) 
		{
			$pirenko_options['z-thumbs_bw']="yes";
			$pirenko_options['z-active_color']="E60909";
		}
		if (is_page("1461"))
		{
			$pirenko_options['z-bottom_sidebar']="yes";
		}
		if (isset($_GET['showall']))
		{
			if ($_GET['showall']=="true")
			{
				$pirenko_options['z-show_homepage_title']="yes";
				$pirenko_options['z-show_htmlblock']='4';
			}
		}
		//BACKGROUND CONFIGURATION 
		$hcss = "";
		$hcss .= "<style type='text/css'>\n";
		//CHECK IF IT'S A CATEGORY PAGE THAT HAS AN IMAGE ASSIGNED - POSTS
		global $wp_query;
		if (isset($wp_query->post->ID))
		{
			$pid = $wp_query->post->ID;
			$category = get_the_category($pid); 
		}
		if(!empty($category))
			$cat_data = get_option("category_".$category[0]->cat_ID."");
		else
			$cat_data['img']="";
		
		if ($cat_data['img']!="" && !is_home() && !is_search())//is_category() && 
		{
			?>
			<img id="full-screen-background-image" />
			<div id="preload_bk"><?php echo $cat_data['img']; ?></div>
			<?php		
		}
		else
		{
			//CHECK IF IT'S A NEWS PAGE THAT HAS A FEATURED IMAGE
			$selected_news=(get_query_var('pir_categories')) ? get_query_var('pir_categories'):'';
			if ($selected_news!="")
			{
				$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ));
				$t_ID = $term->term_id;
				$term_data = get_option("taxonomy_term_$t_ID");
			}
			else
			{
				if (is_single() && get_post_type()=="merc_news")
				{
					//GET PARENT CATEGORY BACKGROUND?
				}
			}
			if ($selected_news!="" && $term_data['img']!="")
			{
				?>
					<img id="full-screen-background-image" />
					<div id="preload_bk"><?php echo $term_data['img']; ?></div>
				<?php
			}
			else
			{
				//CHECK IF IT'S A PAGE THAT HAS A FEATURED IMAGE - PAGE
				//$template_file = get_post_meta($post_id,'_wp_page_template',TRUE);
				if (isset($post->ID) ? has_post_thumbnail( $post->ID ) && is_page() : false)
				{
					$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' );
					?>
					<img id="full-screen-background-image" />
					<div id="preload_bk"><?php echo $image[0]; ?></div>
					<?php
				}
				else
				{
					//CHECK IF A GENERAL BACKGROUND WAS SET ON THE CONTROL PANEL
					if ($pirenko_options['z-background_image']!="")
					{
						?>
						<img id="full-screen-background-image" />
						<div id="preload_bk"><?php echo $pirenko_options['z-background_image']; ?></div>
						<?php
					}
					else
					{
						//CHECK IF THERE'S A PATTERN TO DISPLAY
						if ($pirenko_options['z-pattern']!="")
						{
							$hcss .=
							"body
							{
								background: url(" . get_bloginfo('template_url') . "/images/patterns/".$pirenko_options['z-pattern'].");
								background-attachment:fixed;
							}";
						}
						else
						{
							//SET THE BODY COLOR
							$hcss .=
							"body
							{
								background-color:#".$pirenko_options['z-site_background_color'].";	
							}";
						}
					}
				}
			}
		}
		$hcss .= "</style>\n";			
		echo $hcss;
	?>
   	<div id="active_div"> </div>
    <div id="inactive_div"> </div>
    <div id="mid_div"> </div>
    <div id="darker_div"> </div>
    <div id="backgr_div"> </div>
    <div id="icons_dark_div"> </div>
    <div class="overlay"></div>
    <?php 
		if ($pirenko_options['z-top_sidebar']=="yes")
		{
			?>
            <div id="trapezoid_tr" class="boxed_shadow"></div>
            <!--widgets_sidebar-->
            <div id="minus_and_plus"><p>></p></div>
            <div id="plus_button_hidden"></div>
            <div id="top-sidebar-widgets" class="boxed_shadow">
                <div class="centered_top">
                	<div class="inner-center">
        
                    <?php 
                        if (function_exists('dynamic_sidebar') && dynamic_sidebar('Top Sidebar Widgets')) : 
                        else : 
                            ?>
                            <!-- THIS CONTENT WILL BE DISPLAYED IF THERE ARE NO WIDGETS -->
                            <div id="no-widgets" class="top_widgets">
                                <div id="pirenko_ads">
                                    <h3>. NO WIDGETS YET </h3>
                                        <p>
                                            There are still no widgets here. To add some content please go to the Dashboard and add some Widgets to the Top Sidebar. If you don't need this section just go to Mercina Options and switch off the Top Sidebar.
                                        </p>
                                </div><!-- pirenko_ads -->
                            </div><!-- no-widgets -->
                            <?php 
                        endif; 
                    ?>
                    </div>
            		<div id="height_helper">
                   	</div>
                </div><!--centered_top-->
                <div class="cf"></div>
            </div><!-- top-sidebar-widgets -->
            <?php
		}
	?>                  
	<div id="page-wrap" class="container cf">
		<?php 
		if (is_single())
		{
			?>
    			
            <?php
		}
		else
		{
			//IT'S A SINGLE PAGE: DON'T DISPLAY NEXT AND PREVIOUS ARROWS
			?>
    		<div id="mini_menu" style="display:none;"></div>
            <?php
		}
		?>
        <!--LEFT_SECTION-->
		<div id="left_area" class="cf four columns">
            <div id="left_area_in" class="cf">
                <!--TOP_SECTION-->
                <div id="menu_back" class="cf">
                    <div id="header">
                        <div id="logo">
                            <a href="<?php echo get_option('home'); ?>/">
                                <img id="zuper_logo_image" src="<?php echo ($pirenko_options['logo']); ?>" />
                            </a>
                        </div><!-- logo -->
                        <?php 
							if ($pirenko_options['z-slogan']!="")
							{
								?>
                                <div id="slogan" class="cf">
                                    <?php echo ($pirenko_options['z-slogan']); ?>
                                </div><!--slogan-->
                                <?php
							}
							else
							{
								?>
                                <div id="slogan_spacer" class="cf">
                                &nbsp;
                                </div><!--slogan_spacer-->
                                <?php
							}
							?>
                    </div><!-- header -->
                    <div class="z_divider_fk">
                	</div><!-- z_divider -->
                    <div class="z_divider_tp">
                	</div><!-- z_divider -->
                    <div class="z_divider_fk">
                	</div><!-- z_divider -->
                    <!--MENU-->
                    <div class="access">
                    	<div id="mmenu_wrapper">
                        <?php 
							wp_nav_menu(array('menu' => 'mercina_menu' ));
							echo "</div>";
							wp_nav_menu_select(array('theme_location' => 'select-menu'));
						 ?>
                        
                    </div><!-- access -->
    
                </div><!-- menu_back -->
                
                                    
                <!--LOWER_SECTION(SIDEBAR)-->
                <?php 
					if ($pirenko_options['z-left_sidebar_input']!="0" || $pirenko_options['z-left_sidebar']=="yes")
					{
						?>
                		<div class="z_divider">
                		</div><!-- z_divider -->
                        <?php
					}
				?>
            </div>
            
            <div id="trapezoid_l" class="cf">
            <!--FOOTER-->
            <div id="footer" class="cf">
                <div id="options_menu">
                	<div id="icons_bar">
                        <div id="left_search">
                        <?php 
							if ($pirenko_options['z-left_sidebar_input']=="1")
							{
								?>
                                <div id="help_text">
                                    <p><h5><?php echo $pirenko_options['z-submit_search_tip_text']; ?></h5></p>
                                </div><!-- help_text -->
                                <form method="get" id="searchform" action="<?php bloginfo('url'); ?>/">
                                <div>
                                    <input type="text" value="<?php if(is_search() ) { the_search_query(); } else { echo $pirenko_options['z-search_tip_text']; } ?>" name="s" id="s_form" onfocus="if(this.value=='<?php echo $pirenko_options['z-search_tip_text']; ?>')this.value=''" onblur="if(this.value=='')this.value='<?php echo $pirenko_options['z-search_tip_text']; ?>'" class="input_search pirenko_highlighted" />
                                    
                                </div>
                                </form>
                                <?php
							}
							if ($pirenko_options['z-left_sidebar_input']=="2")
							{
								?>
                                <div id="help_text">
                                    <p><h5><?php echo $pirenko_options['z-submit_newsletter_tip_text']; ?></h5></p>
                                </div><!-- help_text -->
								<form id="newsletter_form" action="#"  method="post">
                                <div>
                                <input type="text" name="email" id="left_email" value="<?php echo $pirenko_options['z-newsletter_tip_text']; ?>" onfocus="if(this.value=='<?php echo $pirenko_options['z-newsletter_tip_text']; ?>')this.value=''" onblur="if(this.value=='')this.value='<?php echo $pirenko_options['z-newsletter_tip_text']; ?>'" class="pirenko_highlighted"/>
                                </div>
                                </form>
                                <?php
							}
							if($pirenko_options['z-left_sidebar_input']=="0")
							{
								//ADJUST LEFT SIDEBAR
						echo 	'<style type="text/css">
										#options_menu
										{
											display:none;
										}
										#left-sidebar-widgets
										{
											margin-top: 0px;	
										}
										</style>';	
							}
						?>
						
                    	</div><!-- left_search -->
                	</div><!-- icons bar -->
                    	
                </div><!-- options_menu -->
                <?php 
					if ($pirenko_options['z-left_sidebar']=="yes")
					{
						?>
						<div id="left-sidebar-widgets" class="pirenko_preloaded">
						<?php 
							if (function_exists('dynamic_sidebar') && dynamic_sidebar('Left Sidebar Widgets')) : 
							else : 
								?>
								<!-- THIS CONTENT WILL BE DISPLAYED IF THERE ARE NO WIDGETS -->
								<div id="no-widgets" class="left_widgets">
									<div id="pirenko_ads">
										<h4>. NO WIDGETS YET </h4>
											<p><em>
												There are still no widgets here... To add some content here please go to the Dashboard and add some Widgets to the Left Sidebar. If you don't need this section just go to Mercina Options and switch off the Left Sidebar.
											</em></p>
									</div><!-- pirenko_ads -->
								</div><!-- no-widgets -->
								<?php 
							endif; 
						?>
						</div><!-- left-sidebar-widgets -->
						<?php
					}
					else
					{
						echo 	'<style type="text/css">
										#icons_bar
										{
											margin-bottom: 32px;
										}
										</style>';	
					}
				?>
                <div class="z_divider_bt">
                	</div><!-- z_divider_bt -->
				</div><!-- FOOTER -->
                <div id="footer_text">
                    <h5>
                        <?php echo $pirenko_options['z-footer_text']; ?>，<a href="http://www.mobanbus.cn" target="_blank" title="Mobanbus">Mobanbus</a>
                    </h5>
                </div>
                <div id="mini_menu_bottom">
                    <div id="back_to_top" class="cf">
                        <div id="bk_top" class="cf">
                            <div class="mini_arrow_up cf">'</div>
                        </div>
                    </div>
                    
                </div>
			</div>
		</div><!-- left_area -->
        