<?php
	//ADD SOME STYLES TO THE BACKEND PANEL
	add_action('admin_head', 'pirenko_custom');
	function pirenko_custom() 
	{
	   	echo '<style type="text/css">
		#pirenko_options form
		{
			overflow: hidden;
			position: relative;
		}
		#zuper_options
		{
			width:1000%;
			margin-top:-16px;
		}
		#zuper_options em
		{
			color:#666;
		}
		#zuper_options h3
		{
			color:#333;
			text-decoration:underline;
			margin:8px 0px 0px 0px;
		}
		.zuper_tab_options
		{
			float:left;
		}
		#pirenko_admin_menu
		{
			padding-right:63px;
			padding-left:2px;
		}
		#pirenko_admin_menu ul
		{
			list-style-type: none;
			background-image: url('.get_bloginfo('template_directory').'/images/admin/navi_bg.png);
			height: 32px;
			margin: auto;
		}
		#pirenko_admin_menu li 
		{
			float: left;
			margin-bottom:0px;
			
		}
		#pirenko_admin_menu ul a 
		{
			background-image: url('.get_bloginfo('template_directory').'/images/admin/navi_bg_divider.png);
			background-repeat: no-repeat;
			background-position: right;
			padding-right: 12px;
			padding-left: 12px;
			display: block;
			line-height: 32px;
			text-decoration: none;
			font-size: 13px;
			color: #21759B;
			font-weight:bold;
		}
		#pirenko_admin_menu ul a:hover 
		{
			color: #D54E21;
		}
		#pirenko_admin_menu_footer
		{
			font-size: 9px;
			float:right;
			padding-top:7px;
			padding-right:8px;
			color:#777777;
		}
		.zuper_tab_options
		{
			margin:0px;
			bottom:0px;
			width:10%;
			float:left;
			height:100%;
		}
		.pirenko_cms_image
		{
			border:1px;
			border-style:solid;
			border-color:#CCC;
			max-height:200px;
		}
		.pirenko_upload
		{
				
		}
		.icons_preview
		{
			margin-left:15px;
			float:left;
			padding:4px;
			margin-top:-5px;
		}
		#zuper_selector
		{
			margin-top:5px;	
		}
		.left_float
		{
			float:left;
		}
		#clear_icons
		{
			background-color:#111;
			height:26px;
			
		}
		.hidden_icons
		{
			display:none;	
		}
		.preview_color
		{
			width:20px;
			height:20px;
			position:absolute;
			margin-left:215px;
			margin-top:-22px;
		}
		#z-css_text
		{
			height:150px;
		}
		#overlay_preview
		{
			height: 80px;
			width: 200px;
			float: left;
			margin-left:10px;
		}
		.preview_pattern
		{
			height: 80px;
			width: 200px;
			float: left;
			margin-left:10px;
		}
		.pirenko_reset_button
		{
			float: right;
    		margin-right: 64px;
    		margin-top: -37px;
		}
		#pattern_selector
		{
			float:left;	
		}
		.slides_image_preview {
			height:100px;	
		}
		</style>';
	}

	//ADD SOME SHORTCODES
	//LISTS
	function list_with_icons_shortcode( $atts, $content = null ) 
	{
		$custom_icons="";
		if (isset($atts['icon']))
			$custom_icons=$atts['icon'];
	return '<div class="list_with_icons '. $custom_icons .'">' . $content . '</div>';
	}
	add_shortcode('list_with_icons', 'list_with_icons_shortcode');
	//BLOCKQUOTES
	function blockquotes_shortcode( $atts, $content = null ) 
	{
	   return '<blockquote>' . $content . '<div class="mercina_author">' . $atts['bf_author'] . $atts['author'] . '</div>' . '</blockquote>';
	}
	add_shortcode('mercina_blockquote', 'blockquotes_shortcode');
	//IMAGE WITH NO MARGINS
	function imagenomargins_shortcode( $atts, $content = null ) 
	{
	   return '<div class="mer_no_mg" style="margin-top:-30px;margin-left:-30px;margin-right:-30px;">' . $content . '</div>';
	}
	add_shortcode('img_no_margin', 'imagenomargins_shortcode');
	//OK BOX
	function ok_box_shortcode( $atts, $content = null ) 
	{
	   return '<p class="rounded_box ok_box">' . $content . '</p>';
	}
	add_shortcode('ok_box', 'ok_box_shortcode');
	//INFO BOX
	function info_box_shortcode( $atts, $content = null ) 
	{
	   return '<p class="rounded_box info_box">' . $content . '</p>';
	}
	add_shortcode('info_box', 'info_box_shortcode');
	//WARNING BOX
	function warning_box_shortcode( $atts, $content = null ) 
	{
	   return '<p class="rounded_box warning_box">' . $content . '</p>';
	}
	add_shortcode('warning_box', 'warning_box_shortcode');
	//ERROR BOX
	function error_box_shortcode( $atts, $content = null ) 
	{
	   return '<p class="rounded_box error_box">' . $content . '</p>';
	}
	add_shortcode('error_box', 'error_box_shortcode');
	//SIMPLE BOX
	function simple_box_shortcode( $atts, $content = null ) 
	{
		$mcustom_bk="#EBEBEB";
		if (isset($atts['bk_color']))
			$mcustom_bk=$atts['bk_color'];
		$mcustom_cl="#969696";
		if (isset($atts['ct_color']))
			$mcustom_cl=$atts['ct_color'];
		return '<p class="simple_box" style="background-color:'.$mcustom_bk.';color:'.$mcustom_cl.';border: 1px solid '.$mcustom_cl.';">' . $content . '</p>';
	}
	add_shortcode('simple_box', 'simple_box_shortcode');
	//BUTTON SHORTCODES
	function dark_button_shortcode( $atts, $content = null ) 
	{
	   return "<input class='all_button dark_button' type='button' value='".$content."'></input>";
	}
	add_shortcode('dark_button', 'dark_button_shortcode');
	
	function grey_button_shortcode( $atts, $content = null ) 
	{
	   return "<input class='all_button grey_button' type='button' value='".$content."'></input>";
	}
	add_shortcode('grey_button', 'grey_button_shortcode');
	
	function chocolate_button_shortcode( $atts, $content = null ) 
	{
	   return "<input class='all_button chocolate_button' type='button' value='".$content."'></input>";
	}
	add_shortcode('chocolate_button', 'chocolate_button_shortcode');
	
	function cyan_button_shortcode( $atts, $content = null ) 
	{
	   return "<input class='all_button cyan_button' type='button' value='".$content."'></input>";
	}
	add_shortcode('cyan_button', 'cyan_button_shortcode');
	
	function pink_button_shortcode( $atts, $content = null ) 
	{
	   return "<input class='all_button pink_button' type='button' value='".$content."'></input>";
	}
	add_shortcode('pink_button', 'pink_button_shortcode');
	
	function dark_green_button_shortcode( $atts, $content = null ) 
	{
	   return "<input class='all_button dark_green_button' type='button' value='".$content."'></input>";
	}
	add_shortcode('dark_green_button', 'dark_green_button_shortcode');
	
	function blue_button_shortcode( $atts, $content ) 
	{
	   return "<input class='all_button blue_button' type='button' value='".$content."'></input>";
	}
	add_shortcode('blue_button', 'blue_button_shortcode');
	
	function red_button_shortcode( $atts, $content = null ) 
	{
	   return "<input class='all_button red_button' type='button' value='".$content."'></input>";
	}
	add_shortcode('red_button', 'red_button_shortcode');
	
	function magenta_button_shortcode( $atts, $content = null ) 
	{
	   return "<input class='all_button magenta_button' type='button' value='".$content."'></input>";
	}
	add_shortcode('magenta_button', 'magenta_button_shortcode');
	
	function yellow_button_shortcode( $atts, $content = null ) 
	{
	   return "<input class='all_button yellow_button' type='button' value='".$content."'></input>";
	}
	add_shortcode('yellow_button', 'yellow_button_shortcode');

	function orange_button_shortcode( $atts, $content = null ) 
	{
	   return "<input class='all_button orange_button' type='button' value='".$content."'></input>";
	}
	add_shortcode('orange_button', 'orange_button_shortcode');
	
	function dirt_button_shortcode( $atts, $content = null ) 
	{
	   return "<input class='all_button dirt_button' type='button' value='".$content."'></input>";
	}
	add_shortcode('dirt_button', 'dirt_button_shortcode');
	
	function phone_icon_shortcode() 
	{
	   return "<span class='pir_phone'></span>";
	}
	add_shortcode('pir_phone_icon', 'phone_icon_shortcode');
	function email_icon_shortcode() 
	{
	   return "<span class='pir_email'></span>";
	}
	add_shortcode('pir_email_icon', 'email_icon_shortcode');
	function home_icon_shortcode() 
	{
	   return "<span class='pir_home'></span>";
	}
	add_shortcode('pir_home_icon', 'home_icon_shortcode');
	function fax_icon_shortcode() 
	{
	   return "<span class='pir_fax'></span>";
	}
	add_shortcode('pir_fax_icon', 'fax_icon_shortcode');
	//SLIDERS
	function mercina_slider( $atts, $content = null ) 
	{
		extract(shortcode_atts(array(
			'category'    	 => '',//SHOW ALL SLIDES BY DEFAULT
			'id'		 => 'sample_slider'
		), $atts));
					$args=array(	'post_type' => 'slides',
								  	'showposts' => 99,
								  	'pirenko_slide_set' => $category
								);
					$loop = new WP_Query( $args );
		$out = '';
		$slide_number=0;
		$out.='	<div class="flex_father"><div class="flexslider shortcode_slider boxed_shadow">
                        <ul id="'. $id .'" class="slides">';
                        		while ( $loop->have_posts() ) : $loop->the_post(); ?>				
									<?php 
									global $post;
									if (has_post_thumbnail( $post->ID ) ):
										//GET THE FEATURED IMAGE
												$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' );	
												$image[0]=get_image_path($image[0]);
											else :
												//THERE'S NO FEATURED IMAGE SO LET'S LOAD A DEFAULT IMAGE
												$container="".get_bloginfo('template_directory')."/images/sample_home.jpg";
												$image[0]=get_image_path($container);
											endif; 
											
											$out.='<li>';
													if (get_post_meta(get_the_ID(), "mercina_slide_url", true)!="")
													{
                                            			$out.='<a href="'.get_post_meta(get_the_ID(), "mercina_slide_url", true) .'">';
                                           
													}
													if (get_the_title()=="")
													{
														$sl_title="&nbsp;";
														$title_class="inv_el";
													}
													else
													{
														$sl_title=get_the_title();
														$title_class="";
													}
													if (get_the_content()=="")
													{
														$sl_body="&nbsp;";
														$body_class="inv_el";
													}
													else
													{
														$sl_body=get_the_content();
														$body_class="";
													}
													
													if (get_post_meta(get_the_ID(), "mercina_slide_video", true)==""):
														$out.='<div class="slider_text_holder">';
														  $out.='<div id="'.$id.'top_'. $slide_number .'" class="headings_top '.$title_class.'">';
														   $out.='<h3>'. $sl_title .'</h3>';
														   $out.='</div>';
														   $out.='<div id="'.$id.'body_'. $slide_number .'" class="headings_body '.$body_class.'">';
															   $out.=' <h4>'. $sl_body .'</h4>';
															$out.='</div>';
														$out.='</div>';
														$out.='<img src="'. get_bloginfo('template_directory') .'/includes/plugins/timthumb.php?src='. $image[0] .'&w=713&h=380" alt="">';
													else:
													//IT's A VIDEO SLIDE
													
													$out.=' <div class="slider_text_holder">';
														  $out.='<div id="'.$id.'top_'. $slide_number .'" class="headings_top slide_video '.$title_class.'">';
														   $out.='<h3>'. $sl_title .'</h3>';
														   $out.='</div>';
														   $out.='<div id="'.$id.'body_'. $slide_number .'" class="headings_body '.$body_class.'">';
															   $out.='<h4>'. $sl_body .'</h4>';
															$out.='</div>';
														$out.='</div>';
													$out.=get_post_meta(get_the_ID(), "mercina_slide_video", true);
													
												endif;
												if (get_post_meta(get_the_ID(), "mercina_slide_url", true)!="")
												{
													
                                                   $out.='</a>';
												}
											$out.='</li>';
											$slide_number++;
								endwhile;
                 $out.='</ul><!-- slides --></div><!-- flexslider home_slider --></div>';
                  return $out;
	}
	add_shortcode('slider', 'mercina_slider');
	//MAIN PHP FUNCTION TO MANIPULATE THE CONTENT ACCORDING TO THE THEME OPTIONS
	//THIS FUNCTION IS CALLED ON THE FOOTER.PHP FILE
	function zuper_head() 
	{
		//GET OPTIONS ARRAY
		$options = get_option('zuper_theme_options');
		//OVERRIDE OPTIONS ONLY IF IN PREVIEW MODE
		if (isset($_SESSION['front_active_color']))
		{
			if ($_SESSION['front_active_color']!="")
				$options['z-active_color']=$_SESSION['front_active_color'];
		}
		
		if (isset($_SESSION['front_skin']))
		{
			if ($_SESSION['front_skin']!="")
			{
				$options['z-icon_set']=$_SESSION['front_skin'];
				if ($_SESSION['front_skin']=="dark")
				{
					$options['z-background_color']="0d0d0d";
					$options['z-custom_opacity']=88;
					
				}
				else
				{
					$options['z-background_color']="ffffff";
					$options['z-custom_opacity']=60;
				}
			}
		}
		
		if (isset($_SESSION['front_align']))
		{
			if ($_SESSION['front_align']!="")
				$options['z-content_alignment']=$_SESSION['front_align'];
		}
		
		if (isset($_SESSION['front_shadows']))
		{
			if ($_SESSION['front_shadows']!="")
			{
				if ($_SESSION['front_shadows']!="0")
				{
					$options['z-custom_shadow']=20;
				}
				else
					$options['z-custom_shadow']=0;
			}
		}
		//FOR PREVIEW ONLY
		if (is_page("1364"))
		{
			$options['z-icon_set']="dark";
			$options['z-background_color']="0d0d0d";
			$options['z-custom_opacity']=88;
			$options['z-pattern']="dark_mosaic.png";
		}
		if (is_page("1442"))
		{
			$options['z-thumbs_bw']="yes";
			$options['z-active_color']="E60909";
		}
		//START CREATING THE STRING THAT WILL CONTAIN THE STYLES THAT WILL BE APPLIED
		$include = $css = '';
		$css .= "<style type='text/css'>\n";
		//ADD CUSTOM CSS
		if ($options['z-css_text']!="")
		{
			$css .= "".$options['z-css_text']."";
		}
		//IMAGE ASSETS LOADING
		$css .=		"
					
					div.anythingSlider-cs-portfolio .forward a 
					{ 
						background: url(" . get_bloginfo('template_url') . "/images/icons/".$options['z-icon_set']."/slider/cs-portfolio.png) no-repeat;
						background-position: -25px top; 
					}
					div.anythingSlider-cs-portfolio .back a 
					{ 
						background: url(" . get_bloginfo('template_url') . "/images/icons/".$options['z-icon_set']."/slider/cs-portfolio.png) no-repeat;
						background-position: 1px top; 
					}
					div.anythingSlider-cs-portfolio .anythingControls ul a, div.anythingSlider-cs-portfolio.activeSlider .anythingControls ul a,
					div.anythingSlider-cs-portfolio .anythingControls ul a:hover, div.anythingSlider-cs-portfolio .anythingControls ul a.cur
					{
						background: url(" . get_bloginfo('template_url') . "/images/icons/".$options['z-icon_set']."/slider/cs-portfolio.png) no-repeat;
						background-position: right -22px;
						background-repeat: no-repeat;
					}
					div.anythingSlider-cs-portfolio.activeSlider .anythingControls ul a:hover,
					div.anythingSlider-cs-portfolio.activeSlider .anythingControls ul a.cur
					{
						background: url(" . get_bloginfo('template_url') . "/images/icons/".$options['z-icon_set']."/slider/cs-portfolio.png) no-repeat;
						background-position: right -76px;
						background-repeat: no-repeat;
					}
					div.anythingSlider-cs-portfolio .anythingControls li.next a, div.anythingSlider-cs-portfolio .anythingControls li.prev a,
					div.anythingSlider-cs-portfolio .anythingControls li.next a:hover, div.anythingSlider-cs-portfolio .anythingControls li.prev a:hover 				{
						background: url(" . get_bloginfo('template_url') . "/images/icons/".$options['z-icon_set']."/slider/cs-portfolio.png) no-repeat;
						width: 16px;
						height: 15px;
						margin: 19px 5px 0 5px;
					}
					div.anythingSlider-cs-portfolio .start-stop, div.anythingSlider-cs-portfolio .start-stop.hover,
					div.anythingSlider-cs-portfolio .start-stop:hover,
					div.anythingSlider-cs-portfolio .start-stop.playing:hover 
					{
						background: url(" . get_bloginfo('template_url') . "/images/icons/".$options['z-icon_set']."/slider/cs-portfolio.png) no-repeat;
						background-position: right top;
						background-repeat: no-repeat;
					}
					div.anythingSlider-cs-portfolio .start-stop.playing
					{
						
						background: url(" . get_bloginfo('template_url') . "/images/icons/".$options['z-icon_set']."/slider/cs-portfolio.png) no-repeat;
						background-position: right -54px;
						background-repeat: no-repeat;
					}
					#forward_news
					{
						background: url(" . get_bloginfo('template_url') . "/images/icons/".$options['z-icon_set']."/slider/cs-portfolio.png) no-repeat;
						background-position: -25px top; 
					}
					#backward_news
					{
						background: url(" . get_bloginfo('template_url') . "/images/icons/".$options['z-icon_set']."/slider/cs-portfolio.png) no-repeat;
						background-position: 1px top; 
					}
					";
		
		
		//BACKGROUND OVERLAY MANAGMENT
		if ($options['z-overlay_image']!="")
		{
			$css .= 	".overlay
						{
							background: url(" . get_bloginfo('template_url') . "/images/overlays/".$options['z-overlay_image'].") repeat scroll 0 0 transparent;
						display:none;
						}";
			
		}
		
		//ADJUST MINIMUM HEIGHT IF THE BOTTOM SIDEBAR IS ACTIVE
		if (!isset($options['z-bottom_sidebar']))
			$options['z-bottom_sidebar']="no";
		if ($options['z-bottom_sidebar']=="yes")
		{
			$css .= 	"#posts_wrapper
						{
							min-height: 10px;
						}";
			
		}
		
		//MENU ALIGN MANAGMENT
		if (!isset($options['z-menu_alignment']))
			$options['z-menu_alignment']="right";
		if ($options['z-menu_alignment']=="right")
		{
			$css .= 	"ul#menu-mercina_menu li a,
						.left_widgets h5
						{
							text-align:right;
						}";
			
		}
		else
		{
			$css .= 	"ul#menu-mercina_menu li a
						{
							text-align:left;
						}
						#menu-mercina_menu
						{
							width:214px;	
						}
						";
		}
		
		//FONT MANIPULATION
		function is_google_font($variable_val)
		{
			if ($variable_val!="bebas_neue" && $variable_val!="osp_din" && $variable_val!="league_gothic" && $variable_val!="Arial")
			{
				return true;
			}
			else
			{
				return false;	
			}
		}
		function font_google_to_css($google_text)
		{
			switch ($google_text) 
			{
				case "Exo:700,800":
				return ''."'Exo', sans-serif";
				break;
				case "bebas_neue":
				return ''."BebasNeueRegular";
				break;
				case "osp_din":
				return ''."OSPDIN";
				break;
				case "Droid+Sans:400,700":
				return ''.'Droid Sans';
				break;
				case "Droid+Serif":
				return ''.'Droid Serif';
				break;
				case "Open+Sans:400,600,700,800":
				return ''.'Open Sans';
				break;
				case "PT+Sans":
				return ''.'PT Sans';
				break;
				case "Yanone+Kaffeesatz":
				return ''.'Yanone Kaffeesatz';
				break;
				case "Alegreya:400italic,700italic,400,700":
				return ''.'Alegreya';
				break;
				case "Arvo":
				return ''.'Arvo';
				break;
				case "Ubuntu":
				return ''.'Ubuntu';
				break;
				case "Asul:400,700":
				return ''.'Asul';
				break;
				case "Acme":
				return ''.'Acme';
				break;
				case "Asap":
				return ''.'Asap';
				break;
				case "Cabin:500,500italic":
				return ''."'Cabin', sans-serif";
				break;
				case "Ruda:400,700,900":
				return ''."'Ruda', sans-serif";
				break;
				case "Oswald:700,400,300":
				return ''."'Oswald', sans-serif";
				break;
				case "Arial":
				return ''."'Arial'";
				break;
				case "Francois+One":
				return ''."'Francois One', sans-serif";
				break;
				case "Anton":
				return ''."'Anton', sans-serif";
				break;
				case "Economica:700":
				return ''."'Economica', sans-serif";
				break;
				case "Exo:700,800":
				return ''."'Exo', sans-serif";
				break;
				case "bebas_neue":
				return ''."BebasNeueRegular";
				break;
				case "osp_din":
				return ''."OSPDIN";
				break;
				case "league_gothic":
				return ''."LeagueGothicRegular";
				break;
				case "Dosis:500,600,700":
				return ''."'Dosis', sans-serif";
				break;
				case "novecento":
				return ''."NovecentowideLightBold";
				break;
				case "novecento_bold":
				return ''."NovecentowideBookBold";
				break;
				case "Questrial":
				return ''."'Questrial', sans-serif";
				break;
				case "Cousine:400,700":
				return ''."'Cousine', sans-serif";
				break;
				case "Bree+Serif":
				return ''."'Bree Serif', serif";
				break;
				case "Lato:400,700":
				return ''."'Lato', sans-serif";
				break;
				case "Vollkorn:400italic,400":
				return ''."'Vollkorn', serif";
				break;
				case "PT+Sans+Narrow":
				return ''."'PT Sans Narrow', sans-serif";
				break;
				case "courier_new":
				return ''."'Courier New', Courier, monospace";
				break;
				case "helvetica":
				return ''."Helvetica, Arial, sans-serif";
				break;
				case "Montserrat":
				return ''."'Montserrat', sans-serif;";
				break;
				case "Lora":
				return ''."'Lora', serif;";
				break;
				case "Oxygen+Mono":
				return ''."'Oxygen Mono', sans-serif;";
				break;
				case "Raleway:400,700":
				return ''."'Raleway', sans-serif;";
				break;
				case "Quicksand:400,700":
				return ''."'Quicksand', sans-serif;";
				break;
				case "Overlock+SC":
				return ''."'Overlock SC', cursive;";
				break;
				case "Muli:400,400italic":
				return ''."'Muli', sans-serif;";
				break;
				case "Rye":
				return ''."'Rye', cursive;";
				break;
				case "Pompiere":
				return ''."'Pompiere', cursive;";
				break;
				default:
				return ''.'Times';
			}		
		}
		$css .=		"body,
					textarea,
					.left_widgets h3,
					#respond textarea,
					input[type='text'],
					h6,
					h7,
					.button_right_floated,
					.home_right_floated
					{
						font-family:" .font_google_to_css($options['z-body_font']). ";
					}
					.news_more_button,
					#bk_top p,
					#menu-mercina_menu,
					h1,
					h2,
					h3,
					h4,
					h5,
					.all_button,
					#contact_ok,
					.ui-tooltip-zuper .ui-tooltip-content,
					#pir_categories,
					.single_post_meta h5,
					.loading_text,
					#small_h,				
					#respond #submit,
					.home_post_title_grid,
					.post-like,
					#s_form,
					#left_email,
					#slogan
					{
						font-family:" .font_google_to_css($options['z-header_font']). ";
						text-transform:uppercase;
					}
					#menu-mercina_menu
					{
						/*font-weight:bold;	*/
					}
					";
		//COLOR MANIPULATION
		function html2rgb($color)
		{
			if ($color[0] == '#')
				$color = substr($color, 1);	
			if (strlen($color) == 6)
				list($r, $g, $b) = array($color[0].$color[1],$color[2].$color[3],$color[4].$color[5]);
					elseif (strlen($color) == 3)
						list($r, $g, $b) = array($color[0].$color[0], $color[1].$color[1], $color[2].$color[2]);
					else
						return false;
			$r = hexdec($r); $g = hexdec($g); $b = hexdec($b);
			return array($r, $g, $b);
		}
		function ColorDarken($color, $dif)
		{
			$color = str_replace('#','', $color);
			$rgb = '';
			if (strlen($color) != 6) 
			{
				// reduce the default amount a little
				$dif = ($dif==20)?$dif/10:$dif;
				for ($x = 0; $x < 3; $x++) 
				{
					$c = hexdec(substr($color,(1*$x),1)) - $dif;
					$c = ($c < 0) ? 0 : dechex($c);
					$rgb .= $c;
				 }
			} 
			else 
			{
			  	for ($x = 0; $x < 3; $x++) 
				{
			   		$c = hexdec(substr($color, (2*$x),2)) - $dif;
			   		$c = ($c < 0) ? 0 : dechex($c);
			   		$rgb .= (strlen($c) < 2) ? '0'.$c : $c;
			  	}
			}
			return '#'.$rgb;
		}
		function hexDarker($hex,$factor)
        {
        	$new_hex = '';
        	$base['R'] = hexdec($hex{0}.$hex{1});
        	$base['G'] = hexdec($hex{2}.$hex{3});
        	$base['B'] = hexdec($hex{4}.$hex{5});
        	foreach ($base as $k => $v)
        	{
                $amount = $v / 100;
                $amount = round($amount * $factor);
                $new_decimal = $v - $amount;
                $new_hex_component = dechex($new_decimal);
                if(strlen($new_hex_component) < 2)
                { 
					$new_hex_component = "0".$new_hex_component; 
				}
                $new_hex .= $new_hex_component;
           	}    
        	return '#'.$new_hex;        
        }
		$main_color = $options['z-active_color'];
		$splitted_main_color= html2rgb($main_color);	
		$inactive_color = $options['z-inactive_color'];
		$splitted_inactive_color= html2rgb($inactive_color);
		$splitted_color= html2rgb($options['z-background_color']);	
		$background_color = $options['z-background_color'];
		$splitted_background_color= html2rgb($background_color);
		
		function alter_brightness($colourstr, $steps) 
		{
			$colourstr = str_replace('#','',$colourstr);
			$rhex = substr($colourstr,0,2);
			$ghex = substr($colourstr,2,2);
			$bhex = substr($colourstr,4,2);
			$r = hexdec($rhex);
			$g = hexdec($ghex);
			$b = hexdec($bhex);
			
			$r = dechex(max(0,min(255,$r + $steps)));
			$g = dechex(max(0,min(255,$g + $steps)));  
			$b = dechex(max(0,min(255,$b + $steps)));
			
			$r = str_pad($r,2,"0");
			$g = str_pad($g,2,"0");
			$b = str_pad($b,2,"0");
			
			$cor = '#'.$r.$g.$b;
			return $cor;
		}


		
		//THIS COLOR IS USED ON COMMENTS
		$darker_color=hexDarker($background_color,8);
		if ($darker_color=='#'.$background_color)
			$darker_color=alter_brightness($darker_color,2);
		//THIS COLOR IS USED ONLY FOR THE ACTIVE THUMBS ROLLOVER
		$clearer_inactive_color=alter_brightness($darker_color,2);
		
		//THIS COLOR IS USED ON ICONS AND ON THE PLUS SIGN
		$darker_color_icons=hexDarker($inactive_color,18);
		if ($darker_color_icons=='#'.$inactive_color)
			$darker_color_icons=alter_brightness($inactive_color,3);
		
		//THIS COLOR IS USED ONLY ON SUBMENUS
		$clearer_active_color=alter_brightness($main_color,30);
		
		//CHECK IF THE OBTAINED VALUES ARE ACCEPTABLE
		if (strlen($clearer_inactive_color)>7)
			$clearer_inactive_color="#FFFFFF";	
		if (strlen($darker_color)>7)
			$darker_color="#222222";
		if ($options['z-icon_set']!="clear")
		{
			$darker_color_styles="#f5f5f5";
		}
		else
		{
			$darker_color_styles="#2a2a2a";
		}
		$splitted_darker_color_styles= html2rgb($darker_color_styles);
		$cust_opacity=floatval($options['z-custom_opacity']/100);
		$shadow_opacity=floatval($options['z-custom_shadow']/100);
		$top_sidebar_align=$options['z-content_alignment']=="12px" ? "22px" : "auto";
		$css .=	"		#page-wrap 
						{
							margin-left: ".$options['z-content_alignment'].";
							margin-right:auto;
						}
						.inner-center
						{
							margin-left: ".$top_sidebar_align.";
							margin-right:auto;
						}
						.home_post_title_grid
						{
							color: $darker_color_styles;
						}
						body,
						a,
						.read_more_link:hover,
						input[type='text'],
						#contact-form textarea,
						ul#menu-mercina_menu li a,
						#plus_button,
						.regular_color,
						#commentform textarea,
						.left_widgets,
						#top-sidebar-widgets,
						.left_widgets li,
						.postmetadata a,
						#single_entry_content a:hover,
						.entry_page a:hover,
						#single_entry_content_news a:hover,
						.search_entry_title a:hover,
						.news_tax_title a:hover,
						.no_color,
						#blog_teaser a,
						#blog_teaser h4
						{
							color: #$inactive_color;
						}
						#page_slider h3,
						.flexslider h3,
						.decent-comments .comment-link,
						.decent-comments .comment-link a,
						.decent-comments .comment-author,
						.decent-comments .comment-author a,
						.tweet a,
						.tweet p
						{
							color: $clearer_inactive_color;
						}
						.flexslider .headings_body,
						#page_slider .headings_body,
						.flex-control-nav li a
						{
							background-color: $clearer_inactive_color;
						}
						h1,
						h2,
						h3,
						h4,
						.flexslider .headings_body h4 a,
						#page_slider .headings_body h4 a,
						h5 a:hover,
						a:hover,
						#blog_teaser a:hover,
						#blog_teaser h3 a,
						.postmetadata a:hover,
						.login-meta a,
						.iwak-widget-twitter .time,
						.more-link,
						.comment.bypostauthor .fn,
						.comment-reply-link,
						.read_more_link,
						.comment-edit-link,
						ul#menu-mercina_menu li a:hover,
						ul#menu-mercina_menu li ul li a:hover,
						ul#menu-mercina_menu li.current-menu-item > a,
						ol.commentlist li.comment div.vcard cite.fn,
						ol.commentlist li.comment div.vcard cite.fn a.url,
						#active_div,
						.left_widgets a:hover,
						.left_widgets h3,
						.singlepostmetadata_bl a:hover,
						.search_header,
						#contact-form .error,
						#commentform .error,
						.comment-awaiting-moderation,
						#back_to_top,
						#magnifier,
						#single_entry_content a,
						.entry_page a,
						#single_entry_content_news a,
						.search_entry_title a,
						#previous_button a,
						#next_button a,
						.single_post_meta h5 a:hover,
						.news_tax_title a,
						.post-like a:hover,
						ul#menu-mercina_menu li.current-merc_news-ancestor a,
						.news_tax_subtitle,
						#top-sidebar-widgets a:hover,
						.comments-link .mini_icons:hover,
						#twitter_update_list li > a ,
						#pir_categories a:hover,
						.squared_button:hover,
						.next-posts h4 a,
						.news_post_title h3 a,
						.news_inner h4 a,
						.news_more_button a,
						#page_slider h4,
						.flexslider h4,
						.header_with_button a
						{
						  color:#$main_color; 
						}
						/*ul#menu-mercina_menu li.current-menu-item ul a,*/
						ul#menu-mercina_menu ul li.menu-item a:hover,
						ul#menu-mercina_menu ul li.current_page_item a:hover,
						ul#menu-mercina_menu ul li.current_page_item a,
						ul#menu-mercina_menu ul li.current-menu-item a:hover,
						ul#menu-mercina_menu ul li.current-menu-item a,
						ul#menu-mercina_menu li.current-post-ancestor a
						{
							color:$clearer_active_color;
						}
						#previous_button a,
						#next_button a,
						#magnifier
						{
							text-shadow: 0 0 2px #$main_color;
						}
						#back_to_top
						{
							text-shadow: 0 0 2px #$main_color;
						}
						.button,
						.pagination a:hover, 
						.pagination a.current, 
						.pagination span.current,
						.news_day,
						.flexslider .headings_top,
						#page_slider .headings_top
						{ 
							background-color: #$main_color; 
						}
						#top-sidebar-widgets
						{
							background-color:rgba($splitted_darker_color_styles[0], $splitted_darker_color_styles[1], $splitted_darker_color_styles[2],0.98);
							box-shadow:0 0 4px 3px rgba(0,0,0,0.4);
						}
						.white_bg
						{
							background:#$background_color;
							background:rgba($splitted_background_color[0], $splitted_background_color[1], $splitted_background_color[2],0.94);
						}
						.boxed_shadow,
						#opaque_slider,
						#opaque_slider_news
						{
							box-shadow:0 0 4px 0px rgba(0,0,0,".$shadow_opacity.");
						}
						.home_block_small_margin,
						.home_block_no_margin,
						#slides_container,
						.home_right_floated,
						.button_right_floated,
						#s_form,
						#left_email,
						#home_fluid_slider
						{
							background-color:rgba($splitted_background_color[0], $splitted_background_color[1], $splitted_background_color[2],".$cust_opacity.");
						}
						#trapezoid_tr,
						#trapezoid_bl
						{
							background-color:rgba($splitted_main_color[0], $splitted_main_color[1], $splitted_main_color[2],0.94);
						}
						.widgets_shadow 
						{
							-moz-box-shadow: 0px 0px 8px rgba($splitted_inactive_color[0], $splitted_inactive_color[1], $splitted_inactive_color[2],1);
							-webkit-box-shadow: 0px 0px 8px rgba($splitted_inactive_color[0], $splitted_inactive_color[1], $splitted_inactive_color[2],1);
							
						}
						
						.post_divider
						{
							border-bottom: 1px dotted #$inactive_color;
						}
						.z_divider,
						.z_divider_bt,
						.z_divider_tp
						{
							border-bottom: 1px solid rgba($splitted_inactive_color[0], $splitted_inactive_color[1], $splitted_inactive_color[2],0.8);
						}
						.home_post_date,
						.singlepostmetadata,
						.singlepostmetadata_news,
						.postmetadata,
						.postmetadata a,
						#mid_div,
						.left_widgets a,
						#contact_ok,
						.singlepostmetadata_bl,
						.singlepostmetadata_bl a,
						#footer_text
						{
							color: #$inactive_color;
						}

						/*
						#slides_container
						#portfolio_slides_container*/
						input[type='text'],
						#contact-form textarea,
						#respond textarea,
						#respond input[type=text],
						.no_shadow,
						ol.commentlist,
						.slidenews_image_back,
						.pirenko_highlighted
						{
							border: 1px solid rgba($splitted_inactive_color[0], $splitted_inactive_color[1], $splitted_inactive_color[2],0.4);
						}
						.form_name_icon
						{
							color: rgba($splitted_inactive_color[0], $splitted_inactive_color[1], $splitted_inactive_color[2],0.4);
						}
						/*
						.pir_home:before,
						.pir_email:before,
						.pir_fax:before,
						.pir_phone:before,
						*/
						.mini_icons,
						.post-like,
						.post-like a,
						.single_post_meta h5,
						.single_post_meta h5 a,
						#minus_and_plus p,
						#icons_dark_div,
						.post-like .count
						{
							color:$darker_color_icons;
						}
						#minus_and_plus
						{
							text-shadow: 0 0 2px $darker_color_icons;
						}
						ol.commentlist li.even
						{
							background-color:$darker_color;
						}
						.flex-control-nav li a:hover,
						.flex-control-nav li a.flex-active
						{
							background-color:$darker_color_icons;
						}
						#darker_div
						{
							color: $inactive_color;
						}
						.lightbox_btn,
						.lightbox_btn_news
						{
							background: url(" . get_bloginfo('template_url') . "/images/icons/".$options['z-icon_set']."/back_magnifier_grid.png);
							background-repeat: no-repeat;
						}
						.readmore_btn
						{
							background: url(" . get_bloginfo('template_url') . "/images/icons/".$options['z-icon_set']."/back_magnifier_link.png);
							background-repeat: no-repeat;
						}
						.news_fader,
						.home_fader_grid
						{
							background-color:#$background_color;
							display:none;
						}
						
						input[type='text'],
						#contact-form textarea,
						#respond input[type=text],
						#respond textarea,
						ol.commentlist li.odd,
						.no_shadow,
						.post_grid,
						.entry_block,
						.slidenews_image_back,
						#twitter_link
						{
							background-color:#$background_color;
						}
						a.lk_text :after
						{
							border-color: transparent transparent transparent #$background_color;	
						}
						a.lk_text.change :after
						{
							border-color: transparent transparent transparent #$background_color;	
						}
						#backgr_div,
						.news_day h1,
						.news_day h4,
						#small_h,
						#top-sidebar-widgets h4
						{
							color:#$background_color;
						}
						.widgets_divider
						{
							border-bottom:dotted 1px #$background_color;
						}
						
						.home_fader
						{
							background: url(" . get_bloginfo('template_url') . "/images/icons/".$options['z-icon_set']."/back_magnifier.png);
							background-repeat: no-repeat;
						}
						.flex-control-nav li a 
						{
							-webkit-box-shadow: 0 1px 1px rgba($splitted_inactive_color[0], $splitted_inactive_color[1], $splitted_inactive_color[2], 0.75);
							-mobox-shadow: 0 1px 1px rgba($splitted_inactive_color[0], $splitted_inactive_color[1], $splitted_inactive_color[2], 0.75);
							box-shadow: 0 1px 1px rgba($splitted_inactive_color[0], $splitted_inactive_color[1], $splitted_inactive_color[2], 0.75);
			}
						
						";
				
		//ADJUST THE MAGNIFIER ICON ALPHA IF THUMBS ARE BLACK AND WHITE
		if ($options['z-thumbs_bw']=="yes")
		{
			$css .= "
				.home_fader_grid,.home_fader
				{
					opacity: 0.3; /* Chrome 4+, FF2+, Saf3.1+, Opera 9+, IE9, iOS 3.2+, Android 2.1+ */
					filter: alpha(opacity=30); /* IE6-IE8 */
				}
			";
		}
		//TOOLTIPS STYLING
		$css .= "
			.ui-tooltip-zuper .ui-tooltip-titlebar,
			.ui-tooltip-zuper .ui-tooltip-content
			{
				background: rgba($splitted_inactive_color[0], $splitted_inactive_color[1], $splitted_inactive_color[2], 1);	
				text-transform:uppercase;
				padding-top:8px;
				font-size:13px;
			}
			.ui-tooltip-zuper .ui-tooltip-icon
			{
				border-color: #FFF;
				text-shadow: none;
			}
		";
		//BUTTONS STYLING
		$css .= "			
				.all_button
				{
					color: #".$options['z-background_color'].";
				}
				.default_button
				{
					background-color: #$main_color;	
				}
		";	
		$css .= "</style>\n";
		//OUTPUT THE CUSTOM STYLES WE JUST BUILT				
		echo $include . $css;
		//"SEND" SOME VALUES TO JQUERY USING HIDDEN DIVS
		$php_to_jquery = '';
		$php_to_jquery.=	"				
							<div id='php_contact_name' style='display: none;' alt=''>". $options['z-contact_name_text'] ."</div>
							<div id='php_contact_email' style='display: none;' alt=''>". $options['z-contact_email_text'] ."</div>
							<div id='php_contact_subject' style='display: none;' alt=''>". $options['z-contact_subject_text'] ."</div>
							
							<div id='php_contact_error' style='display: none;' alt=''>". $options['z-contact_error_text'] ."</div>
							<div id='php_contact_error_email' style='display: none;' alt=''>". $options['z-contact_error_email_text'] ."</div>
							
							<div id='php_contact_wait' style='display: none;' alt=''>". $options['z-contact_wait_text'] ."</div>
							<div id='php_contact_ok' style='display: none;' alt=''>" . $options['z-contact_ok_text'] . "</div>
							";
		//OUTPUT THE DIVS THAT WERE JUST CREATED
		echo $php_to_jquery;
	}
?>