<?php
	//THESE SCRIPTS CONTROL ALL THE THEME OPTIONS PANEL
	//INITIALIZE OUR OPTIONS
	add_action( 'admin_init', 'theme_options_init' );
	add_action( 'admin_menu', 'theme_options_add_page' );
	function theme_options_init()
	{
		register_setting( 'sample_options', 'zuper_theme_options', 'theme_options_validate' );
	}
	//LOAD THE MENU PAGE
	function theme_options_add_page() 
	{
		add_menu_page( __( 'Mercina Options', 'zupertheme' ), __( 'Mercina Options', 'zupertheme' ), 'edit_theme_options', 'theme_options', 'theme_options_do_page' );
	}
	
	//CREATE ARRAYS WITH THE OPTIONS
	//PATTERN BACKGROUNDS
	$select_options = array(
		'0' => array(
			'value' =>	'',
			'label' => __( 'None', 'zupertheme' )
		),
		'1' => array(
			'value' =>	'grey.jpg',
			'label' => __( 'Dotted Grey', 'zupertheme' )
		),
		'2' => array(
			'value' =>	'oblique.png',
			'label' => __( 'Oblique Lines', 'zupertheme' )
		),
		'3' => array(
			'value' =>	'concrete.jpg',
			'label' => __( 'Concrete', 'zupertheme' )
		),
		'4' => array(
			'value' =>	'cream.jpg',
			'label' => __( 'Cream', 'zupertheme' )
		),
		'5' => array(
			'value' =>	'white_grungy.png',
			'label' => __( 'Grungy Squares', 'zupertheme' )
		),
		'6' => array(
			'value' =>	'oblique_squares.png',
			'label' => __( 'Oblique Squares', 'zupertheme' )
		),
		'7' => array(
			'value' =>	'white_circles.png',
			'label' => __( 'Clear Circles', 'zupertheme' )
		),
		'8' => array(
			'value' =>	'dot.gif',
			'label' => __( 'Dark Dots', 'zupertheme' )
		),
		'9' => array(
			'value' =>	'alt_black.jpg',
			'label' => __( 'Dark Irregular', 'zupertheme' )
		),
		'10' => array(
			'value' =>	'curvy.jpg',
			'label' => __( 'Dark Curves', 'zupertheme' )
		),
		'11' => array(
			'value' =>	'dark_dots.png',
			'label' => __( 'Dark Stamped', 'zupertheme' )
		),
		'12' => array(
			'value' =>	'dark_squares.png',
			'label' => __( 'Dark Squares', 'zupertheme' )
		),
		'13' => array(
			'value' =>	'losangles.png',
			'label' => __( 'Dark Losangles', 'zupertheme' )
		),
		'14' => array(
			'value' =>	'dark_circles.png',
			'label' => __( 'Dark Circles', 'zupertheme' )
		),
		'15' => array(
			'value' =>	'scratch.jpg',
			'label' => __( 'Scratches', 'zupertheme' )
		),
		'16' => array(
			'value' =>	'texturetastic_gray.png',
			'label' => __( 'Textured Grey', 'zupertheme' )
		),
		'17' => array(
			'value' =>	'lghtmesh.png',
			'label' => __( 'Light Mesh', 'zupertheme' )
		),
		'18' => array(
			'value' =>	'dark_tire.png',
			'label' => __( 'Dark Stripes', 'zupertheme' )
		),
		'19' => array(
			'value' =>	'first_aid_kit.png',
			'label' => __( 'Grey Squares', 'zupertheme' )
		),
		'20' => array(
			'value' =>	'rough_diagonal.png',
			'label' => __( 'Rough Diagonal', 'zupertheme' )
		),
		'21' => array(
			'value' =>	'purty_wood.png',
			'label' => __( 'Yellow Wood', 'zupertheme' )
		),
		'22' => array(
			'value' =>	'stacked_circles.png',
			'label' => __( 'Stacked Circles', 'zupertheme' )
		),
		'23' => array(
			'value' =>	'outlets.png',
			'label' => __( 'Outlets', 'zupertheme' )
		),
		'24' => array(
			'value' =>	'farmer.png',
			'label' => __( 'Squared Seamless', 'zupertheme' )
		),
		'25' => array(
			'value' =>	'wood_texture.png',
			'label' => __( 'Textured Wood', 'zupertheme' )
		),
		'26' => array(
			'value' =>	'vintage_speckles.png',
			'label' => __( 'Vintage', 'zupertheme' )
		),
		'27' => array(
			'value' =>	'grid_noise.png',
			'label' => __( 'Grid Noise', 'zupertheme' )
		),
		'28' => array(
			'value' =>	'chruch.png',
			'label' => __( 'Seamless White', 'zupertheme' )
		),
		'29' => array(
			'value' =>	'cross_scratches.png',
			'label' => __( 'Cross Scratches', 'zupertheme' )
		),
		'30' => array(
			'value' =>	'blu_stripes.png',
			'label' => __( 'Blue', 'zupertheme' )
		),
		'31' => array(
			'value' =>	'classy_fabric.png',
			'label' => __( 'Classy Fabric', 'zupertheme' )
		),
		'32' => array(
			'value' =>	'vertical_cloth.png',
			'label' => __( 'Vertical Cloth', 'zupertheme' )
		),
		'33' => array(
			'value' =>	'darkdenim.png',
			'label' => __( 'Dark Denim', 'zupertheme' )
		),
		'34' => array(
			'value' =>	'nami.png',
			'label' => __( 'Seamless Dark', 'zupertheme' )
		),
		'35' => array(
			'value' =>	'broken_noise.png',
			'label' => __( 'Broken Noise', 'zupertheme' )
		),
		'36' => array(
			'value' =>	'fake_brick.png',
			'label' => __( 'Fake Fabric', 'zupertheme' )
		),
		'37' => array(
			'value' =>	'type.png',
			'label' => __( 'Typographic', 'zupertheme' )
		),
		'38' => array(
			'value' =>	'noise_pattern.png',
			'label' => __( 'Noisy', 'zupertheme' )
		),
		'39' => array(
			'value' =>	'dark_mosaic.png',
			'label' => __( 'Dark Mosaic', 'zupertheme' )
		),
		'40' => array(
			'value' =>	'whitey.png',
			'label' => __( 'Simple White', 'zupertheme' )
		),
		'41' => array(
			'value' =>	'random_grey_variations.png',
			'label' => __( 'Grey Variations', 'zupertheme' )
		),
		'42' => array(
			'value' =>	'black-linen.png',
			'label' => __( 'Black Linen', 'zupertheme' )
		),
		'43' => array(
			'value' =>	'light_honeycomb.png',
			'label' => __( 'Light Honeycomb', 'zupertheme' )
		),
		'44' => array(
			'value' =>	'black_paper.png',
			'label' => __( 'Black Paper', 'zupertheme' )
		),
		'45' => array(
			'value' =>	'dark_stripes.png',
			'label' => __( 'Dark Stripes', 'zupertheme' )
		),
		'46' => array(
			'value' =>	'pinstriped_suit.png',
			'label' => __( 'Dark Pin Stripes', 'zupertheme' )
		),
		'47' => array(
			'value' =>	'hixs_pattern_evolution.png',
			'label' => __( 'Dark Metal', 'zupertheme' )
		),
		'48' => array(
			'value' =>	'irongrip.png',
			'label' => __( 'Iron Grip', 'zupertheme' )
		),
		'49' => array(
			'value' =>	'px.png',
			'label' => __( 'Tiny Squares', 'zupertheme' )
		),
		'50' => array(
			'value' =>	'green_dust_scratch.png',
			'label' => __( 'Vintage Green', 'zupertheme' )
		)
	);
	//OVERLAYS
	$overlay_options = array(
		'0' => array(
			'value' =>	'',
			'label' => __( 'None', 'zupertheme' )
		),
		'1' => array(
			'value' =>	'diagonal_left_white.png',
			'label' => __( 'Left Diagonal Lines (clear)', 'zupertheme' )
		),
		'2' => array(
			'value' =>	'diagonal_left.png',
			'label' => __( 'Left Diagonal Lines', 'zupertheme' )
		),
		'3' => array(
			'value' =>	'diagonal_right_white.png',
			'label' => __( 'Right Diagonal Lines (clear)', 'zupertheme' )
		),
		'4' => array(
			'value' =>	'diagonal_right.png',
			'label' => __( 'Right Diagonal Lines', 'zupertheme' )
		),
		'5' => array(
			'value' =>	'keys_white.png',
			'label' => __( 'Diagonal Spaces (clear)', 'zupertheme' )
		),
		'6' => array(
			'value' =>	'keys.png',
			'label' => __( 'Diagonal Spaces', 'zupertheme' )
		),
		'7' => array(
			'value' =>	'oblique_squares_lg_white.png',
			'label' => __( 'Large Oblique Squares (clear)', 'zupertheme' )
		),
		'8' => array(
			'value' =>	'oblique_squares_lg.png',
			'label' => __( 'Large Oblique Squares', 'zupertheme' )
		),
		'9' => array(
			'value' =>	'oblique_squares_white.png',
			'label' => __( 'Oblique Squares (clear)', 'zupertheme' )
		),
		'10' => array(
			'value' =>	'oblique_squares.png',
			'label' => __( 'Oblique Squares', 'zupertheme' )
		),
		'11' => array(
			'value' =>	'zig_zag_lg_white.png',
			'label' => __( 'Large Zig Zag (clear)', 'zupertheme' )
		),
		'12' => array(
			'value' =>	'zig_zag_lg.png',
			'label' => __( 'Large Zig Zag', 'zupertheme' )
		),
		'13' => array(
			'value' =>	'zig_zag_white.png',
			'label' => __( 'Zig Zag (clear)', 'zupertheme' )
		),
		'14' => array(
			'value' =>	'zig_zag.png',
			'label' => __( 'Zig Zag', 'zupertheme' )
		)
	);
	//FONTS
	$select_body_options = array(
		'9' => array(
			'value' =>	'Acme',
			'label' => __( 'Acme', 'pixiatheme' )
		),
		'4' => array(
			'value' =>	'Alegreya:400italic,700italic,400,700',
			'label' => __( 'Alegreya', 'pixiatheme' )
		),
		'16' => array(
			'value' =>	'Anton',
			'label' => __( 'Anton', 'pixiatheme' )
		),
		'14' => array(
			'value' =>	'Arial',
			'label' => __( 'Arial', 'pixiatheme' )
		),
		'5' => array(
			'value' =>	'Arvo',
			'label' => __( 'Arvo', 'pixiatheme' )
		),
		'10' => array(
			'value' =>	'Asap',
			'label' => __( 'Asap', 'pixiatheme' )
		),
		'7' => array(
			'value' =>	'Asul:400,700',
			'label' => __( 'Asul', 'pixiatheme' )
		),
		'25' => array(
			'value' =>	'Bree+Serif',
			'label' => __( 'Bree Serif', 'pixiatheme' )
		),
		'11' => array(
			'value' =>	'Cabin:500,500italic',
			'label' => __( 'Cabin', 'pixiatheme' )
		),
		'29' => array(
			'value' =>	'courier_new',
			'label' => __( 'Courier New', 'pixiatheme' )
		),
		'24' => array(
			'value' =>	'Cousine:400,700',
			'label' => __( 'Cousine', 'pixiatheme' )
		),
		'22' => array(
			'value' =>	'Dosis:500,600,700',
			'label' => __( 'Dosis', 'pixiatheme' )
		),
		'1' => array(
			'value' =>	'Droid+Sans:400,700',
			'label' => __( 'Droid Sans', 'pixiatheme' )
		),
		'8' => array(
			'value' =>	'Droid+Serif',
			'label' => __( 'Droid Serif', 'pixiatheme' )
		),
		'18' => array(
			'value' =>	'Economica:700',
			'label' => __( 'Economica', 'pixiatheme' )
		),
		'17' => array(
			'value' =>	'Exo:700,800',
			'label' => __( 'Exo Sans', 'pixiatheme' )
		),
		'15' => array(
			'value' =>	'Francois+One',
			'label' => __( 'Francois One', 'pixiatheme' )
		),
		'30' => array(
			'value' =>	'helvetica',
			'label' => __( 'Helvetica', 'pixiatheme' )
		),
		'26' => array(
			'value' =>	'Lato:400,700',
			'label' => __( 'Lato', 'pixiatheme' )
		),
		'32' => array(
			'value' =>	'Lora',
			'label' => __( 'Lora', 'pixiatheme' )
		),
		'31' => array(
			'value' =>	'Montserrat',
			'label' => __( 'Montserrat', 'pixiatheme' )
		),
		'37' => array(
			'value' =>	'Muli:400,400italic',
			'label' => __( 'Muli', 'pixiatheme' )
		),
		'13' => array(
			'value' =>	'Oswald:700,400,300',
			'label' => __( 'Oswald', 'pixiatheme' )
		),
		'0' => array(
			'value' =>	'Open+Sans:400,600,700,800',
			'label' => __( 'Open Sans', 'pixiatheme' )
		),
		'36' => array(
			'value' =>	'Overlock+SC',
			'label' => __( 'Overlock SC', 'pixiatheme' )
		),
		'33' => array(
			'value' =>	'Oxygen+Mono',
			'label' => __( 'Oxygen Mono', 'pixiatheme' )
		),
		'39' => array(
			'value' =>	'Pompiere',
			'label' => __( 'Pompiere', 'pixiatheme' )
		),
		'2' => array(
			'value' =>	'PT+Sans',
			'label' => __( 'PT Sans', 'pixiatheme' )
		),
		'28' => array(
			'value' =>	'PT+Sans+Narrow',
			'label' => __( 'PT Sans Narrow', 'pixiatheme' )
		),
		'23' => array(
			'value' =>	'Questrial',
			'label' => __( 'Questrial', 'pixiatheme' )
		),
		'35' => array(
			'value' =>	'Quicksand:400,700',
			'label' => __( 'Quicksand', 'pixiatheme' )
		),
		'34' => array(
			'value' =>	'Raleway:400,700',
			'label' => __( 'Raleway', 'pixiatheme' )
		),
		'12' => array(
			'value' =>	'Ruda:400,700,900',
			'label' => __( 'Ruda', 'pixiatheme' )
		),
		'38' => array(
			'value' =>	'Rye',
			'label' => __( 'Rye', 'pixiatheme' )
		),
		'6' => array(
			'value' =>	'Ubuntu',
			'label' => __( 'Ubuntu', 'pixiatheme' )
		),
		'27' => array(
			'value' =>	'Vollkorn:400italic,400',
			'label' => __( 'Vollkorn', 'pixiatheme' )
		),
		'3' => array(
			'value' =>	'Yanone+Kaffeesatz',
			'label' => __( 'Yanone Kaffeesatz', 'pixiatheme' )
		),
		//40
		'90' => array(
			'value' =>	'bebas_neue',
			'label' => __( 'Bebas Neue', 'zupertheme' )
		),
		'91' => array(
			'value' =>	'osp_din',
			'label' => __( 'OSP Din', 'zupertheme' )
		),
		'92' => array(
			'value' =>	'league_gothic',
			'label' => __( 'League Gothic', 'zupertheme' )
		)

	);
	
	//ALIGNMENT
	$alignment_options = array(
		'0' => array(
			'value' =>	'12px',
			'label' => __( 'Left', 'zupertheme' )
		),
		'1' => array(
			'value' =>	'auto',
			'label' => __( 'Centered', 'zupertheme' )
		)
	);
	
	//MENU ALIGNMENT
	$menu_alignment_options = array(
		'0' => array(
			'value' =>	'left',
			'label' => __( 'Left', 'zupertheme' )
		),
		'1' => array(
			'value' =>	'right',
			'label' => __( 'Right', 'zupertheme' )
		)
	);
	
	//SKINS
	$icon_options = array(
		'0' => array(
			'value' =>	'dark',
			'label' => __( 'Optimized for Dark Backgrounds', 'zupertheme' )
		),
		'1' => array(
			'value' =>	'clear',
			'label' => __( 'Optimized for Clear Backgrounds', 'zupertheme' )
		)
	);
	
	//YES/NO OPTION
	$radio_options = array(
		'yes' => array(
			'value' => 'yes',
			'label' => __( 'Yes', 'zupertheme' )
		),
		'no' => array(
			'value' => 'no',
			'label' => __( 'No', 'zupertheme' )
		)
	);
	
	//TRUE/FALSE OPTION
	$truefalse_options = array(
		'true' => array(
			'value' => 'true',
			'label' => __( 'Yes', 'zupertheme' )
		),
		'false' => array(
			'value' => 'false',
			'label' => __( 'No', 'zupertheme' )
		)
	);
	
	//LEFT SIDEBAR INPUT FIELD OPTIONS
	$sidebar_input_options = array(
		'no_display' => array(
			'value' => '0',
			'label' => __( 'No display', 'zupertheme' )
		),
		'top' => array(
			'value' => '1',
			'label' => __( 'Search', 'zupertheme' )
		),
		'center' => array(
			'value' => '2',
			'label' => __( 'Newsletter', 'zupertheme' )
		)
	);
	
	//SHOW LIGHTBOX BUTTON ON ROLLOVER
	$lightbox_options = array(
		'both' => array(
			'value' => 'both',
			'label' => __( 'Show lightbox and link button', 'zupertheme' )
		),
		'light_only' => array(
			'value' => 'light_only',
			'label' => __( 'Show only lightbox button', 'zupertheme' )
		),
		'link_only' => array(
			'value' => 'link_only',
			'label' => __( 'Show only link button', 'zupertheme' )
		)
	);
	//HOMEPAGE POSITION OPTIONS
	$homepage_options = array(
		'no_display' => array(
			'value' => '0',
			'label' => __( 'No display', 'zupertheme' )
		),
		'top' => array(
			'value' => '1',
			'label' => __( 'Top', 'zupertheme' )
		),
		'center' => array(
			'value' => '2',
			'label' => __( 'Center Top', 'zupertheme' )
		),
		'bottom' => array(
			'value' => '3',
			'label' => __( 'Center Bottom', 'zupertheme' )
			
		),
		'bottom_down' => array(
			'value' => '4',
			'label' => __( 'Bottom', 'zupertheme' )
		)
	);
	//CREATE THE OPTIONS PAGE
	function theme_options_do_page() 
	{
		?>
		<script type="text/javascript">
			var mercina_directory = "<?php bloginfo('template_directory') ?>";
		</script>
		<?php
			global $alignment_options,$menu_alignment_options,$select_options, $sidebar_input_options, $overlay_options, $truefalse_options, $radio_options, $icon_options, $select_body_options, $homepage_options,$lightbox_options;
			if ( ! isset( $_REQUEST['settings-updated'] ) )
				$_REQUEST['settings-updated'] = false;
			//GET THEME DATA FROM THE STYLESHEET
			$theme_data = wp_get_theme();
		?>
		<div class="wrap">
			<div id="pirenko_admin_menu">
				<ul>
					<li><a href="#" id="zuper_general_options_button">General</a></li>
					<li><a href="#" id="zuper_homepage_options_button">Homepage</a></li>
                    <li><a href="#" id="zuper_portfolio_options_button">Portfolio</a></li>
                    <li><a href="#" id="zuper_news_options_button">News</a></li>
					<li><a href="#" id="zuper_contact_options_button">Contact</a></li>
					<li><a href="#" id="zuper_404_error_options_button">404 Page</a></li>
					<li><a href="#" id="zuper_translations_options_button">Translations</a></li>
					<div id="pirenko_admin_menu_footer">
						Mercina Theme Admin Panel 2.1
					</div>
				</ul>
			</div>
			<?php if ( false !== $_REQUEST['settings-updated'] ) : ?>
				<div class="updated fade"><p><strong><?php _e( 'Options saved', 'zupertheme' ); ?></strong></p></div>
			<?php endif; ?>
			<div id="pirenko_options">
                <form method="post" action="options.php">
                    <input id="set_default" type="hidden" size="1" type="text" name="zuper_theme_options[set_default]" value="false" />
                    <p class="save_options">
                        <input type="submit" class="button-primary" value="<?php _e( 'Save All Changes', 'zupertheme' ); ?>" />
                    </p>
                    <input type="button" class="button-primary pirenko_reset_button" value="Reset All Settings" onClick="go_there()">
                    </input>
                    <?php settings_fields( 'sample_options' ); ?>
                    <?php $options = get_option( 'zuper_theme_options' ); ?>
                    <div id="zuper_options">
                        <!--GENERAL OPTIONS-->
                        <div class="zuper_tab_options" id="pirenko_general_options">
                            <table class="form-table">       
                                <tr><td colspan="2"><?php echo "<h2>" . $theme_data['Title'] . " General Options" . "</h2>"; ?></td></tr>
                                <?php
                                //LOGO IMAGE
                                ?>
                                <tr valign="top">
                                	<td width="275"><h3><?php _e( 'LOGO IMAGE', 'zupertheme' ); ?></h3></td>
                                    
                                    <td>
                                        <table>
                                        <tr>
                                            <td>
                                            <img class="pirenko_cms_image" id="zuper_theme_options_logo_image" src="<?php esc_attr_e( $options['logo'] ); ?>" style="float:left"  />
                                            </td>
                                        </tr>
                                        <input id="mercina_theme_options_logo" type="hidden" size="1" type="text" name="zuper_theme_options[logo]" value="<?php esc_attr_e( $options['logo'] ); ?>" />
                                        
                                        <tr>
                                        <td>
                                        <a href="#" class="pirenko_upload button" id="upload_image_button" name="theme_options_logo">Upload Logo</a>
                                        </td>
                                        </tr>
                                        </table>
                                    </td>
                                </tr>
                                 <?php
                                //SLOGAN
                                ?>
                                <tr valign="top">
                                <th scope="row">
                                    <?php _e( 'Slogan', 'zupertheme' ); ?>
                                    <p><em>Will be displayed on bottom of your logo image (optional)</em></p>
                                </th>
                                    <td>
                                        <input id="z-slogan" size="30" maxlength="100" type="text" name="zuper_theme_options[z-slogan]" value="<?php esc_attr_e( $options['z-slogan'] ); ?>" />
                                        <label class="description" for="zuper_theme_options[z-slogan]">
                                        </label>
                                    </td>
                                </tr>
                                <?php
                                //FAVICON IMAGE
								if (!isset($options['z-favicon']))
									$options['z-favicon']="". get_bloginfo('template_directory') . "/images/favicon.ico";
                                ?>
                                <tr valign="top">
                                	<td width="275"><h3><?php _e( 'FAVICON IMAGE', 'zupertheme' ); ?></h3>
                                    <p><em>Should have the .ico extension</em></p>
                                    </td>
                                    
                                    <td>
                                        <table>
                                        <tr>
                                            <td>
                                            <img class="pirenko_cms_image" id="zuper_theme_options_favicon_image" src="<?php esc_attr_e( $options['z-favicon'] ); ?>" style="float:left"  />
                                            </td>
                                        </tr>
                                        <input id="mercina_theme_options_favicon" type="hidden" size="1" type="text" name="zuper_theme_options[z-favicon]" value="<?php esc_attr_e( $options['z-favicon'] ); ?>" />
                                        
                                        <tr>
                                        <td>
                                        <a href="#" class="pirenko_upload button" id="upload_image_button" name="theme_options_favicon">Upload Favicon</a>
                                        </td>
                                        </tr>
                                        </table>
                                    </td>
                                </tr>
                                <?php
                                //BACKGROUND IMAGE
                                ?>
                                <tr valign="top"><th scope="row"><h3><?php _e( 'BACKGROUND', 'zupertheme' ); ?></h3></th>
                                <tr valign="top"><th scope="row"><?php _e( 'Background Image', 'zupertheme' ); ?></th>
                                    <td>
                                        <table>
                                        <tr>
                                            <td> 
                                            <img class="pirenko_cms_image" id="zuper_theme_options_background_image" src="<?php esc_attr_e( $options['z-background_image'] ); ?>" style="float:left"  />
                                            </td>
                                        </tr>
                                        <input id="mercina_theme_options_background" size="1" type="hidden" name="zuper_theme_options[z-background_image]" value="<?php esc_attr_e( $options['z-background_image'] ); ?>" />
                                        <tr>
                                        <td>
                                        <a href="#" class="pirenko_upload button" id="upload_image_button" name="theme_options_background">Upload Background</a>
                                        <a href="#" class="button" id="remove_background_button" name="theme_options_background_remove">Remove Background</a>
                                        </td>
                                        </tr>
                                        </table>
                                    </td>
                                </tr>
                                <?php
                                //BACKGROUND PATTERN
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                        <?php _e( 'Background Pattern', 'zupertheme' ); ?>
                                        <p><em>Will be used only if there's no background image</em></p>
                                    </th>
                                    <td>
                                        <select id="pattern_selector" name="zuper_theme_options[z-pattern]">
                                            <?php    
                                                foreach ( $select_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-pattern'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                        <div id="background_preview" class="preview_pattern" style="background-image:url(<?php echo get_bloginfo('template_directory');?>/images/patterns/<?php echo $options['z-pattern']; ?>)">
                                        </div>
                                    </td>
                                </tr>
                                
                                <?php
                                //BACKGROUND COLOR
                                ?>
                                <tr valign="top">
                                <th scope="row">
                                    <?php _e( 'Background Color', 'zupertheme' ); ?>
                                    <p><em>Will be used only if there's no background image and no background pattern</em></p>
                                </th>
                                    <td>
                                        #<input id="z-site_background_color" size="7" maxlength="6" type="text" name="zuper_theme_options[z-site_background_color]" value="<?php esc_attr_e( $options['z-site_background_color'] ); ?>" />
                                        <label class="description" for="zuper_theme_options[z-site_background_color]"><?php _e( ' Hexadecimal Values', 'zupertheme' ); ?></label>
                                        <div id="site-background_preview" class="preview_color" style="background-color:#<?php echo $options['z-site_background_color']; ?>"></div>
                                    </td>
                                </tr>
                                 <?php
                                //CUSTOM OPACITY
                                ?>
                                <tr valign="top">
                                <th scope="row">
                                    <?php _e( 'Custom Opacity', 'zupertheme' ); ?>
                                    <p><em>Will be used on header panels and on the footer message</em></p>
                                </th>
                                    <td>
                                        <input id="z-custom_opacity" size="7" maxlength="6" type="text" name="zuper_theme_options[z-custom_opacity]" value="<?php esc_attr_e( $options['z-custom_opacity'] ); ?>" />
                                        <label class="description" for="zuper_theme_options[z-custom_opacity]"><?php _e( ' Acceptable values: [0,100]', 'zupertheme' ); ?></label>
                                    </td>
                                </tr>
                                <?php
                                //SHADOW OPACITY
                                ?>
                                <tr valign="top">
                                <th scope="row">
                                    <?php _e( 'Shadow Opacity', 'zupertheme' ); ?>
                                    <p><em>Use 0 value for no shadowing effect</em></p>
                                </th>
                                    <td>
                                        <input id="z-custom_shadow" size="7" maxlength="6" type="text" name="zuper_theme_options[z-custom_shadow]" value="<?php esc_attr_e( $options['z-custom_shadow'] ); ?>" />
                                        <label class="description" for="zuper_theme_options[z-custom_shadow]"><?php _e( ' Acceptable values: [0,100]', 'zupertheme' ); ?></label>
                                    </td>
                                </tr>
                                <?php
                                //OVERLAY
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                        <h3><?php _e( 'BACKGROUND OVERLAY IMAGE', 'zupertheme' ); ?></h3>
                                        <p><em>This image is optional and will be displayed on top of your background image, pattern or color.</em></p>
                                    </th>
                                    <td>
                                        <div id="overlay_selector_div">
                                        <select id="overlay_selector" name="zuper_theme_options[z-overlay_image]" class="left_float">
                                            <?php    
                                                foreach ( $overlay_options as $overlay_option ) 
                                                {
                                                    $label = $overlay_option['label'];
                                                    
                                                    if ( $options['z-overlay_image'] == $overlay_option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $overlay_option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $overlay_option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                        </div>
                                        <div id="overlay_preview" class="<?php if ($options['z-overlay_image']=="") {echo "hidden_icons";} ?>" style="background: url(<?php echo get_bloginfo('template_directory');?>/images/overlays/<?php echo $options['z-overlay_image'];?>) repeat scroll 0 0 transparent;background-color: #<?php echo $options['z-inactive_color'];?>;">
                                            
                                        </div> 
                                 
                                    </td>
                                </tr>
                                <?php
                                //FONTS
                                ?>
                                <tr valign="top"><th scope="row"><h3><?php _e( 'FONTS', 'zupertheme' ); ?></h3></th>
                                <?php
                                //HEADINGS FONT
                                ?>
                                <tr valign="top"><th scope="row"><?php _e( 'Headings Font', 'zupertheme' ); ?></th>
                                    <td>
                                        <select name="zuper_theme_options[z-header_font]">
                                            <?php    
                                                foreach ( $select_body_options as $option_header ) 
                                                {
                                                    $label_header = $option_header['label'];
                                                    
                                                    if ( $options['z-header_font'] == $option_header['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option_header['value'] ) . "'>$label_header</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option_header['value'] ) . "'>$label_header</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
                                //BODY
                                ?>
                                <tr valign="top"><th scope="row"><?php _e( 'Body Font', 'zupertheme' ); ?></th>
                                    <td>
                                    <?php
                                    ?>
                                                
                                        <select name="zuper_theme_options[z-body_font]">
                                            <?php    
                                                foreach ( $select_body_options as $option_body ) 
                                                {
                                                    $label_body = $option_body['label'];
                                                    
                                                    if ( $options['z-body_font'] == $option_body['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option_body['value'] ) . "'>$label_body</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option_body['value'] ) . "'>$label_body</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
                                //STYLING
                                ?>
                                <tr valign="top"><th scope="row"><h3><?php _e( 'STYLING', 'zupertheme' ); ?></h3></th>
                                <?php
                                //ALIGNMENT
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                        <?php _e( 'Content Alignment', 'zupertheme' ); ?>
                                    </th>
                                    <td>
                                        <div id="zuper_selector">
                                            <select id="alignment_selector" name="zuper_theme_options[z-content_alignment]" class="left_float">
                                                <?php    
                                                    foreach ( $alignment_options as $align_option ) 
                                                    {
                                                        $label = $align_option['label'];
                                                        
                                                        if ( $options['z-content_alignment'] == $align_option['value'] ) // Make default first in list
                                                            echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $align_option['value'] ) . "'>$label</option>";
                                                        else
                                                            echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $align_option['value'] ) . "'>$label</option>";
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                    </td>
                                </tr>
                                <?php
                                //MENU ALIGNMENT
								if (!isset($options['z-menu_alignment']))
									$options['z-menu_alignment']="right";
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                        <?php _e( 'Menu Buttons Alignment', 'zupertheme' ); ?>
                                    </th>
                                    <td>
                                        <div id="zuper_selector">
                                            <select id="menu_alignment_selector" name="zuper_theme_options[z-menu_alignment]" class="left_float">
                                                <?php    
                                                    foreach ( $menu_alignment_options as $menu_align_option ) 
                                                    {
                                                        $label = $menu_align_option['label'];
                                                        
                                                        if ( $options['z-menu_alignment'] == $menu_align_option['value'] ) // Make default first in list
                                                            echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $menu_align_option['value'] ) . "'>$label</option>";
                                                        else
                                                            echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $menu_align_option['value'] ) . "'>$label</option>";
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                    </td>
                                </tr>
								<?php
                                //ICON SET
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                        <?php _e( 'Icons', 'zupertheme' ); ?>
                                        <p><em>The icons are located in the images/icons folder. You may edit the icons appearence there (PSD files are included)</em></p>
                                    </th>
                                    <td>
                                        <div id="zuper_selector">
                                        <select id="icon_selector" name="zuper_theme_options[z-icon_set]" class="left_float">
                                            <?php    
                                                foreach ( $icon_options as $ic_option ) 
                                                {
                                                    $label = $ic_option['label'];
                                                    
                                                    if ( $options['z-icon_set'] == $ic_option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $ic_option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $ic_option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                        </div>
                                    </td>
                                </tr>
                                <?php
                                //COLORS
                                ?>
                                <tr valign="top"><th scope="row"><h3><?php _e( 'COLORS', 'zupertheme' ); ?></h3></th>
                                <?php
                                //ACTIVE COLOR
                                ?>
                                <tr valign="top"><th scope="row"><?php _e( 'Active color', 'zupertheme' ); ?></th>
                                    <td>
                                        #<input id="z-active_color" size="7" maxlength="6" type="text" name="zuper_theme_options[z-active_color]" value="<?php esc_attr_e( $options['z-active_color'] ); ?>" />
                                        <label class="description" for="zuper_theme_options[z-active_color]"><?php _e( ' Hexadecimal Values', 'zupertheme' ); ?></label>
                                        <div id="active_preview" class="preview_color" style="background-color:#<?php echo $options['z-active_color']; ?>"></div>
                                    </td>
                                </tr>
                                <?php
                                //UP COLOR
                                ?>
                                <tr valign="top"><th scope="row"><?php _e( 'Inactive color', 'zupertheme' ); ?></th>
                                    <td>
                                        #<input id="z-inactive_color" size="7" maxlength="6" type="text" name="zuper_theme_options[z-inactive_color]" value="<?php esc_attr_e( $options['z-inactive_color'] ); ?>" />
                                        <label class="description" for="zuper_theme_options[z-inactive_color]"><?php _e( ' Hexadecimal Values', 'zupertheme' ); ?></label>
                                        <div id="inactive_preview" class="preview_color" style="background-color:#<?php echo $options['z-inactive_color']; ?>"></div>
                                    </td>
                                </tr>
                                <?php
                                //CONTENT BACKGROUND COLOR
                                ?>
                                <tr valign="top"><th scope="row" width="275"><?php _e( 'Content background color', 'zupertheme' ); ?></th>
                                    <td>
                                        #<input id="z-background_color" size="7" maxlength="6" type="text" name="zuper_theme_options[z-background_color]" value="<?php esc_attr_e( $options['z-background_color'] ); ?>" />
                                        <label class="description" for="zuper_theme_options[z-background_color]"><?php _e( ' Hexadecimal Values', 'zupertheme' ); ?></label>
                                        <div id="background_preview" class="preview_color" style="background-color:#<?php echo $options['z-background_color']; ?>">
                                        </div>
                                    </td>
                                </tr>
                                <?php
                                //BLACK AND WHITE THUMBS OPTION
                                ?>
                                <tr valign="top"><th scope="row" width="275"><?php _e( 'Thumbnails are black and white', 'zupertheme' ); ?></th>
                                    <td>
                                        <select name="zuper_theme_options[z-thumbs_bw]">
                                            <?php    
                                                foreach ( $radio_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-thumbs_bw'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
                                //SIDEBARS
                                ?>
                                <tr valign="top"><th scope="row"><h3><?php _e( 'SIDEBARS', 'zupertheme' ); ?></h3></th>
                                <?php
                                //TOP SIDEBAR
                                ?>
                                <tr valign="top"><th scope="row"><?php _e( 'Display Top Sidebar', 'zupertheme' ); ?></th>
                                    <td>
                                        <select name="zuper_theme_options[z-top_sidebar]">
                                            <?php    
                                                foreach ( $radio_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-top_sidebar'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                 <?php
                                //BOTTOM SIDEBAR
								if (!isset($options['z-bottom_sidebar']))
									$options['z-bottom_sidebar']="no";
                                ?>
                                <tr valign="top"><th scope="row"><?php _e( 'Display Bottom Sidebar', 'zupertheme' ); ?></th>
                                    <td>
                                        <select name="zuper_theme_options[z-bottom_sidebar]">
                                            <?php    
                                                foreach ( $radio_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-bottom_sidebar'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
                                //BOTTOM SIDEBAR HEADING TITLE
								if (!isset($options['z-bottom_sidebar_title']))
									$options['z-bottom_sidebar_title']="";
                                ?>
                                <tr valign="top">
                                    <td scope="row">
                                        <?php _e( 'Bottom Sidebar Heading/Title', 'zupertheme' ); ?>
                                        <p><em>Leave blank if not needed it</em></p>
                                    </td>
                                    <td>
                                        <input id="z-bottom_sidebar_title" size="30" maxlength="100" type="text" name="zuper_theme_options[z-bottom_sidebar_title]" value="<?php esc_attr_e( $options['z-bottom_sidebar_title'] ); ?>" />
                                        
                                    </td>
                                </tr>
                                <?php
                                //LEFT SIDEBAR
                                ?>
                                <tr valign="top"><th scope="row"><?php _e( 'Display Left Sidebar', 'zupertheme' ); ?></th>
                                    <td>
                                        <select name="zuper_theme_options[z-left_sidebar]">
                                            <?php    
                                                foreach ( $radio_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-left_sidebar'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
                                 //LEFT SIDEBAR INPUT
                                ?>
                                <tr valign="top">
                                	<th scope="row"><?php _e( 'Left Sidebar Input Field', 'zupertheme' ); ?>
                                    </th>
                                        <td>
                                            <select name="zuper_theme_options[z-left_sidebar_input]">
                                                <?php    
                                                    foreach ( $sidebar_input_options as $option ) 
                                                    {
                                                        $label = $option['label'];
                                                        
                                                        if ( $options['z-left_sidebar_input'] == $option['value'] ) // Make default first in list
                                                            echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                        else
                                                            echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    }
                                                ?>
                                            </select>
                                  	</td>
                                </tr>
                                <?php
                                //NEWSLETTER RECEIVING EMAIL
                                ?>
                                <tr valign="top">
                                    <td scope="row">
                                        <?php _e( 'Newsletter subscription Email', 'zupertheme' ); ?>
                                        <p><em>(optional)</em></p>
                                    </td>
                                    <td>
                                        <input id="z-footer_text2" size="30" maxlength="100" type="text" name="zuper_theme_options[z-footer_text2]" value="<?php esc_attr_e( $options['z-footer_text2'] ); ?>" />
                                        
                                    </td>
                                </tr>
                                <?php
                                //FOOTER TEXT
                                ?>
                                <tr valign="top">
                                    <td scope="row">
                                        <h3><?php _e( 'FOOTER TEXT', 'zupertheme' ); ?></h3>
                                        <p><em>HTML supported</em></p>
                                    </td>
                                    <td>
                                        <input id="z-footer_text" size="30" maxlength="100" type="text" name="zuper_theme_options[z-footer_text]" value="<?php esc_attr_e( $options['z-footer_text'] ); ?>" />
                                        
                                    </td>
                                </tr>
                                <?php
                                //CUSTOM CSS
                                ?>
                                <tr valign="top">
                                    <td scope="row">
                                        <h3><?php _e( 'CUSTOM CSS', 'zupertheme' ); ?></h3>
                                        <p><em>Place here some of your own CSS code. You should not use <b>&lt;style&gt;</b> tags.</em></p>
                                    </td>
                                    <td>
                                        <textarea id="z-css_text" class="" rows="" cols="60" name="zuper_theme_options[z-css_text]" value=""><?php esc_attr_e( $options['z-css_text'] ); ?></textarea>
                                        
                                    </td>
                                </tr>   
                                <?php
                                //RESPONSIVENESS
								if (!isset($options['z-responsive']))
									$options['z-responsive']="false";
                                ?>
                                 <tr valign="top">
                                    <td scope="row">
                                        <h3><?php _e( 'RESPONSIVENESS', 'zupertheme' ); ?></h3>
                                        <p><em>Make theme adjust to smaller screens</em></p>
                                    </td>
                                    <td>
                                 <select name="zuper_theme_options[z-responsive]">
                                            <?php    
                                                foreach ( $truefalse_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-responsive'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select> 
                                        </td>
                                </tr>             
                            </table>
                            <p class="save_options">
                                <input type="submit" class="button-primary" value="<?php _e( 'Save All Changes', 'zupertheme' ); ?>" />
                            </p>
                        </div><!-- zuper_tab_options -->
                        <!-- HOMEPAGE -->         
                        <div class="zuper_tab_options">
                            <table class="form-table">
                                <tr><td colspan="2"><?php echo "<h2>" . $theme_data['Title'] . " Homepage Options" . "</h2>"; ?></td></tr>
                                <?php
                                //SHOW HOMEPAGE TITLE OPTION
                                ?>
                                <tr valign="top"><th scope="row"><h3><?php _e( 'TITLE', 'zupertheme' ); ?></h3></th>
                                <tr valign="top"><th scope="row" width="275"><?php _e( 'Show Title on Homepage', 'zupertheme' ); ?></th>
                                    <td>
                                        <select name="zuper_theme_options[z-show_homepage_title]">
                                            <?php    
                                                foreach ( $radio_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-show_homepage_title'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
                                //HOMEPAGE TITLE OPTION
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                    <?php _e( 'Large Title', 'zupertheme' ); ?>
                                    </th>
                                    <td>
                                        <input id="zuper_theme_options[z-homepage_title_text]" size="25" type="text" name="zuper_theme_options[z-homepage_title_text]" value="<?php esc_attr_e( $options['z-homepage_title_text'] ); ?>" />
                                    </td>
                                </tr>
                                <?php
                                //HOMEPAGE SUBTITLE OPTION
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                    <?php _e( 'Subtitle', 'zupertheme' ); ?>
                                    </th>
                                    <td>
                                        <input id="zuper_theme_options[z-homepage_subtitle_text]" size="65" type="text" name="zuper_theme_options[z-homepage_subtitle_text]" value="<?php esc_attr_e( $options['z-homepage_subtitle_text'] ); ?>" />
                                    </td>
                                </tr>
                                 <?php
                                //SHOW HOMEPAGE SLIDER
                                ?>
                                <tr valign="top"><th scope="row"><h3><?php _e( 'SLIDER', 'zupertheme' ); ?></h3></th>
                                <tr valign="top"><th scope="row" width="275"><?php _e( 'Show Slider on Homepage', 'zupertheme' ); ?></th>
                                    <td>
                                        <select name="zuper_theme_options[z-show_homepage_slider]">
                                            <?php    
                                                foreach ( $homepage_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-show_homepage_slider'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                 <?php
                                //HOMEPAGE SLIDER GROUP
								if (!isset($options['z-homepage_slider_group']))
									$options['z-homepage_slider_group']="zuper_all_s";
                                ?>
                                <tr valign="top"><th scope="row" width="275"><?php _e( 'Homepage Slider Slides Group ID', 'zupertheme' ); ?></th>
                                    <td>
                                    	<select name="zuper_theme_options[z-homepage_slider_group]">
                                            <?php 
												echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='zuper_all_s'>Display all slides</option>";
												$terms=get_terms('pirenko_slide_set');
												$count = count($terms);
											 	if ($count>0)
											 	{   
                                                	foreach ( $terms as $term ) 
                                                	{ 
                                                    	if ( $options['z-homepage_slider_group'] == $term->slug )
                                                        	echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . $term->slug  . "'>" . $term->name  . "</option>";
                                                    	else
                                                        	echo "\n\t<option style=\"padding-right: 10px;\" value='" . $term->slug  . "'>" . $term->name  . "</option>";
                                                	}
												}
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
                                //SLIDESHOW AUTOPLAY
                                ?>
                                <tr valign="top"><th scope="row" width="275"><?php _e( 'Autoplay slideshow', 'zupertheme' ); ?></th>
                                    <td>
                                        <select name="zuper_theme_options[z-autoplay_home]">
                                            <?php    
                                                foreach ( $truefalse_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-autoplay_home'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
                                //SLIDESHOW CREATE CONTROLS
								if (!isset($options['z-controls_home']))
									$options['z-controls_home']="false";
                                ?>
                                <tr valign="top">
                                	<th scope="row" width="275">
										<?php _e( 'Build slideshow extra controls', 'zupertheme' ); ?>
                                        <p><em>Back arrow, Forward arrow and Play/Pause buttons (Only for Non-Responsive Themes)</em></p>
                                    </th>
                                    <td>
                                        <select name="zuper_theme_options[z-controls_home]">
                                            <?php    
                                                foreach ( $truefalse_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-controls_home'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
                                //SLIDESHOW DELAY
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                    <?php _e( 'Slideshow delay in miliseconds', 'zupertheme' ); ?>
                                    <p><em>Use values above 4500 to keep the text showing smoothly</em></p>
                                    </th>
                                    <td>
                                        <input id="zuper_theme_options[z-delay_home]" size="5" type="text" name="zuper_theme_options[z-delay_home]" value="<?php esc_attr_e( $options['z-delay_home'] ); ?>" />
                                    </td>
                                </tr>
                                <?php
                                //SHOW PORTFOLIO OPTION
                                ?>
                                <tr valign="top"><th scope="row"><h3><?php _e( 'PORTFOLIO', 'zupertheme' ); ?></h3></th>
                                <tr valign="top"><th scope="row" width="275"><?php _e( 'Show Portfolio on Homepage', 'zupertheme' ); ?></th>
                                    <td>
                                        <select name="zuper_theme_options[z-show_portfolio]">
                                            <?php    
                                                foreach ( $homepage_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-show_portfolio'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
                                //PORTFOLIO TITLE OPTION
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                    <?php _e( 'Title', 'zupertheme' ); ?>
                                    <p><em>If blank the Template Portfolio Page title will be used instead</em></p>
                                    </th>
                                    <td>
                                        <input id="zuper_theme_options[z-portfolio_title]" size="25" type="text" name="zuper_theme_options[z-portfolio_title]" value="<?php esc_attr_e( $options['z-portfolio_title'] ); ?>" />
                                    </td>
                                </tr>
                                <?php
                                //OLDER PORTFOLIO TEXT
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                        <?php _e( 'View older portfolio entries link text', 'zupertheme' ); ?>
                                    </th>
                                    <td width="275">
                                        <input id="zuper_theme_options[z-older_portfolio_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-older_portfolio_text]" value="<?php esc_attr_e( $options['z-older_portfolio_text'] ); ?>" />
                                    </td>
                                </tr>
                                <?php
                                //SHOW NEWS OPTION
                                ?>
                                <tr valign="top"><th scope="row"><h3><?php _e( 'NEWS', 'zupertheme' ); ?></h3></th>
                                <tr valign="top"><th scope="row" width="275"><?php _e( 'Show Latest News on Homepage', 'zupertheme' ); ?></th>
                                    <td>
                                        <select name="zuper_theme_options[z-show_news]">
                                            <?php    
                                                foreach ( $homepage_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-show_news'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
                                //NEWS TITLE OPTION
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                    <?php _e( 'Title', 'zupertheme' ); ?>
                                    <p><em>If blank the Template News Page title will be used instead</em></p>
                                    </th>
                                    <td>
                                        <input id="zuper_theme_options[z-news_title]" size="25" type="text" name="zuper_theme_options[z-news_title]" value="<?php esc_attr_e( $options['z-news_title'] ); ?>" />
                                    </td>
                                <?php
                                //OLDER NEWS TEASER TITLE
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                        <?php _e( 'Left block title', 'zupertheme' ); ?>
                                    </th>
                                    <td width="275">
                                        <input id="zuper_theme_options[z-news_teaser_title]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-news_teaser_title]" value="<?php esc_attr_e( $options['z-news_teaser_title'] ); ?>" />
                                    </td>
                                </tr>
                                <?php
                                //NEWS TEASER
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                        <?php _e( 'Left block body', 'zupertheme' ); ?>
                                    </th>
                                    <td width="275">
                                       <textarea id="zuper_theme_options[z-news_teaser]" class="pirenko-large-text" cols="40" rows="5" name="zuper_theme_options[z-news_teaser]"><?php echo esc_textarea( $options['z-news_teaser'] ); ?></textarea> 
                                    </td>
                                </tr>
                                <?php
                                //SHOW HTML BLOCK OPTION
								if (!isset($options['z-show_htmlblock']))
									$options['z-show_htmlblock']='0';
                                ?>
                                <tr valign="top"><th scope="row"><h3><?php _e( 'HTML CONTENT BOX', 'zupertheme' ); ?></h3></th>
                                <tr valign="top"><th scope="row" width="275"><?php _e( 'Show HTML content on Homepage', 'zupertheme' ); ?></th>
                                    <td>
                                        <select name="zuper_theme_options[z-show_htmlblock]">
                                            <?php    
                                                foreach ( $homepage_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-show_htmlblock'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
                                //HTML BLOCK TITLE TEXT
								if (!isset($options['z-htmlblock_title']))
									$options['z-htmlblock_title']='';
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                    <?php _e( 'Title', 'zupertheme' ); ?>
                                    </th>
                                    <td>
                                        <input id="zuper_theme_options[z-htmlblock_title]" size="25" type="text" name="zuper_theme_options[z-htmlblock_title]" value="<?php esc_attr_e( $options['z-htmlblock_title'] ); ?>" />
                                    </td>
                                <?php
                                //HTML BLOCK BODY TEXT
								if (!isset($options['z-htmlblock_body']))
									$options['z-htmlblock_body']='';
                                ?>
                                <tr valign="top">
                                    <th scope="row">
                                        <?php _e( 'Body', 'zupertheme' ); ?>
                                        <p><em>HTML supported</em></p>
                                    </th>
                                    <td width="275">
                                       <textarea id="zuper_theme_options[z-htmlblock_body]" class="pirenko-large-text" cols="60" rows="15" name="zuper_theme_options[z-htmlblock_body]"><?php echo esc_textarea( $options['z-htmlblock_body'] ); ?></textarea> 
                                    </td>
                                </tr>
                            </table>
                            <p class="save_options">
                            <input type="submit" class="button-primary" value="<?php _e( 'Save All Changes', 'zupertheme' ); ?>" />
                            </p>
                        </div><!-- zuper_tab_options -->
                        <!--PORTFOLIO PAGE-->
                        <div class="zuper_tab_options">
                            <table class="form-table">
                                <tr><td colspan="2"><?php echo "<h2>" . $theme_data['Title'] . " Portfolio Options" . "</h2>"; ?></td></tr>
                                <?php
									//USE LIGHTBOX
									if (!isset($options['z-use_lightbox']))
										$options['z-use_lightbox']="both";
									//ADJUST VALUES BEFORE UPDATE
									if ($options['z-use_lightbox']=="true")
										$options['z-use_lightbox']="both";
									if ($options['z-use_lightbox']=="false")
										$options['z-use_lightbox']="link_only";
									?>
									<tr valign="top">
										<th scope="row" width="375">
											<?php _e( 'Show lightbox link on portfolio posts rollover', 'zupertheme' ); ?>
										</th>
										<td>
											<select name="zuper_theme_options[z-use_lightbox]">
												<?php    
													foreach ( $lightbox_options as $option ) 
													{
														$label = $option['label'];
														
														if ( $options['z-use_lightbox'] == $option['value'] ) // Make default first in list
															echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
														else
															echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
													}
												?>
											</select>
										</td>
									</tr>
                                    <?php
									//SLIDESHOW AUTOPLAY
									?>
									<tr valign="top">
										<td width="375"><?php _e( 'Autoplay slideshow', 'zupertheme' ); ?></td>
										<td>
											<select name="zuper_theme_options[z-autoplay_portfolio]">
												<?php    
													foreach ( $truefalse_options as $option ) 
													{
														$label = $option['label'];
														
														if ( $options['z-autoplay_portfolio'] == $option['value'] ) // Make default first in list
															echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
														else
															echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
													}
												?>
											</select>
										</td>
									</tr>
									 <?php
                                    //SLIDESHOW CREATE CONTROLS
                                    if (!isset($options['z-controls_portfolio']))
                                        $options['z-controls_portfolio']="false";
                                    ?>
                                    <tr valign="top">
                                        <th scope="row" width="375">
                                            <?php _e( 'Build slideshow extra controls', 'zupertheme' ); ?>
                                            <p><em>Back arrow, Forward arrow and Play/Pause buttons (Only for Non-Responsive Themes)</em></p>
                                        </th>
                                        <td>
                                            <select name="zuper_theme_options[z-controls_portfolio]">
                                                <?php    
                                                    foreach ( $truefalse_options as $option ) 
                                                    {
                                                        $label = $option['label'];
                                                        
                                                        if ( $options['z-controls_portfolio'] == $option['value'] ) // Make default first in list
                                                            echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                        else
                                                            echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    }
                                                ?>
                                            </select>
                                        </td>
                                    </tr>
									<?php
                                    //SLIDESHOW DELAY
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                        <?php _e( 'Slideshow delay in miliseconds', 'zupertheme' ); ?>
                                        </th>
                                        <td>
                                            <input id="zuper_theme_options[z-delay_portfolio]" size="5" type="text" name="zuper_theme_options[z-delay_portfolio]" value="<?php esc_attr_e( $options['z-delay_portfolio'] ); ?>" />
                                        </td>
                                    </tr>
                            	</table>
                            <p class="save_options">
                            <input type="submit" class="button-primary" value="<?php _e( 'Save All Changes', 'zupertheme' ); ?>" />
                            </p>
                        </div><!-- zuper_tab_options -->
                        <!--NEWS PAGE-->
                        <div class="zuper_tab_options">
                            <table class="form-table">
                                <tr><td colspan="2"><?php echo "<h2>" . $theme_data['Title'] . " News Page Options" . "</h2>"; ?></td></tr>
                                <?php
                                //SLIDESHOW AUTOPLAY
								if (!isset($options['z-autoplay_news']))
									$options['z-autoplay_news']='false';
								?>
									<tr valign="top">
										<td width="375"><?php _e( 'Autoplay slideshow?', 'zupertheme' ); ?></td>
										<td>
											<select name="zuper_theme_options[z-autoplay_news]">
												<?php    
													foreach ( $truefalse_options as $option ) 
													{
														$label = $option['label'];
														
														if ( $options['z-autoplay_news'] == $option['value'] ) // Make default first in list
															echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
														else
															echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
													}
												?>
											</select>
										</td>
									</tr>
                                <?php
                                //JUMP TO POST
                                ?>
                                <tr valign="top"><td width="375"><?php _e( 'News images jump to post?', 'zupertheme' ); ?>
                                <p><em>Define here what happens when you click on a news image: show post or lightbox</em></p>
                                </td>
                                    <td>
                                        <select name="zuper_theme_options[z-jump_news]">
                                            <?php    
                                                foreach ( $truefalse_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-jump_news'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
                                //SHOW RIGHTSIDE NAVIGATION
								if (!isset($options['z-show_news_nav']))
									$options['z-show_news_nav']='false';
                                ?>
                                <tr valign="top"><td width="375"><?php _e( 'Show navigation arrows and back to blog buttons?', 'zupertheme' ); ?>
                                <p><em>These elements are only displayed when viewing a single entry</em></p>
                                </td>
                                    <td>
                                        <select name="zuper_theme_options[z-show_news_nav]">
                                            <?php    
                                                foreach ( $truefalse_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-show_news_nav'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
								 //SHOW POSTED BY ON NEWS
                                ?>
                                <tr valign="top"><th scope="row" width="275"><?php _e( 'Show "Posted by" text on news?', 'zupertheme' ); ?></th>
                                    <td>
                                        <select name="zuper_theme_options[z-postedby_news]">
                                            <?php    
                                                foreach ( $radio_options as $option ) 
                                                {
                                                    $label = $option['label'];
                                                    
                                                    if ( $options['z-postedby_news'] == $option['value'] ) // Make default first in list
                                                        echo "\n\t<option style=\"padding-right: 10px;\" selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                    else
                                                        echo "\n\t<option style=\"padding-right: 10px;\" value='" . esc_attr( $option['value'] ) . "'>$label</option>";
                                                }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                            </table>
                            <p class="save_options">
                            <input type="submit" class="button-primary" value="<?php _e( 'Save All Changes', 'zupertheme' ); ?>" />
                            </p>
                        </div><!-- zuper_tab_options -->
                        <!--CONTACT FORM-->
                        <div class="zuper_tab_options">
                            <table class="form-table">
                                <tr><td colspan="2"><?php echo "<h2>" . $theme_data['Title'] . " Contact Page Options" . "</h2>"; ?></td></tr>
                                    <?php
                                    //EMAIL ADDRESS
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <h3><?php _e( 'RECEIVING EMAIL', 'zupertheme' ); ?></h3>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-email_address]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-email_address]" value="<?php esc_attr_e( $options['z-email_address'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //CONTACT INFORMATION
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <h3><?php _e( 'CONTACT INFORMATION', 'zupertheme' ); ?></h3>
                                        </th>
                                       
                                    </tr>
                                     <?php
									//TITLE
									?>
									<tr valign="top">
										<th scope="row">
										<?php _e( 'Title', 'zupertheme' ); ?>
										</th>
										 <td><input id="zuper_theme_options[z-contact-info_title]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-contact-info_title]" value="<?php esc_attr_e( $options['z-contact-info_title'] ); ?>" />
                                            
                                        </td>
									</tr>
                                     <?php
									//ADDRESS
									?>
									<tr valign="top">
										<th scope="row">
										<?php _e( 'Address', 'zupertheme' ); ?>
										</th>
										 <td>
                                            <textarea id="zuper_theme_options[z-contact-address]" class="pirenko-large-text" cols="40" rows="3" name="zuper_theme_options[z-contact-address]"><?php echo esc_textarea( $options['z-contact-address'] ); ?></textarea>
                                            
                                        </td>
									</tr>
                                    <?php
									//TELEPHONE
									?>
									<tr valign="top">
										<th scope="row">
										<?php _e( 'Telephone', 'zupertheme' ); ?>
										</th>
										 <td><input id="zuper_theme_options[z-contact-info_tel]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-contact-info_tel]" value="<?php esc_attr_e( $options['z-contact-info_tel'] ); ?>" />
                                            
                                        </td>
									</tr>
                                    <?php
									//FAX
									?>
									<tr valign="top">
										<th scope="row">
										<?php _e( 'Fax', 'zupertheme' ); ?>
										</th>
										 <td><input id="zuper_theme_options[z-contact-info_fax]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-contact-info_fax]" value="<?php esc_attr_e( $options['z-contact-info_fax'] ); ?>" />
                                            
                                        </td>
									</tr>
									<?php
									//EMAIL
									?>
									<tr valign="top">
										<th scope="row">
										<?php _e( 'Email', 'zupertheme' ); ?>
										</th>
										 <td><input id="zuper_theme_options[z-contact-info_email]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-contact-info_email]" value="<?php esc_attr_e( $options['z-contact-info_email'] ); ?>" />
                                            
                                        </td>
									</tr>
                                    <?php
									//END MESSAGE
									?>
									<tr valign="top">
										<th scope="row">
										<?php _e( 'Bottom Message', 'zupertheme' ); ?>
										</th>
										 <td>
                                         	<textarea id="zuper_theme_options[z-contact-address_info_msg]" class="pirenko-large-text" cols="40" rows="5" name="zuper_theme_options[z-contact-address_info_msg]"><?php echo esc_textarea( $options['z-contact-address_info_msg'] ); ?></textarea>                 
                                        </td>
									</tr>
                                    <?php
                                    //GOOGLE MAPS
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <h3><?php _e( 'GOOGLE MAPS HTML CODE', 'zupertheme' ); ?></h3>
                                            <p><em>To get your custom code visit http://maps.google.com/ and select your location. Click on the hyperlink button and copy/paste the code here</em></p>
                                        </th>
                                        <td>
                                            <input id="zuper_theme_options[z-google-maps]" size="90%" type="pirenko-text" name="zuper_theme_options[z-google-maps]" value="<?php esc_attr_e( $options['z-google-maps'] ); ?>" />
                                        </td>
                                    </tr>
                                     <?php
                                    //HELP TEXT ON NAME
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <h3><?php _e( 'NAME HELP TEXT', 'zupertheme' ); ?></h3>
                                            <p><em>This text will be displayed on the right side of the name input textfield</em></p>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-contact_name_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-contact_name_text]" value="<?php esc_attr_e( $options['z-contact_name_text'] ); ?>" />
                                        </td>
                                    </tr>
                                     <?php
                                    //HELP TEXT ON EMAIL
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <h3><?php _e( 'EMAIL HELP TEXT', 'zupertheme' ); ?></h3>
                                            <p><em>This text will be displayed on the right side of the email input textfield</em></p>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-contact_email_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-contact_email_text]" value="<?php esc_attr_e( $options['z-contact_email_text'] ); ?>" />
                                        </td>
                                    </tr>
                                     <?php
                                    //HELP TEXT ON SUBJECT
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <h3><?php _e( 'SUBJECT HELP TEXT', 'zupertheme' ); ?></h3>
                                            <p><em>This text will be displayed on the right side of the subject input textfield</em></p>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-contact_subject_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-contact_subject_text]" value="<?php esc_attr_e( $options['z-contact_subject_text'] ); ?>" />
                                        </td>
                                    </tr>
                                     <?php
                                    //SUBMIT BUTTON TEXT
									if (!isset($options['z-contact_submit']))
										$options['z-contact_submit']='Send Message';
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <h3><?php _e( 'SUBMIT BUTTON TEXT', 'zupertheme' ); ?></h3>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-contact_submit]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-contact_submit]" value="<?php esc_attr_e( $options['z-contact_submit'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //ERROR MESSAGE FOR EMPTY TEXTFIELDS
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <h3><?php _e( 'ERROR MESSAGE FOR EMPTY FIELD', 'zupertheme' ); ?></h3>
                                            <p><em>This text will be displayed when a mandatory input field is empty</em></p>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-contact_error_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-contact_error_text]" value="<?php esc_attr_e( $options['z-contact_error_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //ERROR MESSAGE FOR INVALID EMAILS
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <h3><?php _e( 'ERROR MESSAGE FOR INVALID EMAIL', 'zupertheme' ); ?></h3>
                                            <p><em>This text will be displayed when the entered email is invalid</em></p>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-contact_error_email_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-contact_error_email_text]" value="<?php esc_attr_e( $options['z-contact_error_email_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //FFEDBACK - WAIT MESSAGE
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <h3><?php _e( 'FORM SUBMISSION: WAIT MESSAGE', 'zupertheme' ); ?></h3>
                                            <p><em>This text will be displayed right after the send message button is clicked and only until the email is sent</em></p>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-contact_wait_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-contact_wait_text]" value="<?php esc_attr_e( $options['z-contact_wait_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //FEEDBACK - EMAIL SENT MESSAGE
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <h3><?php _e( 'FORM SUBMISSION: OK MESSAGE', 'zupertheme' ); ?></h3>
                                            <p><em>This text will be displayed after sending the email</em></p>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-contact_ok_text]" size="85" maxlength="80" type="text" name="zuper_theme_options[z-contact_ok_text]" value="<?php esc_attr_e( $options['z-contact_ok_text'] ); ?>" />
                                        </td>
                                    </tr>
                            </table>
                            <p class="save_options">
                            <input type="submit" class="button-primary" value="<?php _e( 'Save All Changes', 'zupertheme' ); ?>" />
                            </p>
                        </div><!-- zuper_tab_options -->
                        <!--404 ERROR PAGE-->
                         <div class="zuper_tab_options">
                            <table class="form-table">
                                <tr><td colspan="2"><?php echo "<h2>" . $theme_data['Title'] . " 404 Error Page" . "</h2>"; ?></td></tr>
                                    <?php
                                    //ERROR IMAGE
                                    ?>
                                    <tr valign="top">
                                        <td width="275">
                                            <h3><?php _e( '404 ERROR IMAGE', 'zupertheme' ); ?></h3>
                                            <p><em>Recommended dimensions: 650x400px</em></p>
                                        </td>
                                        <td>
                                            <table>
                                            <tr>
                                                <td>
                                                <img class="pirenko_cms_image" id="zuper_theme_options_error404_image" src="<?php esc_attr_e( $options['z-error404'] ); ?>" style="float:left"  />
                                                </td>
                                            </tr>
                                            <input id="mercina_theme_options_error404" size="30" type="hidden" name="zuper_theme_options[z-error404]" value="<?php esc_attr_e( $options['z-error404'] ); ?>" />
                                            
                                            <tr>
                                            <td>
                                            <a href="#" class="pirenko_upload button" id="upload_image_button" name="theme_options_error404">Upload Image</a>
                                            </td>
                                            </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <?php
                                    //TITLE TEXT
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <h3><?php _e( 'TITLE TEXT', 'zupertheme' ); ?></h3>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-404_title_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-404_title_text]" value="<?php esc_attr_e( $options['z-404_title_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //BODY TEXT
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <h3><?php _e( 'BODY TEXT', 'zupertheme' ); ?></h3>
                                        </th>
                                        <td>
                                            <textarea id="zuper_theme_options[z-404_body_text]" class="pirenko-large-text" cols="60" rows="10" name="zuper_theme_options[z-404_body_text]"><?php echo esc_textarea( $options['z-404_body_text'] ); ?></textarea>
                                            
                                        </td>
                                    </tr>
                            </table>
                        </div><!-- zuper_tab_options -->
                        <!--TRANSLATIONS-->
                        <div class="zuper_tab_options">
                            <table class="form-table">
                                <tr><td colspan="2"><?php echo "<h2>" . $theme_data['Title'] . " Translations" . "</h2>"; ?></td></tr>
                                    <?php
                                    //SEARCH TIP TEXT
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Seacr tip text', 'zupertheme' ); ?>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-search_tip_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-search_tip_text]" value="<?php esc_attr_e( $options['z-search_tip_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //SUBMIT SEARCH TIP TEXT
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Submit search tip text', 'zupertheme' ); ?>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-submit_search_tip_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-submit_search_tip_text]" value="<?php esc_attr_e( $options['z-submit_search_tip_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //NEWSLETTER TIP TEXT
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Newsletter tip text', 'zupertheme' ); ?>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-newsletter_tip_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-newsletter_tip_text]" value="<?php esc_attr_e( $options['z-newsletter_tip_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //NEWSLETTER SEARCH TIP TEXT
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Newsletter search tip text', 'zupertheme' ); ?>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-submit_newsletter_tip_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-submit_newsletter_tip_text]" value="<?php esc_attr_e( $options['z-submit_newsletter_tip_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //NEWSLETTER - SUCCESS MESSAGE
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Newsletter submission: Error message', 'zupertheme' ); ?>
                                            <p><em>This text will be displayed after a subscription email fails</em></p>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-newsletter_error_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-newsletter_error_text]" value="<?php esc_attr_e( $options['z-newsletter_error_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //NEWSLETTER - OK MESSAGE
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Form submission: Ok message', 'zupertheme' ); ?>
                                            <p><em>This text will be displayed after a successfull subscription email is sent</em></p>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-newsletter_ok_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-newsletter_ok_text]" value="<?php esc_attr_e( $options['z-newsletter_ok_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //SEARCH RESULTS PAGE TITLE
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Search results page title', 'zupertheme' ); ?>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-submit_search_res_title]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-submit_search_res_title]" value="<?php esc_attr_e( $options['z-submit_search_res_title'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //SHOW ALL TEXT
									if (!isset($options['all_text']))
										$options['all_text']='All';
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'All text', 'queedtheme' ); ?>
                                            <em>(Portfolio filter - show all)</em>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[all_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[all_text]" value="<?php esc_attr_e( $options['all_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //BACK TO PORTFOLIO TEXT
									if (!isset($options['z-back_to_portfolio_text']))
										$options['z-back_to_portfolio_text']='back to';
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Back to portfolio link text', 'zupertheme' ); ?>
                                            <p><em>This link is displayed near the navigation arrows when viewing a single entry</em></p>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-back_to_portfolio_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-back_to_portfolio_text]" value="<?php esc_attr_e( $options['z-back_to_portfolio_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //BACK TO NEWS TEXT
									if (!isset($options['z-back_to_news_text']))
										$options['z-back_to_news_text']='back to';
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Back to blog link text', 'zupertheme' ); ?>
                                            <p><em>This link is displayed near the navigation arrows when viewing a single entry</em></p>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-back_to_news_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-back_to_news_text]" value="<?php esc_attr_e( $options['z-back_to_news_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //PREVIOUS TEXT
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Previous entries text', 'zupertheme' ); ?>
                                            <em>(Bottom Navigation)</em>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-previous_nav_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-previous_nav_text]" value="<?php esc_attr_e( $options['z-previous_nav_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
									//BLOG TEMPLATE
									?>
									<tr valign="top"><th scope="row"><h3><?php _e( 'BLOG', 'zupertheme' ); ?></h3></th>
                                    <?php
                                    //READ MORE TEXT
									if (!isset($options['z-read_more']))
										$options['z-read_more']='Read More';
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Read more text', 'zupertheme' ); ?>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-read_more]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-read_more]" value="<?php esc_attr_e( $options['z-read_more'] ); ?>" />
                                        </td>
                                    </tr>
                                    	<?php
                                    //POSTED BY TEXT
									if (!isset($options['z-posted_by_text']))
										$options['z-posted_by_text']='Posted by';
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Posted by text', 'zupertheme' ); ?>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-posted_by_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-posted_by_text]" value="<?php esc_attr_e( $options['z-posted_by_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
									//COMMENTS TEMPLATE
									?>
									<tr valign="top"><th scope="row"><h3><?php _e( 'COMMENTS', 'zupertheme' ); ?></h3></th>
									<?php
									//COMMENTS YET
									?>
									<tr valign="top"><th scope="row"><?php _e( 'Text when there are no comments yet', 'zupertheme' ); ?></th>
										<td width="275">
                                            <input id="zuper_theme_options[z-no_comments_yet]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-no_comments_yet]" value="<?php esc_attr_e( $options['z-no_comments_yet'] ); ?>" />
                                        </td>
									</tr>
                                    <?php
                                    //LEAVE REPLY
									?>
                                    <tr valign="top"><th scope="row"><?php _e( 'Text to ask the user to leave a reply', 'zupertheme' ); ?></th>
										<td width="275">
                                            <input id="zuper_theme_options[z-comments_leave_reply]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-comments_leave_reply]" value="<?php esc_attr_e( $options['z-comments_leave_reply'] ); ?>" />
                                        </td>
									</tr>
                                    <?php
                                    //COMMENTS HELP TEXT ON NAME
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Name input field help text', 'zupertheme' ); ?>
                                            <p><em>This text will be displayed on the right side of the name input textfield</em></p>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-comments_name_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-comments_name_text]" value="<?php esc_attr_e( $options['z-comments_name_text'] ); ?>" />
                                        </td>
                                    </tr>
                                     <?php
                                    //COMMENTS HELP TEXT ON EMAIL
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Email input field help text', 'zupertheme' ); ?>
                                            <p><em>This text will be displayed on the right side of the email input textfield</em></p>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-comments_email_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-comments_email_text]" value="<?php esc_attr_e( $options['z-comments_email_text'] ); ?>" />
                                        </td>
                                    </tr>
                                     <?php
                                    //SUBMIT COMMENT BUTTON TEXT
									if (!isset($options['z-comments_submit']))
										$options['z-comments_submit']='Submit Comment';
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Submit comment button text', 'zupertheme' ); ?>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-comments_submit]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-comments_submit]" value="<?php esc_attr_e( $options['z-comments_submit'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //COMMENTS HELP TEXT ON WEBSITE
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Website input field help text', 'zupertheme' ); ?>
                                            <p><em>This text will be displayed on the right side of the website input textfield</em></p>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-comments_website_text]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-comments_website_text]" value="<?php esc_attr_e( $options['z-comments_website_text'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //COMMENTS - NO RESPONSES
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Zero responses text', 'zupertheme' ); ?>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-comments_no_response]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-comments_no_response]" value="<?php esc_attr_e( $options['z-comments_no_response'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //COMMENTS - 1 RESPONSE
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'One response text', 'zupertheme' ); ?>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-comments_one_response]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-comments_one_response]" value="<?php esc_attr_e( $options['z-comments_one_response'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //COMMENTS - MULTIPLE RESPONSES
                                    ?>
                                    <tr valign="top">
                                        <th scope="row">
                                            <?php _e( 'Multiple responses text', 'zupertheme' ); ?>
                                        </th>
                                        <td width="275">
                                            <input id="zuper_theme_options[z-comments_oneplus_response]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-comments_oneplus_response]" value="<?php esc_attr_e( $options['z-comments_oneplus_response'] ); ?>" />
                                        </td>
                                    </tr>
                                    <?php
                                    //COMMENTS CLOSED
									?>
                                    <tr valign="top"><th scope="row"><?php _e( 'Text to display when the comments are closed', 'zupertheme' ); ?></th>
										<td width="275">
                                            <input id="zuper_theme_options[z-comments_closed]" size="45" maxlength="50" type="text" name="zuper_theme_options[z-comments_closed]" value="<?php esc_attr_e( $options['z-comments_closed'] ); ?>" />
                                        </td>
									</tr>
                                    
                            </table>
                        </div><!-- zuper_tab_options -->
                    </div>
				</form>
				<form name="pirenko_reset_form" method="post" action="?page=theme_options&reset_mercina=true">
					<input type="hidden" name="action" value="reset_mercina" />
				</form>
				<script language="JavaScript">
                    function go_there()
                    {
                        var where_to=confirm("Are you sure you want to reset all settings?");
                        if (where_to==true)
                        {
                            document.pirenko_reset_form.submit()
                        }
                        else
                        {
                      
                        }
                    }
				</script>
			</div><!-- pirenko_options -->
		</div>
		<?php
	}
	//FUNCTION TO VALIDATE FIELDS IF NECESSARY
	function theme_options_validate( $input ) 
	{
		global $select_options, $radio_options;
	
		return $input;
	}
	//-------------------------------------------
	//CREATE CUSTOM WRITE PANEL FOR REGULAR POSTS
	//-------------------------------------------
	//META BOX FOR POSTS
	$key = "key";
	$meta_boxes = array(
	"skip_featured" => array(
	"name" => "skip_featured",
	"title" => "Use featured image on slideshow and Prettyphoto Lightbox?",
	"description" => ""),
	"image-1" => array(
	"name" => "image-1",
	"title" => "Image 1",
	"description" => ""),
	"image-2" => array(
	"name" => "image-2",
	"title" => "Image/Video 2",
	"description" => ""),
	"image-3" => array(
	"name" => "image-3",
	"title" => "Image/Video 3",
	"description" => ""),
	"image-4" => array(
	"name" => "image-4",
	"title" => "Image/Video 4",
	"description" => ""),
	"image-5" => array(
	"name" => "image-5",
	"title" => "Image/Video 5",
	"description" => ""),
	"image-6" => array(
	"name" => "image-6",
	"title" => "Image/Video 6",
	"description" => ""),
	"image-7" => array(
	"name" => "image-7",
	"title" => "Image/Video 7",
	"description" => ""),
	"image-8" => array(
	"name" => "image-8",
	"title" => "Image/Video 8",
	"description" => ""),
	"image-9" => array(
	"name" => "image-9",
	"title" => "Image/Video 9",
	"description" => ""),
	"image-10" => array(
	"name" => "image-10",
	"title" => "Image/Video 10",
	"description" => "")
	); 
	function create_meta_box() 
	{
		global $key;
		if( function_exists( 'add_meta_box' )) 
		{
			//$post_id = $_GET['post'] ? $_GET['post'] : $_POST['post_ID'] ;
			//$template_file = get_post_meta($post_id,'_wp_page_template',TRUE);
			//if ($template_file == 'default' || $template_file == 'template-news.php' || $template_file == 'template-portfolio.php')
				//add_meta_box( 'new-meta-boxes', ucfirst( $key ) . ' Custom Post Options', 'display_meta_box', 'page', 'normal', 'high' );
			//else
			add_meta_box( 'new-meta-boxes', 'Mercina Custom Post Options', 'display_meta_box', 'post', 'normal', 'high' );
		}
	} 
	function display_meta_box() 
	{
		global $post, $meta_boxes, $key;
		?>
		<div class="form-wrap">
			<?php
                wp_nonce_field( plugin_basename( __FILE__ ), $key . '_wpnonce', false, true );
                $helper=0;
                foreach($meta_boxes as $meta_box) 
                {
                    if ($helper==0)
                    {
                        $data = get_post_meta($post->ID, $key, true);
						$mm_helper="";
						if (isset($data[ $meta_box[ 'name' ]]))
						{
							if ($data[ $meta_box[ 'name' ]]==1 || $data[ $meta_box[ 'name' ]]=="") 
								$mm_helper='CHECKED';
						}
						else
							$mm_helper='CHECKED';
                        ?>
                        <div class="form-field form-required">
                            <label for="<?php echo $meta_box[ 'name' ]; ?>"><?php echo $meta_box[ 'title' ]; ?>
                            <input type="hidden" name="<?php echo $meta_box[ 'name' ]; ?>" value="0" />
                            <input type="checkbox" style="width:50px" name="<?php echo $meta_box[ 'name' ]; ?>" value="1" <?php echo $mm_helper; ?> /></label>
                            
                            <p><?php echo $meta_box[ 'description' ]; ?></p>
                        </div>
                        <?php 
                    }
                    //FEATURED IMAGE
                    if ($helper==1)
                    {
                        $image[0]="";
                        if (has_post_thumbnail( $post->ID ) ): ?>
                        <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
                        <?php endif; ?>
                        <div class="form-field form-required">
                            <label for="<?php echo $meta_box[ 'name' ]; ?>"><?php echo $meta_box[ 'title' ]; ?></label>
                            <input type="hidden" id="mercina_<?php echo $meta_box[ 'name' ]; ?>" name="<?php echo $meta_box[ 'name' ]; ?>" disabled="disabled" value="<?php echo $image[0]; ?>" />
                            <p>This image is the featured image. Please set this up by editing the Featured Image on the right side of this page.</p>
                        </div>
                        <?php 	
                    }
					//REMAINING 9 IMAGES
                    if ($helper>1)
                    {
                        $data = get_post_meta($post->ID, $key, true);
						if (!isset($data[ $meta_box[ 'name' ] ]))
							$data[$meta_box['name' ]]="";
                        ?>
                        <div class="form-field form-required">
                            <label for="<?php echo $meta_box[ 'name' ]; ?>"><?php echo $meta_box[ 'title' ]; ?></label>
                            <input type="text" id="mercina_<?php echo $meta_box[ 'name' ]; ?>" name="<?php echo $meta_box[ 'name' ]; ?>" value="<?php echo htmlspecialchars( $data[ $meta_box[ 'name' ] ] ); ?>" />
                            <p><?php echo $meta_box[ 'description' ]; ?></p>
                            <input class="pirenko_upload" type="button" style="width:100px" value="Upload image" name="<?php echo $meta_box[ 'name' ]; ?>">
                        </div>
                        <?php 
                    } 
                    $helper++;
                }
            ?> 
		</div>
	<?php
	}
	//SAVE FUNCTION
	function save_meta_box( $post_id ) 
	{
		global $post, $meta_boxes, $key;
	 	if (isset($post->post_type))
		{
			if ($post->post_type=="post")
			{
				foreach( $meta_boxes as $meta_box ) 
				{
					if (isset($_POST[ $meta_box[ 'name' ] ]))
						$data[ $meta_box[ 'name' ] ] = $_POST[ $meta_box[ 'name' ] ];
				}
				
				if (isset($_POST[ $key . '_wpnonce' ]))
					if ( !wp_verify_nonce( $_POST[ $key . '_wpnonce' ], plugin_basename(__FILE__) ) )
						return $post_id;
			 
				if ( !current_user_can( 'edit_post', $post_id ))
					return $post_id;
			 	if (isset($data))
					update_post_meta( $post_id, $key, $data );
			}
		}
	}
	add_action( 'admin_menu', 'create_meta_box' );
	add_action( 'save_post', 'save_meta_box' );

?>