<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 *
 *	Template Name: Blog (2 columns)
 */

global $wp, $query_string;

// Post Id
$post_id = get_the_ID();

// Header
get_header();

wp_enqueue_script('kolor_hover');


# Post custom query - filter
$category_filter = get_post_meta($post_id, 'category_filter', TRUE);


$phc_visible = get_post_meta($post_id, 'phc_visible', TRUE);

if($phc_visible == 0)
	$phc_visible = get_option('kolor_pagehead_captions_enable') == 'true' ? 1 : -1;

if($phc_visible == 1):
?>
<div class="bg_absolute content_page_bg bg_02">
	<!-- stripped border -->
	<div class="stripped_border"></div>
	<!-- end: stripped border -->		
</div>
<?php
endif;
?>
	
<!-- site header -->
<div class="site_header bg_02">

<?php

	// Main Menu (optionally with sliders)
	get_template_part('tpls/header', 'menu');

	// Page Head Caption
	get_template_part('tpls/blocks', 'pageheadcaption');
	
?>

</div>
<!-- end: site header -->

<?php if($phc_visible != 1): ?>
<!-- stripped border -->
<div class="stripped_border<?php echo $phc_visible != 1 ? ' margin_bottom_double' : ''; ?>"></div>
<!-- end: stripped border -->
<?php endif; ?>

<?php

$matched_query 		= $wp->matched_query;
$query_string_arr	= wp_parse_args($matched_query);

$paged 				= isset($query_string_arr['paged']) ? $query_string_arr['paged'] : 1;

$blog_query 		= array('post_type' => 'post', 'paged' => $paged);

if(isset($query_string_arr['tag']))
{
	$tag = $query_string_arr['tag'];
	$blog_query['tag'] = $tag;
}
	
if(isset($query_string_arr['category_name']))
{
	$category_name = $query_string_arr['category_name'];
	$blog_query['category_name'] = $category_name;
}

if(is_array($category_filter) && count($category_filter))
{
	$blog_query['cat'] = implode(',', $category_filter);
	define("CUSTOM_POSTS_FILTER", TRUE);
}


query_posts($blog_query);

get_template_part('tpls/blocks', 'blog2andsidebar');

wp_reset_query();
wp_reset_postdata();

// Footer Clients Block
get_template_part('tpls/blocks', 'footerclients');


// Footer Blocks
get_template_part('footer', 'block');


// Footer
get_footer();