<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 *
 *	Template Name: Contact
 */

// Required Resources
wp_enqueue_script(array('google_maps', 'kolor_contact'));

$kolor_contact_form_is_open 	= get_option('kolor_contact_form_is_open');
$contact_form_is_closed_message	= wpautop(get_option('kolor_contact_form_is_closed_message'));

$map_is_visible = get_option('kolor_map_is_visible') == 'true';

if($kolor_contact_form_is_open == 'is_open'):

	$contact_form_fields 	= LaboratorContactForm::$instance->get_fields();
	$available_form_fields 	= array();
	$message_field 			= null;
	
	$success_message_replaced = wpautop(get_option('kolor_contact_form_success_message'));
	
	foreach($contact_form_fields as $field_name => $text)
	{
		$visible_field = get_option("kolor_contact_form_show_{$field_name}");
		$required_field = get_option("kolor_contact_form_required_{$field_name}");
		
		if($visible_field == 'true')
		{
			$field_entry = array(
				'name' => $field_name,
				'required' => $required_field == 'true',
				'text' => $text,
				'value' => isset($_POST[$field_name]) ? stripslashes($_POST[$field_name]) : ''
			);
			
			if($field_name == 'message')
				$message_field = $field_entry;
			else
			{
				array_push($available_form_fields, $field_entry);
				
				// Success Message Display
				$success_message_replaced = str_replace("#{$field_name}#", esc_html($field_entry['value']), $success_message_replaced);
			}
		}
	}
	
	# Success & Error Messages
	$success_message = '<div class="alert success nomargin">' . $success_message_replaced . '</div>';
	$error_message = '<div class="alert error nomargin">' . wpautop(get_option('kolor_contact_form_error_message')) . '</div>';

endif;


// Header
get_header();


?>
	
<!-- site header -->
<div class="site_header bg_02 <?php echo $map_is_visible ? ' content_page_bg contact_page' : ''; ?>">

<?php

	// Main Menu (optionally with sliders)
	get_template_part('tpls/header', 'menu');

?>
	
	<?php if($map_is_visible): ?>
	<!-- contact map -->
	<div class="contact_map" id="map-env"></div>
	<!-- end: contact map -->
	<?php endif; ?>
		
</div>
<!-- end: site header -->
	
<!-- stripped border & map inner shadow -->
<div class="stripped_border"></div>
<?php if($map_is_visible): ?><div class="map_inner_shadow"></div><?php endif; ?>
<!-- end: stripped border & map inner shadow -->

<?php if( ! $map_is_visible): ?>
<br />
<?php endif; ?>


<!-- contact form & address info -->
	<div class="container contact_form_container">
		
		<!-- contact form -->
		<div class="eleven columns contact_form">
		<?php
		# Contact Form
		if($kolor_contact_form_is_open == 'is_open'):
			
			if(defined("LCF_CONTACT_FORM_ERRORS"))
				echo $error_message;
			elseif(defined("LCF_CONTACT_FORM_SUCCESS"))
			{
				echo $success_message;
			}
		?>
			<form method="post" action="" enctype="application/x-www-form-urlencoded">
				<?php
				
				$fields_per_row = 2;
				$total_fields = count($available_form_fields);
				
				$total_rows = ceil($total_fields/$fields_per_row);
				
				
				for($i=1; $i<=$total_rows; $i++):
					
					$_f = ($i-1) * $fields_per_row;
					$_t = $i * $fields_per_row;
				?>
				<div class="row">
					<?php
					for(;$_f<$_t;$_f++):
						
						$field_entry = $available_form_fields[$_f];
						$field_name = $field_entry['name'];
						$is_required = $field_entry['required'];
					?>
					<!-- field -->
					<div class="placeholder <?php echo $_f%2 == 0 ? 'left' : 'right'; ?>">
						<label for="<?php echo $field_name; ?>">
							<?php 
							echo $is_required ? '* ' : ''; 
							echo $field_entry['text'][0]; 
							?>:
						</label>
						<input type="text" id="<?php echo $field_name; ?>" name="<?php echo $field_name; ?>" class="input icon <?php echo $field_entry['text'][1]; ?>" value="<?php echo defined('LCF_CONTACT_FORM_SUCCESS') ? '' : esc_attr($field_entry['value']); ?>" />
					</div>
					<!-- end: field -->
					<?php
					endfor;
					?>
				</div>
				<?php
				
				endfor;
				?>
				

				<?php if($message_field): ?>				
				<div class="row">
					
					<!-- field -->
					<div class="placeholder">
						<label for="message">
						<?php
							echo $message_field['required'] ? '* ' : ''; 
							echo $message_field['text'][0];
						?>
						:</label>
						<textarea class="input icon <?php echo $message_field['text'][1]; ?>" id="<?php echo $message_field['name']; ?>" name="<?php echo $message_field['name']; ?>" rows="8"><?php echo defined('LCF_CONTACT_FORM_SUCCESS') ? '' : $message_field['value']; ?></textarea>
					</div>
					<!-- end: field -->
					
				</div>
				<?php endif; ?>
				
				<div class="row">
					<!-- submit button -->
					<button type="submit" name="contact_request" class="right button">
						<span><?php echo get_option('kolor_contact_form_button_text'); ?></span>
					</button>
					<!-- end: submit button -->
				</div>
				
				<input type="hidden" name="laborator_contact_form_nonce" value="<?php echo wp_create_nonce('LaboratorContactForm'); ?>" />
				
			</form>
		<?php
		else:
		?>
		<div class="alert info nomargin"><?php echo $contact_form_is_closed_message; ?></div>
		<?php
		endif;
		?>
			
			
		</div>
		<!-- end: contact form -->
		
		<?php
			$address_text = make_clickable(nl2br(get_option('kolor_contact_address_text')));
			$contact_text = make_clickable(nl2br(get_option('kolor_contact_contact_info_text')));
		?>
		<!-- address & other info -->
		<div class="five columns address_info">
			<?php
			# Address Sidebar
			?>
			
			<?php if($address_text): ?>
			<!-- address block -->
			<div class="block">
				<h5>
					<i class="location"></i>
					<?php _e('Address', TD); ?>
				</h5>
				
				<p>
					<?php echo $address_text; ?>
				</p>
				
				<?php if($contact_text): ?>
				<div class="separator"></div>
				<?php endif; ?>
				
			</div>
			<!-- end: address block -->
			<?php endif; ?>
			
			<?php if($contact_text): ?>
			<!-- address block -->
			<div class="block">
				<h5>
					<i class="info"></i>
					<?php _e('Contact Info', TD); ?>
				</h5>
				
				<p>
					<?php echo $contact_text; ?>
				</p>
			</div>
			<!-- end: address block -->
			<?php endif; ?>
			
			<!-- social networks block -->
			<div class="block">

				<!-- social networks -->
				<ul class="social">
					<?php if(get_option('kolor_contact_show_fb') != 'false'): ?><li class="facebook"><a href="<?php echo get_option('kolor_facebook_url'); ?>" target="_blank">Facebook</a></li><?php endif; ?>
					<?php if(get_option('kolor_contact_show_twitter') != 'false'): ?><li class="twitter"><a href="<?php echo get_option('kolor_twitter_url'); ?>" target="_blank">Twitter</a></li><?php endif; ?>
					<?php if(get_option('kolor_contact_show_dribbble') != 'false'): ?><li class="dribbble"><a href="<?php echo get_option('kolor_dribbble_url'); ?>" target="_blank">Dribbble</a></li><?php endif; ?>
					<?php if(get_option('kolor_contact_show_skype') != 'false'): ?><li class="skype"><a href="<?php echo get_option('kolor_skype_url'); ?>" target="_blank">Skype</a></li><?php endif; ?>
				</ul>
				<!-- end: social networks --> 
				
			</div>
			<!-- end: social networks block -->
			
		</div>
		<!-- end: address & other info -->
		
	</div>
	<!-- end: contact form & address info -->
	
	<?php 
		/* Client Testimonials */ 
		$testimonials = get_all_testimonials();
		$testimonials_count = count($testimonials);
		
		if($testimonials_count):
		?>
		<!-- client testimonials block -->
		<div class="container">
			<div class="sixteen columns">
				
				
				<!-- section title (linked with the Client Testimonials Block) -->
				<h3 class="title_icon">
					<i class="users"></i>
					<?php _e('What Clients Say', TD); ?>
				</h3>
				<!-- end: section title -->
				
			</div>
		</div>
		
		<div class="client_testimonials">
			
			<div class="container">
			
			<?php
			foreach($testimonials as $testimonial):
				
				$client_name 		= $testimonial['name'];
				$link				= $testimonial['link'];
				$second_line		= $testimonial['second_line'];
				$client_image 		= $testimonial['client_image']['th'];
				$testimonial_text 	= $testimonial['testimonial'];
			?>
				<!-- testimonial entry -->
				<div class="eight columns">
					
					<div class="testimonial_entry">
						
						<div class="photo">
							<img src="<?php echo WPURL . $client_image; ?>" alt="client_1">
						</div>
						
						<div class="details">
							<div class="arrow"></div>
							
							<div class="header">
								<a href="<?php echo esc_attr($link); ?>" target="_blank" class="name"><?php echo $client_name; ?></a>
								<span class="label"><?php echo $second_line; ?></span>
							</div>
							
							<div class="comment">
								<?php echo nl2br($testimonial_text); ?>
							</div>
						</div>
						
					</div>
					
				</div>
				<!-- testimonial entry -->
			<?php
			endforeach;
			?>
							
			</div>
			
		</div>
		<!-- end: client testimonials block -->
		<?php
		endif;
	?>
	<?php /* End: Client Testimonials */ ?>

<?php


// Footer Blocks
get_template_part('footer', 'block');


// Footer
get_footer();