<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 *
 *	Template Name: Gallery
 */

global $wp, $wp_query, $wp_rewrite, $query_string, $post_id;
$query_string_arr = wp_parse_args($query_string);

$post_id = $page_id = get_the_ID();

# Vars
$gallery_options = get_gallery_options();

$slider_items = get_posts(array('post_type' => 'attachment', 'post_parent' => $post_id, 'orderby' => 'menu_order', 'order' => 'ASC'));

# Use External Post Images
if($external_slider_post_id = get_post_meta($post_id, 'external_slider_post_id', TRUE))
{
	$slider_items = get_posts(array('post_type' => 'attachment', 'post_parent' => $external_slider_post_id, 'orderby' => 'menu_order', 'order' => 'ASC'));
}

$slider_items_count = count($slider_items);


extract($gallery_options);

$posts_per_page = $items_per_page;

$paged = isset($query_string_arr['paged']) ? $query_string_arr['paged'] : 1;
$paged = $paged > 1 ? $paged : 1;


# Get Portfolio Items
$query_arr = array(
	'post_type' => 'gallery',
	'posts_per_page' => $posts_per_page,
	'paged' => $paged,
	'orderby' => 'menu_order', 
	'order' => 'ASC'
);


$gallery_items = new WP_Query($query_arr);

# Defined Vars (after wp_query)
$max_num_pages = $gallery_items->max_num_pages;



# Import Required Resources
wp_enqueue_script(array('kolor_wideslider', 'kolor_hover'));

if($infinite_scroll)
{
	wp_enqueue_script('infinitescroll');
	wp_enqueue_script(array('isotope'));
	wp_enqueue_style(array('isotope'));
}


// Header
get_header();

?>
<!-- site header -->
<div class="site_header<?php echo $slider_items_count == 0 ? ' bg_02' : ''; ?>">
<?php

	// Main Menu (optionally with sliders)
	get_template_part('tpls/header', 'menu');

	// WideSlider
	get_template_part('tpls/sliders', 'wideslider');
?>	
</div>
<!-- end: site header -->

<!-- stripped border -->
<div class="stripped_border"></div>
<!-- end: stripped border -->


<!-- page head title -->
<div class="container">
	
	<div class="white_block head_title compact">
		
		<h2 class="block_title left">
			<i class="gallery"></i>
			<?php the_title(); ?>
		</h2>
			
	</div>
	
</div>
<!-- end: page head title -->


<!-- portfolio entries -->
<div class="container portfolio_entries categorizing portfolio_columns_<?php echo $columns; ?><?php echo $infinite_scroll ? (' endless_scrolling' . ($infinite_scroll_manual ? ' endless_scrolling_manual' : '')) : ''; ?>">
<?php
if($gallery_items->have_posts()):

	while($gallery_items->have_posts()): $gallery_items->the_post();
		
		global $post;
		
		$post_id = get_the_ID();
		
		$title = get_the_title();
		
		$thumbnail_size = '';
		
		switch($columns)
		{
			case 2:
				$thumbnail_size = 'portfolio-thumb-4';
				$post_thumbnail = get_the_post_thumbnail($post_id, $thumbnail_size, "portfolio-item-{$post_id}");
				break;
				
			case 3:
				$thumbnail_size = 'portfolio-thumb-3';
				$post_thumbnail = get_the_post_thumbnail($post_id, $thumbnail_size, "portfolio-item-{$post_id}");
				break;
				
			default:
				$thumbnail_size = 'portfolio-thumb-1';
				$post_thumbnail = get_the_post_thumbnail($post_id, $thumbnail_size, "portfolio-item-{$post_id}");
		}
		
		
		# [Alternative] If there is no post thumnail attached, check for other attachments inside the post
		if( ! $post_thumbnail)
		{
			$other_attachment = reset(get_children(array('post_parent' => $post_id, 'post_type' => 'attachment', 'posts_per_page' => 1, 'orderby' => 'menu_order', 'order' => 'ASC')));
			
			$post_thumbnail = wp_get_attachment_image($other_attachment->ID, $thumbnail_size);
			$post_thumbnail = preg_replace('/width=.[0-9]+.|height=.[0-9]+./', '', $post_thumbnail);
		}
		
		$album_date = get_post_meta($post_id, 'album_date', TRUE);
		$album_place = get_post_meta($post_id, 'album_place', TRUE);
		
		if($album_date)
		{
			$album_date = strtotime($album_date);
			$album_date = date("d F Y", $album_date);
		}
		
		$album_second_line = $album_date . ($album_date && $album_place ? ' - ' : '') . $album_place . '&nbsp;';
			
		
?>
	<!-- portfolio entry -->
	<div class="portfolio_entry_item <?php echo $columns == 3 ? 'one-third column' : ($columns == 2 ? 'eight columns' : 'four columns'); ?>">
		
		<div class="portfolio_entry<?php echo ! $gallery_bottom_titles ? ' no_titles' : ''; ?>" data-filter="" data-row-1="<?php echo esc_attr($title); ?>" data-row-2="<?php echo esc_attr($album_second_line); ?>">
			
			<a href="<?php the_permalink(); ?>" class="image portfolio_hover gallery_hover">
				<?php echo $post_thumbnail; ?>
			</a>
			
			<?php if($gallery_bottom_titles): ?>
				<!-- item title -->
				<div class="meta">					
					<a href="<?php the_permalink(); ?>" class="title"><?php the_title(); ?></a>
					
					<div class="right_panel">
						<span class="category gallery_category"><?php echo $album_second_line; ?></span>
						
						<?php if($allow_likes): ?>
						<a href="#" data-id="<?php echo $post_id; ?>" data-nonce="<?php echo wp_create_nonce('LaboratorLikeGalleryItem'); ?>" data-is-gallery-item="1" class="like<?php echo is_portfolio_item_liked($post_id) == 1 ? ' liked' : ''; ?>">Like</a>
						<?php endif; ?>
					</div>
				</div>
				<!-- end: item title -->
			<?php endif; ?>
						
		</div>
		
	</div>
	<!-- end: portfolio entry -->
	<?php
	endwhile;

endif;
?>
</div>
<!-- end: portfolio entries -->


<?php 
	// Normal Pagination
	if($max_num_pages > 1 && ! $infinite_scroll):
		
		$current_page = $paged;
		
		$from_to = pagination_generate_from_to($current_page, $max_num_pages, $numbers_to_show);
		extract($from_to);
		
?>
<!-- pagination -->
<div class="container margin_top">
	<div class="sixteen columns">
	
		<ul class="pagination<?php echo $pagination_position == 'center' ? ' center' : ($pagination_position == 'right' ? ' right' : ($pagination_position == 'full' ? ' full' : '')); ?>"><!-- add class 'center' or 'right' to position the text (default: left) -->		
		
		<?php if($paged > 1): ?>
			<li class="first_page"><a href="<?php echo get_pagenum_link(1); ?>"><?php _e('First Page'); ?></a></li>
		<?php endif; ?>
	
		<?php
		
		if($from > floor($numbers_to_show / 2))
		{
			?>
			<li><a href="<?php echo get_pagenum_link(1); ?>"><?php echo 1; ?></a></li>
			<li>...</li>
			<?php
		}
		
		for($i=$from; $i<=$to; $i++):
			
			$link_to_page = get_pagenum_link($i);
			$is_active = $paged == $i;
		?>
			<li<?php echo $is_active ? ' class="active"' : ''; ?>><a href="<?php echo $link_to_page; ?>"><?php echo $i; ?></a></li>
		<?php
		endfor;
			
		
		if($max_num_pages > $to)
		{
			if($max_num_pages != $i):
			?>
				<li>...</li>
			<?php
			endif;
			
			?>
			<li><a href="<?php echo get_pagenum_link($max_num_pages); ?>"><?php echo $max_num_pages; ?></a></li>
			<?php
		}
		?>
		
		<?php if($paged < $max_num_pages): ?>
			<li class="last_page"><a href="<?php echo get_pagenum_link($max_num_pages); ?>"><?php _e('Last Page'); ?></a></li>
		<?php endif; ?>
		</ul>
		
	</div>
</div>
<!-- end: pagination -->
<?php
	
	elseif($max_num_pages > 1 && $infinite_scroll):
	
		if($disable_isotope == 'true' && isset($_GET['category']))
		{
			$category_browse_url = "portfolio_category={$_GET['category']}&";
		}
	?>
<div class="container margin_top">
	<div class="sixteen columns">
	
		<ul class="pagination center">
			<li class="endless_scroll_pagination">
				<a href="<?php echo admin_url("admin-ajax.php?action=endless_get_results&post_type=gallery&page_id={$page_id}&{$category_browse_url}page=2"); ?>"><?php _e('Load More Items', TD); ?></a>
			</li>
		</ul>
	
	</div>
</div>
	<?php
	
	endif;


// Footer Clients Block
get_template_part('tpls/blocks', 'footerclients');


// Footer Blocks
get_template_part('footer', 'block');


// Footer
get_footer();