<?php
include 'includes/theme_info.php';

define('MENU_TITLE', 'Kolor');
define('MENU_SLUG', 'kolor_options'); //Define your menu slug, if you don't know what it is, just leave it as it is

if (!class_exists('acera_theme_options')) {

    class acera_theme_options {

        private $options;

        public function acera_theme_options($options) {
            $this->options = $options;

            add_action('admin_menu', array(&$this, 'acera_add_menu')); // Action that triggers function below
        }

        public function acera_add_menu() {
            add_menu_page(__(MENU_TITLE), __(MENU_TITLE), 'administrator', MENU_SLUG, array(&$this, 'acera_display_page'), get_stylesheet_directory_uri()."/inc/acera-options/" . 'images/icon.png');
        }

        /* Function That Generates Main Content */

        public function acera_display_page() {
        	
        	# Google Maps Include (AN)
        	?>
        	<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=false"></script>
        	<script type="text/javascript">
        	
        	function init_map(el_id, search_el_id)
        	{
        		var $ = jQuery;
        		var latest_marker = null;
        		
	        	var mapDiv = document.getElementById(el_id);
	        	var mapJq = $(mapDiv);
	        	var input = $( '#' + el_id.replace('map_', '') );
	        	
	        	var search_input = $( '#' + search_el_id );
				
				var pos = new google.maps.LatLng(mapJq.data('lat'), mapJq.data('lon'));
				
				var map = new google.maps.Map(mapDiv, {
					center: pos,
					zoom: 13,
					mapTypeId: google.maps.MapTypeId.ROADMAP,
					mapTypeControl: false,
					scaleControl: false,
					zoomControl: true,
					panControl: false,
					overviewMapControl: false
				});
				
				mapJq.data('map', map);
				
				var marker = new google.maps.Marker({map: map, position: pos});
				
				google.maps.event.addListener(map, 'click', function(ev)
				{
					var latlng = ev.latLng;
					
					marker.setPosition(latlng);
					map.panTo(latlng);
					
					var latlng_str = latlng.toString().replace(/[\(\)\s]*/g, '').replace(',', ';');

					input.val(latlng_str);
				});
				
				// Search Map
				if(search_input.length)
				{
					var geocoder = new google.maps.Geocoder();
					
					search_input.on({
						keydown: function(ev)
						{
							if(ev.keyCode == 13)
							{
								geocoder.geocode( {'address': search_input.val() }, function(results, status) {
									
									if(results)
									{
										var latlng = results[0].geometry.location;
										marker.setPosition(latlng);
										map.panTo(latlng);
										
										var latlng_str = latlng.toString().replace(/[\(\)\s]*/g, '').replace(',', ';');
										input.val(latlng_str);
									}
								});
								
								return false;
							}
						}
					});
				}
        	}
        	</script>
        	<?php
        	# End: Google Maps Include (AN)
        	
            ?>
            <?php $this->save_options(); ?>
            
            <?php
            if(isset($_GET['theme_activated'])):
            	?>
            	<div class="updated acera_updated">
            		<p>You have successfully activated <strong>Kolor</strong> theme. Enjoy it and get the best from it.</p>
            		<p><em>Note: Before publishing, please configure this theme using the forms below and click <strong>Save Changes</strong>.</em></p>
            	</div>
            	<?php
            endif;            
            ?>
            
            
            <form id="acera-settings" method="post">
                <input type="hidden" name="action" id="action" value="acera_save_options" />
                <div id="acera-sidebar">
                    <div id="acera-meta-info">
                        <h1><?php echo FRAMEWORK_NAME; ?></h1>
                        <h2>Theme: <?php echo THEME_NAME; ?></h2>
                        <h2>Author: <?php echo THEME_AUTHOR; ?></h2>
                        <h2>Version: <?php echo THEME_VERSION; ?></h2>
                    </div>
                    <ul id="acera-main-menu">

                        <?php $first = true; ?> 
                        <?php
                        /* Cycle that goes though $options array, it is searching for headings and sections to make navigation */

                        foreach ($this->options as $option):
                            if ($option['type'] == "section") :
                                $section = $option['id'];
                                ?>
                                <li><p><span class="<?php echo $option['icon']; ?>"></span><?php echo $option['title']; ?></p>
                                    <ul<?php if ($option['expanded'] == "true") echo ' class="default-accordion"'; ?>>
                                        <?php
                                        foreach ($this->options as $sections):
                                            if ((isset($sections['section']) && $sections['section'] == $section) && ((isset($sections['type']) && $sections['type'] == "heading") || ($sections['type'] == "html"))):
                                                ?>
                                                <li><a<?php
                            if ($first) {
                                echo ' class="defaulttab"';
                                $first = false;
                            }
                                                ?> href="#" rel="<?php echo $sections['id']; ?>"><p><?php echo $sections['title']; ?></p></a></li>
                                                    <?php
                                                endif;
                                            endforeach;
                                            ?> 
                                    </ul>
                                </li>
                                <?php
                            endif;
                        endforeach;
                        ?>
                    </ul>
                </div>


                <?php /* Below - script that generates divs for each tab */ ?>

                <div id="acera-content">
                    <?php foreach ($this->options as $option): ?> 
                        <?php if ($option['type'] == "heading"): ?>
                            <?php $under_section = $option['id']; ?>
                            <div class="tab-content" id="<?php echo $option['id']; ?>">
                                <div class="acera-settings-headline">
                                    <h2><?php echo $option['title']; ?></h2>
                                    <input name="save" class="save-button" type="submit" value="Save changes" />
                                </div>
                                <?php
                                /* Cycle that goes though options, and calls function for displaying input types */

                                foreach ($this->options as $item) {
                                    if (isset($item['under_section']) && $item['under_section'] == $under_section) {
                                        switch ($item['type']) {
                                            case "text":
                                                $this->display_text($item);
                                                break;

                                            case "color":
                                                $this->display_color($item);
                                                break;

                                            case "small_heading":
                                                $this->display_small_heading($item);
                                                break;

                                            case "textarea":
                                                $this->display_textarea($item);
                                                break;

                                            case "image":
                                                $this->display_image($item);
                                                break;

                                            case "checkbox":
                                                $this->display_checkbox($item);
                                                break;

                                            case "checkbox_image":
                                                $this->display_checkbox_image($item);
                                                break;

                                            case "radio":
                                                $this->display_radio($item);
                                                break;

                                            case "toggle_div_start":
                                                $this->display_toggle_div_start($item);
                                                break;

                                            case "toggle_div_end":
                                                $this->display_toggle_div_end();
                                                break;

                                            case "radio_image":
                                                $this->display_radio_image($item);
                                                break;

                                            case "select":
                                                $this->display_select($item);
                                                break;

                                            case "map":
                                                $this->display_map($item);
                                                break;
                                        }
                                    }
                                }
                                ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($option['type'] == "html"): ?>
                            <div class="tab-content" id="<?php echo $option['id']; ?>">
                                <?php echo $option['source']; ?>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div> 
            </form>

            <?php
        }

        /*         * *************************************
         * *************************************
         * ****                           ****** 
         * ****     Display functions     ******  
         * ****                           ******
         * *************************************
         * ************************************ */






        /* Normal text input ("type" => "text" */

        public function display_text($value) {
            $rel = "";
            if (isset($value['display_checkbox_id']))
                $rel = " rel=".$value['display_checkbox_id'];
            else
                $rel = "";
            ?>
            <div<?php echo $rel; ?> class="separator">
                <div class="label">
                    <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
                </div>
                <div class="settings-content">
                    <div class="acera_image_preview">
                        <?php if (isset($value['img_desc'])): ?>
                            <img src="<?php echo $value['img_desc']; ?>" />
                        <?php endif; ?>
                    </div>
                    <input<?php if (isset($value['placeholder'])) echo ' placeholder="' . $value['placeholder'] . '"'; ?> class="acera-fullwidth" id="<?php echo $value['id']; ?>" name="<?php echo $value['id']; ?>" type="text" value="<?php if (get_option($value['id'])) echo esc_html(stripslashes(get_option($value['id'])));else echo $value['default']; ?>" />
                    <p class="description"><?php echo isset($value['desc']) ? $value['desc'] : ''; ?></p>
                </div>
            </div>
            <?php
        }
        
        
        /* Color picker ("type" => "color") */

        public function display_color($value) {
            $rel = "";
            if (isset($value['display_checkbox_id']))
                $rel = " rel=".$value['display_checkbox_id'];
            else
                $rel = "";
            ?>
            <?php
            if (get_option($value['id']))
                $color = ' style="background-color: #' . get_option($value['id']) . ';"';
            else if ($value['default'])
                $color = ' style="background-color: #' . $value['default'] . ';"'
                ?>

            <div<?php echo $rel; ?> class="separator">
                <div class="label">
                    <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
                </div>
                <div class="settings-content">
                    <div class="acera_image_preview">
                        <?php if ($value['img_desc']): ?>
                            <img src="<?php echo $value['img_desc']; ?>" />
                        <?php endif; ?>
                    </div>
                    <input<?php if ($value['placeholder']) echo ' placeholder="' . $value['placeholder'] . '"'; ?> class="acera-color-picker"<?php echo $color; ?> id="<?php echo $value['id']; ?>" name="<?php echo $value['id']; ?>" type="text" value="<?php if (get_option($value['id'])) echo esc_html(stripslashes(get_option($value['id'])));else echo $value['default']; ?>" />
                    <p class="description"><?php echo isset($value['desc']) ? $value['desc'] : ''; ?></p>
                </div>
            </div>
            <?php
        }

        /* Image Upload ("type" => "image") */

        public function display_image($value) {
            $rel = "";
            if (isset($value['display_checkbox_id']))
                $rel = " rel=".$value['display_checkbox_id'];
            else
                $rel = "";
            ?>
            <div<?php echo $rel; ?> class="separator">
                <div class="label">
                    <label><?php echo $value['name']; ?></label>
                </div>
                <div class="settings-content">
                    <?php
                    if (get_option($value['id']))
                        $def_value = stripslashes(get_option($value['id']));
                    else
                        $def_value = isset($value['default']) ? $value['default'] : '';
                    ?>
                    <input<?php if (isset($value['placeholder'])) echo ' placeholder="' . $value['placeholder'] . '"'; ?> class="acera-fullwidth" type="text" value="<?php echo $def_value; ?>" name="<?php echo $value['id']; ?>" />


                    <span class="upload acera_upload acera-button-blue" id="<?php echo $value['id']; ?>">Upload image</span>
                    <?php if (get_option($value['id'])): ?>
                        <span type="button" class="acera_remove acera-button" id="remove_<?php echo $value['id']; ?>">Remove image</span>
                    <?php endif; ?>

                    <div class="acera_image_preview">
                        <?php if (get_option($value['id'])): ?>
                            <img src="<?php echo get_option($value['id']); ?>" />
                        <?php elseif (isset($value['default']) && $value['default'] != ""): ?>
                            <img src="<?php echo $value['default']; ?>" />
                        <?php endif; ?>
                    </div>

                    <p class="description"><?php echo isset($value['desc']) ? $value['desc'] : ''; ?></p>

                </div>
            </div>
            <?php
        }

        /* Textarea input ("type" => "textarea") */

        public function display_textarea($value) {
            $rel = "";
            if (isset($value['display_checkbox_id']))
                $rel = " rel=".$value['display_checkbox_id'];
            else
                $rel = "";
            ?>
            <div<?php echo $rel; ?> class="separator">
                <div class="label">
                    <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
                </div>
                <div class="settings-content">
                    <div class="acera_image_preview">
                        <?php if (isset($value['img_desc'])): ?>
                            <img src="<?php echo $value['img_desc']; ?>" />
                        <?php endif; ?>
                    </div>
                    <textarea<?php if (isset($value['placeholder'])) echo ' placeholder="' . $value['placeholder'] . '"'; ?> id="<?php echo $value['id']; ?>" name="<?php echo $value['id']; ?>" cols="70" rows="8"><?php
            if (get_option($value['id']))
                echo stripslashes(get_option($value['id']));
            else
                echo isset($value['default']) ? $value['default'] : '';
                        ?></textarea>
                    <p class="description"><?php echo isset($value['desc']) ? $value['desc'] : ''; ?></p>
                </div>
            </div>
            <?php
        }

        /* Select input ("type" => "select") */

        public function display_select($value) {
            $rel = "";
            if (isset($value['display_checkbox_id']))
                $rel = " rel=".$value['display_checkbox_id'];
            else
                $rel = "";
            ?>
            <div<?php echo $rel; ?> class="separator">
                <div class="label">
                    <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
                </div>
                <div class="settings-content">
                    <div class="acera_image_preview">
                        <?php if (isset($value['img_desc'])): ?>
                            <img src="<?php echo $value['img_desc']; ?>" />
                        <?php endif; ?>
                    </div>
                    <select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
                        <?php
                        if (get_option($value['id']))
                            $default = get_option($value['id']);
                        else
                            $default = $value['default'];


                        foreach ($value['options'] as $index => $option):
                            $selected = '';
                            $value_by_index = is_string($index);
                            if ($option == $default)
                                $selected = ' selected="selected"';
                               
                            if($value_by_index && $index == $default)
                            	$selected = ' selected="selected"';
                            ?>
                            <option <?php echo $selected; ?><?php echo $value_by_index ? (' value="'.esc_attr($index).'"') : ''; ?>><?php echo $option ?></option>
                        <?php endforeach; ?>


                    </select>
                    <p class="description"><?php echo isset($value['desc']) ? $value['desc'] : ''; ?></p>
                </div>
            </div>
            <?php
        }
        
        
        // Function by Arlind Nushi
        public function display_map($value) {
            $rel = "";
            if (isset($value['display_checkbox_id']))
                $rel = " rel=".$value['display_checkbox_id'];
            else
                $rel = "";
            
            $original_value = get_option($value['id']);
            $default = $value['default'];
            
            if($original_value)
	            $val = $original_value;
	        else
	        	$val = $default;
	        
	        list($lat, $lon) = explode(';', $val);
	        
            $el_id = "map_" . $value['id'];
            $search_el_id = "search_" . $value['id'];
            ?>
            <div<?php echo $rel; ?> class="separator">
                <div class="label">
                    <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
                </div>
                <div class="settings-content">
                    <div class="acera_image_preview">
                        <?php if (isset($value['img_desc'])): ?>
                            <img src="<?php echo $value['img_desc']; ?>" />
                        <?php endif; ?>
                    </div>
                    
                    <div class="map_border">
	                    <div class="map_location" id="<?php echo $el_id; ?>" data-lat="<?php echo $lat; ?>" data-lon="<?php echo $lon; ?>"></div>
                    </div>
                    
                    <input type="hidden" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="<?php echo $val; ?>" />
                    
                    <?php if($value['search']): ?>
                    <div class="search_input">
	                    <input<?php if ($value['placeholder']) echo ' placeholder="' . $value['placeholder'] . '"'; ?> class="acera-fullwidth" id="<?php echo $search_el_id; ?>" name="<?php echo $search_el_id; ?>" type="text" />
                    </div>
                    <?php endif; ?>
                    
                    <p class="description"><?php echo isset($value['desc']) ? $value['desc'] : ''; ?></p>
                </div>
            </div>
            <script type="text/javascript">
            jQuery(function($)
            {
	            init_map.apply(this, ['<?php echo $el_id; ?>', '<?php echo $search_el_id; ?>']);
            })
            </script>
            <?php
	        
        }
        // End: Function by Arlind Nushi
        

        /* Normal checkbox ("type" => "checkbox") */

        public function display_checkbox($value) {
            $rel = "";
            if (isset($value['display_checkbox_id']))
                $rel = " rel=".$value['display_checkbox_id'];
            else
                $rel = "";
            ?>
            <div<?php echo $rel; ?> class="separator">
                <div class="label">
                    <label><?php echo $value['name']; ?></label>
                </div>
                <div class="settings-content">
                    <div class="acera_image_preview">
                        <?php if (isset($value['img_desc'])): ?>
                            <img src="<?php echo $value['img_desc']; ?>" />
                        <?php endif; ?>
                    </div>
                    <?php
                    $i = 0;
                    foreach ($value['options'] as $box):
                        $checked = '';

                        if (get_option($value['id'][$i])) {
                            if (get_option($value['id'][$i]) == 'true')
                                $checked = ' checked="checked"';

                            else
                                $checked = '';
                        }

                        else {
                            if ($value['default'][$i] == "checked")
                                $checked = ' checked="checked"';
                        }
                        ?>
                        <label for="<?php echo $value['id'][$i]; ?>">
                            <input type="checkbox"<?php echo $checked; ?> name="<?php echo $value['id'][$i]; ?>" id="<?php echo $value['id'][$i]; ?>" />
                            <?php echo $box; ?>
                        </label>
                        <?php
                        $i++;
                    endforeach;
                    ?>
                    <p class="description"><?php echo isset($value['desc']) ? $value['desc'] : ''; ?></p>
                </div>
            </div>
            <?php
        }

        /* Image checkbox ("type" => "checkbox_image") */

        public function display_checkbox_image($value) {
            $rel = "";
            if (isset($value['display_checkbox_id']))
                $rel = " rel=".$value['display_checkbox_id'];
            else
                $rel = "";
            ?>
            <div<?php echo $rel; ?> class="separator">
                <div class="label">
                    <label><?php echo $value['name']; ?></label>
                </div>
                <div class="settings-content">
                    <div class="cOf">
                        <?php
                        $i = 0;
                        foreach ($value['options'] as $box):
                            $checked = '';
                            $class = '';
                            $img_size = '';

                            if (isset($value['image_size'][$i]))
                                $img_size = 'width="' . $value['image_size'][$i] . '"';
                            else if ( ! isset($value['image_size'][$i]) && isset($value['image_size'][0]) && $value['image_size'][0] == true)
                                $img_size = 'width="' . $value['image_size'][0] . '"';
                            else
                                $img_size = 'width="120"';




                            if (get_option($value['id'][$i])) {
                                if (get_option($value['id'][$i]) == 'true') {
                                    $checked = ' checked="checked"';
                                    $class = ' acera-img-selected';
                                }
                            } elseif ($value['default'][$i] == "checked") {
                                $class = ' acera-img-selected';
                                $checked = ' checked="checked"';
                            }
                            ?>
                            <label class="acera-image-checkbox<?php echo $class; ?>" for="<?php echo $value['id'][$i]; ?>">
                                <img <?php echo $img_size; ?> src="<?php echo $value['image_src'][$i]; ?>" alt="<?php echo $box ?>" />
                                <input class="acera-image-checkbox-b" type="checkbox"<?php echo $checked; ?> name="<?php echo $value['id'][$i]; ?>" id="<?php echo $value['id'][$i]; ?>" />
                                <?php if (isset($value['show_labels']) && $value['show_labels'] == "true"): ?><p><?php echo $box; ?></p><?php endif; ?>
                            </label>
                            <?php
                            $i++;
                        endforeach;
                        ?>
                    </div>
                    <p class="description"><?php echo isset($value['desc']) ? $value['desc'] : ''; ?></p>
                </div>
            </div>
            <?php
        }

        /* Normal radio input ("type" => "radio") */

        public function display_radio($value) {
            $rel = "";
            if (isset($value['display_checkbox_id']))
                $rel = " rel=".$value['display_checkbox_id'];
            else
                $rel = "";
            ?>
            <div<?php echo $rel; ?> class="separator">
                <div class="label">
                    <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
                </div>
                <div class="settings-content">
                    <div class="acera_image_preview">
                        <?php if (isset($value['img_desc'])): ?>
                            <img src="<?php echo $value['img_desc']; ?>" />
                        <?php endif; ?>
                    </div>
                    <?php
                    $i = 0;

                    if (get_option($value['id']))
                        $default = get_option($value['id']);
                    else
                        $default = $value['default'];

                    foreach ($value['options'] as $key => $option):
                        $checked = '';

                        if (isset($value['options'][$i]) && $value['options'][$i] == $default) {
                            $checked = ' checked="checked"';
                        }
                        else
                        if ($key == $default) {
                            $checked = ' checked="checked"';
                        }
                        
                        // Value of
                        if(strstr($option, 'valueOf'))
                        {
                        	preg_match("/{valueOf:([a-z-0-9_\-]+?)}/i", $option, $valueof_id);
                        	
                        	$option = preg_replace("/{valueOf:([a-z-0-9_\-]+?)}/i", get_option($valueof_id[1]), $option);
                        	
                        }
                        ?>
                        <label for="<?php echo $value['id'] . $i; ?>">
                            <input type="radio" id="<?php echo $value['id'] . $i; ?>" name="<?php echo $value['id']; ?>" value="<?php echo is_numeric($key) ? $value['options'][$i] : $key; ?>" <?php echo $checked; ?> />
                            <?php echo $option; ?>
                        </label>
                        <?php
                        $i++;
                    endforeach;
                    ?>
                    <p class="description"><?php echo isset($value['desc']) ? $value['desc'] : ''; ?></p>
                </div>
            </div>
            <?php
        }

        /* Image radio input ("type" => "radio_image") */

        public function display_radio_image($value) {
            $rel = "";
            if (isset($value['display_checkbox_id']))
                $rel = " rel=".$value['display_checkbox_id'];
            else
                $rel = "";
            ?>
            <div<?php echo $rel; ?> class="separator">
                <div class="label">
                    <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
                </div>
                <div class="settings-content">
                    <div class="cOf">
                        <?php
                        $i = 0;

                        if (get_option($value['id']))
                            $default = get_option($value['id']);
                        else
                            $default = $value['default'];

                        foreach ($value['options'] as $key => $option):
                            $class = '';
                            $img_size = '';
                            $checked = '';
                            
                            $_value = $option;
                            
                            if(is_string($key))
                            {
                            	$_value = $key;
                            }
                            

                            if (isset($value['image_size'][$i]))
                                $img_size = 'width="' . $value['image_size'][$i] . '"';
                            else if ( ! isset($value['image_size'][$i]) && isset($value['image_size'][0]) && $value['image_size'][0] == true)
                                $img_size = 'width="' . $value['image_size'][0] . '"';
                            else
                                $img_size = 'width="120"';

                            if ($_value == $default) {
                                $checked = ' checked="checked"';
                                $class = ' acera-img-selected';
                            }
                            ?>
                            <label class="acera-image-radio<?php echo $class; ?>" for="<?php echo $value['id'] . $i; ?>">
                                <img <?php echo $img_size; ?> src="<?php echo $value['image_src'][$i]; ?>" alt="<?php echo $box ?>" />
                                <input class="acera-image-radio-b" type="radio" id="<?php echo $value['id'] . $i; ?>" name="<?php echo $value['id']; ?>" value="<?php echo $_value; ?>" <?php echo $checked; ?> />
                                <?php if ($value['show_labels'] == "true"): ?><p><?php echo $option; ?></p><?php endif; ?>
                            </label>
                            <?php
                            $i++;
                        endforeach;
                        ?>
                    </div>
                    <p class="description"><?php echo isset($value['desc']) ? $value['desc'] : ''; ?></p>
                </div>
            </div>
            <?php
        }

        /* Displays small Heading in tabs */

        public function display_small_heading($value) {
            $rel = "";
            if (isset($value['display_checkbox_id']))
                $rel = " rel=".$value['display_checkbox_id'];
            else
                $rel = "";
            ?>
            <div<?php echo $rel; ?> class="separator">
                <h4><?php echo $value['title']; ?></h4>
            </div>
            <?php
        }
        
        /* Hiding div start ("type" => "toggle_div_start" */
        
        public function display_toggle_div_start($value) {
            $rel = "";
            if (isset($value['display_checkbox_id']))
                $rel = " rel=".$value['display_checkbox_id'];
            else
                $rel = "";
            ?>
                <div<?php echo $rel; ?>>
            <?php
        }
        
        
        /* Hiding div end ("type" => "toggle_div_end" */
        
        public function display_toggle_div_end() {
            ?>
                </div>                    
            <?php
        }


        /*         * *************************************
         * *************************************
         * ****                           ****** 
         * ****      Saving function      ******  
         * ****                           ******
         * *************************************
         * ************************************ */

        public function save_options() {

            if (isset($_POST['action']) && $_POST['action'] == "acera_save_options") {
                foreach ($this->options as $value) {
                    $the_type = $value['type'];

                    if ($the_type == "heading" || $the_type == "section" || $the_type == "small_heading")
                        continue;

                    else if ($the_type != "checkbox" && $the_type != "checkbox_image") {
                        update_option($value['id'], stripslashes($_POST[$value['id']]));
                    } else if ($the_type == "checkbox" || $the_type == "checkbox_image") {
                        $i = 0;

                        foreach ($value['options'] as $box) {
                            $curr_id = $value['id'][$i];

                            if (isset($_POST[$curr_id]))
                                update_option($curr_id, 'true');

                            else
                                update_option($curr_id, 'false');
                            $i++;
                        }
                    }
                }
            }
        }

    }

}
?>
