<?php 


$options = array();


/* General / Section */
$options[] = array(
	'type'		=> 'section',
	'id'		=> 'general',
	'title'		=> 'General Settings',
	'icon'		=> 'acera-icon-preference',
	'expanded'	=> TRUE	
);

	

	/* Visual Options / Sub Section */
	$options[] = array(
		'section'	=> 'general',
		'type'		=> 'heading',
		'id'		=> 'visual-options',
		'title'		=> 'Visual Options'
	);
		
		/* Logo */
		$options[] = array(
			'under_section'	=> 'visual-options',
			'type'			=> 'image',
			'name'			=> 'Logo Image',
			'id'			=> 'kolor_logo_url',
			'desc'			=> 'You can also import logo from external URL',
			'placeholder'	=> 'The URL of your logo'
		);
		
		/* Retina Ready Logo */
		$options[] = array(
			'under_section'	=> 'visual-options',
			'type'			=> 'image',
			'name'			=> 'Retina Logo',
			'id'			=> 'kolor_retina_logo_url',
			'desc'			=> '@2x the size of the logo',
			'placeholder'	=> 'Optional'
		);
		
		
		/* Title Options */
		$options[] = array(
			'under_section'	=> 'visual-options',
			'type'			=> 'small_heading',
			'id'			=> 'favicon-title',
			'title'			=> 'Favicon - Browser &amp; Mobile'
		);
		
		/* Favicon */
		$options[] = array(
			'under_section'	=> 'visual-options',
			'type'			=> 'image',
			'name'			=> 'Favicon',
			'id'			=> 'kolor_favicon_16x16',
			'desc'			=> 'PNG format image of size 16x16 pixels.'
		);
		
		
		/* Apple Touch Icon */
		$options[] = array(
			'under_section'	=> 'visual-options',
			'type'			=> 'image',
			'name'			=> 'Apple Touch Icon',
			'id'			=> 'kolor_apple_touch_114px114',
			'desc'			=> 'PNG format image of size 114x144 pixels.'
		);
		
		
		/* Title Options */
		$options[] = array(
			'under_section'	=> 'visual-options',
			'type'			=> 'small_heading',
			'id'			=> 'title-options',
			'title'			=> 'Title Options (title bar in the browser)'
		);
		
		/* Title Position */
		$options[] = array(
			'under_section'	=> 'visual-options',
			'type'			=> 'radio',
			'name'			=> 'Title Type',
			'id'			=> 'kolor_title_type',
			'options'		=> array(
										'site_title_left' => '{SITE_TITLE} {valueOf:kolor_title_separator} {PAGE_TITLE}', 
										'site_title_right' => '{PAGE_TITLE} {valueOf:kolor_title_separator} {SITE_TITLE}',
										'only_site_title' => '{SITE_TITLE}',
										'only_page_title' => '{PAGE_TITLE}'
									),
			'default'		=> 'site_title_right',
			'desc'			=> 'Used in the browser title bar. {SITE_TITLE} = "<strong>' . get_bloginfo('title') . '</strong>"'
		);
		
		/* Title Separator */
		$options[] = array(
			'under_section'	=> 'visual-options',
			'type'			=> 'text',
			'name'			=> 'Title Separator',
			'id'			=> 'kolor_title_separator',
			'default'		=> '-'
		);
		
		
		/* Sidebar Options */
		$options[] = array(
			'under_section'	=> 'visual-options',
			'type'			=> 'small_heading',
			'id'			=> 'sidebar-options',
			'title'			=> 'Sidebar Options'
		);
			
			/* Sidebar Color */
			$options[] = array(
				'under_section'	=> 'visual-options',
				'type'			=> 'radio',
				'name'			=> 'Default Sidebar Color',
				'id'			=> 'kolor_sidebar_color',
				'options'		=> array(
											'dark_sidebar' => 'Dark Sidebar',
											'light_sidebar' => 'Light Sidebar'
										),
				'default'		=> 'dark_sidebar',
				'desc'			=> 'This sidebar is visible on: homepage, page with sidebar, blog, and blog post. <br> Note: You can override sidebar color for each page that supports it.'
			);

		
		
		/* Retina Ready Display */
		$options[] = array(
			'under_section'	=> 'visual-options',
			'type'			=> 'small_heading',
			'id'			=> 'retina-ready-display',
			'title'			=> 'Retina Ready Display'
		);
		
			/* Enable Disable Retina */
			$options[] = array(
				'under_section'	=> 'visual-options',
				'type'			=> 'checkbox',
				'name'			=> 'Enable Retina',
				'id'			=> array('kolor_retina_ready_enable'),
				'options'		=> array('Enable'),
				'desc'			=> 'High quality images are used for devices with aspect ratios 1.5 or higher',
				'default'		=> array('checked')
			);
			

	/* Clients Carousel / Sub Section */
	$options[] = array(
		'section'	=> 'general',
		'type'		=> 'heading',
		'id'		=> 'clients-carousel',
		'title'		=> 'Clients Carousel'
	);
		
		
		/* Clients Block */
		$options[] = array(
			'under_section'	=> 'clients-carousel',
			'type'			=> 'checkbox',
			'name'			=> 'Visibility',
			'id'			=> array('kolor_show_clients_carousel'),
			'options'		=> array('Make it visible'),
			'desc'			=> 'Will be visible in supported templates files.',
			'img_desc'		=> THEMEURL . 'images/admin/our_clients_descimg.png',
			'default'		=> array('checked')
		);
		
		/* Clients Block Timeout */
		$options[] = array(
			'under_section'	=> 'clients-carousel',
			'type'			=> 'text',
			'name'			=> 'Auto Switch Time',
			'id'			=> 'kolor_clients_carousel_timeout',
			'desc'			=> 'In seconds. Set "0" - to disable.',
			'default'		=> '3'
		);
	
	

	

	/* Page Head Caption / Sub Section */
	$options[] = array(
		'section'	=> 'general',
		'type'		=> 'heading',
		'id'		=> 'page-head-caption',
		'title'		=> 'Page Head Captions'
	);
		
		
		/* Enable/Disable PHC */
		$options[] = array(
			'under_section'	=> 'page-head-caption',
			'type'			=> 'checkbox',
			'name'			=> 'Enable Page Head Captions',
			'id'			=> array('kolor_pagehead_captions_enable'),
			'options'		=> array('Yes'),
			'desc'			=> 'Page head captions are supported for these types pages: blog, blog post, normal page and archives.',
			'img_desc'		=> THEMEURL . 'images/admin/page-head-captions.png',
			'default'		=> array('checked')
		);
		
		
		/* Default Page Head Caption - Title */
		$options[] = array(
			'under_section'	=> 'page-head-caption',
			'type'			=> 'text',
			'name'			=> 'Page Title',
			'id'			=> 'kolor_pagehead_captions_title',
			'placeholder'	=> 'Your page title',
			'display_checkbox_id' => 'kolor_pagehead_captions_enable'
		);
		
		
		/* Default Page Head Caption - Description */
		$options[] = array(
			'under_section'	=> 'page-head-caption',
			'type'			=> 'textarea',
			'name'			=> 'Page Description',
			'id'			=> 'kolor_pagehead_captions_description',
			'placeholder'	=> 'Some general description about the site/page',
			'display_checkbox_id' => 'kolor_pagehead_captions_enable',
			'desc'			=> 'Note: You can also set different page caption data for each type of page where PHC is supported when editing (or adding) page.'
		);
		
		
	

	/* Social Networks / Sub Section */
	$options[] = array(
		'section'	=> 'general',
		'type'		=> 'heading',
		'id'		=> 'social-networks',
		'title'		=> 'Social Networks'
	);
	
		
		/* Social Networks to Show */
		$options[] = array(
			'under_section'	=> 'social-networks',
			'type'			=> 'checkbox_image',
			'name'			=> 'Social Networks to Show',
			
			'image_size'	=> array(32),
			
			'id'			=> array(
										'kolor_show_fb',
										'kolor_show_twitter',
										'kolor_show_dribbble',
										'kolor_show_skype',
									),
			'image_src'		=> array(
										THEMEURL . 'images/admin/fb.png',
										THEMEURL . 'images/admin/twitter.png',
										THEMEURL . 'images/admin/dribbble.png',
										THEMEURL . 'images/admin/skype.png',
									),
			'options'		=> array(
										'Facebook',
										'Twitter',
										'Dribbble',
										'Skype',
									),
			'desc'			=> 'Select social networks to show in the footer'
		);
		
		
		/* Facebook Profile */
		$options[] = array(
			'under_section'	=> 'social-networks',
			'type'			=> 'text',
			'name'			=> 'Facebook URL',
			'id'			=> 'kolor_facebook_url',
			'placeholder'	=> 'http://',
			'display_checkbox_id'	=> 'kolor_show_fb'
		);
		
		
		/* Twitter Profile */
		$options[] = array(
			'under_section'	=> 'social-networks',
			'type'			=> 'text',
			'name'			=> 'Twitter URL',
			'id'			=> 'kolor_twitter_url',
			'placeholder'	=> 'http://',
			'display_checkbox_id'	=> 'kolor_show_twitter'
		);
		
		
		/* Dribbble Profile */
		$options[] = array(
			'under_section'	=> 'social-networks',
			'type'			=> 'text',
			'name'			=> 'Dribbble URL',
			'id'			=> 'kolor_dribbble_url',
			'placeholder'	=> 'http://',
			'display_checkbox_id'	=> 'kolor_show_dribbble'
		);
		
		
		/* Skype Profile */
		$options[] = array(
			'under_section'	=> 'social-networks',
			'type'			=> 'text',
			'name'			=> 'Sykpe URL',
			'id'			=> 'kolor_skype_url',
			'placeholder'	=> 'http://',
			'display_checkbox_id'	=> 'kolor_show_skype'
		);
	

	/* Footer / Sub Section */
	$options[] = array(
		'section'	=> 'general',
		'type'		=> 'heading',
		'id'		=> 'footer-scripts',
		'title'		=> 'Footer'
	);
		
		/* Footer Text */
		$options[] = array(
			'under_section'	=> 'footer-scripts',
			'type'			=> 'textarea',
			'name'			=> 'Footer Text',
			'id'			=> 'kolor_footer_text',
			'default'		=> '&copy; ' . date('Y') . ' Your Company',
			'desc'			=> 'You can also include HTML tags'
		);
		
		
		/* Google Analytics */
		$options[] = array(
			'under_section' => 'footer-scripts',
			'type'			=> 'checkbox',
			'name'			=> 'Trackings',
			'id'			=> array('kolor_include_google_analytics'),
			'options'		=> array('Google Analytics')
		);
		
			/* Google Analytics Text */
			$options[] = array(
				'under_section'	=> 'footer-scripts',
				'type'			=> 'textarea',
				'name'			=> 'Google Analytics Tracker Code',
				'id'			=> 'kolor_google_analytics_tracker_code',
				'desc'			=> 'Include &lt;script&gt;&lt;/script&gt; tags',
				'display_checkbox_id' => 'kolor_include_google_analytics'
			);


	
	

/* Portfolio Page / Section */
$options[] = array(
	'type'		=> 'section',
	'id'		=> 'portfolio',
	'title'		=> 'Settings for Pages',
	'icon'		=> 'acera-icon-folder',
	'expanded'	=> TRUE
);

	/* Blog Main Settings Section */
	$options[] = array(
		'section'		=> 'portfolio',
		'type'			=> 'heading',
		'title'			=> 'Blog Page',
		'id'			=> 'blog-main'
	);
		
		/* Post Thumbnails */
		$options[] = array(
			'under_section' => 'blog-main',
			'type'			=> 'checkbox',
			'name'			=> 'Post Thumbnails',
			'id'			=> array('kolor_show_post_thumbnails'),
			'options'		=> array('Show post thumbnails/featured image'),
			'default'		=> array('checked'),
			'img_desc'		=> THEMEURL . 'images/admin/article-thumbnails.png'
		);
		
		/* Share post */
		$options[] = array(
			'under_section' => 'blog-main',
			'type'			=> 'checkbox',
			'name'			=> 'Share Post',
			'id'			=> array('kolor_share_post_bottom_visible'),
			'options'		=> array('Show share buttons'),
			'desc'			=> 'Below the post',
			'default'		=> array('checked')
		);
		
		
		
		/* Buttons Visibility */
		$options[] = array(
			'under_section' => 'blog-main',
			'type'			=> 'checkbox',
			'name'			=> 'Visible Buttons',
			'id'			=> array('kolor_share_post_facebook_button', 'kolor_share_post_twitter_button', 'kolor_share_post_google_button'),
			'options'		=> array('Facebook', 'Twitter', 'Google Plus'),
			'default'		=> array('checked', 'checked', 'checked'),
			'display_checkbox_id' => 'kolor_share_post_bottom_visible'
		);
		
			/* Google Analytics Text */
			$options[] = array(
				'under_section'	=> 'blog-main',
				'type'			=> 'text',
				'name'			=> 'Twitter Username',
				'id'			=> 'kolor_share_post_twitter_id',
				'display_checkbox_id' => 'kolor_share_post_twitter_button',
				'desc'			=> 'Share via @yourtwitterid'
			);
	
		/* Show author info when viewing blog post */
		$options[] = array(
			'under_section'	=> 'blog-main',
			'type'			=> 'select',
			'name'			=> 'Show Author Info',
			'id'			=> 'kolor_blog_post_show_author_info',
			'options'		=> array('yes' => 'Yes', 'no' => 'No'),
			'desc'			=> 'Visible on single post page (only for blog)'
		);
	
		/* Blog Columns Default Color */
		$options[] = array(
			'under_section' 	=> 'blog-main',
			'type' 				=> 'radio_image',
			'id' 				=> 'kolor_default_blog_columns',
			'name' 				=> 'Default Blog Template',
			'show_labels' 		=> 'true',
			'image_src'	 		=> array(
											THEMEURL . 'images/admin/blog-one-column.png',
											THEMEURL . 'images/admin/blog-two-columns.png'
										),
			'image_size' 		=> array('180'),
			'options' 			=> array(
											'one_column'	=> 'One Column',
											'two_columns'	=> 'Two Columns'
										),
			'default'			=> 'one_column'
		);
	
	

	/* Portfolio Main Settings Section */
	$options[] = array(
		'section'		=> 'portfolio',
		'type'			=> 'heading',
		'title'			=> 'Portfolio Page',
		'id'			=> 'portfolio-main'
	);
	
	
		/* Portfolio Pagination (items per page) */
		$portfolio_items_per_page = array();
		$gallery_items_per_page = array();
		
		for($i=30; $i>=3; $i--)
		{
			array_push($portfolio_items_per_page, $i);
		}
		
		$options[] = array(
			'under_section'	=> 'portfolio-main',
			'type'			=> 'select',
			'name'			=> 'Items per page',
			'id'			=> 'kolor_portfolio_items_per_page',
			'options'		=> $portfolio_items_per_page,
			'default'		=> 12,
		);
		
		
		/* Portfolio Pagination Position (items per page) */
		$options[] = array(
			'under_section'	=> 'portfolio-main',
			'type'			=> 'select',
			'name'			=> 'Pagination Position',
			'id'			=> 'kolor_portfolio_pagination_position',
			'options'		=> array('left' => 'Left', 'center' => 'Center', 'right' => 'Right', 'full' => 'Full')
		);
		
		
		/* Portfolio Disable Isotope */
		$options[] = array(
			'under_section' => 'portfolio-main',
			'type'			=> 'checkbox',
			'name'			=> 'Category Filtering',
			'id'			=> array('kolor_portfolio_disable_isotope'),
			'options'		=> array('Disable category filtering via JavaScript (Isotope plugin).')
		);
		
		
		/* Like Options */
		$options[] = array(
			'under_section'	=> 'portfolio-main',
			'type'			=> 'small_heading',
			'id'			=> 'portfolio-likes-settings',
			'title'			=> 'Likes'
		);
		
			/* Allow Likes */
			$options[] = array(
				'under_section' => 'portfolio-main',
				'type'			=> 'checkbox',
				'name'			=> 'Allow Likes',
				'id'			=> array('kolor_portfolio_allow_likes'),
				'options'		=> array('Users can like items'),
				'default'		=> array('checked')
			);
			
			
			/* Portfolio Likes Logging */
			$options[] = array(
				'under_section'	=> 'portfolio-main',
				'type'			=> 'select',
				'name'			=> 'Logging method',
				'id'			=> 'kolor_portfolio_like_logging_method',
				'options'		=> array('cookie' => 'Cookie Based', 'ip' => 'Unique IP'),
				'desc'			=> 'How many times a single user can vote an item. <br />Cookie - each time user opens new window,<br />IP - one time only',
				'default'		=> 'ip',
				'display_checkbox_id'	=> 'kolor_portfolio_allow_likes' 
			);
			
			
			/* User can remove likes  */
			$options[] = array(
				'under_section'	=> 'portfolio-main',
				'type'			=> 'select',
				'name'			=> 'Unlike Item',
				'id'			=> 'kolor_portfolio_unlike_support',
				'options'		=> array('no' => 'No', 'yes' => 'Yes'),
				'desc'			=> 'Allow user to remove the like they gave by offering unlike feature.',
				'default'		=> 'yes',
				'display_checkbox_id'	=> 'kolor_portfolio_allow_likes' 
			);
		
		
		/* Views Options */
		$options[] = array(
			'under_section'	=> 'portfolio-main',
			'type'			=> 'small_heading',
			'id'			=> 'portfolio-views-settings',
			'title'			=> 'Item Views'
		);
		
		
			/* Allow Views */
			$options[] = array(
				'under_section' => 'portfolio-main',
				'type'			=> 'checkbox',
				'name'			=> 'Item Views',
				'id'			=> array('kolor_portfolio_show_views'),
				'options'		=> array('Show item views for portfolio item'),
				'checked'		=> array('checked')
			);
	


	/* Gallery Main Settings Section */
	$options[] = array(
		'section'		=> 'portfolio',
		'type'			=> 'heading',
		'title'			=> 'Gallery Page',
		'id'			=> 'gallery-main'
	);
	
		/* Gallery Pagination (items per page) */
		$options[] = array(
			'under_section'	=> 'gallery-main',
			'type'			=> 'select',
			'name'			=> 'Items per page',
			'id'			=> 'kolor_gallery_items_per_page',
			'options'		=> $portfolio_items_per_page,
			'default'		=> 12,
		);
		
		
		/* Gallery Pagination Position */
		$options[] = array(
			'under_section'	=> 'gallery-main',
			'type'			=> 'select',
			'name'			=> 'Pagination Position',
			'id'			=> 'kolor_gallery_pagination_position',
			'options'		=> array('left' => 'Left', 'center' => 'Center', 'right' => 'Right', 'full' => 'Full')
		);
		
		
		
		/* Like Options */
		$options[] = array(
			'under_section'	=> 'gallery-main',
			'type'			=> 'small_heading',
			'id'			=> 'gallery-likes-settings',
			'title'			=> 'Likes'
		);
		
			/* Allow Likes */
			$options[] = array(
				'under_section' => 'gallery-main',
				'type'			=> 'checkbox',
				'name'			=> 'Allow Likes',
				'id'			=> array('kolor_gallery_allow_likes'),
				'options'		=> array('Users can like items'),
				'default'		=> array('checked')
			);
			
			
			/* Gallery Likes Logging */
			$options[] = array(
				'under_section'	=> 'gallery-main',
				'type'			=> 'select',
				'name'			=> 'Logging method',
				'id'			=> 'kolor_gallery_like_logging_method',
				'options'		=> array('cookie' => 'Cookie Based', 'ip' => 'Unique IP'),
				'desc'			=> 'How many times a single user can vote an item. <br />Cookie - each time user opens new window,<br />IP - one time only',
				'default'		=> 'ip',
				'display_checkbox_id'	=> 'kolor_gallery_allow_likes' 
			);
			
			
			/* User can remove likes  */
			$options[] = array(
				'under_section'	=> 'gallery-main',
				'type'			=> 'select',
				'name'			=> 'Unlike Item',
				'id'			=> 'kolor_gallery_unlike_support',
				'options'		=> array('no' => 'No', 'yes' => 'Yes'),
				'desc'			=> 'Allow user to remove the like they gave by offering unlike feature.',
				'default'		=> 'yes',
				'display_checkbox_id'	=> 'kolor_gallery_allow_likes' 
			);
		
		
		/* Views Options */
		$options[] = array(
			'under_section'	=> 'gallery-main',
			'type'			=> 'small_heading',
			'id'			=> 'gallery-views-settings',
			'title'			=> 'Item Views'
		);
		
		
			/* Allow Views */
			$options[] = array(
				'under_section' => 'gallery-main',
				'type'			=> 'checkbox',
				'name'			=> 'Item Views',
				'id'			=> array('kolor_gallery_show_views'),
				'options'		=> array('Show item views for gallery item'),
				'checked'		=> array('checked')
			);
		
			

	/* 404 Page / Sub Section */
	$options[] = array(
		'section'	=> 'portfolio',
		'type'		=> 'heading',
		'id'		=> 'not-found-page',
		'title'		=> '404 Page'
	);
	
		/* 404 Page Title Text */
		$options[] = array(
			'under_section'	=> 'not-found-page',
			'type'			=> 'text',
			'name'			=> 'Description Text',
			'id'			=> 'kolor_404_line_1',
			'default'		=> 'Sorry, the page you are looking for does not exists!'
		);
	
		/* 404 Page Title Link Text */
		$options[] = array(
			'under_section'	=> 'not-found-page',
			'type'			=> 'text',
			'name'			=> 'Back to Homepage Link Text',
			'id'			=> 'kolor_404_go_to_homepage_link_text',
			'default'		=> 'Go back to homepage &raquo;'
		);


/* Contact Form / Section */
$options[] = array(
	'type'		=> 'section',
	'id'		=> 'contact-page',
	'title'		=> 'Contact Page',
	'icon'		=> 'acera-icon-mail',
	'expanded'	=> TRUE
);


	
		/* Map Location */
		$options[] = array(
			'section'		=> 'contact-page',
			'type'			=> 'heading',
			'title'			=> 'Map Location',
			'id'			=> 'map-location'
		);

	
			/* Map */
			$options[] = array(
				'under_section'	=> 'map-location',
				'type'			=> 'map',
				'name'			=> 'Map Position',
				'id'			=> 'kolor_map_coords',
				'desc'			=> 'Select your preferred center positions',
				'default'		=> '37.4419;-122.1419',
				'search'		=> TRUE,
				'placeholder'	=> 'Search by address...'
			);
			
			
			/* Map Zoom Level */
			$options[] = array(
				'under_section'	=> 'map-location',
				'type'			=> 'select',
				'name'			=> 'Map zoom level',
				'id'			=> 'kolor_map_zoom_lvl',
				'options'		=> array(1,2,3,4,5,6,7,8,9,10,11,12,14,15,16,17,18,19,20),
				'default'		=> 8,
				'desc'			=> 'Choose from 1-20'
			);
			
			/* Show or Hide Map */
			$options[] = array(
				'under_section' => 'map-location',
				'type'			=> 'checkbox',
				'name'			=> 'Contact Page Map',
				'id'			=> array('kolor_map_is_visible'),
				'options'		=> array('Map is visible'),
				'desc'			=> 'Hide or show map on contact page',
				'default'		=> array('checked')
			);



		/* Address and Contact */
		$options[] = array(
			'section'		=> 'contact-page',
			'type'			=> 'heading',
			'title'			=> 'Address & Contact Info',
			'id'			=> 'address-contact-info'
		);
		
		
			/* Address Line */
			$options[] = array(
				'under_section' => 'address-contact-info',
				'type'			=> 'textarea',
				'name'			=> 'Address',
				'id'			=> 'kolor_contact_address_text',
				'placeholder'	=> 'Address line'
			);
		
		
			/* Contact Info Line */
			$options[] = array(
				'under_section' => 'address-contact-info',
				'type'			=> 'textarea',
				'name'			=> 'Contact Info',
				'id'			=> 'kolor_contact_contact_info_text',
				'placeholder'	=> 'Phone numbers, emails and other'
			);
			
			/* Social Networks to Show (on contact page) */
			$options[] = array(
				'under_section'	=> 'address-contact-info',
				'type'			=> 'checkbox_image',
				'name'			=> 'Social Networks to Show',
				
				'image_size'	=> array(32),
				
				'id'			=> array(
											'kolor_contact_show_fb',
											'kolor_contact_show_twitter',
											'kolor_contact_show_dribbble',
											'kolor_contact_show_skype',
										),
				'image_src'		=> array(
											THEMEURL . 'images/admin/fb.png',
											THEMEURL . 'images/admin/twitter.png',
											THEMEURL . 'images/admin/dribbble.png',
											THEMEURL . 'images/admin/skype.png',
										),
				'options'		=> array(
											'Facebook',
											'Twitter',
											'Dribbble',
											'Skype',
										),
				'desc'			=> 'Select social networks to show in the footer<br />Note: To set up URLs of Social Networks click tab "Social Networks" under General Settings'
			);



		/* Contact Form */
		$options[] = array(
			'section'		=> 'contact-page',
			'type'			=> 'heading',
			'title'			=> 'Contact Form',
			'id'			=> 'contact-form'
		);
		
		
			$options[] = array(
				'under_section' => 'contact-form',
				'type'			=> 'radio',
				'name'			=> 'Status',
				'id'			=> 'kolor_contact_form_is_open',
				'options'		=> array('is_open' => 'Contact form is open', 'is_closed' => 'Contact form is closed'),
				'default'		=> 'is_open'
			);
			
			
		
			/* Visible Fields */
			$options[] = array(
				'under_section' => 'contact-form',
				'type'			=> 'checkbox',
				'name'			=> 'Visible Fields',
				'id'			=> array('kolor_contact_form_show_firstname', 'kolor_contact_form_show_lastname', 'kolor_contact_form_show_subject', 'kolor_contact_form_show_email', 'kolor_contact_form_show_message'),
				'options'		=> array('Name', 'Surname', 'Subject', 'Email', 'Message'),
				'default'		=> array('checked', 'checked', 'checked', 'checked', 'checked')
			);
		
		
			/* Required Fields */
			$options[] = array(
				'under_section' => 'contact-form',
				'type'			=> 'checkbox',
				'name'			=> 'Required Fields',
				'id'			=> array('kolor_contact_form_required_firstname', 'kolor_contact_form_required_lastname', 'kolor_contact_form_required_subject', 'kolor_contact_form_required_email', 'kolor_contact_form_required_message'),
				'options'		=> array('Name', 'Surname', 'Subject', 'Email', 'Message'),
				'default'		=> array('checked', 'not', 'not', 'checked', 'checked')
			);
		
		
			/* Success Message */
			$options[] = array(
				'under_section' => 'contact-form',
				'type'			=> 'textarea',
				'name'			=> 'Closed contact form message',
				'id'			=> 'kolor_contact_form_is_closed_message',
				'default'		=> 'We are sorry, but contact form is closed. You may check again few days later.',
				'desc' 			=> 'If contact form is closed this message will be displayed.'
			);
		
		
			/* Success Message */
			$options[] = array(
				'under_section' => 'contact-form',
				'type'			=> 'textarea',
				'name'			=> 'Success Message',
				'id'			=> 'kolor_contact_form_success_message',
				'default'		=> 'Thank you #firstname#, your message has been sent.',
				'desc' 			=> 'Use dynamic field values: #firstname#, #lastname#, #subject# and #email#'
			);
		
		
			/* Error Message */
			$options[] = array(
				'under_section' => 'contact-form',
				'type'			=> 'textarea',
				'name'			=> 'Error Message',
				'id'			=> 'kolor_contact_form_error_message',
				'default'		=> 'Please fill all required fields and make sure you\'ve typed valid email!',
				'desc'			=> 'When users fails to fill all required fields'
			);
			
			
			/* Button Text  */
			$options[] = array(
				'under_section'	=> 'contact-form',
				'type'			=> 'text',
				'name'			=> 'Send button text',
				'id'			=> 'kolor_contact_form_button_text',
				'default'		=> 'Send it'
			);
		
		
	
		/* Email Notifications */
		$options[] = array(
			'section'		=> 'contact-page',
			'type'			=> 'heading',
			'title'			=> 'Email Notifications',
			'id'			=> 'email-notifications'
		);
		
			/* Turn ON/OFF email notifications */
			$options[] = array(
				'under_section' => 'email-notifications',
				'type'			=> 'checkbox',
				'name'			=> 'Email Notifications',
				'id'			=> array('kolor_contact_form_notifications_on'),
				'options'		=> array('Receive email notifications when contact form is submitted'),
				'default'		=> array('checked')
			);	
			
			
			/* Receiver  */
			$options[] = array(
				'under_section'	=> 'email-notifications',
				'type'			=> 'text',
				'name'			=> 'Receiver email',
				'id'			=> 'kolor_contact_form_notifications_email',
				'placeholder'	=> 'your.email@domain.com',
				'display_checkbox_id' => 'kolor_contact_form_notifications_on'
			);
			
			
			/* Subject  */
			$options[] = array(
				'under_section'	=> 'email-notifications',
				'type'			=> 'text',
				'name'			=> 'Subject',
				'id'			=> 'kolor_contact_form_notifications_subject',
				'default'		=> 'New contact form message from #firstname# - #ip#',
				'display_checkbox_id' => 'kolor_contact_form_notifications_on'
			);
			
			
			/* Message  */
			$options[] = array(
				'under_section'	=> 'email-notifications',
				'type'			=> 'textarea',
				'name'			=> 'Message',
				'id'			=> 'kolor_contact_form_notifications_message',
				'default'		=> "You have received new email from contact form on #date#.\n\nClick to see email #link#",
				'display_checkbox_id' => 'kolor_contact_form_notifications_on',
				'desc'			=> 'Use dynamic variables to receive user input data:<br />
				#firstname# - First name<br />
				#lastname# - Last name<br />
				#subject# - Subject<br />
				#email# - User email<br />
				#message# - Message body<br />
				#date# - Date submitted<br />
				#ip# - User IP<br />
				#link# - Link to WordPress admin page (Contact Form)<br />
				Note: <strong>You can include these variables also on subject except #message#.</strong>'
			);
		

/* Miscellaneous Settings / Section */
$options[] = array(
	'type'		=> 'section',
	'id'		=> 'miscellaneous',
	'title'		=> 'Miscellaneous',
	'icon'		=> 'acera-icon-desktop',
	'expanded'	=> TRUE
);

	/* SEO Settings / Sub Section */
	$options[] = array(
		'section'	=> 'miscellaneous',
		'type'		=> 'heading',
		'id'		=> 'seo-settings',
		'title'		=> 'SEO Settings'
	);
	
	
		/* Comments Rules Titles */
		$options[] = array(
			'under_section'	=> 'seo-settings',
			'type'			=> 'text',
			'name'			=> 'Meta Keywords',
			'id'			=> 'kolor_default_meta_keywords',
			'placeholder'	=> 'Comma separated values',
			'desc'			=> 'Meta keywords and meta description can be overridden individually for each post (on edit post page)'
		);
		
	
		/* Comments Rules Description Text */
		$options[] = array(
			'under_section'	=> 'seo-settings',
			'type'			=> 'textarea',
			'name'			=> 'Meta Description',
			'id'			=> 'kolor_default_meta_description',
			'placeholder'	=> 'Search engines prefer up to 160 characters long description for each page'
		);


	/* Font / Sub Section */
	$options[] = array(
		'section'	=> 'miscellaneous',
		'type'		=> 'heading',
		'id'		=> 'fonts',
		'title'		=> 'Font'
	);
		
		
		/* Default Site Font */
		$options[] = array(
			'under_section' 	=> 'fonts',
			'type' 				=> 'radio_image',
			'id' 				=> 'kolor_font_type',
			'name' 				=> 'Font Type',
			'show_labels' 		=> 'true',
			'image_src'	 		=> array(
											THEMEURL . 'images/admin/font-droid.png',
											THEMEURL . 'images/admin/font-opensans.png',
											THEMEURL . 'images/admin/font-pt-sans.png',
											THEMEURL . 'images/admin/font-lato.png',
											THEMEURL . 'images/admin/font-cabin.png',
										),
			'image_size' 		=> array('300'),
			'options' 			=> array(
											'droid' 	=> 'Droid Sans', 
											'opensans'	=> 'Open Sans',
											'pt-sans' 	=> 'PT Sans',
											'lato' 		=> 'Lato',
											'cabin'		=> 'Cabin'
										),
			'desc' 				=> 'Select default font',
			'default'			=> 'opensans'
		);




	/* Custom CSS / Sub Section */
	$options[] = array(
		'section'	=> 'miscellaneous',
		'type'		=> 'heading',
		'id'		=> 'custom-css',
		'title'		=> 'Custom Styling (CSS)'
	);
	
		/* Textarea CSS - Description */
		$options[] = array(
			'under_section'	=> 'custom-css',
			'type'			=> 'textarea',
			'name'			=> 'Custom CSS Styling',
			'id'			=> 'kolor_custom_css',
			'placeholder'	=> 'The text will be wrapped within <style> tag.',
			'desc'			=> 'You can also include URL\'s. Do not use @import!'
		);
	
	

	/* Comments / Sub Section */
	$options[] = array(
		'section'	=> 'miscellaneous',
		'type'		=> 'heading',
		'id'		=> 'comments-page',
		'title'		=> 'Comments Page'
	);
	
	
			/* Comments Rules Titles */
			$options[] = array(
				'under_section'	=> 'comments-page',
				'type'			=> 'text',
				'name'			=> 'Commenting Rules Title',
				'id'			=> 'kolor_comments_page_rules_title',
				'default'		=> 'Rules of the Blog'
			);
			
		
			/* Comments Rules Description Text */
			$options[] = array(
				'under_section'	=> 'comments-page',
				'type'			=> 'textarea',
				'name'			=> 'Rules Explanation',
				'id'			=> 'kolor_comments_page_rules_description',
				'default'		=> 'Do not post violating content, tags like bold, italic and underline are allowed that means HTML can be used while commenting. Lorem ipsum dolor sit amet conceur half the time you know i know what.'
			);


	/* Password Protected Stories / Sub Section */
	$options[] = array(
		'section'	=> 'miscellaneous',
		'type'		=> 'heading',
		'id'		=> 'password-protected-stories',
		'title'		=> 'Password Protected Stories'
	);
		
			/* Google Analytics */
			$options[] = array(
				'under_section' => 'password-protected-stories',
				'type'			=> 'checkbox',
				'name'			=> 'Show excerpt',
				'id'			=> array('kolor_pass_protected_show_excerpt'),
				'options'		=> array('Show story excerpt when a blog post is password procteded')
			);
		
		
			/* Pass Protect Words Count  */
			$options[] = array(
				'under_section'	=> 'password-protected-stories',
				'type'			=> 'text',
				'name'			=> 'Words to show ',
				'id'			=> 'kolor_pass_protected_stories_words_num',
				'desc'			=> 'Words from the story. Valid integer required!',
				'default'		=> 55,
				'display_checkbox_id' => 'kolor_pass_protected_show_excerpt'
			);
		
		
			/* Text Hint  */
			$options[] = array(
				'under_section'	=> 'password-protected-stories',
				'type'			=> 'textarea',
				'name'			=> 'Password hint text ',
				'id'			=> 'kolor_pass_protected_stories_text_hint',
				'default'		=> 'This post is password protected. To view it please enter your password below:',
				'display_checkbox_id' => 'kolor_pass_protected_show_excerpt',
				'img_desc'		=> THEMEURL . 'images/admin/post_password_form.png'
			);
		
		
			/* Button Text  */
			$options[] = array(
				'under_section'	=> 'password-protected-stories',
				'type'			=> 'text',
				'name'			=> 'Submit button text',
				'id'			=> 'kolor_pass_protected_stories_button_text',
				'default'		=> 'Unlock Post',
				'display_checkbox_id' => 'kolor_pass_protected_show_excerpt',
			);
		
		


	/* WideSlider / Sub Section */
	$options[] = array(
		'section'	=> 'miscellaneous',
		'type'		=> 'heading',
		'id'		=> 'wideslider',
		'title'		=> 'Wide Slider'
	);
		
		
			/* Wide Slider Height  */
			$options[] = array(
				'under_section'	=> 'wideslider',
				'type'			=> 'text',
				'name'			=> 'Slider Height',
				'id'			=> 'kolor_wide_slider_height',
				'default'		=> '570',
				'desc'			=> 'Numeric value'
			);